/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.AbstractFlowScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;
import org.jenkinsci.plugins.workflow.graphanalysis.FilteratorImpl;
import org.jenkinsci.plugins.workflow.graphanalysis.NodeStepNamePredicate;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;

@NotThreadSafe
public class ForkScanner
extends AbstractFlowScanner {
    ArrayDeque<ParallelBlockStart> parallelBlockStartStack = new ArrayDeque();
    HashSet<String> headIds = new HashSet();
    FlowNode currentParallelStartNode = null;
    ParallelBlockStart currentParallelStart = null;
    private boolean walkingFromFinish = false;
    NodeType currentType = null;
    NodeType nextType = null;
    private static final Predicate<FlowNode> parallelStartPredicate = new IsParallelStartPredicate();

    @CheckForNull
    public NodeType getCurrentType() {
        return this.currentType;
    }

    @CheckForNull
    public NodeType getNextType() {
        return this.nextType;
    }

    public ForkScanner() {
    }

    public ForkScanner(@NonNull Collection<FlowNode> heads) {
        this.setup(heads);
    }

    public ForkScanner(@NonNull Collection<FlowNode> heads, @NonNull Collection<FlowNode> blackList) {
        this.setup(heads, blackList);
    }

    @Override
    protected void reset() {
        this.parallelBlockStartStack.clear();
        this.currentParallelStart = null;
        this.currentParallelStartNode = null;
        this.myCurrent = null;
        this.myNext = null;
        this.headIds.clear();
    }

    @Deprecated
    public static void setParallelStartPredicate(@NonNull Predicate<FlowNode> pred) {
    }

    public static boolean isParallelStart(@CheckForNull FlowNode f) {
        return parallelStartPredicate.apply((Object)f);
    }

    public static boolean isParallelEnd(@CheckForNull FlowNode f) {
        return f instanceof BlockEndNode && (f.getParents().size() > 1 || ForkScanner.isParallelStart(((BlockEndNode)f).getStartNode()));
    }

    @CheckForNull
    static NodeType getNodeType(@CheckForNull FlowNode f) {
        if (f == null) {
            return null;
        }
        if (f instanceof BlockStartNode) {
            if (f.getPersistentAction(ThreadNameAction.class) != null) {
                return NodeType.PARALLEL_BRANCH_START;
            }
            if (ForkScanner.isParallelStart(f)) {
                return NodeType.PARALLEL_START;
            }
            return NodeType.NORMAL;
        }
        if (f instanceof BlockEndNode) {
            Object start = ((BlockEndNode)f).getStartNode();
            NodeType type = ForkScanner.getNodeType(start);
            if (type == null) {
                return null;
            }
            switch (type) {
                case PARALLEL_BRANCH_START: {
                    return NodeType.PARALLEL_BRANCH_END;
                }
                case PARALLEL_START: {
                    return NodeType.PARALLEL_END;
                }
            }
            return NodeType.NORMAL;
        }
        return NodeType.NORMAL;
    }

    public boolean isWalkingFromFinish() {
        return this.walkingFromFinish;
    }

    ArrayDeque<ParallelBlockStart> convertForksToBlockStarts(ArrayDeque<Fork> parallelForks) {
        ArrayDeque<ParallelBlockStart> output = new ArrayDeque<ParallelBlockStart>();
        for (Fork f : parallelForks) {
            ParallelBlockStart start = new ParallelBlockStart();
            start.forkStart = f.forkStart;
            start.unvisited = new ArrayDeque();
            for (FlowPiece fp : f.following) {
                if (!fp.isLeaf()) continue;
                start.unvisited.add(((FlowSegment)fp).visited.get(0));
            }
            output.add(start);
        }
        return output;
    }

    ArrayDeque<ParallelBlockStart> leastCommonAncestor(final @NonNull Set<FlowNode> heads) {
        HashMap<FlowNode, FlowPiece> branches = new HashMap<FlowNode, FlowPiece>();
        ArrayList<FilteratorImpl<FlowNode>> iterators = new ArrayList<FilteratorImpl<FlowNode>>();
        ArrayList<FlowPiece> livePieces = new ArrayList<FlowPiece>();
        ArrayDeque<Fork> parallelForks = new ArrayDeque<Fork>();
        Predicate<FlowNode> notAHead = new Predicate<FlowNode>(){
            final Collection<FlowNode> checkHeads;
            {
                this.checkHeads = ForkScanner.this.convertToFastCheckable(heads);
            }

            public boolean apply(FlowNode input) {
                return !this.checkHeads.contains((Object)input);
            }
        };
        for (FlowNode f : heads) {
            iterators.add(new FilteratorImpl<FlowNode>(f.iterateEnclosingBlocks().iterator(), notAHead));
            FlowSegment b = new FlowSegment();
            b.add(f);
            livePieces.add(b);
            branches.put(f, b);
        }
        boolean mergedAll = false;
        while (!mergedAll && iterators.size() > 0) {
            ListIterator itIterator = iterators.listIterator();
            ListIterator<FlowSegment> pieceIterator = livePieces.listIterator();
            while (itIterator.hasNext()) {
                Filterator blockStartIterator = (Filterator)itIterator.next();
                FlowPiece myPiece = (FlowPiece)pieceIterator.next();
                if (!blockStartIterator.hasNext()) {
                    pieceIterator.remove();
                    itIterator.remove();
                    continue;
                }
                FlowNode nextBlockStart = (FlowNode)((Object)blockStartIterator.next());
                FlowPiece existingPiece = (FlowPiece)branches.get((Object)nextBlockStart);
                if (existingPiece == null && myPiece instanceof FlowSegment) {
                    ((FlowSegment)myPiece).add(nextBlockStart);
                    branches.put(nextBlockStart, myPiece);
                    continue;
                }
                if (existingPiece == null && myPiece instanceof Fork) {
                    FlowSegment newSegment = new FlowSegment();
                    newSegment.isLeaf = false;
                    newSegment.add(nextBlockStart);
                    newSegment.after = myPiece;
                    pieceIterator.remove();
                    pieceIterator.add(newSegment);
                    branches.put(nextBlockStart, newSegment);
                    continue;
                }
                if (existingPiece == null) continue;
                if (existingPiece instanceof Fork) {
                    ((Fork)existingPiece).following.add(myPiece);
                } else {
                    Fork f = ((FlowSegment)existingPiece).split(branches, (BlockStartNode)nextBlockStart, myPiece);
                    if (f.following.contains(existingPiece)) {
                        int headIndex = livePieces.indexOf(existingPiece);
                        livePieces.set(headIndex, f);
                    }
                    parallelForks.add(f);
                }
                itIterator.remove();
                pieceIterator.remove();
                if (iterators.size() != 1) continue;
                mergedAll = true;
            }
        }
        if (parallelForks.isEmpty()) {
            throw new IllegalStateException("No least common ancestor found from " + heads);
        }
        return this.convertForksToBlockStarts(parallelForks);
    }

    @Override
    protected void setHeads(@NonNull Collection<FlowNode> heads) {
        if (heads.size() > 1) {
            for (FlowNode f : heads) {
                this.headIds.add(f.getId());
            }
            this.parallelBlockStartStack = this.leastCommonAncestor(new LinkedHashSet<FlowNode>(heads));
            this.currentParallelStart = this.parallelBlockStartStack.pop();
            this.currentParallelStartNode = this.currentParallelStart.forkStart;
            this.myNext = this.myCurrent = this.currentParallelStart.unvisited.pop();
            NodeType tempType = ForkScanner.getNodeType(this.myCurrent);
            if (tempType == NodeType.NORMAL) {
                this.nextType = NodeType.PARALLEL_BRANCH_END;
                this.currentType = NodeType.PARALLEL_BRANCH_END;
            } else {
                this.nextType = tempType;
            }
            this.walkingFromFinish = false;
        } else {
            FlowNode f = heads.iterator().next();
            this.walkingFromFinish = f instanceof FlowEndNode;
            this.myCurrent = f;
            this.myNext = f;
            this.nextType = ForkScanner.isParallelEnd(f) ? NodeType.PARALLEL_END : (ForkScanner.isParallelStart(f) ? NodeType.PARALLEL_START : NodeType.NORMAL);
        }
        this.currentType = null;
    }

    @CheckForNull
    public FlowNode getCurrentParallelStartNode() {
        return this.currentParallelStartNode;
    }

    public int getParallelDepth() {
        return this.currentParallelStart == null ? 0 : 1 + this.parallelBlockStartStack.size();
    }

    FlowNode hitParallelEnd(BlockEndNode endNode, List<FlowNode> parents, Collection<FlowNode> blackList) {
        Object start = endNode.getStartNode();
        ArrayDeque<FlowNode> branches = new ArrayDeque<FlowNode>();
        for (FlowNode f : parents) {
            if (blackList.contains((Object)f)) continue;
            branches.addFirst(f);
        }
        FlowNode output = null;
        if (branches.size() > 0) {
            ParallelBlockStart parallelBlockStart = new ParallelBlockStart((BlockStartNode)((Object)start));
            output = (FlowNode)((Object)branches.pop());
            parallelBlockStart.unvisited = branches;
            if (this.currentParallelStart != null) {
                this.parallelBlockStartStack.push(this.currentParallelStart);
            }
            this.currentParallelStart = parallelBlockStart;
            this.currentParallelStartNode = start;
        }
        return output;
    }

    FlowNode hitParallelStart() {
        FlowNode output = null;
        if (this.currentParallelStart != null) {
            if (this.currentParallelStart.unvisited.isEmpty()) {
                output = this.currentParallelStartNode;
                if (this.parallelBlockStartStack.size() > 0) {
                    this.currentParallelStart = this.parallelBlockStartStack.pop();
                    this.currentParallelStartNode = this.currentParallelStart.forkStart;
                } else {
                    this.currentParallelStart = null;
                    this.currentParallelStartNode = null;
                }
            }
        } else {
            return this.myCurrent.getParents().get(0);
        }
        return output != null && !this.myBlackList.contains((Object)output) ? output : null;
    }

    @Override
    public FlowNode next() {
        this.currentType = this.nextType;
        return super.next();
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Function call to modify state, special case where we don't need the returnVal")
    protected FlowNode next(@NonNull FlowNode current, @NonNull Collection<FlowNode> blackList) {
        FlowNode output = null;
        List<FlowNode> parents = current.getParents();
        if (!parents.isEmpty()) {
            if (parents.size() == 1) {
                FlowNode p = parents.get(0);
                if (p == this.currentParallelStartNode || ForkScanner.isParallelStart(p)) {
                    FlowNode temp = this.hitParallelStart();
                    if (temp != null) {
                        this.nextType = NodeType.PARALLEL_START;
                        return temp;
                    }
                } else {
                    if (ForkScanner.isParallelEnd(current)) {
                        BlockEndNode end = (BlockEndNode)current;
                        FlowNode flowNode = this.hitParallelEnd(end, parents, blackList);
                    }
                    this.nextType = ForkScanner.getNodeType(p);
                    if (!blackList.contains((Object)p)) {
                        return p;
                    }
                }
            } else if (ForkScanner.isParallelEnd(current)) {
                BlockEndNode end = (BlockEndNode)current;
                FlowNode possibleOutput = this.hitParallelEnd(end, parents, blackList);
                if (possibleOutput != null) {
                    this.nextType = NodeType.PARALLEL_BRANCH_END;
                    return possibleOutput;
                }
            } else {
                throw new IllegalStateException("Found a FlowNode with multiple parents that isn't the end of a block! " + (Object)((Object)this.myCurrent));
            }
        }
        if (this.currentParallelStart != null && this.currentParallelStart.unvisited.size() > 0) {
            output = this.currentParallelStart.unvisited.pop();
            this.nextType = NodeType.PARALLEL_BRANCH_END;
            if (output instanceof BlockStartNode && output.getPersistentAction(ThreadNameAction.class) != null) {
                this.nextType = NodeType.PARALLEL_BRANCH_START;
            }
        }
        if (output == null) {
            this.nextType = null;
        }
        return output;
    }

    public static void visitSimpleChunks(@NonNull Collection<FlowNode> heads, @NonNull Collection<FlowNode> blacklist, @NonNull SimpleChunkVisitor visitor, @NonNull ChunkFinder finder) {
        ForkScanner scanner = new ForkScanner();
        scanner.setup(heads, blacklist);
        scanner.visitSimpleChunks(visitor, finder);
    }

    public static void visitSimpleChunks(@NonNull Collection<FlowNode> heads, @NonNull SimpleChunkVisitor visitor, @NonNull ChunkFinder finder) {
        ForkScanner scanner = new ForkScanner();
        scanner.setup(heads);
        scanner.visitSimpleChunks(visitor, finder);
    }

    @CheckForNull
    static FlowNode findLastRunningNode(@NonNull List<FlowNode> candidates) {
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        FlowNode lastFound = candidates.get(0);
        long startTime = Long.MIN_VALUE;
        for (FlowNode f : candidates) {
            long myStart;
            TimingAction ta = f.getAction(TimingAction.class);
            long l = myStart = ta == null ? System.currentTimeMillis() : ta.getStartTime();
            if (f instanceof BlockEndNode != lastFound instanceof BlockEndNode) {
                if (f instanceof BlockEndNode) continue;
                lastFound = f;
                startTime = myStart;
                continue;
            }
            if (myStart <= startTime) continue;
            lastFound = f;
            startTime = myStart;
        }
        return lastFound;
    }

    List<FlowNode> currentParallelHeads() {
        ArrayList<FlowNode> ends = new ArrayList<FlowNode>();
        if (this.currentParallelStart != null) {
            ends.addAll(this.currentParallelStart.unvisited);
        }
        if (this.myCurrent != null) {
            ends.add(this.myCurrent);
        }
        return ends;
    }

    static void fireVisitParallelCallbacks(@CheckForNull FlowNode next, @CheckForNull FlowNode current, @CheckForNull FlowNode prev, @NonNull SimpleChunkVisitor visitor, @NonNull ChunkFinder finder, @NonNull ForkScanner scanner) {
        switch (scanner.currentType) {
            case NORMAL: {
                break;
            }
            case PARALLEL_END: {
                FlowNode n = scanner.getCurrentParallelStartNode();
                if (n != null) {
                    visitor.parallelEnd(n, current, scanner);
                    break;
                }
                if (!(current instanceof BlockEndNode)) break;
                visitor.parallelEnd((FlowNode)((Object)((BlockEndNode)current).getStartNode()), current, scanner);
                break;
            }
            case PARALLEL_START: {
                visitor.parallelStart(current, prev, scanner);
                break;
            }
            case PARALLEL_BRANCH_END: {
                FlowNode f = scanner.getCurrentParallelStartNode();
                if (f != null) {
                    visitor.parallelBranchEnd(f, current, scanner);
                    break;
                }
                if (!(current instanceof BlockEndNode)) break;
                visitor.parallelBranchEnd(((FlowNode)((Object)((BlockEndNode)current).getStartNode())).getParents().get(0), current, scanner);
                break;
            }
            case PARALLEL_BRANCH_START: {
                FlowNode parallelStart;
                FlowNode flowNode = parallelStart = scanner.nextType == NodeType.PARALLEL_START ? next : scanner.getCurrentParallelStartNode();
                if (scanner.headIds.contains(current.getId())) {
                    visitor.parallelBranchEnd(parallelStart, current, scanner);
                }
                if (parallelStart != null) {
                    visitor.parallelBranchStart(parallelStart, current, scanner);
                    break;
                }
                visitor.parallelBranchStart(current.getParents().get(0), current, scanner);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type for current node");
            }
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="FindBugs doesn't like passing nulls to a method that can take null")
    static void fireVisitChunkCallbacks(@CheckForNull FlowNode next, @NonNull FlowNode current, @CheckForNull FlowNode prev, @NonNull SimpleChunkVisitor visitor, @NonNull ChunkFinder finder, @NonNull ForkScanner scanner) {
        boolean boundary = false;
        if (prev == null && finder.isStartInsideChunk()) {
            visitor.chunkEnd(current, prev, scanner);
            boundary = true;
            if (finder.isChunkStart(current, prev)) {
                visitor.chunkStart(current, next, scanner);
            }
        } else {
            if (finder.isChunkStart(current, prev)) {
                visitor.chunkStart(current, next, scanner);
                boundary = true;
            }
            if (finder.isChunkEnd(current, prev)) {
                visitor.chunkEnd(current, prev, scanner);
                boundary = true;
            }
        }
        if (!boundary) {
            visitor.atomNode(next, current, prev, scanner);
        }
    }

    public void visitSimpleChunks(@NonNull SimpleChunkVisitor visitor, @NonNull ChunkFinder finder) {
        FlowNode last;
        if (this.currentParallelStart != null && (last = ForkScanner.findLastRunningNode(this.currentParallelHeads())) != null) {
            visitor.parallelEnd(this.currentParallelStartNode, last, this);
        }
        while (this.hasNext()) {
            FlowNode prev = this.myCurrent != this.myNext ? this.myCurrent : null;
            FlowNode f = this.next();
            ForkScanner.fireVisitChunkCallbacks(this.myNext, this.myCurrent, prev, visitor, finder, this);
            ForkScanner.fireVisitParallelCallbacks(this.myNext, this.myCurrent, prev, visitor, finder, this);
        }
    }

    static class Fork
    extends ParallelBlockStart
    implements FlowPiece {
        List<FlowPiece> following = new ArrayList<FlowPiece>();

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Fork(BlockStartNode forkNode) {
            this.forkStart = forkNode;
        }
    }

    static class FlowSegment
    implements FlowPiece {
        ArrayList<FlowNode> visited = new ArrayList();
        FlowPiece after;
        boolean isLeaf = true;

        FlowSegment() {
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf;
        }

        Fork split(@NonNull HashMap<FlowNode, FlowPiece> nodeMapping, @NonNull BlockStartNode joinPoint, @NonNull FlowPiece joiningBranch) {
            int index = this.visited.lastIndexOf((Object)joinPoint);
            Fork newFork = new Fork(joinPoint);
            if (index < 0) {
                throw new IllegalStateException("Tried to split a segment where the node doesn't exist in this segment");
            }
            if (index == this.visited.size() - 1) {
                newFork.following.add(this);
                newFork.following.add(joiningBranch);
                this.visited.remove(index);
            } else {
                if (index == 0) {
                    throw new IllegalStateException("We have a cyclic graph or heads that are not separate branches!");
                }
                FlowSegment newSegment = new FlowSegment();
                newSegment.after = this.after;
                newSegment.visited.addAll(this.visited.subList(0, index));
                newFork.following.add(newSegment);
                newFork.following.add(joiningBranch);
                this.after = newFork;
                this.isLeaf = false;
                this.visited.subList(0, index + 1).clear();
                for (FlowNode n : newSegment.visited) {
                    nodeMapping.put(n, newSegment);
                }
            }
            nodeMapping.put(joinPoint, newFork);
            return newFork;
        }

        public void add(FlowNode f) {
            this.visited.add(f);
        }
    }

    static interface FlowPiece {
        public boolean isLeaf();
    }

    static class ParallelBlockStart {
        BlockStartNode forkStart;
        ArrayDeque<FlowNode> unvisited = new ArrayDeque();

        ParallelBlockStart(@NonNull BlockStartNode forkStart) {
            this.forkStart = forkStart;
        }

        ParallelBlockStart() {
        }
    }

    static class IsParallelStartPredicate
    implements Predicate<FlowNode> {
        static final NodeStepNamePredicate PARALLEL_STEP = new NodeStepNamePredicate("org.jenkinsci.plugins.workflow.cps.steps.ParallelStep");

        IsParallelStartPredicate() {
        }

        public boolean apply(@Nullable FlowNode input) {
            return input instanceof BlockStartNode && PARALLEL_STEP.apply(input) && input.getPersistentAction(ThreadNameAction.class) == null;
        }
    }

    static enum NodeType {
        NORMAL,
        PARALLEL_START,
        PARALLEL_END,
        PARALLEL_BRANCH_START,
        PARALLEL_BRANCH_END;

    }
}

