/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.Messages;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.util.FormValidation;
import hudson.views.ListViewColumn;
import hudson.views.ViewJobFilter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class ViewDescriptor
extends Descriptor<View> {
    @Override
    @NonNull
    public String getDisplayName() {
        return super.getDisplayName();
    }

    public boolean isInstantiable() {
        return true;
    }

    public final String getNewViewDetailPage() {
        return "/" + this.clazz.getName().replace('.', '/').replace('$', '/') + "/newViewDetail.jelly";
    }

    protected ViewDescriptor(Class<? extends View> clazz) {
        super(clazz);
    }

    protected ViewDescriptor() {
    }

    @Restricted(value={DoNotUse.class})
    public AutoCompletionCandidates doAutoCompleteCopyNewItemFrom(@QueryParameter String value, @AncestorInPath ItemGroup<?> container) {
        AutoCompletionCandidates candidates = AutoCompletionCandidates.ofJobNames(TopLevelItem.class, value, container);
        if (container instanceof DirectlyModifiableTopLevelItemGroup) {
            DirectlyModifiableTopLevelItemGroup modifiableContainer = (DirectlyModifiableTopLevelItemGroup)container;
            Iterator<String> it = candidates.getValues().iterator();
            while (it.hasNext()) {
                TopLevelItem item = Jenkins.get().getItem(it.next(), container, TopLevelItem.class);
                if (item == null || modifiableContainer.canAdd(item)) continue;
                it.remove();
            }
        }
        return candidates;
    }

    public List<Descriptor<ListViewColumn>> getColumnsDescriptors() {
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request != null) {
            View view = (View)request.findAncestorObject(this.clazz);
            return view == null ? DescriptorVisibilityFilter.applyType(this.clazz, ListViewColumn.all()) : DescriptorVisibilityFilter.apply(view, ListViewColumn.all());
        }
        return ListViewColumn.all();
    }

    public List<Descriptor<ViewJobFilter>> getJobFiltersDescriptors() {
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request != null) {
            View view = (View)request.findAncestorObject(this.clazz);
            return view == null ? DescriptorVisibilityFilter.applyType(this.clazz, ViewJobFilter.all()) : DescriptorVisibilityFilter.apply(view, ViewJobFilter.all());
        }
        return ViewJobFilter.all();
    }

    protected FormValidation checkDisplayName(@NonNull View view, @CheckForNull String value) {
        if (value == null || value.isBlank()) {
            return FormValidation.ok();
        }
        for (View v : view.owner.getViews()) {
            if (v.getViewName().equals(view.getViewName()) || !Objects.equals(v.getDisplayName(), value)) continue;
            return FormValidation.warning(Messages.View_DisplayNameNotUniqueWarning(value));
        }
        return FormValidation.ok();
    }

    public boolean isApplicable(Class<? extends ViewGroup> ownerType) {
        return true;
    }

    public boolean isApplicableIn(ViewGroup owner) {
        return this.isApplicable(owner.getClass());
    }
}

