/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.userproperty;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.TransientUserActionFactory;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.userproperty.Messages;
import hudson.model.userproperty.UserPropertyCategory;
import hudson.model.userproperty.UserPropertyCategoryAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UserPropertyCategoryExperimentalAction
extends UserPropertyCategoryAction
implements Action {
    public UserPropertyCategoryExperimentalAction(@NonNull User user) {
        super(user);
    }

    @Override
    public String getDisplayName() {
        return Messages.UserPropertyCategoryExperimentalAction_DisplayName();
    }

    @Override
    public String getIconFileName() {
        return this.getTargetUser().hasPermission(Jenkins.ADMINISTER) ? "symbol-flask" : null;
    }

    @Override
    public String getUrlName() {
        return "experiments";
    }

    @Override
    @NonNull
    public List<UserPropertyDescriptor> getMyCategoryDescriptors() {
        return UserProperty.allByCategoryClass(UserPropertyCategory.Experimental.class);
    }

    @Extension(ordinal=100.0)
    @Symbol(value={"experimental"})
    public static class ExperimentalActionFactory
    extends TransientUserActionFactory {
        @Override
        public Collection<? extends Action> createFor(User target) {
            return Collections.singleton(new UserPropertyCategoryExperimentalAction(target));
        }
    }
}

