/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import java.util.List;
import java.util.concurrent.Future;
import jenkins.agents.IOfflineCause;
import jenkins.model.IDisplayExecutor;
import jenkins.model.Jenkins;
import jenkins.model.Named;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface IComputer
extends AccessControlled,
IconSpec,
ModelObject,
Named {
    @NonNull
    public List<? extends IDisplayExecutor> getDisplayExecutors();

    public boolean isOffline();

    public boolean isAcceptingTasks();

    @NonNull
    public String getUrl();

    default public boolean hasOfflineCause() {
        return Util.fixEmpty(this.getOfflineCauseReason()) != null;
    }

    public IOfflineCause getOfflineCause();

    @NonNull
    default public String getOfflineCauseReason() {
        if (this.getOfflineCause() == null) {
            return "";
        }
        return this.getOfflineCause().getReason();
    }

    public boolean isConnecting();

    default public String getIcon() {
        if (!this.isAcceptingTasks()) {
            return "symbol-computer-not-accepting";
        }
        IOfflineCause offlineCause = this.getOfflineCause();
        if (offlineCause != null) {
            return offlineCause.getComputerIcon();
        }
        if (this.isOffline()) {
            return "symbol-computer-offline";
        }
        return "symbol-computer";
    }

    default public String getIconAltText() {
        if (!this.isAcceptingTasks()) {
            return "[suspended]";
        }
        IOfflineCause offlineCause = this.getOfflineCause();
        if (offlineCause != null) {
            return offlineCause.getComputerIconAltText();
        }
        if (this.isOffline()) {
            return "[offline]";
        }
        return "[online]";
    }

    default public String getTooltip() {
        IOfflineCause offlineCause = this.getOfflineCause();
        if (offlineCause != null) {
            return offlineCause.toString();
        }
        return "";
    }

    @Override
    default public String getIconClassName() {
        return this.getIcon();
    }

    public int countBusy();

    public int countExecutors();

    public boolean isOnline();

    default public boolean isConnected() {
        return this.isOnline();
    }

    public int countIdle();

    public boolean isLaunchSupported();

    public Future<?> connect(boolean var1);

    @Override
    @NonNull
    default public ACL getACL() {
        return Jenkins.get().getAuthorizationStrategy().getACL(this);
    }
}

