/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Lookup;
import hudson.Main;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.RestrictedSince;
import hudson.TcpSlaveAgentListener;
import hudson.Util;
import hudson.XmlFile;
import hudson.cli.declarative.CLIMethod;
import hudson.cli.declarative.CLIResolver;
import hudson.init.InitMilestone;
import hudson.init.InitStrategy;
import hudson.init.TermMilestone;
import hudson.init.TerminatorFinder;
import hudson.lifecycle.Lifecycle;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.logging.LogRecorderManager;
import hudson.markup.EscapedMarkupFormatter;
import hudson.markup.MarkupFormatter;
import hudson.model.AbstractCIBase;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AdministrativeMonitor;
import hudson.model.AllView;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.DependencyGraph;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Failure;
import hudson.model.Fingerprint;
import hudson.model.FingerprintCleanupThread;
import hudson.model.FingerprintMap;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Items;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Label;
import hudson.model.ListView;
import hudson.model.LoadBalancer;
import hudson.model.LoadStatistics;
import hudson.model.ManageJenkinsAction;
import hudson.model.ManagementLink;
import hudson.model.ModelObject;
import hudson.model.ModifiableViewGroup;
import hudson.model.NoFingerprintMatch;
import hudson.model.Node;
import hudson.model.OverallLoadStatistics;
import hudson.model.PaneStatusProperties;
import hudson.model.PersistenceRoot;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.RestartListener;
import hudson.model.RootAction;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.UnprotectedRootAction;
import hudson.model.UpdateCenter;
import hudson.model.User;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.ViewGroupMixIn;
import hudson.model.WorkspaceCleanupThread;
import hudson.model.labels.LabelAtom;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SCMListener;
import hudson.model.listeners.SaveableListener;
import hudson.remoting.Callable;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.FederatedLoginService;
import hudson.security.HudsonFilter;
import hudson.security.LegacyAuthorizationStrategy;
import hudson.security.LegacySecurityRealm;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.security.SecurityMode;
import hudson.security.SecurityRealm;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.GlobalCrumbIssuerConfiguration;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerListener;
import hudson.slaves.DumbSlave;
import hudson.slaves.NodeDescriptor;
import hudson.slaves.NodeList;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.AdministrativeError;
import hudson.util.ClockDifference;
import hudson.util.ComboBoxModel;
import hudson.util.CopyOnWriteList;
import hudson.util.CopyOnWriteMap;
import hudson.util.DaemonThreadFactory;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.Futures;
import hudson.util.HudsonIsLoading;
import hudson.util.HudsonIsRestarting;
import hudson.util.Iterators;
import hudson.util.JenkinsReloadFailed;
import hudson.util.LogTaskListener;
import hudson.util.MultipartFormDataParser;
import hudson.util.NamingThreadFactory;
import hudson.util.PluginServletFilter;
import hudson.util.QuotedStringTokenizer;
import hudson.util.RemotingDiagnostics;
import hudson.util.TextFile;
import hudson.util.VersionNumber;
import hudson.util.XStream2;
import hudson.views.DefaultMyViewsTabBar;
import hudson.views.DefaultViewsTabBar;
import hudson.views.MyViewsTabBar;
import hudson.views.ViewsTabBar;
import hudson.widgets.Widget;
import io.jenkins.servlet.RequestDispatcherWrapper;
import io.jenkins.servlet.ServletContextWrapper;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.servlet.RequestDispatcher;
import jenkins.AgentProtocol;
import jenkins.ExtensionComponentSet;
import jenkins.ExtensionRefreshException;
import jenkins.InitReactorRunner;
import jenkins.agents.CloudSet;
import jenkins.diagnostics.URICheckEncodingMonitor;
import jenkins.install.InstallState;
import jenkins.install.SetupWizard;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.IdStrategy;
import jenkins.model.InvalidBuildsDir;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.Loadable;
import jenkins.model.MasterBuildConfiguration;
import jenkins.model.Messages;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.Nodes;
import jenkins.model.ProjectNamingStrategy;
import jenkins.model.UnlabeledLoadStatistics;
import jenkins.security.ClassFilterImpl;
import jenkins.security.ConfidentialStore;
import jenkins.security.MasterToSlaveCallable;
import jenkins.security.RedactSecretJsonInErrorMessageSanitizer;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.security.SecurityListener;
import jenkins.security.stapler.DoActionFilter;
import jenkins.security.stapler.StaplerDispatchValidator;
import jenkins.security.stapler.StaplerDispatchable;
import jenkins.security.stapler.StaplerFilteredActionListener;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.security.stapler.TypedFilter;
import jenkins.slaves.WorkspaceLocator;
import jenkins.util.JenkinsJVM;
import jenkins.util.Listeners;
import jenkins.util.SystemProperties;
import jenkins.util.io.FileBoolean;
import jenkins.util.io.OnMaster;
import jenkins.util.xml.XMLUtils;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hudson.reactor.Executable;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.ReactorException;
import org.jvnet.hudson.reactor.ReactorListener;
import org.jvnet.hudson.reactor.Task;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.hudson.reactor.TaskGraphBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.stapler.DispatchValidator;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.JsonInErrorMessageSanitizer;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.event.FilteredDispatchTriggerListener;
import org.kohsuke.stapler.event.FilteredDoActionTriggerListener;
import org.kohsuke.stapler.event.FilteredFieldTriggerListener;
import org.kohsuke.stapler.event.FilteredGetterTriggerListener;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.framework.adjunct.AdjunctManager;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.jelly.JellyClassLoaderTearOff;
import org.kohsuke.stapler.jelly.JellyRequestDispatcher;
import org.kohsuke.stapler.lang.FieldRef;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.xml.sax.InputSource;

@ExportedBean
public class Jenkins
extends AbstractCIBase
implements DirectlyModifiableTopLevelItemGroup,
StaplerProxy,
StaplerFallback,
ModifiableViewGroup,
AccessControlled,
DescriptorByNameOwner,
ModelObjectWithContextMenu,
ModelObjectWithChildren,
OnMaster,
Loadable {
    private final transient Queue queue;
    private volatile transient boolean configLoaded = false;
    public final transient Lookup lookup = new Lookup();
    private String version = "1.0";
    private transient String installStateName;
    @Deprecated
    private InstallState installState;
    private transient SetupWizard setupWizard;
    private int numExecutors = 2;
    private Node.Mode mode = Node.Mode.NORMAL;
    private Boolean useSecurity;
    private volatile AuthorizationStrategy authorizationStrategy = AuthorizationStrategy.UNSECURED;
    private volatile SecurityRealm securityRealm = SecurityRealm.NO_AUTHENTICATION;
    private volatile boolean disableRememberMe;
    private ProjectNamingStrategy projectNamingStrategy = ProjectNamingStrategy.DefaultProjectNamingStrategy.DEFAULT_NAMING_STRATEGY;
    private String workspaceDir = OLD_DEFAULT_WORKSPACES_DIR;
    private String buildsDir = "${ITEM_ROOTDIR}/builds";
    private String systemMessage;
    private MarkupFormatter markupFormatter;
    public final transient File root;
    private volatile transient InitMilestone initLevel = InitMilestone.STARTED;
    final transient Map<String, TopLevelItem> items = new CopyOnWriteMap.Tree<String, TopLevelItem>(String.CASE_INSENSITIVE_ORDER);
    private static Jenkins theInstance;
    @CheckForNull
    private volatile transient QuietDownInfo quietDownInfo;
    private volatile transient boolean terminating;
    @GuardedBy(value="Jenkins.class")
    private transient boolean cleanUpStarted;
    private static FileBoolean STARTUP_MARKER_FILE;
    private volatile List<JDK> jdks = new ArrayList<JDK>();
    private volatile transient DependencyGraph dependencyGraph;
    private transient Future<DependencyGraph> scheduledFutureDependencyGraph;
    private transient Future<DependencyGraph> calculatingFutureDependencyGraph;
    private transient Object dependencyGraphLock = new Object();
    private volatile ViewsTabBar viewsTabBar = new DefaultViewsTabBar();
    private volatile MyViewsTabBar myViewsTabBar = new DefaultMyViewsTabBar();
    private final transient Map<Class, ExtensionList> extensionLists = new ConcurrentHashMap<Class, ExtensionList>();
    private final transient Map<Class, DescriptorExtensionList> descriptorLists = new ConcurrentHashMap<Class, DescriptorExtensionList>();
    protected final transient ConcurrentMap<Node, Computer> computers = new ConcurrentHashMap<Node, Computer>();
    public final Hudson.CloudList clouds = new Hudson.CloudList(this);
    @Deprecated
    protected volatile transient NodeList slaves;
    private final transient Nodes nodes = new Nodes(this);
    Integer quietPeriod;
    int scmCheckoutRetryCount;
    private final CopyOnWriteArrayList<View> views = new CopyOnWriteArrayList();
    private volatile String primaryView;
    private final transient ViewGroupMixIn viewGroupMixIn = new ViewGroupMixIn(this){

        @Override
        protected List<View> views() {
            return Jenkins.this.views;
        }

        @Override
        protected String primaryView() {
            return Jenkins.this.primaryView;
        }

        @Override
        protected void primaryView(String name) {
            Jenkins.this.primaryView = name;
        }
    };
    private final transient FingerprintMap fingerprintMap = new FingerprintMap();
    public final transient PluginManager pluginManager;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public volatile transient TcpSlaveAgentListener tcpSlaveAgentListener;
    private final transient Object tcpSlaveAgentListenerLock = new Object();
    private final transient CopyOnWriteList<SCMListener> scmListeners = new CopyOnWriteList();
    private int slaveAgentPort = Jenkins.getSlaveAgentPortInitialValue(0);
    private static final boolean SLAVE_AGENT_PORT_ENFORCE;
    private String label = "";
    private static String nodeNameAndSelfLabelOverride;
    private volatile CrumbIssuer crumbIssuer = GlobalCrumbIssuerConfiguration.createDefaultCrumbIssuer();
    private final transient ConcurrentHashMap<String, Label> labels = new ConcurrentHashMap();
    @Exported
    public final transient OverallLoadStatistics overallLoad = new OverallLoadStatistics();
    @Exported
    public final transient LoadStatistics unlabeledLoad = new UnlabeledLoadStatistics();
    public final transient NodeProvisioner unlabeledNodeProvisioner;
    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public final transient NodeProvisioner overallNodeProvisioner = this.unlabeledNodeProvisioner = new NodeProvisioner(null, this.unlabeledLoad);
    @Deprecated
    public final transient javax.servlet.ServletContext servletContext;
    private final transient ServletContext jakartaServletContext;
    private final transient List<Action> actions = new CopyOnWriteArrayList<Action>();
    private DescribableList<NodeProperty<?>, NodePropertyDescriptor> nodeProperties = new DescribableList(this);
    private DescribableList<NodeProperty<?>, NodePropertyDescriptor> globalNodeProperties = new DescribableList(this);
    public final transient List<AdministrativeMonitor> administrativeMonitors = this.getExtensionList(AdministrativeMonitor.class);
    private final transient List<Widget> widgets = this.getExtensionList(Widget.class);
    private final transient AdjunctManager adjuncts;
    private final transient ItemGroupMixIn itemGroupMixIn = new ItemGroupMixIn(this, this){

        @Override
        protected void add(TopLevelItem item) {
            Jenkins.this.items.put(item.getName(), item);
        }

        @Override
        protected File getRootDirFor(String name) {
            return Jenkins.this.getRootDirFor(name);
        }
    };
    static JenkinsHolder HOLDER;
    private final transient String secretKey;
    private final transient UpdateCenter updateCenter = UpdateCenter.createUpdateCenter(null);
    private Boolean noUsageStatistics;
    @Restricted(value={NoExternalUse.class})
    Boolean nodeRenameMigrationNeeded;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public volatile transient ProxyConfiguration proxy;
    private transient LogRecorderManager log = new LogRecorderManager();
    private final transient boolean oldJenkinsJVM;
    @NonNull
    private transient Set<LabelAtom> labelAtomSet;
    @SuppressFBWarnings(value={"MS_MUTABLE_COLLECTION_PKGPROTECT"}, justification="mutable to allow plugins to add additional extensions")
    public static final Set<String> ALLOWED_RESOURCE_EXTENSIONS;
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"}, justification="cannot be made immutable without breaking compatibility")
    public static List<LogRecord> logRecords;
    public static final XStream XSTREAM;
    public static final XStream2 XSTREAM2;
    private static final int TWICE_CPU_NUM;
    final transient ExecutorService threadPoolForLoad = new ThreadPoolExecutor(TWICE_CPU_NUM, TWICE_CPU_NUM, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamingThreadFactory(new DaemonThreadFactory(), "Jenkins load"));
    @Restricted(value={NoExternalUse.class})
    public static final String UNCOMPUTED_VERSION = "?";
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL", "PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public static String VERSION;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public static String CHANGELOG_URL;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public static String VERSION_HASH;
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL", "PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public static String SESSION_HASH;
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL", "PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public static String RESOURCE_PATH;
    @SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL", "PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public static String VIEW_RESOURCE_PATH;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean PARALLEL_LOAD;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean KILL_AFTER_LOAD;
    @Deprecated
    public static boolean FLYWEIGHT_SUPPORT;
    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public static boolean CONCURRENT_BUILD;
    private static final String WORKSPACE_DIRNAME;
    @Restricted(value={NoExternalUse.class})
    public static final String NAME_VALIDATION_REJECTS_TRAILING_DOT_PROP;
    private static final String DEFAULT_BUILDS_DIR = "${ITEM_ROOTDIR}/builds";
    private static final String OLD_DEFAULT_WORKSPACES_DIR;
    private static final String DEFAULT_WORKSPACES_DIR = "${JENKINS_HOME}/workspace/${ITEM_FULL_NAME}";
    static final String BUILDS_DIR_PROP;
    static final String WORKSPACES_DIR_PROP;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean AUTOMATIC_AGENT_LAUNCH;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static int EXTEND_TIMEOUT_SECONDS;
    private static final Logger LOGGER;
    private static final SecureRandom RANDOM;
    public static final PermissionGroup PERMISSIONS;
    public static final Permission ADMINISTER;
    public static final Permission MANAGE;
    public static final Permission SYSTEM_READ;
    @Restricted(value={NoExternalUse.class})
    public static final Permission[] MANAGE_AND_SYSTEM_READ;
    public static final Permission READ;
    @Deprecated
    public static final Permission RUN_SCRIPTS;
    private static final Set<String> ALWAYS_READABLE_PATHS;
    public static final org.springframework.security.core.Authentication ANONYMOUS2;
    @Deprecated
    public static final Authentication ANONYMOUS;

    @Restricted(value={Beta.class})
    public void loadNode(File dir) throws IOException {
        this.getNodesObject().load(dir);
    }

    private static int getSlaveAgentPortInitialValue(int def) {
        return SystemProperties.getInteger(Jenkins.class.getName() + ".slaveAgentPort", def);
    }

    public ServletContext getServletContext() {
        return this.jakartaServletContext;
    }

    @NonNull
    public static Jenkins get() throws IllegalStateException {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            throw new IllegalStateException("Jenkins.instance is missing. Read the documentation of Jenkins.getInstanceOrNull to see what you are doing wrong.");
        }
        return instance;
    }

    @Deprecated
    @NonNull
    public static Jenkins getActiveInstance() throws IllegalStateException {
        return Jenkins.get();
    }

    @CLIResolver
    @CheckForNull
    public static Jenkins getInstanceOrNull() {
        return HOLDER.getInstance();
    }

    @Deprecated
    @Nullable
    public static Jenkins getInstance() {
        return Jenkins.getInstanceOrNull();
    }

    protected Jenkins(File root, ServletContext context) throws IOException, InterruptedException, ReactorException {
        this(root, context, null);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "DM_EXIT"})
    protected Jenkins(File root, ServletContext context, PluginManager pluginManager) throws IOException, InterruptedException, ReactorException {
        this.oldJenkinsJVM = JenkinsJVM.isJenkinsJVM();
        JenkinsJVMAccess._setJenkinsJVM(true);
        long start = System.currentTimeMillis();
        STARTUP_MARKER_FILE = new FileBoolean(new File(root, ".lastStarted"));
        try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
            this.root = root;
            this.jakartaServletContext = context;
            this.servletContext = ServletContextWrapper.fromJakartServletContext((ServletContext)context);
            Jenkins.computeVersion(context);
            if (theInstance != null) {
                throw new IllegalStateException("second instance");
            }
            theInstance = this;
            if (!new File(root, "jobs").exists()) {
                this.workspaceDir = DEFAULT_WORKSPACES_DIR;
            }
            InitStrategy is = InitStrategy.get(Thread.currentThread().getContextClassLoader());
            Trigger.timer = new Timer("Jenkins cron thread");
            this.queue = new Queue(LoadBalancer.CONSISTENT_HASH);
            this.labelAtomSet = Collections.unmodifiableSet(Label.parse(this.label));
            try {
                this.dependencyGraph = DependencyGraph.EMPTY;
            }
            catch (InternalError e) {
                if (e.getMessage().contains("window server")) {
                    throw new Error("Looks like the server runs without X. Please specify -Djava.awt.headless=true as JVM option", e);
                }
                throw e;
            }
            TextFile secretFile = new TextFile(new File(this.getRootDir(), "secret.key"));
            if (secretFile.exists()) {
                this.secretKey = secretFile.readTrim();
            } else {
                byte[] random = new byte[32];
                RANDOM.nextBytes(random);
                this.secretKey = Util.toHexString(random);
                secretFile.write(this.secretKey);
                new FileBoolean(new File(root, "secret.key.not-so-secret")).on();
            }
            try {
                this.proxy = ProxyConfiguration.load();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to load proxy configuration", e);
            }
            if (pluginManager == null) {
                pluginManager = PluginManager.createDefault(this);
            }
            this.pluginManager = pluginManager;
            WebApp webApp = WebApp.get((ServletContext)this.getServletContext());
            webApp.setClassLoader(pluginManager.uberClassLoader);
            webApp.setJsonInErrorMessageSanitizer((JsonInErrorMessageSanitizer)RedactSecretJsonInErrorMessageSanitizer.INSTANCE);
            TypedFilter typedFilter = new TypedFilter();
            webApp.setFilterForGetMethods((FunctionList.Filter)typedFilter);
            webApp.setFilterForFields((FieldRef.Filter)typedFilter);
            webApp.setFilterForDoActions((FunctionList.Filter)new DoActionFilter());
            StaplerFilteredActionListener actionListener = new StaplerFilteredActionListener();
            webApp.setFilteredGetterTriggerListener((FilteredGetterTriggerListener)actionListener);
            webApp.setFilteredDoActionTriggerListener((FilteredDoActionTriggerListener)actionListener);
            webApp.setFilteredFieldTriggerListener((FilteredFieldTriggerListener)actionListener);
            webApp.setDispatchValidator((DispatchValidator)new StaplerDispatchValidator());
            webApp.setFilteredDispatchTriggerListener((FilteredDispatchTriggerListener)actionListener);
            this.adjuncts = new AdjunctManager(this.getServletContext(), pluginManager.uberClassLoader, "adjuncts/" + SESSION_HASH, TimeUnit.DAYS.toMillis(365L));
            ClassFilterImpl.register();
            LOGGER.info("Starting version " + String.valueOf(Jenkins.getVersion()));
            ConfidentialStore.get();
            this.executeReactor(is, pluginManager.initTasks(is), this.loadTasks(), InitMilestone.ordering());
            if (this.initLevel != InitMilestone.COMPLETED) {
                LOGGER.log(Level.SEVERE, "Jenkins initialization has not reached the COMPLETED initialization milestone after the startup. Current state: {0}. It may cause undefined incorrect behavior in Jenkins plugin relying on this state. It is likely an issue with the Initialization task graph. Example: usage of @Initializer(after = InitMilestone.COMPLETED) in a plugin (JENKINS-37759). Please create a bug in Jenkins bugtracker. ", (Object)this.initLevel);
            }
            if (KILL_AFTER_LOAD) {
                System.exit(0);
            }
            this.save();
            this.launchTcpSlaveAgentListener();
            jenkins.util.Timer.get().scheduleAtFixedRate(new SafeTimerTask(){

                @Override
                protected void doRun() throws Exception {
                    Jenkins.this.trimLabels();
                }
            }, TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(5L), TimeUnit.MILLISECONDS);
            this.updateComputerList();
            Computer c = this.toComputer();
            if (c != null) {
                for (ComputerListener cl : ComputerListener.all()) {
                    try {
                        cl.onOnline(c, new LogTaskListener(LOGGER, Level.INFO));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, String.format("Exception in onOnline() for the computer listener %s on the built-in node", cl.getClass()), e);
                    }
                }
            }
            for (ItemListener l : ItemListener.all()) {
                long itemListenerStart = System.currentTimeMillis();
                try {
                    l.onLoaded();
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
                if (!LOG_STARTUP_PERFORMANCE) continue;
                LOGGER.info(String.format("Took %dms for item listener %s startup", System.currentTimeMillis() - itemListenerStart, l.getClass().getName()));
            }
            if (LOG_STARTUP_PERFORMANCE) {
                LOGGER.info(String.format("Took %dms for complete Jenkins startup", System.currentTimeMillis() - start));
            }
            STARTUP_MARKER_FILE.on();
        }
    }

    protected Object readResolve() {
        if (this.jdks == null) {
            this.jdks = new ArrayList<JDK>();
        }
        if (SLAVE_AGENT_PORT_ENFORCE) {
            this.slaveAgentPort = Jenkins.getSlaveAgentPortInitialValue(this.slaveAgentPort);
        }
        this.installStateName = null;
        if (this.nodeRenameMigrationNeeded == null) {
            this.nodeRenameMigrationNeeded = true;
        }
        this._setLabelString(this.label);
        return this;
    }

    @CheckForNull
    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    public void setProxy(@CheckForNull ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    @NonNull
    public InstallState getInstallState() {
        if (this.installState != null) {
            this.installStateName = this.installState.name();
            this.installState = null;
        }
        InstallState is = this.installStateName != null ? InstallState.valueOf(this.installStateName) : InstallState.UNKNOWN;
        return is != null ? is : InstallState.UNKNOWN;
    }

    public void setInstallState(@NonNull InstallState newState) {
        String prior = this.installStateName;
        this.installStateName = newState.name();
        LOGGER.log(Main.isDevelopmentMode ? Level.INFO : Level.FINE, "Install state transitioning from: {0} to: {1}", new Object[]{prior, this.installStateName});
        if (!this.installStateName.equals(prior)) {
            this.getSetupWizard().onInstallStateUpdate(newState);
            newState.initializeState();
        }
    }

    private void executeReactor(final InitStrategy is, TaskBuilder ... builders) throws IOException, InterruptedException, ReactorException {
        Reactor reactor = new Reactor(builders){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runTask(Task task) throws Exception {
                block15: {
                    if (is != null && is.skipInitTask(task)) {
                        return;
                    }
                    String taskName = InitReactorRunner.getDisplayName(task);
                    Thread t = Thread.currentThread();
                    String name = t.getName();
                    if (taskName != null) {
                        t.setName(taskName);
                    }
                    try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                        long start = System.currentTimeMillis();
                        super.runTask(task);
                        if (AbstractCIBase.LOG_STARTUP_PERFORMANCE) {
                            LOGGER.info(String.format("Took %dms for %s by %s", System.currentTimeMillis() - start, taskName, name));
                        }
                    }
                    catch (Error | Exception x) {
                        if (this.containsLinkageError(x)) {
                            LOGGER.log(Level.WARNING, taskName + " failed perhaps due to plugin dependency issues", x);
                            break block15;
                        }
                        throw x;
                    }
                    finally {
                        t.setName(name);
                    }
                }
            }

            private boolean containsLinkageError(Throwable x) {
                if (x instanceof LinkageError) {
                    return true;
                }
                Throwable x2 = x.getCause();
                return x2 != null && this.containsLinkageError(x2);
            }
        };
        new InitReactorRunner(){

            @Override
            protected void onInitMilestoneAttained(InitMilestone milestone) {
                Jenkins.this.initLevel = milestone;
                Jenkins.this.getLifecycle().onExtendTimeout(EXTEND_TIMEOUT_SECONDS, TimeUnit.SECONDS);
                if (milestone == InitMilestone.PLUGINS_PREPARED) {
                    ExtensionList.lookup(ExtensionFinder.class).getComponents();
                }
            }
        }.run(reactor);
    }

    public TcpSlaveAgentListener getTcpSlaveAgentListener() {
        return this.tcpSlaveAgentListener;
    }

    public AdjunctManager getAdjuncts(String dummy) {
        return this.adjuncts;
    }

    @Exported
    public int getSlaveAgentPort() {
        return this.slaveAgentPort;
    }

    public boolean isSlaveAgentPortEnforced() {
        return SLAVE_AGENT_PORT_ENFORCE;
    }

    public void setSlaveAgentPort(int port) throws IOException {
        if (SLAVE_AGENT_PORT_ENFORCE) {
            LOGGER.log(Level.WARNING, "setSlaveAgentPort({0}) call ignored because system property {1} is true", new String[]{Integer.toString(port), Jenkins.class.getName() + ".slaveAgentPortEnforce"});
        } else {
            this.forceSetSlaveAgentPort(port);
        }
    }

    private void forceSetSlaveAgentPort(int port) throws IOException {
        this.slaveAgentPort = port;
        this.launchTcpSlaveAgentListener();
    }

    @NonNull
    public synchronized Set<String> getAgentProtocols() {
        return AgentProtocol.all().stream().map(AgentProtocol::getName).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
    }

    @Deprecated
    public synchronized void setAgentProtocols(@NonNull Set<String> protocols) {
        LOGGER.log(Level.WARNING, null, new IllegalStateException("Jenkins.agentProtocols no longer configurable"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTcpSlaveAgentListener() throws IOException {
        Object object = this.tcpSlaveAgentListenerLock;
        synchronized (object) {
            if (this.tcpSlaveAgentListener != null && this.tcpSlaveAgentListener.configuredPort != this.slaveAgentPort) {
                this.tcpSlaveAgentListener.shutdown();
                this.tcpSlaveAgentListener = null;
            }
            if (this.slaveAgentPort != -1 && this.tcpSlaveAgentListener == null) {
                String administrativeMonitorId = this.getClass().getName() + ".tcpBind";
                try {
                    this.tcpSlaveAgentListener = new TcpSlaveAgentListener(this.slaveAgentPort);
                    AdministrativeMonitor toBeRemoved = null;
                    ExtensionList<AdministrativeMonitor> all = AdministrativeMonitor.all();
                    for (AdministrativeMonitor am : all) {
                        if (!administrativeMonitorId.equals(am.id)) continue;
                        toBeRemoved = am;
                        break;
                    }
                    all.remove(toBeRemoved);
                }
                catch (BindException e) {
                    LOGGER.log(Level.WARNING, String.format("Failed to listen to incoming agent connections through port %s. Change the port number", this.slaveAgentPort), e);
                    new AdministrativeError(administrativeMonitorId, "Failed to listen to incoming agent connections", "Failed to listen to incoming agent connections. <a href='configureSecurity'>Change the inbound TCP port number</a> to solve the problem.", e);
                }
            }
        }
    }

    @Override
    public void setNodeName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNodeDescription() {
        return hudson.model.Messages.Hudson_NodeDescription();
    }

    @Exported
    public String getDescription() {
        return this.systemMessage;
    }

    @NonNull
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public UpdateCenter getUpdateCenter() {
        return this.updateCenter;
    }

    @CheckForNull
    public Boolean isNoUsageStatistics() {
        return this.noUsageStatistics;
    }

    public boolean isUsageStatisticsCollected() {
        return this.noUsageStatistics == null || this.noUsageStatistics == false;
    }

    public void setNoUsageStatistics(Boolean noUsageStatistics) throws IOException {
        this.noUsageStatistics = noUsageStatistics;
        this.save();
    }

    public Api getApi() {
        Object attribute;
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null && (attribute = req.getAttribute("jakarta.servlet.error.message")) != null) {
            return null;
        }
        return new Api(this);
    }

    @Deprecated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Deprecated
    public SecretKey getSecretKeyAsAES128() {
        return Util.toAes128Key(this.secretKey);
    }

    public String getLegacyInstanceId() {
        return Util.getDigestOf(this.getSecretKey());
    }

    public Descriptor<SCM> getScm(String shortClassName) {
        return this.findDescriptor(shortClassName, SCM.all());
    }

    public Descriptor<RepositoryBrowser<?>> getRepositoryBrowser(String shortClassName) {
        return this.findDescriptor(shortClassName, RepositoryBrowser.all());
    }

    public Descriptor<Builder> getBuilder(String shortClassName) {
        return this.findDescriptor(shortClassName, Builder.all());
    }

    public Descriptor<BuildWrapper> getBuildWrapper(String shortClassName) {
        return this.findDescriptor(shortClassName, BuildWrapper.all());
    }

    public Descriptor<Publisher> getPublisher(String shortClassName) {
        return this.findDescriptor(shortClassName, Publisher.all());
    }

    public TriggerDescriptor getTrigger(String shortClassName) {
        return (TriggerDescriptor)this.findDescriptor(shortClassName, Trigger.all());
    }

    public Descriptor<RetentionStrategy<?>> getRetentionStrategy(String shortClassName) {
        return this.findDescriptor(shortClassName, RetentionStrategy.all());
    }

    public JobPropertyDescriptor getJobProperty(String shortClassName) {
        Descriptor d = this.findDescriptor(shortClassName, JobPropertyDescriptor.all());
        return (JobPropertyDescriptor)d;
    }

    @Deprecated
    public ComputerSet getComputer() {
        return new ComputerSet();
    }

    @Restricted(value={DoNotUse.class})
    public CloudSet getCloud() {
        return new CloudSet();
    }

    public Descriptor getDescriptor(String id) {
        Iterable<Descriptor> descriptors = Iterators.sequence(this.getExtensionList(Descriptor.class), DescriptorExtensionList.listLegacyInstances());
        for (Descriptor d : descriptors) {
            if (!d.getId().equals(id)) continue;
            return d;
        }
        Descriptor candidate = null;
        for (Descriptor d : descriptors) {
            String name = d.getId();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(id)) continue;
            if (candidate == null) {
                candidate = d;
                continue;
            }
            throw new IllegalArgumentException(id + " is ambiguous; matches both " + name + " and " + candidate.getId());
        }
        return candidate;
    }

    @Override
    public Descriptor getDescriptorByName(String id) {
        return this.getDescriptor(id);
    }

    @CheckForNull
    public Descriptor getDescriptor(Class<? extends Describable> type) {
        for (Descriptor d : this.getExtensionList(Descriptor.class)) {
            if (d.clazz != type) continue;
            return d;
        }
        return null;
    }

    @NonNull
    public Descriptor getDescriptorOrDie(Class<? extends Describable> type) {
        Descriptor d = this.getDescriptor(type);
        if (d == null) {
            throw new AssertionError((Object)(String.valueOf(type) + " is missing its descriptor"));
        }
        return d;
    }

    public <T extends Descriptor> T getDescriptorByType(Class<T> type) {
        for (Descriptor d : this.getExtensionList(Descriptor.class)) {
            if (d.getClass() != type) continue;
            return (T)((Descriptor)type.cast(d));
        }
        return null;
    }

    public Descriptor<SecurityRealm> getSecurityRealms(String shortClassName) {
        return this.findDescriptor(shortClassName, SecurityRealm.all());
    }

    private <T extends Describable<T>> Descriptor<T> findDescriptor(String shortClassName, Collection<? extends Descriptor<T>> descriptors) {
        String name = "." + shortClassName;
        for (Descriptor<T> d : descriptors) {
            if (!d.clazz.getName().endsWith(name)) continue;
            return d;
        }
        return null;
    }

    protected void updateNewComputer(Node n) {
        this.updateNewComputer(n, AUTOMATIC_AGENT_LAUNCH);
    }

    protected void updateComputerList() {
        HashSet<Node> allNodes = new HashSet<Node>();
        allNodes.add(this);
        allNodes.addAll(this.getNodes());
        this.updateComputerList(AUTOMATIC_AGENT_LAUNCH, allNodes);
    }

    protected void updateComputers(Node ... nodes) {
        HashSet<Node> nodeSet = new HashSet<Node>();
        Collections.addAll(nodeSet, nodes);
        this.updateComputerList(AUTOMATIC_AGENT_LAUNCH, nodeSet);
    }

    @Deprecated
    public CopyOnWriteList<SCMListener> getSCMListeners() {
        return this.scmListeners;
    }

    @CheckForNull
    public Plugin getPlugin(String shortName) {
        PluginWrapper p = this.pluginManager.getPlugin(shortName);
        if (p == null) {
            return null;
        }
        return p.getPlugin();
    }

    @CheckForNull
    public <P extends Plugin> P getPlugin(Class<P> clazz) {
        PluginWrapper p = this.pluginManager.getPlugin(clazz);
        if (p == null) {
            return null;
        }
        return (P)p.getPlugin();
    }

    public <P extends Plugin> List<P> getPlugins(Class<P> clazz) {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        for (PluginWrapper w : this.pluginManager.getPlugins(clazz)) {
            result.add(w.getPlugin());
        }
        return Collections.unmodifiableList(result);
    }

    public String getSystemMessage() {
        return this.systemMessage;
    }

    @NonNull
    public MarkupFormatter getMarkupFormatter() {
        MarkupFormatter f = this.markupFormatter;
        return f != null ? f : new EscapedMarkupFormatter();
    }

    public void setMarkupFormatter(MarkupFormatter f) {
        this.markupFormatter = f;
    }

    public void setSystemMessage(String message) throws IOException {
        this.systemMessage = message;
        this.save();
    }

    @StaplerDispatchable
    public FederatedLoginService getFederatedLoginService(String name) {
        for (FederatedLoginService fls : FederatedLoginService.all()) {
            if (!fls.getUrlName().equals(name)) continue;
            return fls;
        }
        return null;
    }

    public List<FederatedLoginService> getFederatedLoginServices() {
        return FederatedLoginService.all();
    }

    @Override
    public Launcher createLauncher(TaskListener listener) {
        return new Launcher.LocalLauncher(listener).decorateFor(this);
    }

    @Override
    @NonNull
    public String getFullName() {
        return "";
    }

    @Override
    public String getFullDisplayName() {
        return "";
    }

    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    @Exported(name="jobs")
    public List<TopLevelItem> getItems() {
        return this.getItems(t -> true);
    }

    @Override
    public List<TopLevelItem> getItems(Predicate<TopLevelItem> pred) {
        ArrayList<TopLevelItem> viewableItems = new ArrayList<TopLevelItem>();
        for (TopLevelItem item : this.items.values()) {
            if (!pred.test(item) || !item.hasPermission(Item.READ)) continue;
            viewableItems.add(item);
        }
        return viewableItems;
    }

    public Map<String, TopLevelItem> getItemMap() {
        return Collections.unmodifiableMap(this.items);
    }

    @Override
    public <T> List<T> getItems(Class<T> type) {
        ArrayList<T> r = new ArrayList<T>();
        for (TopLevelItem i : this.getItems(type::isInstance)) {
            r.add(type.cast(i));
        }
        return r;
    }

    @Deprecated
    public List<Project> getProjects() {
        return Util.createSubList(this.items.values(), Project.class);
    }

    public Collection<String> getJobNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Job j : this.allItems(Job.class)) {
            names.add(j.getFullName());
        }
        names.sort(String.CASE_INSENSITIVE_ORDER);
        return names;
    }

    @Restricted(value={NoExternalUse.class})
    public ComboBoxModel doFillJobNameItems() {
        return new ComboBoxModel((Collection<? extends String>)this.getJobNames());
    }

    @Override
    public List<Action> getViewActions() {
        return this.getActions();
    }

    public Collection<String> getTopLevelItemNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (TopLevelItem j : this.items.values()) {
            names.add(j.getName());
        }
        return names;
    }

    @Override
    @CheckForNull
    public View getView(@CheckForNull String name) {
        return this.viewGroupMixIn.getView(name);
    }

    @Override
    @Exported
    public Collection<View> getViews() {
        return this.viewGroupMixIn.getViews();
    }

    @Override
    public void addView(@NonNull View v) throws IOException {
        this.viewGroupMixIn.addView(v);
    }

    public void setViews(Collection<View> views) throws IOException {
        try (BulkChange bc = new BulkChange(this);){
            this.views.clear();
            for (View v : views) {
                this.addView(v);
            }
            bc.commit();
        }
    }

    @Override
    public boolean canDelete(View view) {
        return this.viewGroupMixIn.canDelete(view);
    }

    @Override
    public synchronized void deleteView(View view) throws IOException {
        this.viewGroupMixIn.deleteView(view);
    }

    @Override
    public void onViewRenamed(View view, String oldName, String newName) {
        this.viewGroupMixIn.onViewRenamed(view, oldName, newName);
    }

    @Override
    @Exported
    public View getPrimaryView() {
        return this.viewGroupMixIn.getPrimaryView();
    }

    public void setPrimaryView(@NonNull View v) {
        this.primaryView = v.getViewName();
    }

    @Override
    public ViewsTabBar getViewsTabBar() {
        return this.viewsTabBar;
    }

    public void setViewsTabBar(ViewsTabBar viewsTabBar) {
        this.viewsTabBar = viewsTabBar;
    }

    public Jenkins getItemGroup() {
        return this;
    }

    @Deprecated
    public MyViewsTabBar getMyViewsTabBar() {
        return this.myViewsTabBar;
    }

    @Deprecated
    public void setMyViewsTabBar(MyViewsTabBar myViewsTabBar) {
        this.myViewsTabBar = myViewsTabBar;
    }

    public boolean isUpgradedFromBefore(VersionNumber v) {
        try {
            return new VersionNumber(this.version).isOlderThan(v);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Computer[] getComputers() {
        return (Computer[])this.getComputersCollection().stream().sorted(Comparator.comparing(Computer::getName)).toArray(Computer[]::new);
    }

    @CLIResolver
    @CheckForNull
    public Computer getComputer(@Argument(required=true, metaVar="NAME", usage="Node name") @NonNull String name) {
        if (name.equals("(built-in)") || name.equals("(master)")) {
            name = "";
        }
        for (Computer c : this.getComputersCollection()) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @CheckForNull
    public Label getLabel(String expr) {
        if (expr == null) {
            return null;
        }
        expr = QuotedStringTokenizer.unquote((String)expr);
        Label l;
        while ((l = this.labels.get(expr)) == null) {
            try {
                this.labels.putIfAbsent(expr, Label.parseExpression(expr));
            }
            catch (IllegalArgumentException e) {
                return this.getLabelAtom(expr);
            }
        }
        return l;
    }

    @Nullable
    public LabelAtom getLabelAtom(@CheckForNull String name) {
        if (name == null) {
            return null;
        }
        Label l;
        while ((l = this.labels.get(name)) == null) {
            LabelAtom la = new LabelAtom(name);
            if (this.labels.putIfAbsent(name, la) != null) continue;
            la.load();
        }
        return (LabelAtom)l;
    }

    @Restricted(value={NoExternalUse.class})
    @Nullable
    public LabelAtom tryGetLabelAtom(@NonNull String name) {
        Label label = this.labels.get(name);
        if (label instanceof LabelAtom) {
            return (LabelAtom)label;
        }
        return null;
    }

    public Set<Label> getLabels() {
        TreeSet<Label> r = new TreeSet<Label>();
        for (Label l : this.labels.values()) {
            if (l.isEmpty()) continue;
            r.add(l);
        }
        return r;
    }

    @Override
    protected Set<LabelAtom> getLabelAtomSet() {
        return this.labelAtomSet;
    }

    public Set<LabelAtom> getLabelAtoms() {
        TreeSet<LabelAtom> r = new TreeSet<LabelAtom>();
        for (Label l : this.labels.values()) {
            if (l.isEmpty() || !(l instanceof LabelAtom)) continue;
            r.add((LabelAtom)l);
        }
        return r;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public String getDisplayName() {
        return hudson.model.Messages.Hudson_DisplayName();
    }

    public List<JDK> getJDKs() {
        return this.jdks;
    }

    @Restricted(value={NoExternalUse.class})
    public void setJDKs(Collection<? extends JDK> jdks) {
        this.jdks = new ArrayList<JDK>(jdks);
    }

    public JDK getJDK(String name) {
        if (name == null) {
            List<JDK> jdks = this.getJDKs();
            if (jdks.size() == 1) {
                return jdks.get(0);
            }
            return null;
        }
        for (JDK j : this.getJDKs()) {
            if (!j.getName().equals(name)) continue;
            return j;
        }
        return null;
    }

    @CheckForNull
    public Node getNode(String name) {
        return this.nodes.getNode(name);
    }

    @Restricted(value={Beta.class})
    @CheckForNull
    public Node getOrLoadNode(String nodeName) {
        return this.getNodesObject().getOrLoad(nodeName);
    }

    public Cloud getCloud(String name) {
        return this.clouds.getByName(name);
    }

    @Override
    protected ConcurrentMap<Node, Computer> getComputerMap() {
        return this.computers;
    }

    @Restricted(value={NoExternalUse.class})
    public Collection<Computer> getComputersCollection() {
        return this.computers.values();
    }

    @Override
    @NonNull
    public List<Node> getNodes() {
        return this.nodes.getNodes();
    }

    @Restricted(value={NoExternalUse.class})
    public Nodes getNodesObject() {
        return this.nodes;
    }

    public void addNode(Node n) throws IOException {
        this.nodes.addNode(n);
    }

    public void removeNode(@NonNull Node n) throws IOException {
        this.nodes.removeNode(n);
    }

    @Restricted(value={Beta.class})
    public void unloadNode(@NonNull Node n) {
        this.nodes.unload(n);
    }

    public boolean updateNode(Node n) throws IOException {
        return this.nodes.updateNode(n);
    }

    public void setNodes(List<? extends Node> n) throws IOException {
        this.nodes.setNodes(n);
    }

    @Override
    public DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        return this.nodeProperties;
    }

    public DescribableList<NodeProperty<?>, NodePropertyDescriptor> getGlobalNodeProperties() {
        return this.globalNodeProperties;
    }

    void trimLabels() {
        this.trimLabels((Set<LabelAtom>)null);
    }

    void trimLabels(Node ... nodes) {
        HashSet<LabelAtom> includedLabels = new HashSet<LabelAtom>();
        Arrays.stream(nodes).filter(Objects::nonNull).forEach(n -> includedLabels.addAll(n.drainLabelsToTrim()));
        this.trimLabels(includedLabels);
    }

    private void trimLabels(@CheckForNull Set<LabelAtom> includedLabels) {
        HashSet<Set<LabelAtom>> nodeLabels = new HashSet<Set<LabelAtom>>();
        nodeLabels.add(this.getAssignedLabels());
        this.getNodes().forEach(n -> nodeLabels.add(n.getAssignedLabels()));
        Iterator<Label> itr = this.labels.values().iterator();
        while (itr.hasNext()) {
            Label l = itr.next();
            if (includedLabels != null && !includedLabels.contains(l)) {
                if (!l.matches(includedLabels)) continue;
            }
            if (nodeLabels.stream().anyMatch(l::matches) || !l.getClouds().isEmpty()) {
                this.resetLabel(l);
                continue;
            }
            itr.remove();
        }
    }

    @CheckForNull
    public AdministrativeMonitor getAdministrativeMonitor(String id) {
        for (AdministrativeMonitor m : this.administrativeMonitors) {
            if (!m.id.equals(id)) continue;
            return m;
        }
        return null;
    }

    public List<AdministrativeMonitor> getActiveAdministrativeMonitors() {
        if (!AdministrativeMonitor.hasPermissionToDisplay()) {
            return Collections.emptyList();
        }
        return this.administrativeMonitors.stream().filter(m -> {
            try {
                return m.hasRequiredPermission() && m.isEnabled() && m.isActivated();
            }
            catch (Throwable x) {
                LOGGER.log(Level.WARNING, null, x);
                return false;
            }
        }).collect(Collectors.toList());
    }

    @Override
    public NodeDescriptor getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    public int getQuietPeriod() {
        return this.quietPeriod != null ? this.quietPeriod : 5;
    }

    public void setQuietPeriod(Integer quietPeriod) throws IOException {
        this.quietPeriod = quietPeriod;
        this.save();
    }

    public int getScmCheckoutRetryCount() {
        return this.scmCheckoutRetryCount;
    }

    public void setScmCheckoutRetryCount(int scmCheckoutRetryCount) throws IOException {
        this.scmCheckoutRetryCount = scmCheckoutRetryCount;
        this.save();
    }

    @Override
    public String getSearchUrl() {
        return "";
    }

    @Override
    public SearchIndexBuilder makeSearchIndex() {
        SearchIndexBuilder builder = super.makeSearchIndex();
        this.actions.stream().filter(e -> e.getIconFileName() != null && e.getUrlName() != null).forEach(action -> builder.add(new SearchItem(){
            final /* synthetic */ Action val$action;
            {
                this.val$action = action;
            }

            @Override
            public String getSearchName() {
                return this.val$action.getDisplayName();
            }

            @Override
            public String getSearchUrl() {
                return this.val$action.getUrlName();
            }

            @Override
            public String getSearchIcon() {
                return this.val$action.getIconFileName();
            }

            @Override
            public SearchIndex getSearchIndex() {
                return SearchIndex.EMPTY;
            }
        }));
        builder.add(new CollectionSearchIndex<TopLevelItem>(){

            @Override
            protected SearchItem get(String key) {
                return Jenkins.this.getItemByFullName(key, TopLevelItem.class);
            }

            @Override
            protected Collection<TopLevelItem> all() {
                return Jenkins.this.getAllItems(TopLevelItem.class);
            }

            @Override
            @NonNull
            protected Iterable<TopLevelItem> allAsIterable() {
                return Jenkins.this.allItems(TopLevelItem.class);
            }
        }).add(this.getPrimaryView().makeSearchIndex()).add(new CollectionSearchIndex(){

            @Override
            protected Computer get(String key) {
                return Jenkins.this.getComputer(key);
            }

            protected Collection<Computer> all() {
                return Jenkins.this.getComputersCollection();
            }
        }).add(new CollectionSearchIndex(){

            @Override
            protected User get(String key) {
                return User.get(key, false);
            }

            protected Collection<User> all() {
                return User.getAll();
            }
        }).add(new CollectionSearchIndex(){

            @Override
            protected View get(String key) {
                return Jenkins.this.getView(key);
            }

            protected Collection<View> all() {
                return Jenkins.this.getAllViews();
            }
        });
        return builder;
    }

    @Override
    public String getUrlChildPrefix() {
        return "job";
    }

    @Nullable
    public String getRootUrl() throws IllegalStateException {
        JenkinsLocationConfiguration config = JenkinsLocationConfiguration.get();
        String url = config.getUrl();
        if (url != null) {
            return Util.ensureEndsWith(url, "/");
        }
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null) {
            return this.getRootUrlFromRequest();
        }
        return null;
    }

    @Exported(name="url")
    @Restricted(value={DoNotUse.class})
    @CheckForNull
    public String getConfiguredRootUrl() {
        JenkinsLocationConfiguration config = JenkinsLocationConfiguration.get();
        return config.getUrl();
    }

    public boolean isRootUrlSecure() {
        String url = this.getRootUrl();
        return url != null && url.startsWith("https");
    }

    @NonNull
    public String getRootUrlFromRequest() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            throw new IllegalStateException("cannot call getRootUrlFromRequest from outside a request handling thread");
        }
        StringBuilder buf = new StringBuilder();
        String scheme = Jenkins.getXForwardedHeader(req, "X-Forwarded-Proto", req.getScheme());
        buf.append(scheme).append("://");
        String host = Jenkins.getXForwardedHeader(req, "X-Forwarded-Host", req.getServerName());
        int index = host.lastIndexOf(58);
        int port = req.getServerPort();
        if (index == -1) {
            buf.append(host);
        } else if (host.startsWith("[") && host.endsWith("]")) {
            buf.append(host);
        } else {
            buf.append(host, 0, index);
            if (index + 1 < host.length()) {
                try {
                    port = Integer.parseInt(host.substring(index + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String forwardedPort = Jenkins.getXForwardedHeader(req, "X-Forwarded-Port", null);
        if (forwardedPort != null) {
            try {
                port = Integer.parseInt(forwardedPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port != ("https".equals(scheme) ? 443 : 80)) {
            buf.append(':').append(port);
        }
        buf.append(req.getContextPath()).append('/');
        return buf.toString();
    }

    private static String getXForwardedHeader(StaplerRequest2 req, String header, String defaultValue) {
        String value = req.getHeader(header);
        if (value != null) {
            int index = value.indexOf(44);
            return index == -1 ? value.trim() : value.substring(0, index).trim();
        }
        return defaultValue;
    }

    @Override
    public File getRootDir() {
        return this.root;
    }

    @Override
    public FilePath getWorkspaceFor(TopLevelItem item) {
        for (WorkspaceLocator l : WorkspaceLocator.all()) {
            FilePath workspace = l.locate(item, this);
            if (workspace == null) continue;
            return workspace;
        }
        return new FilePath(this.expandVariablesForDirectory(this.workspaceDir, item));
    }

    public File getBuildDirFor(Job job) {
        return this.expandVariablesForDirectory(this.buildsDir, job);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isDefaultBuildDir() {
        return DEFAULT_BUILDS_DIR.equals(this.buildsDir);
    }

    @Restricted(value={NoExternalUse.class})
    boolean isDefaultWorkspaceDir() {
        return OLD_DEFAULT_WORKSPACES_DIR.equals(this.workspaceDir) || DEFAULT_WORKSPACES_DIR.equals(this.workspaceDir);
    }

    private File expandVariablesForDirectory(String base, Item item) {
        return new File(Jenkins.expandVariablesForDirectory(base, item.getFullName(), item.getRootDir().getPath()));
    }

    @Restricted(value={NoExternalUse.class})
    public static String expandVariablesForDirectory(String base, String itemFullName, String itemRootDir) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("JENKINS_HOME", Jenkins.get().getRootDir().getPath());
        properties.put("ITEM_ROOTDIR", itemRootDir);
        properties.put("ITEM_FULLNAME", itemFullName);
        properties.put("ITEM_FULL_NAME", itemFullName.replace(':', '$'));
        return Util.replaceMacro(base, Collections.unmodifiableMap(properties));
    }

    public String getRawWorkspaceDir() {
        return this.workspaceDir;
    }

    public String getRawBuildsDir() {
        return this.buildsDir;
    }

    @Restricted(value={NoExternalUse.class})
    public void setRawBuildsDir(String buildsDir) {
        this.buildsDir = buildsDir;
    }

    @Override
    @NonNull
    public FilePath getRootPath() {
        return new FilePath(this.getRootDir());
    }

    @Override
    public FilePath createPath(String absolutePath) {
        return new FilePath((VirtualChannel)null, absolutePath);
    }

    @Override
    public ClockDifference getClockDifference() {
        return ClockDifference.ZERO;
    }

    @Override
    public Callable<ClockDifference, IOException> getClockDifferenceCallable() {
        return new ClockDifferenceCallable();
    }

    public LogRecorderManager getLog() {
        this.checkPermission(SYSTEM_READ);
        return this.log;
    }

    public void setLog(LogRecorderManager log) {
        this.checkPermission(ADMINISTER);
        this.log = log;
    }

    @Exported
    public boolean isUseSecurity() {
        return this.securityRealm != SecurityRealm.NO_AUTHENTICATION || this.authorizationStrategy != AuthorizationStrategy.UNSECURED;
    }

    public boolean isUseProjectNamingStrategy() {
        return this.projectNamingStrategy != ProjectNamingStrategy.DEFAULT_NAMING_STRATEGY;
    }

    @Exported
    public boolean isUseCrumbs() {
        return this.crumbIssuer != null;
    }

    public SecurityMode getSecurity() {
        SecurityRealm realm = this.securityRealm;
        if (realm == SecurityRealm.NO_AUTHENTICATION) {
            return SecurityMode.UNSECURED;
        }
        if (realm instanceof LegacySecurityRealm) {
            return SecurityMode.LEGACY;
        }
        return SecurityMode.SECURED;
    }

    public SecurityRealm getSecurityRealm() {
        return this.securityRealm;
    }

    public void setSecurityRealm(@CheckForNull SecurityRealm securityRealm) {
        if (securityRealm == null) {
            securityRealm = SecurityRealm.NO_AUTHENTICATION;
        }
        this.useSecurity = true;
        IdStrategy oldUserIdStrategy = this.securityRealm == null ? securityRealm.getUserIdStrategy() : this.securityRealm.getUserIdStrategy();
        this.securityRealm = securityRealm;
        this.resetFilter(securityRealm, oldUserIdStrategy);
        this.saveQuietly();
    }

    private void resetFilter(@CheckForNull SecurityRealm securityRealm, @CheckForNull IdStrategy oldUserIdStrategy) {
        try {
            HudsonFilter filter = HudsonFilter.get(this.getServletContext());
            if (filter == null) {
                LOGGER.fine("HudsonFilter has not yet been initialized: Can't perform security setup for now");
            } else {
                LOGGER.fine("HudsonFilter has been previously initialized: Setting security up");
                filter.reset(securityRealm);
                LOGGER.fine("Security is now fully set up");
            }
            if (oldUserIdStrategy != null && this.securityRealm != null && !oldUserIdStrategy.equals(this.securityRealm.getUserIdStrategy())) {
                User.rekey();
            }
        }
        catch (ServletException e) {
            throw new RuntimeException("Failed to configure filter", e){};
        }
    }

    public void setAuthorizationStrategy(@CheckForNull AuthorizationStrategy a) {
        if (a == null) {
            a = AuthorizationStrategy.UNSECURED;
        }
        this.useSecurity = true;
        this.authorizationStrategy = a;
        this.saveQuietly();
    }

    public boolean isDisableRememberMe() {
        return this.disableRememberMe;
    }

    public void setDisableRememberMe(boolean disableRememberMe) {
        this.disableRememberMe = disableRememberMe;
    }

    public void disableSecurity() {
        this.useSecurity = null;
        this.setSecurityRealm(SecurityRealm.NO_AUTHENTICATION);
        this.authorizationStrategy = AuthorizationStrategy.UNSECURED;
    }

    public void setProjectNamingStrategy(ProjectNamingStrategy ns) {
        if (ns == null) {
            ns = ProjectNamingStrategy.DEFAULT_NAMING_STRATEGY;
        }
        this.projectNamingStrategy = ns;
    }

    public Lifecycle getLifecycle() {
        return Lifecycle.get();
    }

    @CheckForNull
    public Injector getInjector() {
        return Jenkins.lookup(Injector.class);
    }

    public <T> ExtensionList<T> getExtensionList(Class<T> extensionType) {
        ExtensionList extensionList = this.extensionLists.get(extensionType);
        return extensionList != null ? extensionList : this.extensionLists.computeIfAbsent(extensionType, key -> ExtensionList.create(this, key));
    }

    @Deprecated(since="2.519")
    public ExtensionList getExtensionList(String extensionType) throws ClassNotFoundException {
        return this.getExtensionList(this.pluginManager.uberClassLoader.loadClass(extensionType));
    }

    @NonNull
    public <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> getDescriptorList(Class<T> type) {
        return this.descriptorLists.computeIfAbsent(type, key -> DescriptorExtensionList.createDescriptorList(this, key));
    }

    /*
     * WARNING - void declaration
     */
    public void refreshExtensions() throws ExtensionRefreshException {
        void var3_8;
        ExtensionList<ExtensionFinder> finders = this.getExtensionList(ExtensionFinder.class);
        LOGGER.finer(() -> "refreshExtensions " + String.valueOf(finders));
        for (ExtensionFinder extensionFinder : finders) {
            if (extensionFinder.isRefreshable()) continue;
            throw new ExtensionRefreshException(String.valueOf(extensionFinder) + " doesn't support refresh");
        }
        ArrayList<ExtensionComponentSet> fragments = new ArrayList<ExtensionComponentSet>();
        for (ExtensionFinder ef : finders) {
            LOGGER.finer(() -> "searching " + String.valueOf(ef));
            fragments.add(ef.refresh());
        }
        ExtensionComponentSet extensionComponentSet = ExtensionComponentSet.union(fragments).filtered();
        ArrayList<ExtensionComponent<ExtensionFinder>> newFinders = new ArrayList<ExtensionComponent<ExtensionFinder>>(extensionComponentSet.find(ExtensionFinder.class));
        while (!newFinders.isEmpty()) {
            void var3_6;
            ExtensionFinder f = (ExtensionFinder)((ExtensionComponent)newFinders.remove(newFinders.size() - 1)).getInstance();
            LOGGER.finer(() -> "found new ExtensionFinder " + String.valueOf(f));
            ExtensionComponentSet ecs = ExtensionComponentSet.allOf(f).filtered();
            newFinders.addAll(ecs.find(ExtensionFinder.class));
            ExtensionComponentSet extensionComponentSet2 = ExtensionComponentSet.union(new ExtensionComponentSet[]{var3_6, ecs});
        }
        for (ExtensionFinder ef : finders) {
            LOGGER.finer(() -> "searching again in " + String.valueOf(ef));
            ExtensionComponentSet extensionComponentSet3 = ExtensionComponentSet.union(new ExtensionComponentSet[]{var3_8, ef.refresh().filtered()});
        }
        ArrayList<ExtensionList> listsToFireOnChangeListeners = new ArrayList<ExtensionList>();
        for (ExtensionList extensionList : this.extensionLists.values()) {
            if (!extensionList.refresh((ExtensionComponentSet)var3_8)) continue;
            listsToFireOnChangeListeners.add(extensionList);
        }
        for (ExtensionList extensionList : this.descriptorLists.values()) {
            if (!extensionList.refresh((ExtensionComponentSet)var3_8)) continue;
            listsToFireOnChangeListeners.add(extensionList);
        }
        for (ExtensionList<Object> extensionList : listsToFireOnChangeListeners) {
            extensionList.fireOnChangeListeners();
        }
        for (ExtensionComponent extensionComponent : var3_8.find(RootAction.class)) {
            Action a = (Action)extensionComponent.getInstance();
            if (this.actions.contains(a)) continue;
            this.actions.add(a);
        }
    }

    @Override
    @NonNull
    public ACL getACL() {
        return this.authorizationStrategy.getRootACL();
    }

    public AuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    public ProjectNamingStrategy getProjectNamingStrategy() {
        return this.projectNamingStrategy == null ? ProjectNamingStrategy.DEFAULT_NAMING_STRATEGY : this.projectNamingStrategy;
    }

    @Exported
    public boolean isQuietingDown() {
        return this.quietDownInfo != null;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public boolean isPreparingSafeRestart() {
        QuietDownInfo quietDownInfo = this.quietDownInfo;
        if (quietDownInfo != null) {
            return quietDownInfo.isSafeRestart();
        }
        return false;
    }

    @Exported
    @CheckForNull
    public String getQuietDownReason() {
        QuietDownInfo info = this.quietDownInfo;
        return info != null ? info.message : null;
    }

    public boolean isTerminating() {
        return this.terminating;
    }

    public InitMilestone getInitLevel() {
        return this.initLevel;
    }

    public void setNumExecutors(int n) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Incorrect field \"# of executors\": " + n + ". It should be a non-negative number.");
        }
        if (this.numExecutors != n) {
            this.numExecutors = n;
            this.updateComputers(this);
            this.save();
        }
    }

    @Override
    public TopLevelItem getItem(String name) throws AccessDeniedException {
        if (name == null) {
            return null;
        }
        TopLevelItem item = this.items.get(name);
        if (item == null) {
            return null;
        }
        if (!item.hasPermission(Item.READ)) {
            if (item.hasPermission(Item.DISCOVER)) {
                throw new AccessDeniedException("Please login to access job " + name);
            }
            return null;
        }
        return item;
    }

    public Item getItem(String pathName, ItemGroup context) {
        if (context == null) {
            context = this;
        }
        if (pathName == null) {
            return null;
        }
        if (pathName.startsWith("/")) {
            return this.getItemByFullName(pathName);
        }
        PersistenceRoot ctx = context;
        StringTokenizer tokens = new StringTokenizer(pathName, "/");
        while (tokens.hasMoreTokens()) {
            String s = tokens.nextToken();
            if (s.equals("..")) {
                if (ctx instanceof Item) {
                    ctx = ((Item)ctx).getParent();
                    continue;
                }
                ctx = null;
                break;
            }
            if (s.equals(".")) continue;
            if (ctx instanceof ItemGroup) {
                ItemGroup<? extends Item> g = ctx;
                Item i = g.getItem(s);
                if (i == null || !i.hasPermission(Item.READ)) {
                    ctx = null;
                    break;
                }
                ctx = i;
                continue;
            }
            return null;
        }
        if (ctx instanceof Item) {
            return (Item)ctx;
        }
        return this.getItemByFullName(pathName);
    }

    public final Item getItem(String pathName, Item context) {
        return this.getItem(pathName, context != null ? context.getParent() : null);
    }

    public final <T extends Item> T getItem(String pathName, ItemGroup context, @NonNull Class<T> type) {
        Item r = this.getItem(pathName, context);
        if (type.isInstance(r)) {
            return (T)((Item)type.cast(r));
        }
        return null;
    }

    public final <T extends Item> T getItem(String pathName, Item context, Class<T> type) {
        return this.getItem(pathName, context != null ? context.getParent() : null, type);
    }

    @Override
    public File getRootDirFor(TopLevelItem child) {
        return this.getRootDirFor(child.getName());
    }

    @Override
    private File getRootDirFor(String name) {
        return new File(new File(this.getRootDir(), "jobs"), name);
    }

    @CheckForNull
    public <T extends Item> T getItemByFullName(@NonNull String fullName, Class<T> type) throws AccessDeniedException {
        StringTokenizer tokens = new StringTokenizer(fullName, "/");
        ItemGroup<TopLevelItem> parent = this;
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        while (true) {
            Object item = parent.getItem(tokens.nextToken());
            if (!tokens.hasMoreTokens()) {
                if (type.isInstance(item)) {
                    return (T)((Item)type.cast(item));
                }
                return null;
            }
            if (!(item instanceof ItemGroup)) {
                return null;
            }
            if (!item.hasPermission(Item.READ)) {
                return null;
            }
            parent = (ItemGroup)item;
        }
    }

    @CheckForNull
    public Item getItemByFullName(String fullName) {
        return this.getItemByFullName(fullName, Item.class);
    }

    @CheckForNull
    public User getUser(String name) {
        return User.get(name, User.ALLOW_USER_CREATION_VIA_URL && this.hasPermission(ADMINISTER));
    }

    @NonNull
    public synchronized TopLevelItem createProject(@NonNull TopLevelItemDescriptor type, @NonNull String name) throws IOException {
        return this.createProject(type, name, true);
    }

    @Override
    @NonNull
    public synchronized TopLevelItem createProject(@NonNull TopLevelItemDescriptor type, @NonNull String name, boolean notify) throws IOException {
        return this.itemGroupMixIn.createProject(type, name, notify);
    }

    public synchronized void putItem(TopLevelItem item) throws IOException, InterruptedException {
        String name = item.getName();
        TopLevelItem old = this.items.get(name);
        if (old == item) {
            return;
        }
        this.checkPermission(Item.CREATE);
        if (old != null) {
            old.delete();
        }
        this.items.put(name, item);
        ItemListener.fireOnCreated(item);
    }

    @NonNull
    public synchronized <T extends TopLevelItem> T createProject(@NonNull Class<T> type, @NonNull String name) throws IOException {
        return (T)((TopLevelItem)type.cast(this.createProject((TopLevelItemDescriptor)this.getDescriptorOrDie(type), name)));
    }

    @Override
    public void onRenamed(TopLevelItem job, String oldName, String newName) throws IOException {
        this.items.remove(oldName);
        this.items.put(newName, job);
        for (View v : this.views) {
            v.onJobRenamed(job, oldName, newName);
        }
    }

    @Override
    public void onDeleted(TopLevelItem item) throws IOException {
        ItemListener.fireOnDeleted(item);
        this.items.remove(item.getName());
        for (View v : this.views) {
            v.onJobRenamed(item, item.getName(), null);
        }
    }

    @Override
    public boolean canAdd(TopLevelItem item) {
        return true;
    }

    @Override
    public synchronized <I extends TopLevelItem> I add(I item, String name) throws IOException, IllegalArgumentException {
        if (this.items.containsKey(name)) {
            throw new IllegalArgumentException("already an item '" + name + "'");
        }
        this.items.put(name, item);
        return item;
    }

    @Override
    public void remove(TopLevelItem item) throws IOException, IllegalArgumentException {
        this.items.remove(item.getName());
    }

    public FingerprintMap getFingerprintMap() {
        return this.fingerprintMap;
    }

    @StaplerDispatchable
    public Object getFingerprint(String md5sum) throws IOException {
        Fingerprint r = (Fingerprint)this.fingerprintMap.get(md5sum);
        if (r == null) {
            return new NoFingerprintMatch(md5sum);
        }
        return r;
    }

    public Fingerprint _getFingerprint(String md5sum) throws IOException {
        return (Fingerprint)this.fingerprintMap.get(md5sum);
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    protected XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, new File(this.root, "config.xml"));
    }

    @Override
    public int getNumExecutors() {
        return this.numExecutors;
    }

    @Override
    public Node.Mode getMode() {
        return this.mode;
    }

    public void setMode(Node.Mode m) throws IOException {
        this.mode = m;
        this.save();
    }

    @Override
    public String getLabelString() {
        return Util.fixNull(this.label).trim();
    }

    @Override
    public void setLabelString(String label) throws IOException {
        this._setLabelString(label);
        this.save();
    }

    private void _setLabelString(String label) {
        this.label = label;
        if (Jenkins.getInstanceOrNull() != null) {
            this.labelAtomSet = Collections.unmodifiableSet(Label.parse(label));
        }
    }

    @Override
    @NonNull
    public LabelAtom getSelfLabel() {
        if (nodeNameAndSelfLabelOverride != null) {
            return this.getLabelAtom(nodeNameAndSelfLabelOverride);
        }
        if (this.getRenameMigrationDone()) {
            return this.getLabelAtom("built-in");
        }
        return this.getLabelAtom("master");
    }

    boolean getRenameMigrationDone() {
        if (this.nodeRenameMigrationNeeded == null) {
            return true;
        }
        return this.nodeRenameMigrationNeeded == false;
    }

    void performRenameMigration() throws IOException {
        this.nodeRenameMigrationNeeded = false;
        this.save();
        this.trimLabels();
    }

    @Override
    @NonNull
    public Computer createComputer() {
        return new Hudson.MasterComputer();
    }

    @Override
    public void load() throws IOException {
        XmlFile cfg = this.getConfigFile();
        if (cfg.exists()) {
            String originalPrimaryView = this.primaryView;
            ArrayList<View> originalViews = new ArrayList<View>(this.views);
            this.primaryView = null;
            this.views.clear();
            try {
                cfg.unmarshal(this);
            }
            catch (IOException | RuntimeException x) {
                this.primaryView = originalPrimaryView;
                this.views.clear();
                this.views.addAll(originalViews);
                throw x;
            }
        }
        if (this.views.isEmpty() || this.primaryView == null) {
            AllView v = new AllView("all");
            this.setViewOwner(v);
            this.views.add(0, v);
            this.primaryView = v.getViewName();
        }
        this.primaryView = AllView.migrateLegacyPrimaryAllViewLocalizedName(this.views, this.primaryView);
        this.clouds.setOwner(this);
        this.configLoaded = true;
        try {
            Jenkins.checkRawBuildsDir(this.buildsDir);
            this.setBuildsAndWorkspacesDir();
            this.resetFilter(this.securityRealm, null);
        }
        catch (InvalidBuildsDir invalidBuildsDir) {
            throw new IOException(invalidBuildsDir);
        }
        this.updateComputers(this);
    }

    private void setBuildsAndWorkspacesDir() throws IOException, InvalidBuildsDir {
        boolean mustSave = false;
        String newBuildsDir = SystemProperties.getString(BUILDS_DIR_PROP);
        boolean freshStartup = STARTUP_MARKER_FILE.isOff();
        if (newBuildsDir != null && !this.buildsDir.equals(newBuildsDir)) {
            Jenkins.checkRawBuildsDir(newBuildsDir);
            Level level = freshStartup ? Level.INFO : Level.WARNING;
            LOGGER.log(level, "Changing builds directories from {0} to {1}. Beware that no automated data migration will occur.", new String[]{this.buildsDir, newBuildsDir});
            this.buildsDir = newBuildsDir;
            mustSave = true;
        } else if (!this.isDefaultBuildDir()) {
            LOGGER.log(Level.INFO, "Using non default builds directories: {0}.", this.buildsDir);
        }
        String newWorkspacesDir = SystemProperties.getString(WORKSPACES_DIR_PROP);
        if (newWorkspacesDir != null && !this.workspaceDir.equals(newWorkspacesDir)) {
            Level level = freshStartup ? Level.INFO : Level.WARNING;
            LOGGER.log(level, "Changing workspaces directories from {0} to {1}. Beware that no automated data migration will occur.", new String[]{this.workspaceDir, newWorkspacesDir});
            this.workspaceDir = newWorkspacesDir;
            mustSave = true;
        } else if (!this.isDefaultWorkspaceDir()) {
            LOGGER.log(Level.INFO, "Using non default workspaces directories: {0}.", this.workspaceDir);
        }
        if (mustSave) {
            this.save();
        }
    }

    @VisibleForTesting
    static void checkRawBuildsDir(String newBuildsDirValue) throws InvalidBuildsDir {
        File d;
        String replacedValue = Jenkins.expandVariablesForDirectory(newBuildsDirValue, "doCheckRawBuildsDir-Marker:foo", Jenkins.get().getRootDir().getPath() + "/jobs/doCheckRawBuildsDir-Marker$foo");
        File replacedFile = new File(replacedValue);
        if (!replacedFile.isAbsolute()) {
            throw new InvalidBuildsDir(newBuildsDirValue + " does not resolve to an absolute path");
        }
        if (!replacedValue.contains("doCheckRawBuildsDir-Marker")) {
            throw new InvalidBuildsDir(newBuildsDirValue + " does not contain ${ITEM_FULL_NAME} or ${ITEM_ROOTDIR}, cannot distinguish between projects");
        }
        if (replacedValue.contains("doCheckRawBuildsDir-Marker:foo")) {
            try {
                File tmp = File.createTempFile("Jenkins-doCheckRawBuildsDir", "foo:bar");
                Files.delete(tmp.toPath());
            }
            catch (IOException | InvalidPathException e) {
                throw (InvalidBuildsDir)new InvalidBuildsDir(newBuildsDirValue + " contains ${ITEM_FULLNAME} but your system does not support it (JENKINS-12251). Use ${ITEM_FULL_NAME} instead").initCause(e);
            }
        }
        if (!(d = new File(replacedValue)).isDirectory()) {
            while (!(d = d.getParentFile()).exists()) {
            }
            if (!d.canWrite()) {
                throw new InvalidBuildsDir(newBuildsDirValue + " does not exist and probably cannot be created");
            }
        }
    }

    private synchronized TaskBuilder loadTasks() throws IOException {
        File projectsDir = new File(this.root, "jobs");
        if (!projectsDir.getCanonicalFile().isDirectory() && !projectsDir.mkdirs()) {
            if (projectsDir.exists()) {
                throw new IOException(String.valueOf(projectsDir) + " is not a directory");
            }
            throw new IOException("Unable to create " + String.valueOf(projectsDir) + "\nPermission issue? Please create this directory manually.");
        }
        File[] subdirs = projectsDir.listFiles();
        final Set loadedNames = Collections.synchronizedSet(new HashSet());
        TaskGraphBuilder g = new TaskGraphBuilder();
        TaskGraphBuilder.Handle loadJenkins = g.requires(new Milestone[]{InitMilestone.EXTENSIONS_AUGMENTED}).attains(new Milestone[]{InitMilestone.SYSTEM_CONFIG_LOADED}).add("Loading global config", new Executable(){

            public void run(Reactor session) throws Exception {
                Jenkins.this.load();
                if (Jenkins.this.slaves != null && !Jenkins.this.slaves.isEmpty() && Jenkins.this.nodes.isLegacy()) {
                    Jenkins.this.nodes.setNodes(Jenkins.this.slaves);
                    Jenkins.this.slaves = null;
                } else {
                    Jenkins.this.nodes.load();
                }
            }
        });
        ArrayList<TaskGraphBuilder.Handle> loadJobs = new ArrayList<TaskGraphBuilder.Handle>();
        for (final File subdir : subdirs) {
            loadJobs.add(g.requires(new Milestone[]{loadJenkins}).attains(new Milestone[]{InitMilestone.JOB_LOADED}).notFatal().add("Loading item " + subdir.getName(), new Executable(){

                public void run(Reactor session) throws Exception {
                    if (!Items.getConfigFile(subdir).exists()) {
                        return;
                    }
                    TopLevelItem item = (TopLevelItem)Items.load(Jenkins.this, subdir);
                    Jenkins.this.items.put(item.getName(), item);
                    loadedNames.add(item.getName());
                }
            }));
        }
        g.requires((Milestone[])loadJobs.toArray(new TaskGraphBuilder.Handle[0])).attains(new Milestone[]{InitMilestone.JOB_LOADED}).add("Cleaning up obsolete items deleted from the disk", new Executable(){

            public void run(Reactor reactor) {
                for (String name : Jenkins.this.items.keySet()) {
                    if (loadedNames.contains(name)) continue;
                    Jenkins.this.items.remove(name);
                }
            }
        });
        g.requires(new Milestone[]{InitMilestone.JOB_CONFIG_ADAPTED}).attains(new Milestone[]{InitMilestone.COMPLETED}).add("Finalizing set up", new Executable(){

            public void run(Reactor session) throws Exception {
                Jenkins.this.rebuildDependencyGraph();
                for (Node node : Jenkins.this.nodes.getNodes()) {
                    node.getAssignedLabels();
                }
                Jenkins.this.getAssignedLabels();
                if (Jenkins.this.useSecurity != null && !Jenkins.this.useSecurity.booleanValue()) {
                    Jenkins.this.authorizationStrategy = AuthorizationStrategy.UNSECURED;
                    Jenkins.this.setSecurityRealm(SecurityRealm.NO_AUTHENTICATION);
                } else {
                    if (Jenkins.this.authorizationStrategy == null) {
                        Jenkins.this.authorizationStrategy = Jenkins.this.useSecurity == null ? AuthorizationStrategy.UNSECURED : new LegacyAuthorizationStrategy();
                    }
                    if (Jenkins.this.securityRealm == null) {
                        if (Jenkins.this.useSecurity == null) {
                            Jenkins.this.setSecurityRealm(SecurityRealm.NO_AUTHENTICATION);
                        } else {
                            Jenkins.this.setSecurityRealm(new LegacySecurityRealm());
                        }
                    }
                }
                Jenkins.this.setCrumbIssuer(Jenkins.this.getCrumbIssuer());
                for (Action action : Jenkins.this.getExtensionList(RootAction.class)) {
                    if (Jenkins.this.actions.contains(action)) continue;
                    Jenkins.this.actions.add(action);
                }
                Jenkins.this.setupWizard = ExtensionList.lookupSingleton(SetupWizard.class);
                Jenkins.this.getInstallState().initializeState();
            }
        });
        return g;
    }

    @Override
    public synchronized void save() throws IOException {
        InitMilestone currentMilestone = this.initLevel;
        if (!this.configLoaded) {
            LOGGER.log(Level.SEVERE, "An attempt to save Jenkins'' global configuration before it has been loaded has been made during milestone " + String.valueOf((Object)currentMilestone) + ".  This is indicative of a bug in the caller and may lead to full or partial loss of configuration.", new IllegalStateException("call trace"));
            throw new IllegalStateException("An attempt to save the global configuration was made before it was loaded");
        }
        if (BulkChange.contains(this)) {
            return;
        }
        if (currentMilestone == InitMilestone.COMPLETED) {
            LOGGER.log(Level.FINE, "setting version {0} to {1}", new Object[]{this.version, VERSION});
            this.version = VERSION;
        } else {
            LOGGER.log(Level.FINE, "refusing to set version {0} to {1} during {2}", new Object[]{this.version, VERSION, currentMilestone});
        }
        if (this.nodeRenameMigrationNeeded == null) {
            this.nodeRenameMigrationNeeded = false;
        }
        this.getConfigFile().write(this);
        SaveableListener.fireOnChange(this, this.getConfigFile());
    }

    private void saveQuietly() {
        try {
            this.save();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        if (theInstance != this && theInstance != null) {
            LOGGER.log(Level.WARNING, "This instance is no longer the singleton, ignoring cleanUp()");
            return;
        }
        Class<Jenkins> clazz = Jenkins.class;
        synchronized (Jenkins.class) {
            if (this.cleanUpStarted) {
                LOGGER.log(Level.WARNING, "Jenkins.cleanUp() already started, ignoring repeated cleanUp()");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.cleanUpStarted = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                this.getLifecycle().onStatusUpdate("Stopping Jenkins");
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                this.fireBeforeShutdown(errors);
                this._cleanUpRunTerminators(errors);
                this.terminating = true;
                Set<Future<?>> pending = this._cleanUpDisconnectComputers(errors);
                this._cleanUpCancelDependencyGraphCalculation();
                this._cleanUpInterruptReloadThread(errors);
                this._cleanUpShutdownTriggers(errors);
                this._cleanUpShutdownTimer(errors);
                this._cleanUpShutdownTcpSlaveAgent(errors);
                this._cleanUpShutdownPluginManager(errors);
                this._cleanUpPersistQueue(errors);
                this._cleanUpShutdownThreadPoolForLoad(errors);
                this._cleanUpAwaitDisconnects(errors, pending);
                this._cleanUpPluginServletFilters(errors);
                this._cleanUpReleaseAllLoggers(errors);
                this.getLifecycle().onStatusUpdate("Jenkins stopped");
                if (!errors.isEmpty()) {
                    StringBuilder message = new StringBuilder("Unexpected issues encountered during cleanUp: ");
                    Iterator iterator = errors.iterator();
                    message.append(((Throwable)iterator.next()).getMessage());
                    while (iterator.hasNext()) {
                        message.append("; ");
                        message.append(((Throwable)iterator.next()).getMessage());
                    }
                    iterator = errors.iterator();
                    RuntimeException exception = new RuntimeException(message.toString(), (Throwable)iterator.next());
                    while (iterator.hasNext()) {
                        exception.addSuppressed((Throwable)iterator.next());
                    }
                    throw exception;
                }
            }
            finally {
                theInstance = null;
                if (JenkinsJVM.isJenkinsJVM()) {
                    JenkinsJVMAccess._setJenkinsJVM(this.oldJenkinsJVM);
                }
                ClassFilterImpl.unregister();
            }
            return;
        }
    }

    private void fireBeforeShutdown(List<Throwable> errors) {
        LOGGER.log(Level.FINE, "Notifying termination");
        for (ItemListener l : ItemListener.all()) {
            try {
                l.onBeforeShutdown();
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (LinkageError e) {
                LOGGER.log(Level.WARNING, e, () -> "ItemListener " + String.valueOf(l) + ": " + e.getMessage());
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, e, () -> "ItemListener " + String.valueOf(l) + ": " + e.getMessage());
                errors.add(e);
            }
        }
    }

    private void _cleanUpRunTerminators(List<Throwable> errors) {
        try {
            TerminatorFinder tf = new TerminatorFinder(this.pluginManager != null ? this.pluginManager.uberClassLoader : Thread.currentThread().getContextClassLoader());
            new Reactor(new TaskBuilder[]{tf}).execute(Runnable::run, new ReactorListener(){
                final Level level = Level.parse(SystemProperties.getString(Jenkins.class.getName() + ".termLogLevel", "FINE"));

                public void onTaskStarted(Task t) {
                    LOGGER.log(this.level, "Started {0}", InitReactorRunner.getDisplayName(t));
                }

                public void onTaskCompleted(Task t) {
                    LOGGER.log(this.level, "Completed {0}", InitReactorRunner.getDisplayName(t));
                }

                public void onTaskFailed(Task t, Throwable err, boolean fatal) {
                    LOGGER.log(Level.SEVERE, err, () -> "Failed " + InitReactorRunner.getDisplayName(t));
                }

                public void onAttained(Milestone milestone) {
                    Level lv = this.level;
                    Object s = "Attained " + milestone.toString();
                    if (milestone instanceof TermMilestone && !Main.isUnitTest) {
                        lv = Level.INFO;
                        s = milestone.toString();
                    }
                    LOGGER.log(lv, (String)s);
                }
            });
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.SEVERE, "Failed to execute termination", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to execute termination", e);
            errors.add(e);
        }
    }

    private Set<Future<?>> _cleanUpDisconnectComputers(List<Throwable> errors) {
        LOGGER.log(Main.isUnitTest ? Level.FINE : Level.INFO, "Starting node disconnection");
        HashSet pending = new HashSet();
        Queue.withLock(() -> {
            for (Computer c : this.getComputersCollection()) {
                try {
                    c.interrupt();
                    this.killComputer(c);
                    pending.add(c.disconnect(null));
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (LinkageError e) {
                    LOGGER.log(Level.WARNING, e, () -> "Could not disconnect " + String.valueOf(c) + ": " + e.getMessage());
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, e, () -> "Could not disconnect " + String.valueOf(c) + ": " + e.getMessage());
                    errors.add(e);
                }
            }
        });
        return pending;
    }

    private void _cleanUpInterruptReloadThread(List<Throwable> errors) {
        LOGGER.log(Level.FINE, "Interrupting reload thread");
        try {
            this.interruptReloadThread();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.WARNING, "Not permitted to interrupt reload thread", e);
            errors.add(e);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.SEVERE, "Failed to interrupt reload thread", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to interrupt reload thread", e);
            errors.add(e);
        }
    }

    private void _cleanUpShutdownTriggers(List<Throwable> errors) {
        LOGGER.log(Level.FINE, "Shutting down triggers");
        try {
            final Timer timer = Trigger.timer;
            if (timer != null) {
                final CountDownLatch latch = new CountDownLatch(1);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        timer.cancel();
                        latch.countDown();
                    }
                }, 0L);
                if (latch.await(10L, TimeUnit.SECONDS)) {
                    LOGGER.log(Level.FINE, "Triggers shut down successfully");
                } else {
                    timer.cancel();
                    LOGGER.log(Level.INFO, "Gave up waiting for triggers to finish running");
                }
            }
            Trigger.timer = null;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.SEVERE, "Failed to shut down triggers", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to shut down triggers", e);
            errors.add(e);
        }
    }

    private void _cleanUpShutdownTimer(List<Throwable> errors) {
        LOGGER.log(Level.FINE, "Shutting down timer");
        try {
            jenkins.util.Timer.shutdown();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.WARNING, "Not permitted to shut down Timer", e);
            errors.add(e);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.SEVERE, "Failed to shut down Timer", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to shut down Timer", e);
            errors.add(e);
        }
    }

    private void _cleanUpShutdownTcpSlaveAgent(List<Throwable> errors) {
        if (this.tcpSlaveAgentListener != null) {
            LOGGER.log(Level.FINE, "Shutting down TCP/IP agent listener");
            try {
                this.tcpSlaveAgentListener.shutdown();
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (LinkageError e) {
                LOGGER.log(Level.SEVERE, "Failed to shut down TCP/IP agent listener", e);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to shut down TCP/IP agent listener", e);
                errors.add(e);
            }
        }
    }

    private void _cleanUpShutdownPluginManager(List<Throwable> errors) {
        if (this.pluginManager != null) {
            LOGGER.log(Main.isUnitTest ? Level.FINE : Level.INFO, "Stopping plugin manager");
            try {
                this.pluginManager.stop();
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (LinkageError e) {
                LOGGER.log(Level.SEVERE, "Failed to stop plugin manager", e);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to stop plugin manager", e);
                errors.add(e);
            }
        }
    }

    private void _cleanUpPersistQueue(List<Throwable> errors) {
        if (this.getRootDir().exists()) {
            LOGGER.log(Main.isUnitTest ? Level.FINE : Level.INFO, "Persisting build queue");
            try {
                this.getQueue().save();
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (LinkageError e) {
                LOGGER.log(Level.SEVERE, "Failed to persist build queue", e);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to persist build queue", e);
                errors.add(e);
            }
        }
    }

    private void _cleanUpShutdownThreadPoolForLoad(List<Throwable> errors) {
        LOGGER.log(Level.FINE, "Shutting down Jenkins load thread pool");
        try {
            this.threadPoolForLoad.shutdown();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.WARNING, "Not permitted to shut down Jenkins load thread pool", e);
            errors.add(e);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.SEVERE, "Failed to shut down Jenkins load thread pool", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to shut down Jenkins load thread pool", e);
            errors.add(e);
        }
    }

    private void _cleanUpAwaitDisconnects(List<Throwable> errors, Set<Future<?>> pending) {
        if (!pending.isEmpty()) {
            LOGGER.log(Main.isUnitTest ? Level.FINE : Level.INFO, "Waiting for node disconnection completion");
        }
        for (Future<?> f : pending) {
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException e) {
                LOGGER.log(Level.WARNING, "Failed to shut down remote computer connection cleanly", e);
            }
            catch (TimeoutException e) {
                LOGGER.log(Level.WARNING, "Failed to shut down remote computer connection within 10 seconds", e);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (LinkageError e) {
                LOGGER.log(Level.WARNING, "Failed to shut down remote computer connection", e);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Unexpected error while waiting for remote computer connection disconnect", e);
                errors.add(e);
            }
        }
    }

    private void _cleanUpPluginServletFilters(List<Throwable> errors) {
        LOGGER.log(Level.FINE, "Stopping filters");
        try {
            PluginServletFilter.cleanUp();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.SEVERE, "Failed to stop filters", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to stop filters", e);
            errors.add(e);
        }
    }

    private void _cleanUpReleaseAllLoggers(List<Throwable> errors) {
        LOGGER.log(Level.FINE, "Releasing all loggers");
        try {
            LogFactory.releaseAll();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.SEVERE, "Failed to release all loggers", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to release all loggers", e);
            errors.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cleanUpCancelDependencyGraphCalculation() {
        Object object = this.dependencyGraphLock;
        synchronized (object) {
            LOGGER.log(Level.FINE, "Canceling internal dependency graph calculation");
            if (this.scheduledFutureDependencyGraph != null && !this.scheduledFutureDependencyGraph.isDone()) {
                this.scheduledFutureDependencyGraph.cancel(true);
            }
            if (this.calculatingFutureDependencyGraph != null && !this.calculatingFutureDependencyGraph.isDone()) {
                this.calculatingFutureDependencyGraph.cancel(true);
            }
        }
    }

    public Object getDynamic(String token) {
        for (Action action : this.getActions()) {
            String url = action.getUrlName();
            if (url == null || !url.equals(token) && !url.equals("/" + token)) continue;
            return action;
        }
        for (Action action : this.getManagementLinks()) {
            if (!Objects.equals(action.getUrlName(), token)) continue;
            return action;
        }
        return null;
    }

    @POST
    public synchronized void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        try (BulkChange bc = new BulkChange(this);){
            this.checkPermission(MANAGE);
            JSONObject json = req.getSubmittedForm();
            this.systemMessage = Util.nullify(req.getParameter("system_message"));
            boolean result = true;
            for (Descriptor d : Functions.getSortedDescriptorsForGlobalConfigUnclassified()) {
                result &= this.configureDescriptor(req, json, d);
            }
            this.save();
            this.updateComputers(this);
            if (result) {
                FormApply.success(req.getContextPath() + "/").generateResponse(req, rsp, null);
            } else {
                FormApply.success("configure").generateResponse(req, rsp, null);
            }
            bc.commit();
        }
    }

    @CheckForNull
    public CrumbIssuer getCrumbIssuer() {
        return GlobalCrumbIssuerConfiguration.DISABLE_CSRF_PROTECTION ? null : this.crumbIssuer;
    }

    public void setCrumbIssuer(CrumbIssuer issuer) {
        this.crumbIssuer = issuer;
    }

    public synchronized void doTestPost(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        rsp.sendRedirect("foo");
    }

    private boolean configureDescriptor(StaplerRequest2 req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }

    @POST
    public synchronized void doConfigExecutorsSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(ADMINISTER);
        try (BulkChange bc = new BulkChange(this);){
            JSONObject json = req.getSubmittedForm();
            ExtensionList.lookupSingleton(MasterBuildConfiguration.class).configure(req, json);
            this.getNodeProperties().rebuild(req, json.optJSONObject("nodeProperties"), NodeProperty.all());
            bc.commit();
        }
        this.updateComputers(this);
        FormApply.success(req.getContextPath() + "/" + this.toComputer().getUrl()).generateResponse(req, rsp, null);
    }

    @RequirePOST
    public synchronized void doSubmitDescription(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.getPrimaryView().doSubmitDescription(req, rsp);
    }

    @RequirePOST
    public synchronized HttpRedirect doQuietDown() {
        try {
            return this.doQuietDown(false, 0, null);
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public synchronized HttpRedirect doQuietDown(boolean block, int timeout) {
        try {
            return this.doQuietDown(block, timeout, null);
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated(since="2.414")
    public HttpRedirect doQuietDown(boolean block, int timeout, @CheckForNull String message) throws InterruptedException, IOException {
        return this.doQuietDown(block, timeout, message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public HttpRedirect doQuietDown(@QueryParameter boolean block, @QueryParameter int timeout, @QueryParameter @CheckForNull String message, @QueryParameter boolean safeRestart) throws InterruptedException, IOException {
        Jenkins jenkins = this;
        synchronized (jenkins) {
            this.checkPermission(MANAGE);
            this.quietDownInfo = new QuietDownInfo(message, safeRestart);
        }
        if (block) {
            long waitUntil = timeout;
            if (timeout > 0) {
                waitUntil += System.currentTimeMillis();
            }
            while (this.isQuietingDown() && (timeout <= 0 || System.currentTimeMillis() < waitUntil) && !RestartListener.isAllReady()) {
                TimeUnit.SECONDS.sleep(1L);
            }
        }
        return new HttpRedirect(".");
    }

    @RequirePOST
    public synchronized HttpRedirect doCancelQuietDown() {
        this.checkPermission(MANAGE);
        this.quietDownInfo = null;
        this.getQueue().scheduleMaintenance();
        return new HttpRedirect(".");
    }

    @POST
    public HttpResponse doToggleCollapse() throws ServletException, IOException {
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        String paneId = request.getParameter("paneId");
        PaneStatusProperties.forCurrentUser().toggleCollapsed(paneId);
        return HttpResponses.forwardToPreviousPage();
    }

    public void doClassicThreadDump(StaplerResponse2 rsp) throws IOException, ServletException {
        rsp.sendRedirect2("threadDump");
    }

    public Map<String, Map<String, String>> getAllThreadDumps() throws IOException, InterruptedException {
        this.checkPermission(ADMINISTER);
        HashMap<String, hudson.remoting.Future<Map<String, String>>> future = new HashMap<String, hudson.remoting.Future<Map<String, String>>>();
        for (Computer c : this.getComputers()) {
            try {
                future.put(c.getName(), RemotingDiagnostics.getThreadDumpAsync(c.getChannel()));
            }
            catch (Exception e) {
                LOGGER.info("Failed to get thread dump for node " + c.getName() + ": " + e.getMessage());
            }
        }
        if (this.toComputer() == null) {
            future.put("master", RemotingDiagnostics.getThreadDumpAsync((VirtualChannel)FilePath.localChannel));
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        HashMap<String, Map<String, String>> r = new HashMap<String, Map<String, String>>();
        for (Map.Entry e : future.entrySet()) {
            try {
                r.put((String)e.getKey(), (Map)((Future)e.getValue()).get(endTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            }
            catch (Exception x) {
                r.put((String)e.getKey(), Map.of("Failed to retrieve thread dump", Functions.printThrowable(x)));
            }
        }
        return Collections.unmodifiableSortedMap(new TreeMap(r));
    }

    @Override
    @RequirePOST
    public synchronized TopLevelItem doCreateItem(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        return this.itemGroupMixIn.createTopLevelItem(req, rsp);
    }

    @Override
    public TopLevelItem createProjectFromXML(String name, InputStream xml) throws IOException {
        return this.itemGroupMixIn.createProjectFromXML(name, xml);
    }

    @Override
    public <T extends TopLevelItem> T copy(T src, String name) throws IOException {
        return this.itemGroupMixIn.copy(src, name);
    }

    @Override
    public <T extends AbstractProject<?, ?>> T copy(T src, String name) throws IOException {
        return (T)((AbstractProject)((Object)this.copy((TopLevelItem)((Object)src), name)));
    }

    @POST
    public synchronized void doCreateView(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.addView(View.create(req, rsp, (ViewGroup)this));
    }

    public static void checkGoodName(String name) throws Failure {
        if (name == null || name.isEmpty()) {
            throw new Failure(hudson.model.Messages.Hudson_NoName());
        }
        if (".".equals(name.trim())) {
            throw new Failure(hudson.model.Messages.Jenkins_NotAllowedName("."));
        }
        if ("..".equals(name.trim())) {
            throw new Failure(hudson.model.Messages.Jenkins_NotAllowedName(".."));
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isISOControl(ch)) {
                throw new Failure(hudson.model.Messages.Hudson_ControlCodeNotAllowed(Jenkins.toPrintableName(name)));
            }
            if ("?*/\\%!@#$^&|<>[]:;".indexOf(ch) == -1) continue;
            throw new Failure(hudson.model.Messages.Hudson_UnsafeChar(Character.valueOf(ch)));
        }
        if (SystemProperties.getBoolean(NAME_VALIDATION_REJECTS_TRAILING_DOT_PROP, true) && name.trim().endsWith(".")) {
            throw new Failure(hudson.model.Messages.Hudson_TrailingDot());
        }
    }

    private static String toPrintableName(String name) {
        StringBuilder printableName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isISOControl(ch)) {
                printableName.append("\\u").append((int)ch).append(';');
                continue;
            }
            printableName.append(ch);
        }
        return printableName.toString();
    }

    public void doSecured(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (req.getUserPrincipal() == null) {
            rsp.setStatus(401);
            return;
        }
        String path = req.getContextPath() + req.getOriginalRestOfPath();
        String q = req.getQueryString();
        if (q != null) {
            path = path + UNCOMPUTED_VERSION + q;
        }
        rsp.sendRedirect2(path);
    }

    public void doLoginEntry(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (req.getUserPrincipal() == null) {
            rsp.sendRedirect2("noPrincipal");
            return;
        }
        String from = req.getParameter("from");
        if (from != null && from.startsWith("/") && !from.equals("/loginError")) {
            rsp.sendRedirect2(from);
            return;
        }
        rsp.sendRedirect2(".");
    }

    public void doLogout(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        String user = Jenkins.getAuthentication2().getName();
        this.securityRealm.doLogout(req, rsp);
        SecurityListener.fireLoggedOut(user);
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException {
        try {
            this.doLogout(req != null ? StaplerRequest.toStaplerRequest2((StaplerRequest)req) : null, rsp != null ? StaplerResponse.toStaplerResponse2((StaplerResponse)rsp) : null);
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    public Slave.JnlpJar getJnlpJars(String fileName) {
        return new Slave.JnlpJar(fileName);
    }

    public Slave.JnlpJar doJnlpJars(StaplerRequest2 req) {
        return new Slave.JnlpJar(req.getRestOfPath().substring(1));
    }

    @RequirePOST
    public synchronized HttpResponse doReload() throws IOException {
        this.checkPermission(MANAGE);
        this.getLifecycle().onReload(Jenkins.getAuthentication2().getName(), null);
        WebApp.get((ServletContext)this.getServletContext()).setApp((Object)new HudsonIsLoading());
        new Thread("Jenkins config reload thread"){

            @Override
            public void run() {
                try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                    Jenkins.this.reload();
                    Jenkins.this.getLifecycle().onReady();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed to reload Jenkins config", e);
                    new JenkinsReloadFailed(e).publish(Jenkins.this.getServletContext(), Jenkins.this.root);
                }
            }
        }.start();
        return HttpResponses.redirectViaContextPath((String)"/");
    }

    public void reload() throws IOException, InterruptedException, ReactorException {
        this.queue.save();
        this.executeReactor(null, this.loadTasks());
        if (this.initLevel != InitMilestone.COMPLETED) {
            LOGGER.log(Level.SEVERE, "Jenkins initialization has not reached the COMPLETED initialization milestone after the configuration reload. Current state: {0}. It may cause undefined incorrect behavior in Jenkins plugin relying on this state. It is likely an issue with the Initialization task graph. Example: usage of @Initializer(after = InitMilestone.COMPLETED) in a plugin (JENKINS-37759). Please create a bug in Jenkins bugtracker.", (Object)this.initLevel);
        }
        User.reload();
        this.queue.load();
        WebApp.get((ServletContext)this.getServletContext()).setApp((Object)this);
    }

    @RequirePOST
    public void doDoFingerprintCheck(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        try (MultipartFormDataParser p = new MultipartFormDataParser((HttpServletRequest)req, 10);){
            if (this.isUseCrumbs() && !this.getCrumbIssuer().validateCrumb((ServletRequest)req, p)) {
                rsp.sendError(403, "No crumb found");
            }
            rsp.sendRedirect2(req.getContextPath() + "/fingerprint/" + Util.getDigestOf(p.getFileItem2("name").getInputStream()) + "/");
        }
    }

    @RequirePOST
    @SuppressFBWarnings(value={"DM_GC"}, justification="for debugging")
    public void doGc(StaplerResponse2 rsp) throws IOException {
        this.checkPermission(ADMINISTER);
        System.gc();
        rsp.setStatus(200);
        rsp.setContentType("text/plain");
        rsp.getWriter().println("GCed");
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest2 request, StaplerResponse2 response) throws IOException, JellyException {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu().from((ModelObjectWithContextMenu)this, request, response);
        for (ModelObjectWithContextMenu.MenuItem i : menu.items) {
            if (!i.url.equals(request.getContextPath() + "/manage")) continue;
            i.subMenu = new ModelObjectWithContextMenu.ContextMenu().from(ExtensionList.lookupSingleton(ManageJenkinsAction.class), request, response, "index");
        }
        return menu;
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest2 request, StaplerResponse2 response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (View view : this.getViews()) {
            menu.add(view.getViewUrl(), view.getDisplayName());
        }
        return menu;
    }

    public RemotingDiagnostics.HeapDump getHeapDump() throws IOException {
        return new RemotingDiagnostics.HeapDump(this, (VirtualChannel)FilePath.localChannel);
    }

    @RequirePOST
    public void doSimulateOutOfMemory() throws IOException {
        this.checkPermission(ADMINISTER);
        System.out.println("Creating artificial OutOfMemoryError situation");
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        while (true) {
            args.add(new byte[0x100000]);
        }
    }

    public DirectoryBrowserSupport doUserContent() {
        return new DirectoryBrowserSupport((ModelObject)this, this.getRootPath().child("userContent"), "User content", "folder.png", true);
    }

    @CLIMethod(name="restart")
    public void doRestart(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, RestartNotSupportedException {
        this.checkPermission(MANAGE);
        if (req != null && req.getMethod().equals("GET")) {
            req.getView((Object)this, "_restart.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        if (req == null || req.getMethod().equals("POST")) {
            this.restart();
        }
        if (rsp != null) {
            rsp.sendRedirect2(".");
        }
    }

    @WebMethod(name={"404"})
    @Restricted(value={NoExternalUse.class})
    public void generateNotFoundResponse(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        if (ResourceDomainConfiguration.isResourceRequest((HttpServletRequest)req)) {
            rsp.forward((Object)this, "_404_simple", req);
        } else {
            Object attribute = req.getAttribute("jenkins.ErrorAttributeFilter.user");
            if (attribute instanceof org.springframework.security.core.Authentication) {
                try (ACLContext unused = ACL.as2((org.springframework.security.core.Authentication)attribute);){
                    rsp.forward((Object)this, "_404", req);
                }
            } else {
                rsp.forward((Object)this, "_404", req);
            }
        }
    }

    @Deprecated(since="2.414")
    public HttpResponse doSafeRestart(StaplerRequest req) throws IOException, ServletException, RestartNotSupportedException {
        return this.doSafeRestart(req != null ? StaplerRequest.toStaplerRequest2((StaplerRequest)req) : null, null);
    }

    public HttpResponse doSafeRestart(StaplerRequest2 req, @QueryParameter(value="message") String message) throws IOException, ServletException, RestartNotSupportedException {
        this.checkPermission(MANAGE);
        if (req != null && req.getMethod().equals("GET")) {
            return HttpResponses.forwardToView((Object)this, (String)"_safeRestart.jelly");
        }
        if (req != null && req.getParameter("cancel") != null) {
            return this.doCancelQuietDown();
        }
        if (req == null || req.getMethod().equals("POST")) {
            this.safeRestart(message);
        }
        return HttpResponses.redirectToDot();
    }

    @Deprecated
    @StaplerNotDispatchable
    public HttpResponse doSafeRestart(StaplerRequest req, @QueryParameter(value="message") String message) throws IOException, javax.servlet.ServletException, RestartNotSupportedException {
        try {
            return this.doSafeRestart(req != null ? StaplerRequest.toStaplerRequest2((StaplerRequest)req) : null, message);
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    private static Lifecycle restartableLifecycle() throws RestartNotSupportedException {
        if (Main.isUnitTest) {
            throw new RestartNotSupportedException("Restarting the controller JVM is not supported in JenkinsRule-based tests");
        }
        Lifecycle lifecycle = Lifecycle.get();
        lifecycle.verifyRestartable();
        return lifecycle;
    }

    public void restart() throws RestartNotSupportedException {
        final Lifecycle lifecycle = Jenkins.restartableLifecycle();
        this.getServletContext().setAttribute("app", (Object)new HudsonIsRestarting());
        new Thread("restart thread"){
            final String exitUser;
            {
                super(arg0);
                this.exitUser = Jenkins.getAuthentication2().getName();
            }

            @Override
            public void run() {
                try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                    lifecycle.onStatusUpdate("Restart in 5 seconds");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                    lifecycle.onStop(this.exitUser, null);
                    Listeners.notify(RestartListener.class, true, RestartListener::onRestart);
                    lifecycle.restart();
                }
                catch (InterruptedIOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Interrupted while trying to restart Jenkins", e);
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to restart Jenkins", e);
                }
            }
        }.start();
    }

    @Deprecated(since="2.414")
    public void safeRestart() throws RestartNotSupportedException {
        this.safeRestart(null);
    }

    public void safeRestart(final String message) throws RestartNotSupportedException {
        final Lifecycle lifecycle = Jenkins.restartableLifecycle();
        this.quietDownInfo = new QuietDownInfo(message, true);
        new Thread("safe-restart thread"){
            final String exitUser;
            {
                super(arg0);
                this.exitUser = Jenkins.getAuthentication2().getName();
            }

            @Override
            public void run() {
                try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                    Jenkins.this.doQuietDown(true, 0, message, true);
                    if (Jenkins.this.isQuietingDown()) {
                        Jenkins.this.getServletContext().setAttribute("app", (Object)new HudsonIsRestarting(true));
                        lifecycle.onStatusUpdate("Restart in 10 seconds");
                        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
                        lifecycle.onStop(this.exitUser, null);
                        Listeners.notify(RestartListener.class, true, RestartListener::onRestart);
                        lifecycle.restart();
                    } else {
                        lifecycle.onStatusUpdate("Safe-restart mode cancelled");
                    }
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Failed to restart Jenkins", e);
                }
            }
        }.start();
    }

    @CLIMethod(name="shutdown")
    @RequirePOST
    public void doExit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        String exitAddr;
        this.checkPermission(ADMINISTER);
        final String exitUser = Jenkins.getAuthentication2().getName();
        String string = exitAddr = req != null ? req.getRemoteAddr() : null;
        if (rsp != null) {
            rsp.setStatus(200);
            rsp.setContentType("text/plain");
            try (PrintWriter w = rsp.getWriter();){
                w.println("Shutting down");
            }
        }
        new Thread("exit thread"){

            @Override
            @SuppressFBWarnings(value={"DM_EXIT"}, justification="Exit is really intended.")
            public void run() {
                try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                    Jenkins.this.getLifecycle().onStop(exitUser, exitAddr);
                    Jenkins.this.cleanUp();
                    System.exit(0);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Failed to shut down Jenkins", e);
                }
            }
        }.start();
    }

    @CLIMethod(name="safe-shutdown")
    @RequirePOST
    public HttpResponse doSafeExit(StaplerRequest2 req) throws IOException {
        this.checkPermission(ADMINISTER);
        this.quietDownInfo = new QuietDownInfo();
        final String exitUser = Jenkins.getAuthentication2().getName();
        final String exitAddr = req != null ? req.getRemoteAddr() : null;
        new Thread("safe-exit thread"){

            @Override
            @SuppressFBWarnings(value={"DM_EXIT"}, justification="Exit is really intended.")
            public void run() {
                try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                    Jenkins.this.getLifecycle().onStop(exitUser, exitAddr);
                    Jenkins.this.doQuietDown(true, 0, null);
                    if (Jenkins.this.isQuietingDown()) {
                        Jenkins.this.cleanUp();
                        System.exit(0);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to shut down Jenkins", e);
                }
            }
        }.start();
        return HttpResponses.plainText((String)"Shutting down as soon as all jobs are complete");
    }

    @Deprecated
    @StaplerNotDispatchable
    public HttpResponse doSafeExit(StaplerRequest req) throws IOException {
        return this.doSafeExit(req != null ? StaplerRequest.toStaplerRequest2((StaplerRequest)req) : null);
    }

    @NonNull
    public static org.springframework.security.core.Authentication getAuthentication2() {
        org.springframework.security.core.Authentication a = SecurityContextHolder.getContext().getAuthentication();
        if (a == null) {
            a = ANONYMOUS2;
        }
        return a;
    }

    @Deprecated
    @NonNull
    public static Authentication getAuthentication() {
        return Authentication.fromSpring(Jenkins.getAuthentication2());
    }

    public void doScript(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins._doScript(req, rsp, req.getView((Object)this, "_script.jelly"), (VirtualChannel)FilePath.localChannel, this.getACL());
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doScript(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException {
        try {
            Jenkins._doScript(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp), StaplerRequest.toStaplerRequest2((StaplerRequest)req).getView((Object)this, "_script.jelly"), (VirtualChannel)FilePath.localChannel, this.getACL());
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    public void doScriptText(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins._doScript(req, rsp, req.getView((Object)this, "_scriptText.jelly"), (VirtualChannel)FilePath.localChannel, this.getACL());
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doScriptText(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException {
        try {
            Jenkins._doScript(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp), StaplerRequest.toStaplerRequest2((StaplerRequest)req).getView((Object)this, "_scriptText.jelly"), (VirtualChannel)FilePath.localChannel, this.getACL());
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    public static void _doScript(StaplerRequest2 req, StaplerResponse2 rsp, jakarta.servlet.RequestDispatcher view, VirtualChannel channel, ACL acl) throws IOException, ServletException {
        acl.checkPermission(ADMINISTER);
        String text = req.getParameter("script");
        if (text != null) {
            if (!"POST".equals(req.getMethod())) {
                throw HttpResponses.error((int)405, (String)"requires POST");
            }
            if (channel == null) {
                throw HttpResponses.error((int)404, (String)"Node is offline");
            }
            try {
                req.setAttribute("output", (Object)RemotingDiagnostics.executeGroovy(text, channel));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ServletException((Throwable)e);
            }
        }
        view.forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Deprecated
    public static void _doScript(StaplerRequest req, StaplerResponse rsp, RequestDispatcher view, VirtualChannel channel, ACL acl) throws IOException, javax.servlet.ServletException {
        try {
            Jenkins._doScript(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp), RequestDispatcherWrapper.toJakartaRequestDispatcher((RequestDispatcher)view), channel, acl);
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    @RequirePOST
    public void doEval(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.checkPermission(ADMINISTER);
        req.getWebApp().getDispatchValidator().allowDispatch(req, rsp);
        try {
            MetaClass mc = req.getWebApp().getMetaClass(this.getClass());
            Script script = ((JellyClassLoaderTearOff)mc.classLoader.loadTearOff(JellyClassLoaderTearOff.class)).createContext().compileScript(new InputSource(req.getReader()));
            new JellyRequestDispatcher((Object)this, script).forward((ServletRequest)req, (ServletResponse)rsp);
        }
        catch (JellyException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doSignup(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (this.getSecurityRealm().allowsSignup()) {
            req.getView((Object)this.getSecurityRealm(), "signup.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        req.getView(SecurityRealm.class, "signup.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @SuppressFBWarnings(value={"INSECURE_COOKIE"}, justification="TODO needs triage")
    public void doIconSize(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        String qs = req.getQueryString();
        if (qs == null) {
            throw new ServletException();
        }
        Cookie cookie = new Cookie("iconSize", Functions.validateIconSize(qs));
        cookie.setMaxAge(9999999);
        cookie.setSecure(req.isSecure());
        cookie.setHttpOnly(true);
        rsp.addCookie(cookie);
        String ref = req.getHeader("Referer");
        if (ref == null) {
            ref = ".";
        }
        rsp.sendRedirect2(ref);
    }

    @RequirePOST
    public void doFingerprintCleanup(StaplerResponse2 rsp) throws IOException {
        this.checkPermission(ADMINISTER);
        FingerprintCleanupThread.invoke();
        rsp.setStatus(200);
        rsp.setContentType("text/plain");
        rsp.getWriter().println("Invoked");
    }

    @RequirePOST
    public void doWorkspaceCleanup(StaplerResponse2 rsp) throws IOException {
        this.checkPermission(ADMINISTER);
        WorkspaceCleanupThread.invoke();
        rsp.setStatus(200);
        rsp.setContentType("text/plain");
        rsp.getWriter().println("Invoked");
    }

    public FormValidation doDefaultJDKCheck(StaplerRequest2 request, @QueryParameter String value) {
        if (!JDK.isDefaultName(value)) {
            return FormValidation.ok();
        }
        if (JDK.isDefaultJDKValid(this)) {
            return FormValidation.ok();
        }
        return FormValidation.errorWithMarkup(hudson.model.Messages.Hudson_NoJavaInPath(request.getContextPath()));
    }

    public FormValidation doCheckViewName(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String name = Util.fixEmpty(value);
        if (name == null) {
            return FormValidation.ok();
        }
        if (this.getView(name) != null) {
            return FormValidation.error(hudson.model.Messages.Hudson_ViewAlreadyExists(name));
        }
        try {
            Jenkins.checkGoodName(name);
        }
        catch (Failure e) {
            return FormValidation.error(e.getMessage());
        }
        return FormValidation.ok();
    }

    @Deprecated
    public FormValidation doViewExistsCheck(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty(value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (this.getView(view) == null) {
            return FormValidation.ok();
        }
        return FormValidation.error(hudson.model.Messages.Hudson_ViewAlreadyExists(view));
    }

    public void doResources(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        URL url;
        int idx;
        String path = req.getRestOfPath();
        String extension = (path = path.substring(path.indexOf(47, 1) + 1)).substring((idx = path.lastIndexOf(46)) + 1);
        if (ALLOWED_RESOURCE_EXTENSIONS.contains(extension) && (url = this.pluginManager.uberClassLoader.getResource(path)) != null) {
            long expires = MetaClass.NO_CACHE ? 0L : TimeUnit.DAYS.toMillis(365L);
            rsp.serveFile(req, url, expires);
            return;
        }
        rsp.sendError(404);
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    @RestrictedSince(value="2.37")
    public FormValidation doCheckURIEncoding(StaplerRequest2 request) throws IOException {
        return ExtensionList.lookupSingleton(URICheckEncodingMonitor.class).doCheckURIEncoding(request);
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    @RestrictedSince(value="2.37")
    public static boolean isCheckURIEncodingEnabled() {
        return ExtensionList.lookupSingleton(URICheckEncodingMonitor.class).isCheckEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<DependencyGraph> getFutureDependencyGraph() {
        Object object = this.dependencyGraphLock;
        synchronized (object) {
            if (this.scheduledFutureDependencyGraph != null) {
                return this.scheduledFutureDependencyGraph;
            }
            if (this.calculatingFutureDependencyGraph != null) {
                return this.calculatingFutureDependencyGraph;
            }
            return CompletableFuture.completedFuture(this.dependencyGraph);
        }
    }

    public void rebuildDependencyGraph() {
        DependencyGraph graph = new DependencyGraph();
        graph.build();
        this.dependencyGraph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<DependencyGraph> rebuildDependencyGraphAsync() {
        Object object = this.dependencyGraphLock;
        synchronized (object) {
            if (this.scheduledFutureDependencyGraph != null) {
                return this.scheduledFutureDependencyGraph;
            }
            this.scheduledFutureDependencyGraph = this.scheduleCalculationOfFutureDependencyGraph(500, TimeUnit.MILLISECONDS);
            return this.scheduledFutureDependencyGraph;
        }
    }

    private Future<DependencyGraph> scheduleCalculationOfFutureDependencyGraph(int delay, TimeUnit unit) {
        return jenkins.util.Timer.get().schedule(() -> {
            Future<DependencyGraph> temp = null;
            Object object = this.dependencyGraphLock;
            synchronized (object) {
                if (this.calculatingFutureDependencyGraph != null) {
                    temp = this.calculatingFutureDependencyGraph;
                }
            }
            if (temp != null) {
                temp.get();
            }
            object = this.dependencyGraphLock;
            synchronized (object) {
                this.calculatingFutureDependencyGraph = this.scheduledFutureDependencyGraph;
                this.scheduledFutureDependencyGraph = null;
            }
            this.rebuildDependencyGraph();
            object = this.dependencyGraphLock;
            synchronized (object) {
                this.calculatingFutureDependencyGraph = null;
            }
            return this.dependencyGraph;
        }, (long)delay, unit);
    }

    public DependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    public List<ManagementLink> getManagementLinks() {
        return ManagementLink.all();
    }

    @Restricted(value={NoExternalUse.class})
    public Map<ManagementLink.Category, List<ManagementLink>> getCategorizedManagementLinks() {
        TreeMap<ManagementLink.Category, List<ManagementLink>> byCategory = new TreeMap<ManagementLink.Category, List<ManagementLink>>();
        for (ManagementLink link : ManagementLink.all()) {
            if (link.getIconFileName() == null || !Jenkins.get().hasPermission(link.getRequiredPermission())) continue;
            byCategory.computeIfAbsent(link.getCategory(), c -> new ArrayList()).add(link);
        }
        return byCategory;
    }

    @Restricted(value={NoExternalUse.class})
    public SetupWizard getSetupWizard() {
        return this.setupWizard;
    }

    public User getMe() {
        User u = User.current();
        if (u == null) {
            throw new AccessDeniedException("/me is not available when not logged in");
        }
        return u;
    }

    @StaplerDispatchable
    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public Object getTarget() {
        try {
            this.checkPermission(READ);
        }
        catch (AccessDeniedException e) {
            if (!this.isSubjectToMandatoryReadPermissionCheck(Stapler.getCurrentRequest2().getRestOfPath())) {
                return this;
            }
            throw e;
        }
        return this;
    }

    public boolean isSubjectToMandatoryReadPermissionCheck(String restOfPath) {
        for (String name : ALWAYS_READABLE_PATHS) {
            if (!restOfPath.startsWith("/" + name + "/") && !restOfPath.equals("/" + name)) continue;
            return false;
        }
        for (String name : this.getUnprotectedRootActions()) {
            if (!restOfPath.startsWith("/" + name + "/") && !restOfPath.equals("/" + name)) continue;
            return false;
        }
        return !this.isAgentJnlpPath(restOfPath, "jenkins") && !this.isAgentJnlpPath(restOfPath, "slave") || !"true".equals(Stapler.getCurrentRequest2().getParameter("encrypt"));
    }

    private boolean isAgentJnlpPath(String restOfPath, String prefix) {
        return restOfPath.matches("(/manage)?/computer/[^/]+/" + prefix + "-agent[.]jnlp");
    }

    public Collection<String> getUnprotectedRootActions() {
        TreeSet<String> names = new TreeSet<String>();
        names.add("jnlpJars");
        for (Action a : this.getActions()) {
            String url;
            if (!(a instanceof UnprotectedRootAction) || (url = a.getUrlName()) == null) continue;
            names.add(url);
        }
        return names;
    }

    public View getStaplerFallback() {
        return this.getPrimaryView();
    }

    boolean isDisplayNameUnique(ItemGroup<?> itemGroup, String displayName, String currentJobName) {
        Collection<Item> itemCollection = itemGroup.getItems((T t) -> t instanceof TopLevelItem);
        for (TopLevelItem topLevelItem : itemCollection) {
            if (topLevelItem.getName().equals(currentJobName) || !displayName.equals(topLevelItem.getDisplayName())) continue;
            return false;
        }
        return true;
    }

    boolean isNameUnique(ItemGroup<?> itemGroup, String name, String currentJobName) {
        Object item = itemGroup.getItem(name);
        if (null == item) {
            return true;
        }
        return item.getName().equals(currentJobName);
    }

    @Deprecated
    public FormValidation doCheckDisplayName(@QueryParameter String displayName, @QueryParameter String jobName) {
        displayName = displayName.trim();
        LOGGER.fine(() -> "Current job name is " + jobName);
        if (!this.isNameUnique(this, displayName, jobName)) {
            return FormValidation.warning(hudson.model.Messages.Jenkins_CheckDisplayName_NameNotUniqueWarning(displayName));
        }
        if (!this.isDisplayNameUnique(this, displayName, jobName)) {
            return FormValidation.warning(hudson.model.Messages.Jenkins_CheckDisplayName_DisplayNameNotUniqueWarning(displayName));
        }
        return FormValidation.ok();
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation checkDisplayName(String displayName, TopLevelItem item) {
        displayName = displayName.trim();
        String jobName = item.getName();
        LOGGER.fine(() -> "Current job name is " + jobName);
        if (!this.isNameUnique(item.getParent(), displayName, jobName)) {
            return FormValidation.warning(hudson.model.Messages.Jenkins_CheckDisplayName_NameNotUniqueWarning(displayName));
        }
        if (!this.isDisplayNameUnique(item.getParent(), displayName, jobName)) {
            return FormValidation.warning(hudson.model.Messages.Jenkins_CheckDisplayName_DisplayNameNotUniqueWarning(displayName));
        }
        return FormValidation.ok();
    }

    @CheckForNull
    public static <T> T lookup(Class<T> type) {
        Jenkins j = Jenkins.getInstanceOrNull();
        return j != null ? (T)j.lookup.get(type) : null;
    }

    private static void computeVersion(ServletContext context) {
        Properties props = new Properties();
        try (InputStream is = Jenkins.class.getResourceAsStream("jenkins-version.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to load jenkins-version.properties");
        }
        String ver = props.getProperty("version");
        if (ver == null) {
            ver = UNCOMPUTED_VERSION;
        }
        if (Main.isDevelopmentMode && "${project.version}".equals(ver)) {
            try {
                for (File dir = new File(".").getAbsoluteFile(); dir != null; dir = dir.getParentFile()) {
                    File pom = new File(dir, "pom.xml");
                    if (!pom.exists() || !"pom".equals(XMLUtils.getValue("/project/artifactId", pom))) continue;
                    pom = pom.getCanonicalFile();
                    LOGGER.info("Reading version from: " + pom.getAbsolutePath());
                    ver = XMLUtils.getValue("/project/version", pom);
                    break;
                }
                LOGGER.info("Jenkins is in dev mode, using version: " + ver);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, () -> "Unable to read Jenkins version: " + e.getMessage());
            }
        }
        VERSION = ver;
        context.setAttribute("version", (Object)ver);
        CHANGELOG_URL = props.getProperty("changelog.url");
        VERSION_HASH = Util.getDigestOf(ver).substring(0, 8);
        SESSION_HASH = Util.getDigestOf(ver + System.currentTimeMillis()).substring(0, 8);
        RESOURCE_PATH = ver.equals(UNCOMPUTED_VERSION) || SystemProperties.getBoolean("hudson.script.noCache") ? "" : "/static/" + SESSION_HASH;
        VIEW_RESOURCE_PATH = "/resources/" + SESSION_HASH;
    }

    @CheckForNull
    public static VersionNumber getVersion() {
        return Jenkins.toVersion(VERSION);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static VersionNumber getStoredVersion() {
        return Jenkins.toVersion(Jenkins.get().version);
    }

    @CheckForNull
    private static VersionNumber toVersion(@CheckForNull String versionString) {
        if (versionString == null) {
            return null;
        }
        try {
            return new VersionNumber(versionString);
        }
        catch (NumberFormatException e) {
            try {
                int idx = versionString.indexOf(32);
                if (idx > 0) {
                    return new VersionNumber(versionString.substring(0, idx));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public boolean shouldShowStackTrace() {
        return Boolean.getBoolean(Jenkins.class.getName() + ".SHOW_STACK_TRACE");
    }

    static {
        SLAVE_AGENT_PORT_ENFORCE = SystemProperties.getBoolean(Jenkins.class.getName() + ".slaveAgentPortEnforce", false);
        nodeNameAndSelfLabelOverride = SystemProperties.getString(Jenkins.class.getName() + ".nodeNameAndSelfLabelOverride");
        HOLDER = new JenkinsHolder(){

            @Override
            @CheckForNull
            public Jenkins getInstance() {
                return theInstance;
            }
        };
        ALLOWED_RESOURCE_EXTENSIONS = new HashSet<String>(Arrays.asList("js|css|jpeg|jpg|png|gif|html|htm".split("\\|")));
        logRecords = Collections.emptyList();
        TWICE_CPU_NUM = Math.max(4, Runtime.getRuntime().availableProcessors() * 2);
        VERSION = UNCOMPUTED_VERSION;
        RESOURCE_PATH = "";
        VIEW_RESOURCE_PATH = "/resources/TBD";
        PARALLEL_LOAD = SystemProperties.getBoolean(Jenkins.class.getName() + ".parallelLoad", true);
        KILL_AFTER_LOAD = SystemProperties.getBoolean(Jenkins.class.getName() + ".killAfterLoad", false);
        FLYWEIGHT_SUPPORT = true;
        CONCURRENT_BUILD = true;
        WORKSPACE_DIRNAME = SystemProperties.getString(Jenkins.class.getName() + ".workspaceDirName", "workspace");
        NAME_VALIDATION_REJECTS_TRAILING_DOT_PROP = Jenkins.class.getName() + ".nameValidationRejectsTrailingDot";
        OLD_DEFAULT_WORKSPACES_DIR = "${ITEM_ROOTDIR}/" + WORKSPACE_DIRNAME;
        BUILDS_DIR_PROP = Jenkins.class.getName() + ".buildsDir";
        WORKSPACES_DIR_PROP = Jenkins.class.getName() + ".workspacesDir";
        AUTOMATIC_AGENT_LAUNCH = SystemProperties.getBoolean(Jenkins.class.getName() + ".automaticAgentLaunch", true);
        EXTEND_TIMEOUT_SECONDS = (int)SystemProperties.getDuration(Jenkins.class.getName() + ".extendTimeoutSeconds", ChronoUnit.SECONDS, Duration.ofSeconds(15L)).toSeconds();
        LOGGER = Logger.getLogger(Jenkins.class.getName());
        RANDOM = new SecureRandom();
        PERMISSIONS = Permission.HUDSON_PERMISSIONS;
        ADMINISTER = Permission.HUDSON_ADMINISTER;
        MANAGE = new Permission(PERMISSIONS, "Manage", hudson.model.Messages._Jenkins_Manage_Description(), ADMINISTER, SystemProperties.getBoolean("jenkins.security.ManagePermission"), new PermissionScope[]{PermissionScope.JENKINS});
        SYSTEM_READ = new Permission(PERMISSIONS, "SystemRead", hudson.model.Messages._Jenkins_SystemRead_Description(), ADMINISTER, SystemProperties.getBoolean("jenkins.security.SystemReadPermission"), new PermissionScope[]{PermissionScope.JENKINS});
        MANAGE_AND_SYSTEM_READ = new Permission[]{MANAGE, SYSTEM_READ};
        READ = new Permission(PERMISSIONS, "Read", hudson.model.Messages._Hudson_ReadPermission_Description(), Permission.READ, PermissionScope.JENKINS);
        RUN_SCRIPTS = new Permission(PERMISSIONS, "RunScripts", hudson.model.Messages._Hudson_RunScriptsPermission_Description(), ADMINISTER, PermissionScope.JENKINS);
        ALWAYS_READABLE_PATHS = new HashSet<String>(Arrays.asList("404", "_404", "_404_simple", "login", "loginError", "logout", "accessDenied", "adjuncts", "error", "oops", "signup", "tcpSlaveAgentListener", "federatedLoginService", "securityRealm"));
        String paths = SystemProperties.getString(Jenkins.class.getName() + ".additionalReadablePaths");
        if (paths != null) {
            LOGGER.info(() -> "SECURITY-2047 override: Adding the following paths to ALWAYS_READABLE_PATHS: " + paths);
            ALWAYS_READABLE_PATHS.addAll(Arrays.stream(paths.split(",")).map(String::trim).collect(Collectors.toSet()));
        }
        ANONYMOUS2 = new org.springframework.security.authentication.AnonymousAuthenticationToken("anonymous", (Object)"anonymous", Set.of(new SimpleGrantedAuthority("anonymous")));
        ANONYMOUS = new AnonymousAuthenticationToken("anonymous", "anonymous", new GrantedAuthority[]{new GrantedAuthorityImpl("anonymous")});
        try {
            XSTREAM2 = new XStream2();
            XSTREAM = XSTREAM2;
            XSTREAM.alias("jenkins", Jenkins.class);
            XSTREAM.alias("slave", DumbSlave.class);
            XSTREAM.alias("jdk", JDK.class);
            XSTREAM.alias("view", ListView.class);
            XSTREAM.alias("listView", ListView.class);
            XSTREAM2.addCriticalField(Jenkins.class, "securityRealm");
            XSTREAM2.addCriticalField(Jenkins.class, "authorizationStrategy");
            Node.Mode.class.getEnumConstants();
            assert (PERMISSIONS != null);
            assert (ADMINISTER != null);
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to load Jenkins.class", e);
            throw e;
        }
    }

    public static interface JenkinsHolder {
        @CheckForNull
        public Jenkins getInstance();
    }

    private static final class JenkinsJVMAccess
    extends JenkinsJVM {
        private JenkinsJVMAccess() {
        }

        private static void _setJenkinsJVM(boolean jenkinsJVM) {
            JenkinsJVM.setJenkinsJVM(jenkinsJVM);
        }
    }

    public static final class DescriptorImpl
    extends NodeDescriptor {
        @Extension
        public static final DescriptorImpl INSTANCE = new DescriptorImpl();

        @Override
        public boolean isInstantiable() {
            return false;
        }

        public FormValidation doCheckNumExecutors(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger(value);
        }

        public Object getDynamic(String token) {
            return Jenkins.get().getDescriptor(token);
        }
    }

    private static class ClockDifferenceCallable
    extends MasterToSlaveCallable<ClockDifference, IOException> {
        private ClockDifferenceCallable() {
        }

        public ClockDifference call() throws IOException {
            return new ClockDifference(0L);
        }
    }

    private static final class QuietDownInfo {
        @CheckForNull
        final String message;
        private boolean safeRestart;

        QuietDownInfo() {
            this(null, false);
        }

        QuietDownInfo(String message) {
            this(message, false);
        }

        QuietDownInfo(String message, boolean safeRestart) {
            this.message = message;
            this.safeRestart = safeRestart;
        }

        boolean isSafeRestart() {
            return this.safeRestart;
        }

        void setSafeRestart(boolean safeRestart) {
            this.safeRestart = safeRestart;
        }
    }

    public static class MasterComputer
    extends Computer {
        @Deprecated
        public static final LocalChannel localChannel = FilePath.localChannel;

        protected MasterComputer() {
            super(Jenkins.get());
        }

        @Override
        @NonNull
        public String getName() {
            return "";
        }

        @Override
        public boolean isConnecting() {
            return false;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return hudson.model.Messages.Hudson_Computer_DisplayName();
        }

        @Override
        public String getCaption() {
            return hudson.model.Messages.Hudson_Computer_Caption();
        }

        @Override
        @NonNull
        public String getUrl() {
            return "computer/(built-in)/";
        }

        @Override
        public RetentionStrategy getRetentionStrategy() {
            return RetentionStrategy.NOOP;
        }

        @Override
        protected boolean isAlive() {
            return true;
        }

        @Override
        public Boolean isUnix() {
            return !Functions.isWindows();
        }

        @Override
        public HttpResponse doDoDelete() throws IOException {
            throw HttpResponses.status((int)400);
        }

        @Override
        @POST
        public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
            Jenkins.get().doConfigExecutorsSubmit(req, rsp);
        }

        @Override
        @WebMethod(name={"config.xml"})
        public void doConfigDotXml(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            throw HttpResponses.status((int)400);
        }

        @Override
        public boolean hasPermission(Permission permission) {
            if (permission == Computer.DELETE) {
                return false;
            }
            return super.hasPermission(permission == Computer.CONFIGURE ? ADMINISTER : permission);
        }

        @Override
        public VirtualChannel getChannel() {
            return FilePath.localChannel;
        }

        @Override
        public Charset getDefaultCharset() {
            return Charset.defaultCharset();
        }

        @Override
        public List<LogRecord> getLogRecords() throws IOException, InterruptedException {
            return logRecords;
        }

        @Override
        @RequirePOST
        public void doLaunchSlaveAgent(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            rsp.sendError(404);
        }

        @Override
        protected Future<?> _connect(boolean forceReconnect) {
            return Futures.precomputed(null);
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class MasterRestartNotifyier
    extends RestartListener {
        @Override
        public void onRestart() {
            Computer computer = Jenkins.get().toComputer();
            if (computer == null) {
                return;
            }
            RestartCause cause = new RestartCause();
            Listeners.notify(ComputerListener.class, true, l -> l.onOffline(computer, cause));
        }

        @Override
        public boolean isReadyToRestart() throws IOException, InterruptedException {
            return true;
        }

        private static class RestartCause
        extends OfflineCause.SimpleOfflineCause {
            protected RestartCause() {
                super(hudson.model.Messages._Jenkins_IsRestarting());
            }
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class EnforceSlaveAgentPortAdministrativeMonitor
    extends AdministrativeMonitor {
        @Inject
        Jenkins j;

        @Override
        public String getDisplayName() {
            return Messages.EnforceSlaveAgentPortAdministrativeMonitor_displayName();
        }

        public String getSystemPropertyName() {
            return Jenkins.class.getName() + ".slaveAgentPort";
        }

        public int getExpectedPort() {
            int slaveAgentPort = this.j.slaveAgentPort;
            return Jenkins.getSlaveAgentPortInitialValue(slaveAgentPort);
        }

        @RequirePOST
        public void doAct(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
            this.j.forceSetSlaveAgentPort(this.getExpectedPort());
            rsp.sendRedirect2(req.getContextPath() + "/manage");
        }

        @Override
        public boolean isActivated() {
            int slaveAgentPort = Jenkins.get().slaveAgentPort;
            return SLAVE_AGENT_PORT_ENFORCE && slaveAgentPort != Jenkins.getSlaveAgentPortInitialValue(slaveAgentPort);
        }
    }

    public static class CloudList
    extends DescribableList<Cloud, Descriptor<Cloud>> {
        public CloudList(Jenkins h) {
            super(h);
        }

        public CloudList() {
        }

        public Cloud getByName(String name) {
            for (Cloud c : this) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            return null;
        }

        @Override
        protected void onModified() throws IOException {
            super.onModified();
            Jenkins.get().trimLabels();
        }
    }
}

