/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.CopyOnWriteMap;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.IntPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.lazy.BuildReference;
import jenkins.model.lazy.BuildReferenceMapAdapter;
import jenkins.util.MemoryReductionUtil;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class AbstractLazyLoadRunMap<R>
extends AbstractMap<Integer, R>
implements SortedMap<Integer, R> {
    private final CopyOnWriteMap.Tree<Integer, BuildReference<R>> core = new CopyOnWriteMap.Tree(Collections.reverseOrder());
    private final BuildReferenceMapAdapter.Resolver<R> buildResolver = new BuildReferenceMapAdapterResolver();
    private final BuildReferenceMapAdapter<R> adapter = new BuildReferenceMapAdapter<R>(this.core, this.buildResolver){

        @Override
        protected boolean removeValue(R value) {
            return AbstractLazyLoadRunMap.this.removeValue(value);
        }
    };
    protected File dir;
    private static final Pattern BUILD_NUMBER = Pattern.compile("[0-9]+");
    static final Logger LOGGER = Logger.getLogger(AbstractLazyLoadRunMap.class.getName());

    @Override
    public Set<Integer> keySet() {
        return this.adapter.keySet();
    }

    @Override
    public Collection<R> values() {
        return this.adapter.values();
    }

    @Override
    public Set<Map.Entry<Integer, R>> entrySet() {
        assert (this.baseDirInitialized());
        return this.adapter.entrySet();
    }

    @Restricted(value={NoExternalUse.class})
    protected AbstractLazyLoadRunMap() {
    }

    @Restricted(value={NoExternalUse.class})
    protected void initBaseDir(File dir) {
        assert (this.dir == null);
        this.dir = dir;
        if (dir != null) {
            this.loadNumberOnDisk();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public final boolean baseDirInitialized() {
        return this.dir != null;
    }

    public final void updateBaseDir(File dir) {
        this.dir = dir;
    }

    public synchronized void purgeCache() {
        this.loadNumberOnDisk();
    }

    private void loadNumberOnDisk() {
        String[] kids = this.dir.list();
        if (kids == null) {
            kids = MemoryReductionUtil.EMPTY_STRING_ARRAY;
        }
        TreeMap newBuildRefsMap = new TreeMap();
        IntPredicate allower = this.createLoadAllower();
        for (String s : kids) {
            if (!BUILD_NUMBER.matcher(s).matches()) continue;
            try {
                int buildNumber = Integer.parseInt(s);
                if (allower.test(buildNumber)) {
                    newBuildRefsMap.put(buildNumber, new BuildReference(s));
                    continue;
                }
                LOGGER.fine(() -> "declining to consider " + buildNumber + " in " + String.valueOf(this.dir));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.core.replaceBy(newBuildRefsMap);
    }

    @Restricted(value={NoExternalUse.class})
    protected boolean allowLoad(int buildNumber) {
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    protected IntPredicate createLoadAllower() {
        return this::allowLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={Beta.class})
    public final void recognizeNumber(int buildNumber) {
        if (new File(this.dir, Integer.toString(buildNumber)).isDirectory()) {
            AbstractLazyLoadRunMap abstractLazyLoadRunMap = this;
            synchronized (abstractLazyLoadRunMap) {
                if (this.core.containsKey(buildNumber)) {
                    LOGGER.fine(() -> "already knew about " + buildNumber + " in " + String.valueOf(this.dir));
                } else {
                    this.core.put(buildNumber, new BuildReference(String.valueOf(buildNumber)));
                    LOGGER.fine(() -> "recognizing " + buildNumber + " in " + String.valueOf(this.dir));
                }
            }
        } else {
            LOGGER.fine(() -> "no such subdirectory " + buildNumber + " in " + String.valueOf(this.dir));
        }
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return this.core.comparator();
    }

    @Override
    public boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    @Override
    public boolean containsKey(Object value) {
        return this.adapter.containsKey(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.adapter.containsValue(value);
    }

    public SortedMap<Integer, R> getLoadedBuilds() {
        TreeMap res = new TreeMap(Comparator.reverseOrder());
        for (Map.Entry entry : this.core.entrySet()) {
            BuildReference buildRef = (BuildReference)entry.getValue();
            if (!buildRef.isSet() || buildRef.isUnloadable()) continue;
            res.put((Integer)entry.getKey(), buildRef);
        }
        return new BuildReferenceMapAdapter(res, this.buildResolver);
    }

    @Override
    public SortedMap<Integer, R> subMap(Integer fromKey, Integer toKey) {
        return this.adapter.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<Integer, R> headMap(Integer toKey) {
        return this.adapter.headMap(toKey);
    }

    @Override
    public SortedMap<Integer, R> tailMap(Integer fromKey) {
        return this.adapter.tailMap(fromKey);
    }

    @Override
    public Integer firstKey() {
        return this.adapter.firstKey();
    }

    @Override
    public Integer lastKey() {
        return this.adapter.lastKey();
    }

    public R newestBuild() {
        return this.search(Integer.MAX_VALUE, Direction.DESC);
    }

    public R oldestBuild() {
        return this.search(Integer.MIN_VALUE, Direction.ASC);
    }

    @Override
    public R get(Object key) {
        return this.adapter.get(key);
    }

    public R get(int n) {
        return this.getByNumber(n);
    }

    public boolean runExists(int number) {
        return this.core.containsKey(number);
    }

    @CheckForNull
    public R search(int n, Direction d) {
        if (d == Direction.EXACT) {
            return this.adapter.get(n);
        }
        NavigableMap<Integer, BuildReference<R>> subCore = d == Direction.ASC ? this.core.headMap(n, true).descendingMap() : this.core.tailMap(n, true);
        return new BuildReferenceMapAdapter<R>(subCore, this.buildResolver).values().stream().findFirst().orElse(null);
    }

    public R getById(String id) {
        return this.getByNumber(Integer.parseInt(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R resolveBuildRef(BuildReference<R> ref) {
        if (ref == null || ref.isUnloadable()) {
            return null;
        }
        R v = ref.get();
        if (v != null) {
            return v;
        }
        AbstractLazyLoadRunMap abstractLazyLoadRunMap = this;
        synchronized (abstractLazyLoadRunMap) {
            v = ref.get();
            if (v != null) {
                return v;
            }
            int n = ref.number;
            if (this.allowLoad(n)) {
                v = this.load(n);
                if (v == null) {
                    ref.setUnloadable();
                    return null;
                }
                ref.set(v);
                return v;
            }
            LOGGER.fine(() -> "declining to load " + n + " in " + String.valueOf(this.dir));
            return null;
        }
    }

    public R getByNumber(int n) {
        return this.adapter.get(n);
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized int maxNumberOnDisk() {
        try {
            return this.core.firstKey();
        }
        catch (NoSuchElementException ignored) {
            return 0;
        }
    }

    protected final synchronized void proposeNewNumber(int number) throws IllegalStateException {
        if (number <= this.maxNumberOnDisk()) {
            throw new IllegalStateException("JENKINS-27530: cannot create a build with number " + number + " since that (or higher) is already in use among " + String.valueOf(this.keySet()));
        }
    }

    public R put(R value) {
        return this._put(value);
    }

    protected R _put(R value) {
        return this.put(this.getNumberOf(value), value);
    }

    @Override
    public synchronized R put(Integer key, R r) {
        int n = this.getNumberOf(r);
        BuildReference<R> old = this.core.put(n, this.createReference(r));
        return this.resolveBuildRef(old);
    }

    @Override
    public synchronized void putAll(Map<? extends Integer, ? extends R> newData) {
        TreeMap<Integer, BuildReference<R>> newWrapperData = new TreeMap<Integer, BuildReference<R>>();
        for (Map.Entry<Integer, R> entry : newData.entrySet()) {
            newWrapperData.put(entry.getKey(), this.createReference(entry.getValue()));
        }
        this.core.putAll(newWrapperData);
    }

    @Override
    public R remove(Object key) {
        return this.adapter.remove(key);
    }

    private R load(int n) {
        assert (Thread.holdsLock(this));
        assert (this.dir != null);
        return this.load(new File(this.dir, String.valueOf(n)));
    }

    private R load(File dataDir) {
        assert (Thread.holdsLock(this));
        try {
            R r = this.retrieve(dataDir);
            if (r == null) {
                LOGGER.fine(() -> "nothing in " + String.valueOf(dataDir));
                return null;
            }
            return r;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load " + String.valueOf(dataDir), e);
            return null;
        }
    }

    protected abstract int getNumberOf(R var1);

    protected String getIdOf(R r) {
        return String.valueOf(this.getNumberOf(r));
    }

    protected BuildReference<R> createReference(R r) {
        return new BuildReference<R>(this.getIdOf(r), r);
    }

    protected abstract R retrieve(File var1) throws IOException;

    protected abstract Class<R> getBuildClass();

    public synchronized boolean removeValue(R run) {
        return this.core.remove(this.getNumberOf(run)) != null;
    }

    public synchronized void reset(Map<Integer, R> builds) {
        TreeMap<Integer, BuildReference<R>> copy = new TreeMap<Integer, BuildReference<R>>();
        for (R r : builds.values()) {
            copy.put(this.getNumberOf(r), this.createReference(r));
        }
        this.core.replaceBy(copy);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    private class BuildReferenceMapAdapterResolver
    implements BuildReferenceMapAdapter.Resolver<R> {
        private BuildReferenceMapAdapterResolver() {
        }

        @Override
        public R resolveBuildRef(BuildReference<R> buildRef) {
            return AbstractLazyLoadRunMap.this.resolveBuildRef(buildRef);
        }

        @Override
        public Integer getNumberOf(R build) {
            return AbstractLazyLoadRunMap.this.getNumberOf(build);
        }

        @Override
        public Class<R> getBuildClass() {
            return AbstractLazyLoadRunMap.this.getBuildClass();
        }
    }

    public static enum Direction {
        ASC,
        DESC,
        EXACT;

    }
}

