/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.PluginManager;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.JarURLValidator;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.ChannelConfigurator;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Deprecated
@Extension
public class JarURLValidatorImpl
extends ChannelConfigurator
implements JarURLValidator {
    public static final Logger LOGGER = Logger.getLogger(JarURLValidatorImpl.class.getName());

    @Override
    public void onChannelBuilding(ChannelBuilder builder, @Nullable Object context) {
        LOGGER.log(Level.CONFIG, () -> "Setting up JarURLValidatorImpl for context: " + String.valueOf(context));
        builder.withProperty(JarURLValidator.class, (Object)this);
    }

    public void validate(URL url) throws IOException {
        String rejectAllProp = JarURLValidatorImpl.class.getName() + ".REJECT_ALL";
        if (SystemProperties.getBoolean(rejectAllProp)) {
            LOGGER.log(Level.FINE, () -> "Rejecting URL due to configuration: " + String.valueOf(url));
            throw new IOException("The system property '" + rejectAllProp + "' has been set, so all attempts by agents to load jars from the controller are rejected. Update the agent.jar of the affected agent to a version released in August 2024 or later to prevent this error.");
        }
        String allowAllProp = Channel.class.getName() + ".DISABLE_JAR_URL_VALIDATOR";
        if (SystemProperties.getBoolean(allowAllProp)) {
            LOGGER.log(Level.FINE, () -> "Allowing URL due to configuration: " + String.valueOf(url));
            return;
        }
        if (!JarURLValidatorImpl.isAllowedJar(url)) {
            LOGGER.log(Level.FINE, () -> "Rejecting URL: " + String.valueOf(url));
            throw new IOException("This URL does not point to a jar file allowed to be requested by agents: " + String.valueOf(url) + ". Update the agent.jar of the affected agent to a version released in August 2024 or later to prevent this error. Alternatively, set the system property '" + allowAllProp + "' to 'true' if all the code built by Jenkins is as trusted as an administrator.");
        }
        LOGGER.log(Level.FINE, () -> "Allowing URL: " + String.valueOf(url));
    }

    @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="All URLs point to local files, so no DNS lookup.")
    private static boolean isAllowedJar(URL url) {
        URLClassLoader urlClassLoader;
        PluginManager.UberClassLoader uberClassLoader;
        ClassLoader classLoader = Jenkins.get().getPluginManager().uberClassLoader;
        if (classLoader instanceof PluginManager.UberClassLoader && (uberClassLoader = (PluginManager.UberClassLoader)classLoader).isPluginJar(url)) {
            LOGGER.log(Level.FINER, () -> "Determined to be plugin jar: " + String.valueOf(url));
            return true;
        }
        ClassLoader coreClassLoader = Jenkins.class.getClassLoader();
        if (coreClassLoader instanceof URLClassLoader && Set.of((urlClassLoader = (URLClassLoader)coreClassLoader).getURLs()).contains(url)) {
            LOGGER.log(Level.FINER, () -> "Determined to be core jar: " + String.valueOf(url));
            return true;
        }
        LOGGER.log(Level.FINER, () -> "Neither core nor plugin jar: " + String.valueOf(url));
        return false;
    }
}

