/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jenkins.telemetry.Telemetry;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class JavaSystemProperties
extends Telemetry {
    private static final String[] PROPERTIES = new String[]{"file.encoding", "file.separator", "java.vm.name", "java.vm.vendor", "java.vm.version", "os.arch", "os.name", "os.version", "user.language"};

    public Map<String, String> getProperties() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        for (String property : PROPERTIES) {
            String value = System.getProperty(property);
            properties.put(property, value);
        }
        return properties;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "System Properties";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2023, 12, 17);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2024, 4, 1);
    }

    @Override
    public JSONObject createContent() {
        JSONObject o = new JSONObject();
        Iterator<Map.Entry<String, String>> iterator = this.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            String value;
            Map.Entry<String, String> entry;
            o = o.element(entry.getKey(), (Object)((value = (entry = iterator.next()).getValue()) == null ? "(undefined)" : value));
        }
        o.put("components", this.buildComponentInformation());
        return o;
    }
}

