/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Messages;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.Util;
import hudson.model.AdministrativeMonitor;
import hudson.model.Api;
import hudson.model.ModelObject;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.util.VersionNumber;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;
import jenkins.plugins.DetachedPluginsUtil;
import jenkins.security.UpdateSiteWarningsMonitor;
import jenkins.util.AntClassLoader;
import jenkins.util.URLClassLoader2;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class PluginWrapper
implements Comparable<PluginWrapper>,
ModelObject {
    private static final boolean ENABLE_PLUGIN_DEPENDENCIES_VERSION_CHECK = Boolean.parseBoolean(System.getProperty(PluginWrapper.class.getName() + ".dependenciesVersionCheck.enabled", "true"));
    public final PluginManager parent;
    private final Manifest manifest;
    public final ClassLoader classLoader;
    public final URL baseResourceURL;
    private final File disableFile;
    private final File archive;
    private final String shortName;
    private final boolean active;
    private boolean hasCycleDependency = false;
    private final List<Dependency> dependencies;
    private final List<Dependency> optionalDependencies;
    private final transient Map<String, Boolean> dependencyErrors = new HashMap<String, Boolean>(0);
    boolean isBundled;
    private Set<String> dependents = Collections.emptySet();
    private Set<String> optionalDependents = Collections.emptySet();
    private static Set<String> CORE_ONLY_DEPENDANT = Set.of("jenkins-core");
    @Extension
    public static final PluginWrapperAdministrativeMonitor NOTICE = new PluginWrapperAdministrativeMonitor();
    private static final Logger LOGGER = Logger.getLogger(PluginWrapper.class.getName());
    public static final String MANIFEST_FILENAME = "META-INF/MANIFEST.MF";

    public List<String> getDependencyErrors() {
        return List.copyOf(this.dependencyErrors.keySet());
    }

    @Restricted(value={NoExternalUse.class})
    public List<String> getOriginalDependencyErrors() {
        Predicate<Map.Entry> p = Map.Entry::getValue;
        return this.dependencyErrors.entrySet().stream().filter(p.negate()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasOriginalDependencyErrors() {
        return !this.getOriginalDependencyErrors().isEmpty();
    }

    @Restricted(value={NoExternalUse.class})
    public List<String> getDerivedDependencyErrors() {
        return this.dependencyErrors.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasDerivedDependencyErrors() {
        return !this.getDerivedDependencyErrors().isEmpty();
    }

    public void setDependents(@NonNull Set<String> dependents) {
        this.dependents = dependents;
    }

    @Deprecated
    public void setDependants(@NonNull Set<String> dependents) {
        this.setDependents(dependents);
    }

    public void setOptionalDependents(@NonNull Set<String> optionalDependents) {
        this.optionalDependents = optionalDependents;
    }

    @Deprecated
    public void setOptionalDependants(@NonNull Set<String> optionalDependents) {
        this.setOptionalDependents(this.dependents);
    }

    @NonNull
    public Set<String> getDependents() {
        if (this.isBundled && this.dependents.isEmpty()) {
            return CORE_ONLY_DEPENDANT;
        }
        return this.dependents;
    }

    @Deprecated
    @NonNull
    public Set<String> getDependants() {
        return this.getDependents();
    }

    @NonNull
    public Set<String> getMandatoryDependents() {
        HashSet<String> s = new HashSet<String>(this.dependents);
        s.removeAll(this.optionalDependents);
        return s;
    }

    @NonNull
    public Set<String> getOptionalDependents() {
        return this.optionalDependents;
    }

    @Deprecated
    @NonNull
    public Set<String> getOptionalDependants() {
        return this.getOptionalDependents();
    }

    public boolean hasDependents() {
        return this.isBundled || !this.dependents.isEmpty();
    }

    public boolean hasMandatoryDependents() {
        if (this.isBundled) {
            return true;
        }
        return this.dependents.stream().anyMatch(d -> !this.optionalDependents.contains(d));
    }

    @Deprecated
    public boolean hasDependants() {
        return this.hasDependents();
    }

    public boolean hasOptionalDependents() {
        return !this.optionalDependents.isEmpty();
    }

    @Deprecated
    public boolean hasOptionalDependants() {
        return this.hasOptionalDependents();
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public boolean hasMandatoryDependencies() {
        return this.dependencies.stream().anyMatch(d -> !d.optional);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isDeprecated() {
        return !this.getDeprecations().isEmpty();
    }

    @Restricted(value={Beta.class})
    public void injectJarsToClasspath(File ... jars) throws Exception {
        if (this.classLoader instanceof AntClassLoader) {
            for (File f : jars) {
                LOGGER.log(Level.CONFIG, () -> "Inserting " + f + " into " + this.shortName + " plugin's classpath");
                ((AntClassLoader)((Object)this.classLoader)).addPathComponent(f);
            }
        } else if (this.classLoader instanceof URLClassLoader2) {
            for (File f : jars) {
                LOGGER.log(Level.CONFIG, () -> "Inserting " + f + " into " + this.shortName + " plugin's classpath");
                ((URLClassLoader2)this.classLoader).addURL(f.toURI().toURL());
            }
        } else {
            throw new AssertionError((Object)"PluginWrapper classloader has changed type, but this code has not been updated accordingly");
        }
    }

    public PluginWrapper(PluginManager parent, File archive, Manifest manifest, URL baseResourceURL, ClassLoader classLoader, File disableFile, List<Dependency> dependencies, List<Dependency> optionalDependencies) {
        this.parent = parent;
        this.manifest = manifest;
        this.shortName = Util.intern(PluginWrapper.computeShortName(manifest, archive.getName()));
        this.baseResourceURL = baseResourceURL;
        this.classLoader = classLoader;
        this.disableFile = disableFile;
        this.active = !disableFile.exists();
        this.dependencies = dependencies;
        this.optionalDependencies = optionalDependencies;
        for (Dependency d : optionalDependencies) {
            assert (d.optional) : d + " included among optionalDependencies of " + this.shortName + " but was not marked optional";
        }
        this.archive = archive;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.removeStart((String)this.getLongName(), (String)"Jenkins ");
    }

    public Api getApi() {
        Jenkins.get().checkAnyPermission(Jenkins.SYSTEM_READ, Jenkins.MANAGE);
        return new Api(this);
    }

    public URL getIndexPage() {
        URL idx = null;
        try {
            Enumeration<URL> en = this.classLoader.getResources("index.jelly");
            while (en.hasMoreElements()) {
                idx = en.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return idx != null && idx.toString().contains(this.shortName) ? idx : null;
    }

    static String computeShortName(Manifest manifest, String fileName) {
        String n = manifest.getMainAttributes().getValue("Short-Name");
        if (n != null) {
            return n;
        }
        n = manifest.getMainAttributes().getValue("Extension-Name");
        if (n != null) {
            return n;
        }
        return FilenameUtils.getBaseName((String)fileName);
    }

    @Exported
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> getMandatoryDependencies() {
        return this.dependencies.stream().filter(d -> !d.optional).collect(Collectors.toList());
    }

    public List<Dependency> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    @Exported
    public String getShortName() {
        return this.shortName;
    }

    @CheckForNull
    public Plugin getPlugin() {
        PluginManager.PluginInstanceStore pis = Jenkins.lookup(PluginManager.PluginInstanceStore.class);
        return pis != null ? pis.store.get(this) : null;
    }

    @NonNull
    public Plugin getPluginOrFail() throws Exception {
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            throw new Exception("Cannot find the plugin instance: " + this.shortName);
        }
        return plugin;
    }

    @Exported
    public String getUrl() {
        List<UpdateSite.Plugin> siteMetadataList = this.getInfoFromAllSites();
        String firstSiteUrl = null;
        if (!siteMetadataList.isEmpty() && this.allUrlsMatch(firstSiteUrl = siteMetadataList.get((int)0).wiki, siteMetadataList)) {
            return firstSiteUrl;
        }
        String url = this.manifest.getMainAttributes().getValue("Url");
        if (url != null) {
            return url;
        }
        return firstSiteUrl;
    }

    private boolean allUrlsMatch(String url, List<UpdateSite.Plugin> uiList) {
        return uiList.stream().allMatch(k -> k.wiki != null && k.wiki.equals(url));
    }

    public String toString() {
        return "Plugin:" + this.getShortName();
    }

    @Exported
    @Deprecated
    public String getLongName() {
        String name = this.manifest.getMainAttributes().getValue("Long-Name");
        if (name != null) {
            return name;
        }
        return this.shortName;
    }

    @Exported
    public YesNoMaybe supportsDynamicLoad() {
        String v = this.manifest.getMainAttributes().getValue("Support-Dynamic-Loading");
        if (v == null) {
            return YesNoMaybe.MAYBE;
        }
        return Boolean.parseBoolean(v) ? YesNoMaybe.YES : YesNoMaybe.NO;
    }

    @Exported
    public String getVersion() {
        return this.getVersionOf(this.manifest);
    }

    private String getVersionOf(Manifest manifest) {
        String v = manifest.getMainAttributes().getValue("Plugin-Version");
        if (v != null) {
            return v;
        }
        v = manifest.getMainAttributes().getValue("Implementation-Version");
        if (v != null) {
            return v;
        }
        return "???";
    }

    @Exported
    @CheckForNull
    public String getRequiredCoreVersion() {
        String v = this.manifest.getMainAttributes().getValue("Jenkins-Version");
        if (v != null) {
            return v;
        }
        v = this.manifest.getMainAttributes().getValue("Hudson-Version");
        if (v != null) {
            return v;
        }
        return null;
    }

    public VersionNumber getVersionNumber() {
        return new VersionNumber(this.getVersion());
    }

    public boolean isOlderThan(VersionNumber v) {
        try {
            return this.getVersionNumber().compareTo(v) < 0;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public void stop() {
        Plugin plugin = this.getPlugin();
        if (plugin != null) {
            try {
                LOGGER.log(Level.FINE, "Stopping {0}", this.shortName);
                plugin.stop();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to shut down " + this.shortName, t);
            }
        } else {
            LOGGER.log(Level.FINE, "Could not find Plugin instance to stop for {0}", this.shortName);
        }
        LogFactory.release((ClassLoader)this.classLoader);
    }

    public void releaseClassLoader() {
        if (this.classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.classLoader)).close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to shut down classloader", e);
            }
        }
    }

    public void enable() throws IOException {
        if (!this.disableFile.exists()) {
            LOGGER.log(Level.FINEST, "Plugin {0} has been already enabled. Skipping the enable() operation", this.getShortName());
            return;
        }
        if (!this.disableFile.delete()) {
            throw new IOException("Failed to delete " + this.disableFile);
        }
    }

    @Deprecated
    public void disable() throws IOException {
        this.disableWithoutCheck();
    }

    private void disableWithoutCheck() throws IOException {
        try {
            OutputStream os = Files.newOutputStream(this.disableFile.toPath(), new OpenOption[0]);
            if (os != null) {
                os.close();
            }
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    @NonNull
    public PluginDisableResult disable(@NonNull PluginDisableStrategy strategy) {
        PluginDisableResult result = new PluginDisableResult(this.shortName);
        if (!this.isEnabled()) {
            result.setMessage(Messages.PluginWrapper_Already_Disabled(this.shortName));
            result.setStatus(PluginDisableStatus.ALREADY_DISABLED);
            return result;
        }
        String aDependentNotDisabled = null;
        Set<String> dependentsToCheck = this.dependentsToCheck(strategy);
        for (String dependent : dependentsToCheck) {
            PluginDisableResult dependentStatus;
            PluginWrapper dependentPlugin = this.parent.getPlugin(dependent);
            if (dependentPlugin == null) {
                dependentStatus = new PluginDisableResult(dependent, PluginDisableStatus.NO_SUCH_PLUGIN, Messages.PluginWrapper_NoSuchPlugin(dependent));
                result.addDependentDisableStatus(dependentStatus);
                continue;
            }
            if (strategy.equals((Object)PluginDisableStrategy.NONE)) {
                if (!dependentPlugin.isEnabled()) continue;
                aDependentNotDisabled = dependent;
                break;
            }
            if (!dependentPlugin.isEnabled()) {
                dependentStatus = new PluginDisableResult(dependent, PluginDisableStatus.ALREADY_DISABLED, Messages.PluginWrapper_Already_Disabled(dependent));
                result.addDependentDisableStatus(dependentStatus);
                continue;
            }
            PluginDisableResult dependentResult = dependentPlugin.disable(strategy);
            PluginDisableStatus dependentStatus2 = dependentResult.status;
            if (PluginDisableStatus.ERROR_DISABLING.equals((Object)dependentStatus2) || PluginDisableStatus.NOT_DISABLED_DEPENDANTS.equals((Object)dependentStatus2)) {
                aDependentNotDisabled = dependent;
                break;
            }
            result.addDependentDisableStatus(dependentResult);
        }
        if (aDependentNotDisabled == null) {
            try {
                this.disableWithoutCheck();
                result.setMessage(Messages.PluginWrapper_Plugin_Disabled(this.shortName));
                result.setStatus(PluginDisableStatus.DISABLED);
            }
            catch (IOException io) {
                result.setMessage(Messages.PluginWrapper_Error_Disabling(this.shortName, io.toString()));
                result.setStatus(PluginDisableStatus.ERROR_DISABLING);
            }
        } else {
            result.setMessage(Messages.PluginWrapper_Plugin_Has_Dependent(this.shortName, aDependentNotDisabled, (Object)strategy));
            result.setStatus(PluginDisableStatus.NOT_DISABLED_DEPENDANTS);
        }
        return result;
    }

    private Set<String> dependentsToCheck(PluginDisableStrategy strategy) {
        Sets.SetView dependentsToCheck;
        switch (strategy) {
            case ALL: {
                dependentsToCheck = this.getDependents();
                break;
            }
            default: {
                dependentsToCheck = Sets.difference(this.getDependents(), this.getOptionalDependents());
            }
        }
        return dependentsToCheck;
    }

    @Exported
    public boolean isActive() {
        return this.active && !this.hasCycleDependency();
    }

    public boolean hasCycleDependency() {
        return this.hasCycleDependency;
    }

    public void setHasCycleDependency(boolean hasCycle) {
        this.hasCycleDependency = hasCycle;
    }

    @Exported
    public boolean isBundled() {
        return this.isBundled;
    }

    @Exported
    public boolean isEnabled() {
        return !this.disableFile.exists();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setPlugin(Plugin plugin) {
        Jenkins.lookup(PluginManager.PluginInstanceStore.class).store.put(this, plugin);
        plugin.wrapper = this;
    }

    public String getPluginClass() {
        return this.manifest.getMainAttributes().getValue("Plugin-Class");
    }

    public boolean hasLicensesXml() {
        try {
            new URL(this.baseResourceURL, "WEB-INF/licenses.xml").openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void resolvePluginDependencies() throws IOException {
        PluginWrapper dependency;
        if (ENABLE_PLUGIN_DEPENDENCIES_VERSION_CHECK) {
            String requiredCoreVersion = this.getRequiredCoreVersion();
            if (requiredCoreVersion == null) {
                LOGGER.warning(this.shortName + " doesn't declare required core version.");
            } else {
                VersionNumber actualVersion = Jenkins.getVersion();
                if (actualVersion.isOlderThan(new VersionNumber(requiredCoreVersion))) {
                    this.versionDependencyError(Messages.PluginWrapper_obsoleteCore(Jenkins.getVersion().toString(), requiredCoreVersion), Jenkins.getVersion().toString(), requiredCoreVersion);
                }
            }
        }
        for (Dependency d : this.dependencies) {
            dependency = this.parent.getPlugin(d.shortName);
            if (dependency == null) {
                PluginWrapper failedDependency = NOTICE.getPlugin(d.shortName);
                if (failedDependency != null) {
                    this.dependencyErrors.put(Messages.PluginWrapper_failed_to_load_dependency_2(failedDependency.getLongName(), failedDependency.getShortName(), failedDependency.getVersion()), true);
                    break;
                }
                this.dependencyErrors.put(Messages.PluginWrapper_missing(d.shortName, d.version), false);
                continue;
            }
            if (dependency.isActive()) {
                if (!this.isDependencyObsolete(d, dependency)) continue;
                this.versionDependencyError(Messages.PluginWrapper_obsolete_2(dependency.getLongName(), dependency.getShortName(), dependency.getVersion(), d.version), dependency.getVersion(), d.version);
                continue;
            }
            if (this.isDependencyObsolete(d, dependency)) {
                this.versionDependencyError(Messages.PluginWrapper_obsolete_2(dependency.getLongName(), dependency.getShortName(), dependency.getVersion(), d.version), dependency.getVersion(), d.version);
                continue;
            }
            this.dependencyErrors.put(Messages.PluginWrapper_disabled_2(dependency.getLongName(), dependency.getShortName()), false);
        }
        for (Dependency d : this.optionalDependencies) {
            dependency = this.parent.getPlugin(d.shortName);
            if (dependency == null || !dependency.isActive()) continue;
            if (this.isDependencyObsolete(d, dependency)) {
                this.versionDependencyError(Messages.PluginWrapper_obsolete_2(dependency.getLongName(), dependency.getShortName(), dependency.getVersion(), d.version), dependency.getVersion(), d.version);
                continue;
            }
            this.dependencies.add(d);
        }
        if (!this.dependencyErrors.isEmpty()) {
            NOTICE.addPlugin(this);
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(Messages.PluginWrapper_failed_to_load_plugin_2(this.getLongName(), this.getShortName(), this.getVersion())).append(System.lineSeparator());
            Iterator<String> iterator = this.dependencyErrors.keySet().iterator();
            while (iterator.hasNext()) {
                String dependencyError = iterator.next();
                messageBuilder.append(" - ").append(dependencyError);
                if (!iterator.hasNext()) continue;
                messageBuilder.append(System.lineSeparator());
            }
            throw new IOException(messageBuilder.toString());
        }
    }

    private boolean isDependencyObsolete(Dependency d, PluginWrapper dependency) {
        return ENABLE_PLUGIN_DEPENDENCIES_VERSION_CHECK && dependency.getVersionNumber().isOlderThan(new VersionNumber(d.version));
    }

    private void versionDependencyError(String message, String actual, String minimum) {
        if (PluginWrapper.isSnapshot(actual) || PluginWrapper.isSnapshot(minimum)) {
            LOGGER.log(Level.WARNING, "Suppressing dependency error in {0} v{1}: {2}", new Object[]{this.getShortName(), this.getVersion(), message});
        } else {
            this.dependencyErrors.put(message, false);
        }
    }

    static boolean isSnapshot(@NonNull String version) {
        return version.contains("-SNAPSHOT") || version.matches(".+-[0-9]{8}.[0-9]{6}-[0-9]+");
    }

    public UpdateSite.Plugin getUpdateInfo() {
        UpdateCenter uc = Jenkins.get().getUpdateCenter();
        UpdateSite.Plugin p = uc.getPlugin(this.getShortName(), this.getVersionNumber());
        if (p != null && p.isNewerThan(this.getVersion())) {
            return p;
        }
        return null;
    }

    public UpdateSite.Plugin getInfo() {
        UpdateCenter uc = Jenkins.get().getUpdateCenter();
        UpdateSite.Plugin p = uc.getPlugin(this.getShortName(), this.getVersionNumber());
        if (p != null) {
            return p;
        }
        return uc.getPlugin(this.getShortName());
    }

    private List<UpdateSite.Plugin> getInfoFromAllSites() {
        UpdateCenter uc = Jenkins.get().getUpdateCenter();
        return uc.getPluginFromAllSites(this.getShortName(), this.getVersionNumber());
    }

    @Exported
    public boolean hasUpdate() {
        return this.getUpdateInfo() != null;
    }

    @Exported
    @Deprecated
    public boolean isPinned() {
        return false;
    }

    @Exported
    public boolean isDeleted() {
        return !this.archive.exists();
    }

    @Exported
    public boolean isDetached() {
        return DetachedPluginsUtil.isDetachedPlugin(this.shortName);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasImpliedDependents() {
        if (!this.isDetached()) {
            return false;
        }
        for (PluginWrapper p : Jenkins.get().getPluginManager().getPlugins()) {
            for (Dependency dependency : DetachedPluginsUtil.getImpliedDependencies(p.shortName, p.getRequiredCoreVersion())) {
                if (!dependency.shortName.equals(this.shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public Set<String> getImpliedDependents() {
        if (!this.isDetached()) {
            return Collections.emptySet();
        }
        HashSet<String> implied = new HashSet<String>();
        for (PluginWrapper p : Jenkins.get().getPluginManager().getPlugins()) {
            for (Dependency dependency : DetachedPluginsUtil.getImpliedDependencies(p.shortName, p.getRequiredCoreVersion())) {
                if (!dependency.shortName.equals(this.shortName)) continue;
                implied.add(p.shortName);
            }
        }
        return implied;
    }

    @Override
    public int compareTo(PluginWrapper pw) {
        return this.shortName.compareToIgnoreCase(pw.shortName);
    }

    @Exported
    public boolean isDowngradable() {
        return this.getBackupFile().exists();
    }

    public File getBackupFile() {
        return new File(Jenkins.get().getRootDir(), "plugins/" + this.getShortName() + ".bak");
    }

    @Exported
    public String getBackupVersion() {
        File backup = this.getBackupFile();
        if (backup.exists()) {
            String string;
            JarFile backupPlugin = new JarFile(backup);
            try {
                string = backupPlugin.getManifest().getMainAttributes().getValue("Plugin-Version");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        backupPlugin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to get backup version from " + backup, e);
                    return null;
                }
            }
            backupPlugin.close();
            return string;
        }
        return null;
    }

    @Deprecated
    public boolean isPinningForcingOldVersion() {
        return false;
    }

    @RequirePOST
    public HttpResponse doMakeEnabled() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.enable();
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doMakeDisabled() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.disable();
        return HttpResponses.ok();
    }

    @RequirePOST
    @Deprecated
    public HttpResponse doPin() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        LOGGER.log(Level.WARNING, "Call to pin plugin has been ignored. Plugin name: " + this.shortName);
        return HttpResponses.ok();
    }

    @RequirePOST
    @Deprecated
    public HttpResponse doUnpin() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        LOGGER.log(Level.WARNING, "Call to unpin plugin has been ignored. Plugin name: " + this.shortName);
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doDoUninstall() throws IOException {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        Files.deleteIfExists(Util.fileToPath(this.archive));
        Files.deleteIfExists(Util.fileToPath(this.disableFile));
        jenkins.getPluginManager().resolveDependentPlugins();
        return HttpResponses.redirectViaContextPath((String)"/pluginManager/installed");
    }

    @Restricted(value={DoNotUse.class})
    public List<UpdateSite.Warning> getActiveWarnings() {
        return ExtensionList.lookupSingleton(UpdateSiteWarningsMonitor.class).getActivePluginWarningsByPlugin().getOrDefault(this, Collections.emptyList());
    }

    @Restricted(value={NoExternalUse.class})
    public List<UpdateSite.Deprecation> getDeprecations() {
        ArrayList<UpdateSite.Deprecation> deprecations = new ArrayList<UpdateSite.Deprecation>();
        UpdateCenter updateCenter = Jenkins.get().getUpdateCenter();
        if (updateCenter.isSiteDataReady()) {
            for (UpdateSite site : updateCenter.getSites()) {
                UpdateSite.Data data = site.getData();
                if (data == null) continue;
                for (Map.Entry<String, UpdateSite.Deprecation> entry : data.getDeprecations().entrySet()) {
                    if (!entry.getKey().equals(this.shortName)) continue;
                    deprecations.add(entry.getValue());
                }
            }
        }
        return deprecations;
    }

    @Restricted(value={NoExternalUse.class})
    public String getIssueTrackerReportUrl() {
        UpdateCenter updateCenter = Jenkins.get().getUpdateCenter();
        if (updateCenter.isSiteDataReady()) {
            for (UpdateSite site : updateCenter.getSites()) {
                UpdateSite.Plugin sitePlugin = site.getPlugin(this.shortName);
                if (sitePlugin == null || sitePlugin.issueTrackers == null) continue;
                for (UpdateSite.IssueTracker issueTracker : sitePlugin.issueTrackers) {
                    if (issueTracker.reportUrl == null) continue;
                    return issueTracker.reportUrl;
                }
            }
        }
        return null;
    }

    public static enum PluginDisableStrategy {
        NONE,
        MANDATORY,
        ALL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum PluginDisableStatus {
        NO_SUCH_PLUGIN,
        DISABLED,
        ALREADY_DISABLED,
        NOT_DISABLED_DEPENDANTS,
        ERROR_DISABLING;

    }

    public static class PluginDisableResult {
        private String plugin;
        private PluginDisableStatus status;
        private String message;
        private Set<PluginDisableResult> dependentsDisableStatus = new HashSet<PluginDisableResult>();

        public PluginDisableResult(String plugin) {
            this.plugin = plugin;
        }

        public PluginDisableResult(String plugin, PluginDisableStatus status, String message) {
            this.plugin = plugin;
            this.status = status;
            this.message = message;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public PluginDisableStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginDisableResult that = (PluginDisableResult)o;
            return Objects.equals(this.plugin, that.plugin);
        }

        public int hashCode() {
            return Objects.hash(this.plugin);
        }

        public void setStatus(PluginDisableStatus status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Set<PluginDisableResult> getDependentsDisableStatus() {
            return this.dependentsDisableStatus;
        }

        public void addDependentDisableStatus(PluginDisableResult dependentDisableStatus) {
            this.dependentsDisableStatus.add(dependentDisableStatus);
        }
    }

    public static final class PluginWrapperAdministrativeMonitor
    extends AdministrativeMonitor {
        private final Map<String, PluginWrapper> plugins = new HashMap<String, PluginWrapper>();

        void addPlugin(PluginWrapper plugin) {
            this.plugins.put(plugin.shortName, plugin);
        }

        @Override
        public boolean isActivated() {
            return !this.plugins.isEmpty();
        }

        @Restricted(value={DoNotUse.class})
        public boolean hasAnyDerivedDependencyErrors() {
            return this.plugins.values().stream().anyMatch(PluginWrapper::hasDerivedDependencyErrors);
        }

        @Override
        public String getDisplayName() {
            return Messages.PluginWrapper_PluginWrapperAdministrativeMonitor_DisplayName();
        }

        public Collection<PluginWrapper> getPlugins() {
            return this.plugins.values();
        }

        public PluginWrapper getPlugin(String shortName) {
            return this.plugins.get(shortName);
        }

        public void doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
            if (req.hasParameter("correct")) {
                rsp.sendRedirect(req.getContextPath() + "/pluginManager");
            }
        }

        public static PluginWrapperAdministrativeMonitor get() {
            return AdministrativeMonitor.all().get(PluginWrapperAdministrativeMonitor.class);
        }
    }

    @ExportedBean
    public static final class Dependency {
        @Exported
        public final String shortName;
        @Exported
        public final String version;
        @Exported
        public final boolean optional;

        public Dependency(String s) {
            int idx = s.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("Illegal dependency specifier " + s);
            }
            this.shortName = Util.intern(s.substring(0, idx));
            String version = Util.intern(s.substring(idx + 1));
            boolean isOptional = false;
            String[] osgiProperties = version.split("[;]");
            for (int i = 1; i < osgiProperties.length; ++i) {
                String osgiProperty = osgiProperties[i].trim();
                if (!osgiProperty.equalsIgnoreCase("resolution:=optional")) continue;
                isOptional = true;
                break;
            }
            this.optional = isOptional;
            this.version = isOptional ? osgiProperties[0] : version;
        }

        public String toString() {
            return this.shortName + " (" + this.version + ")" + (this.optional ? " optional" : "");
        }
    }
}

