/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import com.google.common.collect.Iterables;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.queue.FutureLoad;
import hudson.model.queue.LoadPredictor;
import hudson.model.queue.SubTask;
import hudson.model.queue.Timeline;
import hudson.model.queue.WorkUnit;
import hudson.model.queue.WorkUnitContext;
import hudson.security.ACL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MappingWorksheet {
    public final List<ExecutorChunk> executors;
    public final List<WorkChunk> works;
    public final Queue.BuildableItem item;

    public MappingWorksheet(Queue.BuildableItem item, List<? extends ExecutorSlot> offers) {
        this(item, offers, LoadPredictor.all());
    }

    public MappingWorksheet(Queue.BuildableItem item, List<? extends ExecutorSlot> offers, Collection<? extends LoadPredictor> loadPredictors) {
        this.item = item;
        HashMap<Computer, List> j = new HashMap<Computer, List>();
        for (ExecutorSlot executorSlot : offers) {
            Computer c = executorSlot.getExecutor().getOwner();
            List list = j.computeIfAbsent(c, k -> new ArrayList());
            list.add(executorSlot);
        }
        long duration = item.task.getEstimatedDuration();
        if (duration > 0L) {
            long now = System.currentTimeMillis();
            for (Map.Entry entry : j.entrySet()) {
                int minIdle;
                List list = (List)entry.getValue();
                int max = ((Computer)entry.getKey()).countExecutors();
                Timeline timeline = new Timeline();
                int peak = 0;
                block2: for (LoadPredictor loadPredictor : loadPredictors) {
                    for (FutureLoad fl : Iterables.limit(loadPredictor.predict(this, (Computer)entry.getKey(), now, now + duration), (int)100)) {
                        if ((peak = Math.max(peak, timeline.insert(fl.startTime, fl.startTime + fl.duration, fl.numExecutors))) < max) continue;
                        break block2;
                    }
                }
                if ((minIdle = max - peak) < 0) {
                    minIdle = 0;
                }
                if (minIdle >= list.size()) continue;
                entry.setValue(list.subList(0, minIdle));
            }
        }
        ArrayList<ExecutorChunk> executors = new ArrayList<ExecutorChunk>();
        for (List group : j.values()) {
            if (group.isEmpty()) continue;
            ExecutorChunk executorChunk = new ExecutorChunk(group, executors.size());
            if (executorChunk.node == null) continue;
            executors.add(executorChunk);
        }
        this.executors = Collections.unmodifiableList(executors);
        LinkedHashMap<Object, List> linkedHashMap = new LinkedHashMap<Object, List>();
        for (SubTask subTask : item.task.getSubTasks()) {
            Object c = subTask.getSameNodeConstraint();
            if (c == null) {
                c = new Object();
            }
            List list = linkedHashMap.computeIfAbsent(c, k -> new ArrayList());
            list.add(subTask);
        }
        ArrayList<WorkChunk> works = new ArrayList<WorkChunk>();
        for (List group : linkedHashMap.values()) {
            works.add(new WorkChunk(group, works.size()));
        }
        this.works = Collections.unmodifiableList(works);
    }

    public WorkChunk works(int index) {
        return this.works.get(index);
    }

    public ExecutorChunk executors(int index) {
        return this.executors.get(index);
    }

    public static abstract class ExecutorSlot {
        public abstract Executor getExecutor();

        public abstract boolean isAvailable();

        protected abstract void set(WorkUnit var1) throws UnsupportedOperationException;
    }

    public final class Mapping {
        private final ExecutorChunk[] mapping;

        public Mapping() {
            this.mapping = new ExecutorChunk[MappingWorksheet.this.works.size()];
        }

        public ExecutorChunk assigned(int n) {
            return this.mapping[n];
        }

        public WorkChunk get(int n) {
            return MappingWorksheet.this.works.get(n);
        }

        public ExecutorChunk assign(int index, ExecutorChunk element) {
            ExecutorChunk o = this.mapping[index];
            this.mapping[index] = element;
            return o;
        }

        public int size() {
            return this.mapping.length;
        }

        public Map<WorkChunk, ExecutorChunk> toMap() {
            HashMap<WorkChunk, ExecutorChunk> r = new HashMap<WorkChunk, ExecutorChunk>();
            for (int i = 0; i < this.size(); ++i) {
                r.put(this.get(i), this.assigned(i));
            }
            return r;
        }

        public boolean isPartiallyValid() {
            int[] used = new int[MappingWorksheet.this.executors.size()];
            for (int i = 0; i < this.mapping.length; ++i) {
                ExecutorChunk ec = this.mapping[i];
                if (ec == null) continue;
                if (!ec.canAccept(MappingWorksheet.this.works(i))) {
                    return false;
                }
                int n = ec.index;
                used[n] = used[n] + MappingWorksheet.this.works(i).size();
                if (used[n] <= ec.capacity()) continue;
                return false;
            }
            return true;
        }

        public boolean isCompletelyValid() {
            for (ExecutorChunk ec : this.mapping) {
                if (ec != null) continue;
                return false;
            }
            return this.isPartiallyValid();
        }

        public void execute(WorkUnitContext wuc) {
            if (!this.isCompletelyValid()) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < this.size(); ++i) {
                this.assigned(i).execute(this.get(i), wuc);
            }
        }
    }

    public class WorkChunk
    extends ReadOnlyList<SubTask> {
        public final int index;
        public final Label assignedLabel;
        public final ExecutorChunk lastBuiltOn;

        private WorkChunk(List<SubTask> base, int index) {
            super(base);
            assert (!base.isEmpty());
            this.index = index;
            this.assignedLabel = this.getAssignedLabel(base.get(0));
            Node lbo = base.get(0).getLastBuiltOn();
            for (ExecutorChunk ec : MappingWorksheet.this.executors) {
                if (ec.node != lbo) continue;
                this.lastBuiltOn = ec;
                return;
            }
            this.lastBuiltOn = null;
        }

        private Label getAssignedLabel(SubTask task) {
            for (LabelAssignmentAction laa : MappingWorksheet.this.item.getActions(LabelAssignmentAction.class)) {
                Label l = laa.getAssignedLabel(task);
                if (l == null) continue;
                return l;
            }
            return task.getAssignedLabel();
        }

        public List<ExecutorChunk> applicableExecutorChunks() {
            ArrayList<ExecutorChunk> r = new ArrayList<ExecutorChunk>(MappingWorksheet.this.executors.size());
            for (ExecutorChunk e : MappingWorksheet.this.executors) {
                if (!e.canAccept(this)) continue;
                r.add(e);
            }
            return r;
        }
    }

    public final class ExecutorChunk
    extends ReadOnlyList<ExecutorSlot> {
        public final int index;
        public final Computer computer;
        public final Node node;
        public final ACL nodeAcl;

        private ExecutorChunk(List<ExecutorSlot> base, int index) {
            super(base);
            this.index = index;
            assert (!base.isEmpty());
            this.computer = base.get(0).getExecutor().getOwner();
            this.node = this.computer.getNode();
            this.nodeAcl = this.node.getACL();
        }

        public boolean canAccept(WorkChunk c) {
            if (this.size() < c.size()) {
                return false;
            }
            if (c.assignedLabel != null && !c.assignedLabel.contains(this.node)) {
                return false;
            }
            return Node.SKIP_BUILD_CHECK_ON_FLYWEIGHTS && MappingWorksheet.this.item.task instanceof Queue.FlyweightTask || this.nodeAcl.hasPermission2(MappingWorksheet.this.item.authenticate2(), Computer.BUILD);
        }

        public String getName() {
            return this.node.getNodeName();
        }

        public int capacity() {
            return this.size();
        }

        private void execute(WorkChunk wc, WorkUnitContext wuc) {
            assert (this.capacity() >= wc.size());
            int e = 0;
            for (SubTask s : wc) {
                while (!((ExecutorSlot)this.get(e)).isAvailable()) {
                    ++e;
                }
                ((ExecutorSlot)this.get(e++)).set(wuc.createWorkUnit(s));
            }
        }
    }

    private static class ReadOnlyList<E>
    extends AbstractList<E> {
        protected final List<E> base;

        ReadOnlyList(List<E> base) {
            this.base = base;
        }

        @Override
        public E get(int index) {
            return this.base.get(index);
        }

        @Override
        public int size() {
            return this.base.size();
        }
    }
}

