/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.AccessDeniedHandlerImpl;
import hudson.security.AuthenticationManagerProxy;
import hudson.security.AuthenticationProcessingFilter2;
import hudson.security.ChainedServletFilter;
import hudson.security.CliAuthenticator;
import hudson.security.FederatedLoginService;
import hudson.security.GroupDetails;
import hudson.security.HttpSessionContextIntegrationFilter2;
import hudson.security.HudsonAuthenticationEntryPoint;
import hudson.security.Messages;
import hudson.security.TokenBasedRememberMeServices2;
import hudson.security.UnwrapSecurityExceptionFilter;
import hudson.security.UserDetailsServiceProxy;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.security.captcha.CaptchaSupport;
import hudson.util.DescriptorList;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.security.AcegiSecurityExceptionFilter;
import jenkins.security.AuthenticationSuccessHandler;
import jenkins.security.BasicHeaderProcessor;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;

public abstract class SecurityRealm
extends AbstractDescribableImpl<SecurityRealm>
implements ExtensionPoint {
    private CaptchaSupport captchaSupport;
    private static final ThreadLocal<Boolean> insideGetPostLogOutUrl = ThreadLocal.withInitial(() -> false);
    private transient SecurityComponents securityComponents;
    public static final SecurityRealm NO_AUTHENTICATION = new None();
    @Deprecated
    public static final DescriptorList<SecurityRealm> LIST = new DescriptorList<SecurityRealm>(SecurityRealm.class);
    private static final Logger LOGGER = Logger.getLogger(SecurityRealm.class.getName());
    public static final org.springframework.security.core.GrantedAuthority AUTHENTICATED_AUTHORITY2 = new SimpleGrantedAuthority("authenticated");
    @Deprecated
    public static final GrantedAuthority AUTHENTICATED_AUTHORITY = new GrantedAuthorityImpl("authenticated");

    public abstract SecurityComponents createSecurityComponents();

    public IdStrategy getUserIdStrategy() {
        return IdStrategy.CASE_INSENSITIVE;
    }

    public IdStrategy getGroupIdStrategy() {
        return this.getUserIdStrategy();
    }

    @Deprecated
    public CliAuthenticator createCliAuthenticator(CLICommand command) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Descriptor<SecurityRealm> getDescriptor() {
        return super.getDescriptor();
    }

    public String getAuthenticationGatewayUrl() {
        return "j_spring_security_check";
    }

    public String getLoginUrl() {
        return "login";
    }

    public boolean canLogOut() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPostLogOutUrl2(StaplerRequest req, org.springframework.security.core.Authentication auth) {
        if (Util.isOverridden(SecurityRealm.class, this.getClass(), "getPostLogOutUrl", StaplerRequest.class, Authentication.class) && !insideGetPostLogOutUrl.get().booleanValue()) {
            insideGetPostLogOutUrl.set(true);
            try {
                String string = this.getPostLogOutUrl(req, Authentication.fromSpring(auth));
                return string;
            }
            finally {
                insideGetPostLogOutUrl.set(false);
            }
        }
        return req.getContextPath() + "/";
    }

    @Deprecated
    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        return this.getPostLogOutUrl2(req, auth.toSpring());
    }

    public CaptchaSupport getCaptchaSupport() {
        return this.captchaSupport;
    }

    public void setCaptchaSupport(CaptchaSupport captchaSupport) {
        this.captchaSupport = captchaSupport;
    }

    public List<Descriptor<CaptchaSupport>> getCaptchaSupportDescriptors() {
        return CaptchaSupport.all();
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        org.springframework.security.core.Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.clearContext();
        String contextPath = req.getContextPath().length() > 0 ? req.getContextPath() : "/";
        this.resetRememberMeCookie(req, rsp, contextPath);
        this.clearStaleSessionCookies(req, rsp, contextPath);
        rsp.sendRedirect2(this.getPostLogOutUrl2(req, auth));
    }

    private void resetRememberMeCookie(StaplerRequest req, StaplerResponse rsp, String contextPath) {
        Cookie cookie = new Cookie("remember-me", "");
        cookie.setMaxAge(0);
        cookie.setSecure(req.isSecure());
        cookie.setHttpOnly(true);
        cookie.setPath(contextPath);
        rsp.addCookie(cookie);
    }

    private void clearStaleSessionCookies(StaplerRequest req, StaplerResponse rsp, String contextPath) {
        String cookieName = "JSESSIONID.";
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().startsWith("JSESSIONID.")) continue;
                LOGGER.log(Level.FINE, "Removing cookie {0} during logout", cookie.getName());
                cookie.setMaxAge(0);
                cookie.setValue("");
                rsp.addCookie(cookie);
            }
        }
    }

    public boolean allowsSignup() {
        Class<?> clz = this.getClass();
        return clz.getClassLoader().getResource(clz.getName().replace('.', '/') + "/signup.jelly") != null;
    }

    public UserDetails loadUserByUsername2(String username) throws org.springframework.security.core.userdetails.UsernameNotFoundException {
        if (Util.isOverridden(SecurityRealm.class, this.getClass(), "loadUserByUsername", String.class)) {
            try {
                return this.loadUserByUsername(username).toSpring();
            }
            catch (AcegiSecurityException x) {
                throw x.toSpring();
            }
            catch (DataAccessException x) {
                throw x.toSpring();
            }
        }
        return this.getSecurityComponents().userDetails2.loadUserByUsername(username);
    }

    @Deprecated
    public org.acegisecurity.userdetails.UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            return org.acegisecurity.userdetails.UserDetails.fromSpring(this.loadUserByUsername2(username));
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    public GroupDetails loadGroupByGroupname2(String groupname, boolean fetchMembers) throws org.springframework.security.core.userdetails.UsernameNotFoundException {
        if (Util.isOverridden(SecurityRealm.class, this.getClass(), "loadGroupByGroupname", String.class)) {
            try {
                return this.loadGroupByGroupname(groupname);
            }
            catch (AcegiSecurityException x) {
                throw x.toSpring();
            }
            catch (DataAccessException x) {
                throw x.toSpring();
            }
        }
        if (Util.isOverridden(SecurityRealm.class, this.getClass(), "loadGroupByGroupname", String.class, Boolean.TYPE)) {
            try {
                return this.loadGroupByGroupname(groupname, fetchMembers);
            }
            catch (AcegiSecurityException x) {
                throw x.toSpring();
            }
            catch (DataAccessException x) {
                throw x.toSpring();
            }
        }
        throw new UserMayOrMayNotExistException2(groupname);
    }

    @Deprecated
    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        try {
            return this.loadGroupByGroupname2(groupname, false);
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    @Deprecated
    public GroupDetails loadGroupByGroupname(String groupname, boolean fetchMembers) throws UsernameNotFoundException, DataAccessException {
        try {
            return this.loadGroupByGroupname2(groupname, fetchMembers);
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    public HttpResponse commenceSignup(FederatedLoginService.FederatedIdentity identity) {
        throw new UnsupportedOperationException();
    }

    public final void doCaptcha(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.captchaSupport != null) {
            String id = req.getSession().getId();
            rsp.setContentType("image/png");
            rsp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            rsp.setHeader("Pragma", "no-cache");
            rsp.setHeader("Expires", "0");
            this.captchaSupport.generateImage(id, (OutputStream)rsp.getOutputStream());
        }
    }

    protected final boolean validateCaptcha(String text) {
        if (this.captchaSupport != null) {
            String id = Stapler.getCurrentRequest().getSession().getId();
            return this.captchaSupport.validateCaptcha(id, text);
        }
        return true;
    }

    public synchronized SecurityComponents getSecurityComponents() {
        if (this.securityComponents == null) {
            this.securityComponents = this.createSecurityComponents();
        }
        return this.securityComponents;
    }

    public Filter createFilter(FilterConfig filterConfig) {
        LOGGER.entering(SecurityRealm.class.getName(), "createFilter");
        SecurityComponents sc = this.getSecurityComponents();
        ArrayList<Object> filters = new ArrayList<Object>();
        HttpSessionSecurityContextRepository httpSessionSecurityContextRepository = new HttpSessionSecurityContextRepository();
        httpSessionSecurityContextRepository.setAllowSessionCreation(false);
        filters.add((Object)new HttpSessionContextIntegrationFilter2((SecurityContextRepository)httpSessionSecurityContextRepository));
        BasicHeaderProcessor bhp = new BasicHeaderProcessor();
        BasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new BasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName("Jenkins");
        bhp.setAuthenticationEntryPoint((AuthenticationEntryPoint)basicAuthenticationEntryPoint);
        bhp.setRememberMeServices(sc.rememberMe2);
        filters.add(bhp);
        AuthenticationProcessingFilter2 apf = new AuthenticationProcessingFilter2(this.getAuthenticationGatewayUrl());
        apf.setAuthenticationManager(sc.manager2);
        if (SystemProperties.getInteger(SecurityRealm.class.getName() + ".sessionFixationProtectionMode", 1) == 1) {
            apf.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new SessionFixationProtectionStrategy());
        }
        apf.setRememberMeServices(sc.rememberMe2);
        AuthenticationSuccessHandler successHandler = new AuthenticationSuccessHandler();
        successHandler.setTargetUrlParameter("from");
        apf.setAuthenticationSuccessHandler((org.springframework.security.web.authentication.AuthenticationSuccessHandler)successHandler);
        apf.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler("/loginError"));
        filters.add((Object)apf);
        filters.add(new RememberMeAuthenticationFilter(sc.manager2, sc.rememberMe2));
        filters.addAll(this.commonFilters());
        return new ChainedServletFilter(filters);
    }

    protected final List<Filter> commonFilters() {
        AnonymousAuthenticationFilter apf = new AnonymousAuthenticationFilter("anonymous", (Object)"anonymous", List.of(new SimpleGrantedAuthority("anonymous")));
        ExceptionTranslationFilter etf = new ExceptionTranslationFilter((AuthenticationEntryPoint)new HudsonAuthenticationEntryPoint("/" + this.getLoginUrl() + "?from={0}"));
        etf.setAccessDeniedHandler((AccessDeniedHandler)new AccessDeniedHandlerImpl());
        UnwrapSecurityExceptionFilter usef = new UnwrapSecurityExceptionFilter();
        AcegiSecurityExceptionFilter asef = new AcegiSecurityExceptionFilter();
        return Arrays.asList(apf, etf, usef, asef);
    }

    @Restricted(value={DoNotUse.class})
    public static String getFrom() {
        String returnValue;
        String from = null;
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            from = request.getParameter("from");
        }
        if (from == null && request != null && request.getRequestURI() != null && !request.getRequestURI().equals("/loginError") && !request.getRequestURI().equals("/login")) {
            from = request.getRequestURI();
        }
        return StringUtils.isBlank((String)(returnValue = URLEncoder.encode(from = StringUtils.defaultIfBlank((String)from, (String)"/").trim(), StandardCharsets.UTF_8))) ? "/" : returnValue;
    }

    public static DescriptorExtensionList<SecurityRealm, Descriptor<SecurityRealm>> all() {
        return Jenkins.get().getDescriptorList(SecurityRealm.class);
    }

    public static final class SecurityComponents {
        public final org.springframework.security.authentication.AuthenticationManager manager2;
        @Deprecated
        public final AuthenticationManager manager;
        public final org.springframework.security.core.userdetails.UserDetailsService userDetails2;
        @Deprecated
        public final UserDetailsService userDetails;
        public final RememberMeServices rememberMe2;
        @Deprecated
        public final org.acegisecurity.ui.rememberme.RememberMeServices rememberMe;

        public SecurityComponents() {
            this(new AuthenticationManagerProxy());
        }

        public SecurityComponents(org.springframework.security.authentication.AuthenticationManager manager) {
            this(manager, new UserDetailsServiceProxy());
        }

        @Deprecated
        public SecurityComponents(AuthenticationManager manager) {
            this(manager.toSpring());
        }

        public SecurityComponents(org.springframework.security.authentication.AuthenticationManager manager, org.springframework.security.core.userdetails.UserDetailsService userDetails) {
            this(manager, userDetails, SecurityComponents.createRememberMeService(userDetails));
        }

        @Deprecated
        public SecurityComponents(AuthenticationManager manager, UserDetailsService userDetails) {
            this(manager.toSpring(), userDetails.toSpring());
        }

        public SecurityComponents(org.springframework.security.authentication.AuthenticationManager manager, org.springframework.security.core.userdetails.UserDetailsService userDetails, RememberMeServices rememberMe) {
            assert (manager != null && userDetails != null && rememberMe != null);
            this.manager2 = manager;
            this.userDetails2 = userDetails;
            this.rememberMe2 = rememberMe;
            this.manager = AuthenticationManager.fromSpring(manager);
            this.userDetails = UserDetailsService.fromSpring(userDetails);
            this.rememberMe = org.acegisecurity.ui.rememberme.RememberMeServices.fromSpring(rememberMe);
        }

        @Deprecated
        public SecurityComponents(AuthenticationManager manager, UserDetailsService userDetails, org.acegisecurity.ui.rememberme.RememberMeServices rememberMe) {
            this(manager.toSpring(), userDetails.toSpring(), rememberMe.toSpring());
        }

        private static RememberMeServices createRememberMeService(org.springframework.security.core.userdetails.UserDetailsService uds) {
            TokenBasedRememberMeServices2 rms = new TokenBasedRememberMeServices2(uds);
            rms.setParameter("remember_me");
            return rms;
        }
    }

    private static class None
    extends SecurityRealm {
        private None() {
        }

        @Override
        public SecurityComponents createSecurityComponents() {
            return new SecurityComponents(new org.springframework.security.authentication.AuthenticationManager(){

                public org.springframework.security.core.Authentication authenticate(org.springframework.security.core.Authentication authentication) {
                    return authentication;
                }
            }, new org.springframework.security.core.userdetails.UserDetailsService(){

                public UserDetails loadUserByUsername(String username) throws org.springframework.security.core.userdetails.UsernameNotFoundException {
                    throw new org.springframework.security.core.userdetails.UsernameNotFoundException(username);
                }
            });
        }

        @Override
        public GroupDetails loadGroupByGroupname2(String groupname, boolean fetchMembers) throws org.springframework.security.core.userdetails.UsernameNotFoundException {
            throw new org.springframework.security.core.userdetails.UsernameNotFoundException(groupname);
        }

        @Override
        public Filter createFilter(FilterConfig filterConfig) {
            return new ChainedServletFilter();
        }

        private Object readResolve() {
            return NO_AUTHENTICATION;
        }

        @Extension(ordinal=-100.0)
        @Symbol(value={"none"})
        public static class DescriptorImpl
        extends Descriptor<SecurityRealm> {
            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.NoneSecurityRealm_DisplayName();
            }

            @Override
            public SecurityRealm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                return NO_AUTHENTICATION;
            }
        }
    }
}

