/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.google.common.primitives.Ints;
import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.util.ProcessKiller;
import hudson.util.ProcessKillingVeto;
import hudson.util.ProcessTreeRemoting;
import hudson.util.QuotedStringTokenizer;
import hudson.util.jna.GNUCLibrary;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.agents.AgentComputerUtil;
import jenkins.security.SlaveToMasterCallable;
import jenkins.util.SystemProperties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;

public abstract class ProcessTree
implements Iterable<OSProcess>,
ProcessTreeRemoting.IProcessTree,
SerializableOnlyOverRemoting {
    protected final Map<Integer, OSProcess> processes = new HashMap<Integer, OSProcess>();
    private volatile transient List<ProcessKiller> killers;
    private boolean skipVetoes;
    private final long softKillWaitSeconds = Integer.getInteger("SoftKillWaitSeconds", 5).intValue();
    static volatile Boolean vetoersExist;
    static final ProcessTree DEFAULT;
    private static final boolean IS_LITTLE_ENDIAN;
    private static final Logger LOGGER;
    static boolean enabled;

    private ProcessTree() {
        this.skipVetoes = false;
    }

    private ProcessTree(boolean vetoesExist) {
        this.skipVetoes = !vetoesExist;
    }

    @CheckForNull
    public final OSProcess get(int pid) {
        return this.processes.get(pid);
    }

    @Override
    @NonNull
    public final Iterator<OSProcess> iterator() {
        return this.processes.values().iterator();
    }

    @CheckForNull
    public abstract OSProcess get(@NonNull Process var1);

    @Override
    public abstract void killAll(@NonNull Map<String, String> var1) throws InterruptedException;

    public void killAll(@CheckForNull Process proc, @CheckForNull Map<String, String> modelEnvVars) throws InterruptedException {
        OSProcess p;
        LOGGER.fine("killAll: process=" + proc + " and envs=" + modelEnvVars);
        if (proc != null && (p = this.get(proc)) != null) {
            p.killRecursively();
        }
        if (modelEnvVars != null) {
            this.killAll(modelEnvVars);
        }
    }

    @NonNull
    final List<ProcessKiller> getKillers() throws InterruptedException {
        if (this.killers == null) {
            try {
                VirtualChannel channelToController = AgentComputerUtil.getChannelToController();
                this.killers = channelToController != null ? (List<Object>)channelToController.call((Callable)new ListAll()) : Collections.emptyList();
            }
            catch (IOException | Error e) {
                LOGGER.log(Level.WARNING, "Failed to obtain killers", e);
                this.killers = Collections.emptyList();
            }
        }
        return this.killers;
    }

    public static ProcessTree get() {
        if (!enabled) {
            return DEFAULT;
        }
        if (vetoersExist == null) {
            try {
                VirtualChannel channelToController = AgentComputerUtil.getChannelToController();
                if (channelToController != null) {
                    vetoersExist = (Boolean)channelToController.call((Callable)new DoVetoersExist());
                }
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.FINE, "Caught InterruptedException while checking if vetoers exist: ", ie);
                Thread.interrupted();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error while determining if vetoers exist", e);
            }
        }
        boolean vetoes = vetoersExist == null ? true : vetoersExist;
        try {
            if (File.pathSeparatorChar == ';') {
                return new Windows(vetoes);
            }
            String os = Util.fixNull(System.getProperty("os.name"));
            if (os.equals("Linux")) {
                return new Linux(vetoes);
            }
            if (os.equals("AIX")) {
                return new AIX(vetoes);
            }
            if (os.equals("SunOS")) {
                return new Solaris(vetoes);
            }
            if (os.equals("Mac OS X")) {
                return new Darwin(vetoes);
            }
            if (os.equals("FreeBSD")) {
                return new FreeBSD(vetoes);
            }
        }
        catch (LinkageError e) {
            LOGGER.log(Level.FINE, "Failed to load OS-specific implementation; reverting to the default", e);
            enabled = false;
        }
        return DEFAULT;
    }

    Object writeReplace() throws ObjectStreamException {
        return new Remote(this, this.getChannelForSerialization());
    }

    static {
        DEFAULT = new Local(){

            @Override
            public OSProcess get(final @NonNull Process proc) {
                return new OSProcess(-1){

                    @Override
                    @CheckForNull
                    public OSProcess getParent() {
                        return null;
                    }

                    @Override
                    public void killRecursively() {
                        proc.destroy();
                    }

                    @Override
                    public void kill() throws InterruptedException {
                        if (this.getVeto() != null) {
                            return;
                        }
                        proc.destroy();
                        this.killByKiller();
                    }

                    @Override
                    @NonNull
                    public List<String> getArguments() {
                        return Collections.emptyList();
                    }

                    @Override
                    @NonNull
                    public EnvVars getEnvironmentVariables() {
                        return new EnvVars();
                    }
                };
            }

            @Override
            public void killAll(@NonNull Map<String, String> modelEnvVars) {
            }
        };
        IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
        LOGGER = Logger.getLogger(ProcessTree.class.getName());
        enabled = !SystemProperties.getBoolean("hudson.util.ProcessTreeKiller.disable") && !SystemProperties.getBoolean(ProcessTree.class.getName() + ".disable");
    }

    public static class Remote
    extends ProcessTree {
        private final ProcessTreeRemoting.IProcessTree proxy;
        private static final long serialVersionUID = 1L;

        @Deprecated
        public Remote(ProcessTree proxy, Channel ch) {
            this.proxy = (ProcessTreeRemoting.IProcessTree)ch.export(ProcessTreeRemoting.IProcessTree.class, (Object)proxy);
            for (Map.Entry<Integer, OSProcess> e : proxy.processes.entrySet()) {
                this.processes.put(e.getKey(), new RemoteProcess(e.getValue(), ch));
            }
        }

        public Remote(ProcessTree proxy, Channel ch, boolean vetoersExist) {
            super(vetoersExist);
            this.proxy = (ProcessTreeRemoting.IProcessTree)ch.export(ProcessTreeRemoting.IProcessTree.class, (Object)proxy);
            for (Map.Entry<Integer, OSProcess> e : proxy.processes.entrySet()) {
                this.processes.put(e.getKey(), new RemoteProcess(e.getValue(), ch));
            }
        }

        @Override
        @CheckForNull
        public OSProcess get(@NonNull Process proc) {
            return null;
        }

        @Override
        public void killAll(@NonNull Map<String, String> modelEnvVars) throws InterruptedException {
            this.proxy.killAll(modelEnvVars);
        }

        @Override
        Object writeReplace() {
            return this;
        }

        @SuppressFBWarnings(value={"SE_INNER_CLASS"}, justification="Serializing the outer instance is intended")
        private class RemoteProcess
        extends OSProcess
        implements Serializable {
            private final ProcessTreeRemoting.IOSProcess proxy;
            private static final long serialVersionUID = 1L;

            RemoteProcess(OSProcess proxy, Channel ch) {
                super(proxy.getPid());
                this.proxy = (ProcessTreeRemoting.IOSProcess)ch.export(ProcessTreeRemoting.IOSProcess.class, (Object)proxy);
            }

            @Override
            @CheckForNull
            public OSProcess getParent() {
                ProcessTreeRemoting.IOSProcess p = this.proxy.getParent();
                if (p == null) {
                    return null;
                }
                return Remote.this.get(p.getPid());
            }

            @Override
            public void kill() throws InterruptedException {
                this.proxy.kill();
            }

            @Override
            public void killRecursively() throws InterruptedException {
                this.proxy.killRecursively();
            }

            @Override
            @NonNull
            public List<String> getArguments() {
                return this.proxy.getArguments();
            }

            @Override
            @NonNull
            public EnvVars getEnvironmentVariables() {
                return this.proxy.getEnvironmentVariables();
            }

            @Override
            Object writeReplace() {
                return this;
            }

            @Override
            public <T> T act(ProcessCallable<T> callable) throws IOException, InterruptedException {
                return this.proxy.act(callable);
            }
        }
    }

    public static abstract class Local
    extends ProcessTree {
        @Deprecated
        Local() {
        }

        Local(boolean vetoesExist) {
            super(vetoesExist);
        }
    }

    private static class FreeBSD
    extends Unix {
        private static final int ENOMEM = 12;
        private static final int CTL_KERN = 1;
        private static final int KERN_ARGMAX = 8;
        private static final int KERN_PROC = 14;
        private static final int KERN_PROC_ALL = 0;
        private static final int KERN_PROC_ARGS = 7;
        private static final int KERN_PROC_ENV = 35;
        private final long sizeOf_kinfo_proc;
        private static final long sizeOf_kinfo_proc_32 = 768L;
        private static final long sizeOf_kinfo_proc_64 = 1088L;
        private final int kinfo_proc_pid_offset;
        private static final int kinfo_proc_pid_offset_32 = 40;
        private static final int kinfo_proc_pid_offset_64 = 72;
        private final int kinfo_proc_ppid_offset;
        private static final int kinfo_proc_ppid_offset_32 = 44;
        private static final int kinfo_proc_ppid_offset_64 = 76;
        private static final int sizeOfInt = Native.getNativeSize(Integer.TYPE);

        FreeBSD(boolean vetoersExist) {
            super(vetoersExist);
            String arch = System.getProperty("sun.arch.data.model");
            if ("64".equals(arch)) {
                this.sizeOf_kinfo_proc = 1088L;
                this.kinfo_proc_pid_offset = 72;
                this.kinfo_proc_ppid_offset = 76;
            } else {
                this.sizeOf_kinfo_proc = 768L;
                this.kinfo_proc_pid_offset = 40;
                this.kinfo_proc_ppid_offset = 44;
            }
            try {
                Memory m;
                NativeLongByReference size;
                block7: {
                    size = new NativeLongByReference(new NativeLong(0L));
                    int nRetry = 0;
                    do {
                        if (GNUCLibrary.LIBC.sysctl(new int[]{1, 14, 0}, 3, Pointer.NULL, size, Pointer.NULL, new NativeLong(0L)) != 0) {
                            throw new IOException("Failed to get memory requirement: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                        }
                        long len = size.getValue().longValue();
                        len += len / 10L;
                        m = new Memory(len);
                        size.setValue(new NativeLong(len));
                        if (GNUCLibrary.LIBC.sysctl(new int[]{1, 14, 0}, 3, (Pointer)m, size, Pointer.NULL, new NativeLong(0L)) == 0) break block7;
                    } while (Native.getLastError() == 12 && nRetry++ < 16);
                    throw new IOException("Failed to get kern.proc.all: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                }
                long count = size.getValue().longValue() / this.sizeOf_kinfo_proc;
                LOGGER.fine(() -> "Found " + count + " processes");
                for (long base = 0L; base < size.getValue().longValue(); base += this.sizeOf_kinfo_proc) {
                    int pid = m.getInt(base + (long)this.kinfo_proc_pid_offset);
                    int ppid = m.getInt(base + (long)this.kinfo_proc_ppid_offset);
                    this.processes.put(pid, new FreeBSDProcess(pid, ppid));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to obtain process list", e);
            }
        }

        private class FreeBSDProcess
        extends UnixProcess {
            private final int ppid;
            private EnvVars envVars;
            private List<String> arguments;

            FreeBSDProcess(int pid, int ppid) {
                super(pid);
                this.ppid = ppid;
            }

            @Override
            @CheckForNull
            public OSProcess getParent() {
                return FreeBSD.this.get(this.ppid);
            }

            @Override
            @NonNull
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                try {
                    this.envVars = new EnvVars();
                    int argmax = this.getArgmax();
                    Memory m = new Memory((long)argmax);
                    NativeLongByReference size = new NativeLongByReference(new NativeLong((long)argmax));
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 14, 35, this.pid}, 4, (Pointer)m, size, Pointer.NULL, new NativeLong(0L)) != 0) {
                        throw new IOException("Failed to get kern.proc.env: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    this.parse(m, size.getValue(), this.envVars::addLine);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.envVars;
            }

            @Override
            @NonNull
            public List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                try {
                    this.arguments = new ArrayList<String>();
                    int argmax = this.getArgmax();
                    Memory m = new Memory((long)argmax);
                    NativeLongByReference size = new NativeLongByReference(new NativeLong((long)argmax));
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 14, 7, this.pid}, 4, (Pointer)m, size, Pointer.NULL, new NativeLong(0L)) != 0) {
                        throw new IOException("Failed to get kern.proc.args: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    this.parse(m, size.getValue(), this.arguments::add);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.arguments;
            }

            private int getArgmax() throws IOException {
                IntByReference argmaxRef = new IntByReference(0);
                NativeLongByReference size = new NativeLongByReference(new NativeLong((long)sizeOfInt));
                if (GNUCLibrary.LIBC.sysctl(new int[]{1, 8}, 2, argmaxRef.getPointer(), size, Pointer.NULL, new NativeLong(0L)) != 0) {
                    throw new IOException("Failed to get kern.argmax: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                }
                return argmaxRef.getValue();
            }

            private void parse(Memory m, NativeLong size, Consumer<String> consumer) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                long offset = 0L;
                while (offset < size.longValue()) {
                    byte ch;
                    while ((ch = m.getByte(offset++)) != 0) {
                        baos.write(ch);
                    }
                    consumer.accept(baos.toString(StandardCharsets.UTF_8));
                    baos.reset();
                }
            }
        }
    }

    private static class Darwin
    extends Unix {
        private final int sizeOf_kinfo_proc;
        private static final int sizeOf_kinfo_proc_32 = 492;
        private static final int sizeOf_kinfo_proc_64 = 648;
        private final int kinfo_proc_pid_offset;
        private static final int kinfo_proc_pid_offset_32 = 24;
        private static final int kinfo_proc_pid_offset_64 = 40;
        private final int kinfo_proc_ppid_offset;
        private static final int kinfo_proc_ppid_offset_32 = 416;
        private static final int kinfo_proc_ppid_offset_64 = 560;
        private static final int sizeOfInt = Native.getNativeSize(Integer.TYPE);
        private static final int CTL_KERN = 1;
        private static final int KERN_PROC = 14;
        private static final int KERN_PROC_ALL = 0;
        private static final int ENOMEM = 12;
        private static int[] MIB_PROC_ALL = new int[]{1, 14, 0};
        private static final int KERN_ARGMAX = 8;
        private static final int KERN_PROCARGS2 = 49;

        Darwin(boolean vetoersExist) {
            super(vetoersExist);
            String arch = System.getProperty("sun.arch.data.model");
            if ("64".equals(arch)) {
                this.sizeOf_kinfo_proc = 648;
                this.kinfo_proc_pid_offset = 40;
                this.kinfo_proc_ppid_offset = 560;
            } else {
                this.sizeOf_kinfo_proc = 492;
                this.kinfo_proc_pid_offset = 24;
                this.kinfo_proc_ppid_offset = 416;
            }
            try {
                Memory m;
                NativeLongByReference size;
                block7: {
                    size = new NativeLongByReference(new NativeLong(0L));
                    int nRetry = 0;
                    do {
                        if (GNUCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, Pointer.NULL, size, Pointer.NULL, new NativeLong(0L)) != 0) {
                            throw new IOException("Failed to obtain memory requirement: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                        }
                        m = new Memory(size.getValue().longValue());
                        if (GNUCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, (Pointer)m, size, Pointer.NULL, new NativeLong(0L)) == 0) break block7;
                    } while (Native.getLastError() == 12 && nRetry++ < 16);
                    throw new IOException("Failed to call kern.proc.all: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                }
                int count = size.getValue().intValue() / this.sizeOf_kinfo_proc;
                LOGGER.fine("Found " + count + " processes");
                for (int base = 0; base < size.getValue().intValue(); base += this.sizeOf_kinfo_proc) {
                    int pid = m.getInt((long)(base + this.kinfo_proc_pid_offset));
                    int ppid = m.getInt((long)(base + this.kinfo_proc_ppid_offset));
                    this.processes.put(pid, new DarwinProcess(pid, ppid));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to obtain process list", e);
            }
        }

        private class DarwinProcess
        extends UnixProcess {
            private final int ppid;
            private EnvVars envVars;
            private List<String> arguments;

            DarwinProcess(int pid, int ppid) {
                super(pid);
                this.ppid = ppid;
            }

            @Override
            @CheckForNull
            public OSProcess getParent() {
                return Darwin.this.get(this.ppid);
            }

            @Override
            @NonNull
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.parse();
                return this.envVars;
            }

            @Override
            @NonNull
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.parse();
                return this.arguments;
            }

            private void parse() {
                try {
                    this.arguments = new ArrayList<String>();
                    this.envVars = new EnvVars();
                    IntByReference argmaxRef = new IntByReference(0);
                    NativeLongByReference size = new NativeLongByReference(new NativeLong((long)sizeOfInt));
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 8}, 2, argmaxRef.getPointer(), size, Pointer.NULL, new NativeLong(0L)) != 0) {
                        throw new IOException("Failed to get kern.argmax: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    int argmax = argmaxRef.getValue();
                    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Not needed for JNA")
                    class StringArrayMemory
                    extends Memory {
                        private long offset;
                        private long length;

                        StringArrayMemory(long l) {
                            super(l);
                            this.offset = 0L;
                            this.length = 0L;
                            this.length = l;
                        }

                        void setLength(long l) {
                            this.length = Math.min(l, this.size());
                        }

                        int readInt() {
                            if (this.offset > this.length - (long)sizeOfInt) {
                                return 0;
                            }
                            int r = this.getInt(this.offset);
                            this.offset += (long)sizeOfInt;
                            return r;
                        }

                        byte peek() {
                            if (this.offset >= this.length) {
                                return 0;
                            }
                            return this.getByte(this.offset);
                        }

                        String readString() {
                            byte ch;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            while (this.offset < this.length && (ch = this.getByte(this.offset++)) != 0) {
                                baos.write(ch);
                            }
                            return baos.toString(StandardCharsets.UTF_8);
                        }

                        void skip0() {
                            while (this.offset < this.length && this.getByte(this.offset) == 0) {
                                ++this.offset;
                            }
                        }
                    }
                    StringArrayMemory m = new StringArrayMemory(argmax);
                    m.clear();
                    size.setValue(new NativeLong((long)argmax));
                    if (GNUCLibrary.LIBC.sysctl(new int[]{1, 49, this.pid}, 3, (Pointer)m, size, Pointer.NULL, new NativeLong(0L)) != 0) {
                        throw new IOException("Failed to obtain ken.procargs2: " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    m.setLength(size.getValue().longValue());
                    int argc = m.readInt();
                    String args0 = m.readString();
                    m.skip0();
                    try {
                        for (int i = 0; i < argc; ++i) {
                            this.arguments.add(m.readString());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalStateException("Failed to parse arguments: pid=" + this.pid + ", arg0=" + args0 + ", arguments=" + this.arguments + ", nargs=" + argc + ". Please see https://www.jenkins.io/redirect/troubleshooting/darwin-failed-to-parse-arguments", e);
                    }
                    while (m.peek() != 0) {
                        this.envVars.addLine(m.readString());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static class Solaris
    extends ProcfsUnix {
        Solaris(boolean vetoersExist) {
            super(vetoersExist);
        }

        @Override
        protected OSProcess createProcess(int pid) throws IOException {
            return new SolarisProcess(pid);
        }

        private static long to64(int i) {
            return (long)i & 0xFFFFFFFFL;
        }

        private static int adjust(int i) {
            if (IS_LITTLE_ENDIAN) {
                return i << 24 | i << 8 & 0xFF0000 | i >> 8 & 0xFF00 | i >>> 24;
            }
            return i;
        }

        public static long adjustL(long i) {
            if (IS_LITTLE_ENDIAN) {
                return Long.reverseBytes(i);
            }
            return i;
        }

        private class SolarisProcess
        extends UnixProcess {
            private static final byte PR_MODEL_ILP32 = 1;
            private static final byte PR_MODEL_LP64 = 2;
            private final int LINE_LENGTH_LIMIT;
            private final boolean b64;
            private final int ppid;
            private final long envp;
            private final long argp;
            private final int argc;
            private EnvVars envVars;
            private List<String> arguments;

            private SolarisProcess(int pid) throws IOException {
                super(pid);
                this.LINE_LENGTH_LIMIT = SystemProperties.getInteger(Solaris.class.getName() + ".lineLimit", 10000);
                try (RandomAccessFile psinfo = new RandomAccessFile(this.getFile("psinfo"), "r");){
                    psinfo.seek(8L);
                    if (Solaris.adjust(psinfo.readInt()) != pid) {
                        throw new IOException("psinfo PID mismatch");
                    }
                    this.ppid = Solaris.adjust(psinfo.readInt());
                    if (Native.POINTER_SIZE == 8) {
                        psinfo.seek(236L);
                        this.argc = Solaris.adjust(psinfo.readInt());
                        this.argp = Solaris.adjustL(psinfo.readLong());
                        this.envp = Solaris.adjustL(psinfo.readLong());
                        this.b64 = psinfo.readByte() == 2;
                    } else {
                        psinfo.seek(188L);
                        this.argc = Solaris.adjust(psinfo.readInt());
                        this.argp = Solaris.to64(Solaris.adjust(psinfo.readInt()));
                        this.envp = Solaris.to64(Solaris.adjust(psinfo.readInt()));
                        this.b64 = psinfo.readByte() == 2;
                    }
                }
                if (this.ppid == -1) {
                    throw new IOException("Failed to parse PPID from /proc/" + pid + "/status");
                }
            }

            @Override
            @CheckForNull
            public OSProcess getParent() {
                return Solaris.this.get(this.ppid);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.arguments = new ArrayList<String>(this.argc);
                if (this.argc == 0) {
                    return this.arguments;
                }
                int psize = this.b64 ? 8 : 4;
                Memory m = new Memory((long)psize);
                try {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Reading " + this.getFile("as"));
                    }
                    int fd = GNUCLibrary.LIBC.open(this.getFile("as").getAbsolutePath(), 0);
                    try {
                        for (int n = 0; n < this.argc; ++n) {
                            GNUCLibrary.LIBC.pread(fd, m, new NativeLong((long)psize), new NativeLong(this.argp + (long)(n * psize)));
                            long addr = this.b64 ? m.getLong(0L) : Solaris.to64(m.getInt(0L));
                            this.arguments.add(this.readLine(fd, addr, "argv[" + n + "]"));
                        }
                    }
                    finally {
                        GNUCLibrary.LIBC.close(fd);
                    }
                }
                catch (LastErrorException | IOException throwable) {
                    // empty catch block
                }
                this.arguments = Collections.unmodifiableList(this.arguments);
                return this.arguments;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.envVars = new EnvVars();
                if (this.envp == 0L) {
                    return this.envVars;
                }
                int psize = this.b64 ? 8 : 4;
                Memory m = new Memory((long)psize);
                try {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Reading " + this.getFile("as"));
                    }
                    int fd = GNUCLibrary.LIBC.open(this.getFile("as").getAbsolutePath(), 0);
                    try {
                        int n = 0;
                        while (true) {
                            long addr;
                            GNUCLibrary.LIBC.pread(fd, m, new NativeLong((long)psize), new NativeLong(this.envp + (long)(n * psize)));
                            long l = addr = this.b64 ? m.getLong(0L) : Solaris.to64(m.getInt(0L));
                            if (addr == 0L) {
                                break;
                            }
                            this.envVars.addLine(this.readLine(fd, addr, "env[" + n + "]"));
                            ++n;
                        }
                    }
                    finally {
                        GNUCLibrary.LIBC.close(fd);
                    }
                }
                catch (LastErrorException | IOException throwable) {
                    // empty catch block
                }
                return this.envVars;
            }

            private String readLine(int fd, long addr, String prefix) throws IOException {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Reading " + prefix + " at " + addr);
                }
                Memory m = new Memory(1L);
                byte ch = 1;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int i = 0;
                while (true) {
                    if (i++ > this.LINE_LENGTH_LIMIT) {
                        LOGGER.finest("could not find end of line, giving up");
                        throw new IOException("could not find end of line, giving up");
                    }
                    GNUCLibrary.LIBC.pread(fd, m, new NativeLong(1L), new NativeLong(addr));
                    ch = m.getByte(0L);
                    if (ch == 0) break;
                    buf.write(ch);
                    ++addr;
                }
                String line = buf.toString(StandardCharsets.UTF_8);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(prefix + " was " + line);
                }
                return line;
            }
        }
    }

    static class AIX
    extends ProcfsUnix {
        AIX(boolean vetoersExist) {
            super(vetoersExist);
        }

        @Override
        protected OSProcess createProcess(int pid) throws IOException {
            return new AIXProcess(pid);
        }

        private static long to64(int i) {
            return (long)i & 0xFFFFFFFFL;
        }

        private static int adjust(int i) {
            if (IS_LITTLE_ENDIAN) {
                return i << 24 | i << 8 & 0xFF0000 | i >> 8 & 0xFF00 | i >>> 24;
            }
            return i;
        }

        public static long adjustL(long i) {
            if (IS_LITTLE_ENDIAN) {
                return Long.reverseBytes(i);
            }
            return i;
        }

        private class AIXProcess
        extends UnixProcess {
            private static final byte PR_MODEL_ILP32 = 0;
            private static final byte PR_MODEL_LP64 = 1;
            private final int LINE_LENGTH_LIMIT;
            private final boolean b64;
            private final int ppid;
            private final long pr_envp;
            private final long pr_argp;
            private final int argc;
            private EnvVars envVars;
            private List<String> arguments;

            private AIXProcess(int pid) throws IOException {
                super(pid);
                this.LINE_LENGTH_LIMIT = SystemProperties.getInteger(AIX.class.getName() + ".lineLimit", 10000);
                try (RandomAccessFile pstatus = new RandomAccessFile(this.getFile("status"), "r");){
                    pstatus.seek(17L);
                    byte pr_dmodel = pstatus.readByte();
                    if (pr_dmodel == 0) {
                        this.b64 = false;
                    } else if (pr_dmodel == 1) {
                        this.b64 = true;
                    } else {
                        throw new IOException("Unrecognized data model value");
                    }
                    pstatus.seek(88L);
                    if (AIX.adjust((int)pstatus.readLong()) != pid) {
                        throw new IOException("pstatus PID mismatch");
                    }
                    this.ppid = AIX.adjust((int)pstatus.readLong());
                }
                try (RandomAccessFile psinfo = new RandomAccessFile(this.getFile("psinfo"), "r");){
                    psinfo.seek(48L);
                    if (AIX.adjust((int)psinfo.readLong()) != pid) {
                        throw new IOException("psinfo PID mismatch");
                    }
                    if (AIX.adjust((int)psinfo.readLong()) != this.ppid) {
                        throw new IOException("psinfo PPID mismatch");
                    }
                    psinfo.seek(148L);
                    this.argc = AIX.adjust(psinfo.readInt());
                    this.pr_argp = AIX.adjustL(psinfo.readLong());
                    this.pr_envp = AIX.adjustL(psinfo.readLong());
                }
            }

            @Override
            @CheckForNull
            public OSProcess getParent() {
                return AIX.this.get(this.ppid);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @NonNull
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.arguments = new ArrayList<String>(this.argc);
                if (this.argc == 0) {
                    return this.arguments;
                }
                try {
                    int psize = this.b64 ? 8 : 4;
                    Memory m = new Memory((long)psize);
                    int fd = GNUCLibrary.LIBC.open(this.getFile("as").getAbsolutePath(), 0);
                    try {
                        long argp;
                        GNUCLibrary.LIBC.pread(fd, m, new NativeLong((long)psize), new NativeLong(this.pr_argp));
                        long l = argp = this.b64 ? m.getLong(0L) : AIX.to64(m.getInt(0L));
                        if (argp == 0L) {
                            List<String> list = this.arguments;
                            return list;
                        }
                        int n = 0;
                        while (true) {
                            long addr;
                            GNUCLibrary.LIBC.pread(fd, m, new NativeLong((long)psize), new NativeLong(argp + (long)(n * psize)));
                            long l2 = addr = this.b64 ? m.getLong(0L) : AIX.to64(m.getInt(0L));
                            if (addr != 0L) {
                                this.arguments.add(this.readLine(fd, addr, "arg[" + n + "]"));
                                ++n;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        GNUCLibrary.LIBC.close(fd);
                    }
                }
                catch (LastErrorException | IOException throwable) {
                    // empty catch block
                }
                this.arguments = Collections.unmodifiableList(this.arguments);
                return this.arguments;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @NonNull
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.envVars = new EnvVars();
                if (this.pr_envp == 0L) {
                    return this.envVars;
                }
                try {
                    int psize = this.b64 ? 8 : 4;
                    Memory m = new Memory((long)psize);
                    int fd = GNUCLibrary.LIBC.open(this.getFile("as").getAbsolutePath(), 0);
                    try {
                        long envp;
                        GNUCLibrary.LIBC.pread(fd, m, new NativeLong((long)psize), new NativeLong(this.pr_envp));
                        long l = envp = this.b64 ? m.getLong(0L) : AIX.to64(m.getInt(0L));
                        if (envp == 0L) {
                            EnvVars envVars = this.envVars;
                            return envVars;
                        }
                        int n = 0;
                        while (true) {
                            long addr;
                            GNUCLibrary.LIBC.pread(fd, m, new NativeLong((long)psize), new NativeLong(envp + (long)(n * psize)));
                            long l2 = addr = this.b64 ? m.getLong(0L) : AIX.to64(m.getInt(0L));
                            if (addr == 0L) {
                                return this.envVars;
                            }
                            this.envVars.addLine(this.readLine(fd, addr, "env[" + n + "]"));
                            ++n;
                        }
                    }
                    finally {
                        GNUCLibrary.LIBC.close(fd);
                    }
                }
                catch (LastErrorException | IOException throwable) {
                    // empty catch block
                }
                return this.envVars;
            }

            private String readLine(int fd, long addr, String prefix) throws IOException {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Reading " + prefix + " at " + addr);
                }
                Memory m = new Memory(1L);
                byte ch = 1;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int i = 0;
                while (true) {
                    if (i++ > this.LINE_LENGTH_LIMIT) {
                        LOGGER.finest("could not find end of line, giving up");
                        throw new IOException("could not find end of line, giving up");
                    }
                    long r = GNUCLibrary.LIBC.pread(fd, m, new NativeLong(1L), new NativeLong(addr));
                    ch = m.getByte(0L);
                    if (ch == 0) break;
                    buf.write(ch);
                    ++addr;
                }
                String line = buf.toString(StandardCharsets.UTF_8);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(prefix + " was " + line);
                }
                return line;
            }
        }
    }

    static class Linux
    extends ProcfsUnix {
        Linux(boolean vetoersExist) {
            super(vetoersExist);
        }

        @Override
        protected LinuxProcess createProcess(int pid) throws IOException {
            return new LinuxProcess(pid);
        }

        public byte[] readFileToByteArray(File file) throws IOException {
            try (FileInputStream in = FileUtils.openInputStream((File)file);){
                byte[] byArray = IOUtils.toByteArray((InputStream)in);
                return byArray;
            }
        }

        class LinuxProcess
        extends UnixProcess {
            private int ppid;
            private EnvVars envVars;
            private List<String> arguments;

            LinuxProcess(int pid) throws IOException {
                super(pid);
                this.ppid = -1;
                try (BufferedReader r = Files.newBufferedReader(Util.fileToPath(this.getFile("status")), StandardCharsets.UTF_8);){
                    String line;
                    while ((line = r.readLine()) != null) {
                        if (!(line = line.toLowerCase(Locale.ENGLISH)).startsWith("ppid:")) continue;
                        this.ppid = Integer.parseInt(line.substring(5).trim());
                        break;
                    }
                }
                if (this.ppid == -1) {
                    throw new IOException("Failed to parse PPID from /proc/" + pid + "/status");
                }
            }

            @Override
            @CheckForNull
            public OSProcess getParent() {
                return Linux.this.get(this.ppid);
            }

            @Override
            @NonNull
            public synchronized List<String> getArguments() {
                if (this.arguments != null) {
                    return this.arguments;
                }
                this.arguments = new ArrayList<String>();
                try {
                    byte[] cmdline = Linux.this.readFileToByteArray(this.getFile("cmdline"));
                    int pos = 0;
                    for (int i = 0; i < cmdline.length; ++i) {
                        byte b = cmdline[i];
                        if (b != 0) continue;
                        this.arguments.add(new String(cmdline, pos, i - pos, StandardCharsets.UTF_8));
                        pos = i + 1;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.arguments = Collections.unmodifiableList(this.arguments);
                return this.arguments;
            }

            @Override
            @NonNull
            public synchronized EnvVars getEnvironmentVariables() {
                if (this.envVars != null) {
                    return this.envVars;
                }
                this.envVars = new EnvVars();
                try {
                    byte[] environ = Linux.this.readFileToByteArray(this.getFile("environ"));
                    int pos = 0;
                    for (int i = 0; i < environ.length; ++i) {
                        byte b = environ[i];
                        if (b != 0) continue;
                        this.envVars.addLine(new String(environ, pos, i - pos, StandardCharsets.UTF_8));
                        pos = i + 1;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.envVars;
            }
        }
    }

    public abstract class UnixProcess
    extends OSProcess {
        protected UnixProcess(int pid) {
            super(pid);
        }

        protected final File getFile(String relativePath) {
            return new File(new File("/proc/" + this.getPid()), relativePath);
        }

        @Override
        public void kill() throws InterruptedException {
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(ProcessTree.this.softKillWaitSeconds);
            this.kill(deadline);
        }

        private void kill(long deadline) throws InterruptedException {
            if (this.getVeto() != null) {
                return;
            }
            int pid = this.getPid();
            LOGGER.fine("Killing pid=" + pid);
            ProcessHandle.of(pid).ifPresent(ProcessHandle::destroy);
            int sleepTime = 10;
            File status = this.getFile("status");
            while (status.exists()) {
                Thread.sleep(sleepTime);
                sleepTime = Math.min(sleepTime * 2, 1000);
                if (System.nanoTime() < deadline) continue;
            }
            this.killByKiller();
        }

        @Override
        public void killRecursively() throws InterruptedException {
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(ProcessTree.this.softKillWaitSeconds);
            this.killRecursively(deadline);
        }

        private void killRecursively(long deadline) throws InterruptedException {
            LOGGER.fine("Recursively killing pid=" + this.getPid());
            for (OSProcess p : this.getChildren()) {
                if (p instanceof UnixProcess) {
                    ((UnixProcess)p).killRecursively(deadline);
                    continue;
                }
                p.killRecursively();
            }
            this.kill(deadline);
        }

        @Override
        @NonNull
        public abstract List<String> getArguments();
    }

    static abstract class ProcfsUnix
    extends Unix {
        ProcfsUnix(boolean vetoersExist) {
            super(vetoersExist);
            File[] processes = new File("/proc").listFiles(File::isDirectory);
            if (processes == null) {
                LOGGER.info("No /proc");
                return;
            }
            for (File p : processes) {
                int pid;
                try {
                    pid = Integer.parseInt(p.getName());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                try {
                    this.processes.put(pid, this.createProcess(pid));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected abstract OSProcess createProcess(int var1) throws IOException;
    }

    static abstract class Unix
    extends Local {
        Unix(boolean vetoersExist) {
            super(vetoersExist);
        }

        @Override
        @CheckForNull
        public OSProcess get(@NonNull Process proc) {
            return this.get(Ints.checkedCast((long)proc.pid()));
        }

        @Override
        public void killAll(@NonNull Map<String, String> modelEnvVars) throws InterruptedException {
            for (OSProcess p : this) {
                if (!p.hasMatchingEnvVars(modelEnvVars)) continue;
                p.killRecursively();
            }
        }
    }

    private static final class Windows
    extends Local {
        Windows(boolean vetoesExist) {
            super(vetoesExist);
            for (WinProcess p : WinProcess.all()) {
                int pid = p.getPid();
                if (pid == 0 || pid == 4) continue;
                this.processes.put(pid, new WindowsOSProcess(p));
            }
        }

        @Override
        @CheckForNull
        public OSProcess get(@NonNull Process proc) {
            return this.get(new WinProcess(proc).getPid());
        }

        @Override
        public void killAll(@NonNull Map<String, String> modelEnvVars) throws InterruptedException {
            for (OSProcess p : this) {
                boolean matched;
                if (p.getPid() < 10) continue;
                LOGGER.log(Level.FINEST, "Considering to kill {0}", p.getPid());
                try {
                    matched = Windows.hasMatchingEnvVars(p, modelEnvVars);
                }
                catch (WindowsOSProcessException e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.log(Level.FINEST, "Failed to check environment variable match for process with pid=" + p.getPid(), e);
                    continue;
                }
                if (matched) {
                    p.killRecursively();
                    continue;
                }
                LOGGER.log(Level.FINEST, "Environment variable didn't match for process with pid={0}", p.getPid());
            }
        }

        private static boolean hasMatchingEnvVars(@NonNull OSProcess p, @NonNull Map<String, String> modelEnvVars) throws WindowsOSProcessException {
            if (p instanceof WindowsOSProcess) {
                return ((WindowsOSProcess)p).hasMatchingEnvVars2(modelEnvVars);
            }
            try {
                return p.hasMatchingEnvVars(modelEnvVars);
            }
            catch (WinpException e) {
                throw new WindowsOSProcessException(e);
            }
        }

        static {
            WinProcess.enableDebugPrivilege();
        }
    }

    private static class WindowsOSProcessException
    extends Exception {
        WindowsOSProcessException(WinpException ex) {
            super(ex);
        }

        WindowsOSProcessException(String message, WinpException ex) {
            super(message, ex);
        }
    }

    private class WindowsOSProcess
    extends OSProcess {
        private final WinProcess p;
        private EnvVars env;
        private List<String> args;

        WindowsOSProcess(WinProcess p) {
            super(p.getPid());
            this.p = p;
        }

        @Override
        @CheckForNull
        public OSProcess getParent() {
            return null;
        }

        @Override
        public void killRecursively() throws InterruptedException {
            if (this.getVeto() != null) {
                return;
            }
            LOGGER.log(Level.FINER, "Killing recursively {0}", this.getPid());
            this.killSoftly();
            this.p.killRecursively();
            this.killByKiller();
        }

        @Override
        public void kill() throws InterruptedException {
            if (this.getVeto() != null) {
                return;
            }
            LOGGER.log(Level.FINER, "Killing {0}", this.getPid());
            this.killSoftly();
            this.p.kill();
            this.killByKiller();
        }

        private void killSoftly() throws InterruptedException {
            try {
                if (!this.p.sendCtrlC()) {
                    return;
                }
            }
            catch (WinpException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Failed to send CTRL+C to pid=" + this.getPid(), e);
                }
                return;
            }
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(ProcessTree.this.softKillWaitSeconds);
            int sleepTime = 10;
            while (this.p.isRunning()) {
                Thread.sleep(sleepTime);
                sleepTime = Math.min(sleepTime * 2, 1000);
                if (System.nanoTime() < deadline) continue;
            }
        }

        @Override
        @NonNull
        public synchronized List<String> getArguments() {
            if (this.args == null) {
                this.args = Arrays.asList(QuotedStringTokenizer.tokenize((String)this.p.getCommandLine()));
            }
            return this.args;
        }

        @Override
        @NonNull
        public synchronized EnvVars getEnvironmentVariables() {
            try {
                return this.getEnvironmentVariables2();
            }
            catch (WindowsOSProcessException e) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Failed to get the environment variables of process with pid=" + this.p.getPid(), e);
                }
                return this.env;
            }
        }

        private synchronized EnvVars getEnvironmentVariables2() throws WindowsOSProcessException {
            if (this.env != null) {
                return this.env;
            }
            this.env = new EnvVars();
            try {
                this.env.putAll(this.p.getEnvironmentVariables());
            }
            catch (WinpException e) {
                throw new WindowsOSProcessException("Failed to get the environment variables", e);
            }
            return this.env;
        }

        private boolean hasMatchingEnvVars2(Map<String, String> modelEnvVar) throws WindowsOSProcessException {
            if (modelEnvVar.isEmpty()) {
                return false;
            }
            EnvVars envs = this.getEnvironmentVariables2();
            for (Map.Entry<String, String> e : modelEnvVar.entrySet()) {
                String v = (String)envs.get(e.getKey());
                if (v != null && v.equals(e.getValue())) continue;
                return false;
            }
            return true;
        }
    }

    private static class DoVetoersExist
    extends SlaveToMasterCallable<Boolean, IOException> {
        private DoVetoersExist() {
        }

        public Boolean call() throws IOException {
            return ProcessKillingVeto.all().size() > 0;
        }
    }

    public static interface ProcessCallable<T>
    extends Serializable {
        public T invoke(OSProcess var1, VirtualChannel var2) throws IOException;
    }

    @SuppressFBWarnings(value={"SE_INNER_CLASS"}, justification="Serializing the outer instance is intended")
    private final class SerializedProcess
    implements Serializable {
        private final int pid;
        private static final long serialVersionUID = 1L;

        private SerializedProcess(int pid) {
            this.pid = pid;
        }

        Object readResolve() {
            return ProcessTree.this.get(this.pid);
        }
    }

    public abstract class OSProcess
    implements ProcessTreeRemoting.IOSProcess,
    Serializable {
        final int pid;

        private OSProcess(int pid) {
            this.pid = pid;
        }

        @Override
        public final int getPid() {
            return this.pid;
        }

        @Override
        @CheckForNull
        public abstract OSProcess getParent();

        final ProcessTree getTree() {
            return ProcessTree.this;
        }

        @NonNull
        public final List<OSProcess> getChildren() {
            ArrayList<OSProcess> r = new ArrayList<OSProcess>();
            for (OSProcess p : ProcessTree.this) {
                if (p.getParent() != this) continue;
                r.add(p);
            }
            return r;
        }

        @Override
        public abstract void kill() throws InterruptedException;

        void killByKiller() throws InterruptedException {
            for (ProcessKiller killer : ProcessTree.this.getKillers()) {
                try {
                    if (!killer.kill(this)) continue;
                    break;
                }
                catch (IOException | Error e) {
                    LOGGER.log(Level.WARNING, "Failed to kill pid=" + this.getPid(), e);
                }
            }
        }

        @Override
        public abstract void killRecursively() throws InterruptedException;

        @CheckForNull
        protected ProcessKillingVeto.VetoCause getVeto() {
            String causeMessage = null;
            if (!ProcessTree.this.skipVetoes) {
                try {
                    VirtualChannel channelToController = AgentComputerUtil.getChannelToController();
                    if (channelToController != null) {
                        CheckVetoes vetoCheck = new CheckVetoes(this);
                        causeMessage = (String)channelToController.call((Callable)vetoCheck);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "I/O Exception while checking for vetoes", e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Interrupted Exception while checking for vetoes", e);
                }
            }
            if (causeMessage != null) {
                return new ProcessKillingVeto.VetoCause(causeMessage);
            }
            return null;
        }

        @Override
        @NonNull
        public abstract List<String> getArguments();

        @Override
        @NonNull
        public abstract EnvVars getEnvironmentVariables();

        public final boolean hasMatchingEnvVars(Map<String, String> modelEnvVar) {
            if (modelEnvVar.isEmpty()) {
                return false;
            }
            EnvVars envs = this.getEnvironmentVariables();
            for (Map.Entry<String, String> e : modelEnvVar.entrySet()) {
                String v = (String)envs.get(e.getKey());
                if (v != null && v.equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        @Override
        public <T> T act(ProcessCallable<T> callable) throws IOException, InterruptedException {
            return callable.invoke(this, (VirtualChannel)FilePath.localChannel);
        }

        Object writeReplace() {
            return new SerializedProcess(this.pid);
        }

        private class CheckVetoes
        extends SlaveToMasterCallable<String, IOException> {
            private ProcessTreeRemoting.IOSProcess process;

            CheckVetoes(ProcessTreeRemoting.IOSProcess processToCheck) {
                this.process = processToCheck;
            }

            public String call() throws IOException {
                for (ProcessKillingVeto vetoExtension : ProcessKillingVeto.all()) {
                    ProcessKillingVeto.VetoCause cause = vetoExtension.vetoProcessKilling(this.process);
                    if (cause == null) continue;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.info("Killing of pid " + OSProcess.this.getPid() + " vetoed by " + vetoExtension.getClass().getName() + ": " + cause.getMessage());
                    }
                    return cause.getMessage();
                }
                return null;
            }
        }
    }

    private static class ListAll
    extends SlaveToMasterCallable<List<ProcessKiller>, IOException> {
        private ListAll() {
        }

        public List<ProcessKiller> call() throws IOException {
            return new ArrayList<ProcessKiller>(ProcessKiller.all());
        }
    }
}

