/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.security.ResourceDomainConfiguration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ResourceDomainFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(ResourceDomainFilter.class.getName());
    private static final Set<String> ALLOWED_PATHS = new HashSet<String>(Arrays.asList("/static-files", "/favicon.ico", "/favicon.svg", "/robots.txt"));
    public static final String ERROR_RESPONSE = "Jenkins serves only static files on this domain.";

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void init() throws ServletException {
        PluginServletFilter.addFilter(new ResourceDomainFilter());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            if (ResourceDomainConfiguration.isResourceRequest(httpServletRequest)) {
                String path = httpServletRequest.getPathInfo();
                if (!path.startsWith("/static-files/") && !ALLOWED_PATHS.contains(path)) {
                    LOGGER.fine(() -> "Rejecting request to " + httpServletRequest.getRequestURL() + " from " + httpServletRequest.getRemoteAddr() + " on resource domain");
                    httpServletResponse.sendError(404, ERROR_RESPONSE);
                    return;
                }
                LOGGER.finer(() -> "Accepting request to " + httpServletRequest.getRequestURL() + " from " + httpServletRequest.getRemoteAddr() + " on resource domain");
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

