/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import org.kohsuke.args4j.Argument;

@Extension
public class DeleteCredentialsDomainCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store Id", required=true)
    public CredentialsStore store;
    @Argument(metaVar="DOMAIN", usage="Domain Name", required=true, index=1)
    public String domain;

    public String getShortDescription() {
        return Messages.DeleteCredentialsDomainCommand_ShortDescription();
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Domain domain = DeleteCredentialsDomainCommand.getDomainByName(this.store, this.domain);
        if (domain == null) {
            this.stderr.println("No such domain");
            return 2;
        }
        if (this.store.removeDomain(domain)) {
            return 0;
        }
        this.stderr.println("Not deleted");
        return 1;
    }
}

