/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.fingerprints;

import com.cloudbees.plugins.credentials.fingerprints.AbstractCredentialsFingerprintFacet;
import com.cloudbees.plugins.credentials.fingerprints.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Fingerprint;
import hudson.model.Item;
import jenkins.model.Jenkins;

public class ItemCredentialsFingerprintFacet
extends AbstractCredentialsFingerprintFacet {
    @NonNull
    private final String itemFullName;
    private final long timestamp0;

    public ItemCredentialsFingerprintFacet(@NonNull Item item, @NonNull Fingerprint fingerprint, long timestamp) {
        this(item, fingerprint, timestamp, timestamp);
    }

    public ItemCredentialsFingerprintFacet(@NonNull Item item, @NonNull Fingerprint fingerprint, long timestamp0, long timestamp) {
        super(fingerprint, Math.max(timestamp, timestamp0));
        this.itemFullName = item.getFullName();
        this.timestamp0 = Math.min(timestamp, timestamp0);
    }

    @NonNull
    public String getItemFullName() {
        return this.itemFullName;
    }

    @CheckForNull
    public Item getItem() {
        return Jenkins.get().getItemByFullName(this.itemFullName);
    }

    public long getTimestamp0() {
        return this.timestamp0;
    }

    public String getTimestampString() {
        long now = System.currentTimeMillis();
        return this.timestamp0 == this.getTimestamp() ? Messages.AbstractCredentialsFingerprintFacet_timestampSingle(Util.getTimeSpanString((long)(now - this.getTimestamp()))) : Messages.AbstractCredentialsFingerprintFacet_timestampRange(Util.getTimeSpanString((long)(now - this.timestamp0)), Util.getTimeSpanString((long)(now - this.getTimestamp())));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItemCredentialsFingerprintFacet node = (ItemCredentialsFingerprintFacet)((Object)o);
        if (this.getTimestamp0() != node.getTimestamp0()) {
            return false;
        }
        return this.getItemFullName().equals(node.getItemFullName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getItemFullName().hashCode();
        result = 31 * result + (int)(this.getTimestamp0() ^ this.getTimestamp0() >>> 32);
        return result;
    }
}

