/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TransientUserActionFactory;
import hudson.model.UserIdMapper;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.tasks.UserAvatarResolver;
import hudson.util.FormValidation;
import hudson.util.RunList;
import hudson.util.XStream2;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.model.Loadable;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.scm.RunWithSCM;
import jenkins.security.ImpersonatingUserDetailsService2;
import jenkins.security.UserDetailsCache;
import jenkins.util.SystemProperties;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@ExportedBean
@BridgeMethodsAdded
public class User
extends AbstractModelObject
implements AccessControlled,
DescriptorByNameOwner,
Loadable,
Saveable,
Comparable<User>,
ModelObjectWithContextMenu,
StaplerProxy {
    public static final XStream2 XSTREAM = new XStream2();
    private static final Logger LOGGER = Logger.getLogger(User.class.getName());
    static final String CONFIG_XML = "config.xml";
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(User.class.getName() + ".skipPermissionCheck");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean ALLOW_NON_EXISTENT_USER_TO_LOGIN = SystemProperties.getBoolean(User.class.getName() + ".allowNonExistentUserToLogin");
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean ALLOW_USER_CREATION_VIA_URL = SystemProperties.getBoolean(User.class.getName() + ".allowUserCreationViaUrl");
    private static final String UNKNOWN_USERNAME = "unknown";
    private static final String[] ILLEGAL_PERSISTED_USERNAMES = new String[]{"anonymous", "SYSTEM", "unknown"};
    private final int version = 10;
    private String id;
    private volatile String fullName;
    private volatile String description;
    private volatile List<UserProperty> properties = new ArrayList<UserProperty>();

    private User(String id, String fullName) {
        this.id = id;
        this.fullName = fullName;
        this.load(id);
    }

    @Override
    public void load() {
        this.load(this.id);
    }

    private void load(String userId) {
        this.clearExistingProperties();
        this.loadFromUserConfigFile(userId);
        this.removeNullsThatFailedToLoad();
        this.allocateDefaultPropertyInstancesAsNeeded();
        this.setUserToProperties();
    }

    private void setUserToProperties() {
        for (UserProperty p : this.properties) {
            p.setUser(this);
        }
    }

    private void allocateDefaultPropertyInstancesAsNeeded() {
        for (UserPropertyDescriptor d : UserProperty.all()) {
            UserProperty up;
            if (this.getProperty(d.clazz) != null || (up = d.newInstance(this)) == null) continue;
            this.properties.add(up);
        }
    }

    private void removeNullsThatFailedToLoad() {
        this.properties.removeIf(Objects::isNull);
    }

    private void loadFromUserConfigFile(String userId) {
        XmlFile config = this.getConfigFile();
        try {
            if (config != null && config.exists()) {
                config.unmarshal(this);
                this.id = userId;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to load " + config, e);
        }
    }

    private void clearExistingProperties() {
        this.properties.clear();
    }

    private XmlFile getConfigFile() {
        File existingUserFolder = this.getExistingUserFolder();
        return existingUserFolder == null ? null : new XmlFile(XSTREAM, new File(existingUserFolder, CONFIG_XML));
    }

    @NonNull
    public static IdStrategy idStrategy() {
        Jenkins j = Jenkins.get();
        SecurityRealm realm = j.getSecurityRealm();
        if (realm == null) {
            return IdStrategy.CASE_INSENSITIVE;
        }
        return realm.getUserIdStrategy();
    }

    @Override
    public int compareTo(@NonNull User that) {
        return User.idStrategy().compare(this.id, that.id);
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getUrl() {
        return "user/" + Util.rawEncode(User.idStrategy().keyFor(this.id));
    }

    @Override
    @NonNull
    public String getSearchUrl() {
        return "/user/" + Util.rawEncode(User.idStrategy().keyFor(this.id));
    }

    @Override
    public String getSearchIcon() {
        return UserAvatarResolver.resolve(this, "48x48");
    }

    @Exported(visibility=999)
    @NonNull
    public String getAbsoluteUrl() {
        return Jenkins.get().getRootUrl() + this.getUrl();
    }

    @Exported(visibility=999)
    @NonNull
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        if (Util.fixEmptyAndTrim(name) == null) {
            name = this.id;
        }
        this.fullName = name;
    }

    @Exported
    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<Descriptor<UserProperty>, UserProperty> getProperties() {
        return Descriptor.toMap(this.properties);
    }

    public synchronized void addProperty(@NonNull UserProperty p) throws IOException {
        Object old = this.getProperty(p.getClass());
        ArrayList<UserProperty> ps = new ArrayList<UserProperty>(this.properties);
        if (old != null) {
            ps.remove(old);
        }
        ps.add(p);
        p.setUser(this);
        this.properties = ps;
        this.save();
    }

    public synchronized void addProperties(@NonNull List<UserProperty> multipleProperties) throws IOException {
        ArrayList<UserProperty> newProperties = new ArrayList<UserProperty>(this.properties);
        for (UserProperty property : multipleProperties) {
            Object oldProp = this.getProperty(property.getClass());
            if (oldProp != null) {
                newProperties.remove(oldProp);
            }
            newProperties.add(property);
            property.setUser(this);
        }
        this.properties = newProperties;
        this.save();
    }

    @Exported(name="property", inline=true)
    public List<UserProperty> getAllProperties() {
        if (this.hasPermission(Jenkins.ADMINISTER)) {
            return Collections.unmodifiableList(this.properties);
        }
        return Collections.emptyList();
    }

    public <T extends UserProperty> T getProperty(Class<T> clazz) {
        for (UserProperty p : this.properties) {
            if (!clazz.isInstance(p)) continue;
            return (T)((UserProperty)clazz.cast(p));
        }
        return null;
    }

    @NonNull
    public org.springframework.security.core.Authentication impersonate2() throws org.springframework.security.core.userdetails.UsernameNotFoundException {
        return this.impersonate(this.getUserDetailsForImpersonation2());
    }

    @Deprecated
    @NonNull
    public Authentication impersonate() throws UsernameNotFoundException {
        try {
            return Authentication.fromSpring(this.impersonate2());
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    @NonNull
    public UserDetails getUserDetailsForImpersonation2() throws org.springframework.security.core.userdetails.UsernameNotFoundException {
        ImpersonatingUserDetailsService2 userDetailsService = new ImpersonatingUserDetailsService2(Jenkins.get().getSecurityRealm().getSecurityComponents().userDetails2);
        try {
            UserDetails userDetails = userDetailsService.loadUserByUsername(this.id);
            LOGGER.log(Level.FINE, "Impersonation of the user {0} was a success", this.id);
            return userDetails;
        }
        catch (UserMayOrMayNotExistException2 e) {
            LOGGER.log(Level.FINE, "The user {0} may or may not exist in the SecurityRealm, so we provide minimum access", this.id);
        }
        catch (org.springframework.security.core.userdetails.UsernameNotFoundException e) {
            if (ALLOW_NON_EXISTENT_USER_TO_LOGIN) {
                LOGGER.log(Level.FINE, "The user {0} was not found in the SecurityRealm but we are required to let it pass, due to ALLOW_NON_EXISTENT_USER_TO_LOGIN", this.id);
            }
            LOGGER.log(Level.FINE, "The user {0} was not found in the SecurityRealm", this.id);
            throw e;
        }
        return new LegitimateButUnknownUserDetails(this.id);
    }

    @Deprecated
    @NonNull
    public org.acegisecurity.userdetails.UserDetails getUserDetailsForImpersonation() throws UsernameNotFoundException {
        try {
            return org.acegisecurity.userdetails.UserDetails.fromSpring(this.getUserDetailsForImpersonation2());
        }
        catch (AuthenticationException x) {
            throw org.acegisecurity.AuthenticationException.fromSpring(x);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public org.springframework.security.core.Authentication impersonate(@NonNull UserDetails userDetails) {
        return new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), (Object)"", userDetails.getAuthorities());
    }

    @RequirePOST
    public void doSubmitDescription(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.checkPermission(Jenkins.ADMINISTER);
        this.description = req.getParameter("description");
        this.save();
        rsp.sendRedirect(".");
    }

    @NonNull
    public static User getUnknown() {
        return User.getById(UNKNOWN_USERNAME, true);
    }

    @Deprecated
    @Nullable
    public static User get(String idOrFullName, boolean create) {
        return User.get(idOrFullName, create, Collections.emptyMap());
    }

    @Nullable
    public static User get(String idOrFullName, boolean create, @NonNull Map context) {
        if (idOrFullName == null) {
            return null;
        }
        User user = AllUsers.get(idOrFullName);
        if (user != null) {
            return user;
        }
        String id = CanonicalIdResolver.resolve(idOrFullName, context);
        return User.getOrCreateById(id, idOrFullName, create);
    }

    @Nullable
    private static User getOrCreateById(@NonNull String id, @NonNull String fullName, boolean create) {
        User u = AllUsers.get(id);
        if (u == null && (create || UserIdMapper.getInstance().isMapped(id))) {
            u = new User(id, fullName);
            AllUsers.put(id, u);
            if (!id.equals(fullName) && !UserIdMapper.getInstance().isMapped(id)) {
                try {
                    u.save();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "Failed to save user configuration for " + id, x);
                }
            }
        }
        return u;
    }

    @Deprecated
    @NonNull
    public static User get(String idOrFullName) {
        return User.getOrCreateByIdOrFullName(idOrFullName);
    }

    @NonNull
    public static User getOrCreateByIdOrFullName(@NonNull String idOrFullName) {
        return User.get(idOrFullName, true, Collections.emptyMap());
    }

    @CheckForNull
    public static User current() {
        return User.get2(Jenkins.getAuthentication2());
    }

    @CheckForNull
    public static User get2(@CheckForNull org.springframework.security.core.Authentication a) {
        if (a == null || a instanceof AnonymousAuthenticationToken) {
            return null;
        }
        return User.getById(a.getName(), true);
    }

    @Deprecated
    @CheckForNull
    public static User get(@CheckForNull Authentication a) {
        return User.get2(a != null ? a.toSpring() : null);
    }

    @Nullable
    public static User getById(String id, boolean create) {
        return User.getOrCreateById(id, id, create);
    }

    @NonNull
    public static Collection<User> getAll() {
        IdStrategy strategy = User.idStrategy();
        ArrayList<User> users = new ArrayList<User>(AllUsers.values());
        users.sort((o1, o2) -> strategy.compare(o1.getId(), o2.getId()));
        return users;
    }

    @Restricted(value={Beta.class})
    public static void reload() throws IOException {
        UserIdMapper.getInstance().reload();
        AllUsers.reload();
    }

    public static void rekey() {
        try {
            User.reload();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to perform rekey operation.", e);
        }
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return this.getFullName();
    }

    private boolean relatedTo(@NonNull Run<?, ?> b) {
        if (b instanceof RunWithSCM && ((RunWithSCM)((Object)b)).hasParticipant(this)) {
            return true;
        }
        for (Cause cause : b.getCauses()) {
            String userId;
            if (!(cause instanceof Cause.UserIdCause) || (userId = ((Cause.UserIdCause)cause).getUserId()) == null || !User.idStrategy().equals(userId, this.getId())) continue;
            return true;
        }
        return false;
    }

    @WithBridgeMethods(value={List.class})
    @NonNull
    public RunList getBuilds() {
        return RunList.fromJobs(Jenkins.get().allItems(Job.class)).filter(this::relatedTo);
    }

    @NonNull
    public Set<AbstractProject<?, ?>> getProjects() {
        HashSet r = new HashSet();
        for (AbstractProject p2 : Jenkins.get().allItems(AbstractProject.class, p -> p.hasParticipant(this))) {
            r.add(p2);
        }
        return r;
    }

    public String toString() {
        return this.id;
    }

    @Deprecated
    public static void clear() {
        if (ExtensionList.lookup(AllUsers.class).isEmpty()) {
            return;
        }
        UserIdMapper.getInstance().clear();
        AllUsers.clear();
    }

    private static File getConfigFileFor(String id) {
        return new File(User.getUserFolderFor(id), CONFIG_XML);
    }

    private static File getUserFolderFor(String id) {
        return new File(User.getRootDir(), User.idStrategy().filenameOf(id));
    }

    @CheckForNull
    public File getUserFolder() {
        return this.getExistingUserFolder();
    }

    @CheckForNull
    private File getExistingUserFolder() {
        return UserIdMapper.getInstance().getDirectory(this.id);
    }

    static File getRootDir() {
        return new File(Jenkins.get().getRootDir(), "users");
    }

    public static boolean isIdOrFullnameAllowed(@CheckForNull String id) {
        if (id == null || id.isBlank()) {
            return false;
        }
        String trimmedId = id.trim();
        for (String invalidId : ILLEGAL_PERSISTED_USERNAMES) {
            if (!trimmedId.equalsIgnoreCase(invalidId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void save() throws IOException {
        if (!User.isIdOrFullnameAllowed(this.id)) {
            throw FormValidation.error(Messages.User_IllegalUsername(this.id));
        }
        if (!User.isIdOrFullnameAllowed(this.fullName)) {
            throw FormValidation.error(Messages.User_IllegalFullname(this.fullName));
        }
        if (BulkChange.contains(this)) {
            return;
        }
        XmlFile xmlFile = new XmlFile(XSTREAM, this.constructUserConfigFile());
        xmlFile.write(this);
        SaveableListener.fireOnChange(this, xmlFile);
    }

    private File constructUserConfigFile() throws IOException {
        return new File(this.putUserFolderIfAbsent(), CONFIG_XML);
    }

    private File putUserFolderIfAbsent() throws IOException {
        return UserIdMapper.getInstance().putIfAbsent(this.id, true);
    }

    public void delete() throws IOException {
        String idKey = User.idStrategy().keyFor(this.id);
        File existingUserFolder = this.getExistingUserFolder();
        UserIdMapper.getInstance().remove(this.id);
        AllUsers.remove(this.id);
        this.deleteExistingUserFolder(existingUserFolder);
        UserDetailsCache.get().invalidate(idKey);
    }

    private void deleteExistingUserFolder(File existingUserFolder) throws IOException {
        if (existingUserFolder != null && existingUserFolder.exists()) {
            Util.deleteRecursive(existingUserFolder);
        }
    }

    public Api getApi() {
        return new Api(this);
    }

    @RequirePOST
    public void doDoDelete(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.checkPermission(Jenkins.ADMINISTER);
        if (User.idStrategy().equals(this.id, Jenkins.getAuthentication2().getName())) {
            rsp.sendError(400, "Cannot delete self");
            return;
        }
        this.delete();
        rsp.sendRedirect2("../..");
    }

    public void doRssAll(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (all builds)", this.getUrl(), this.getBuilds().newBuilds());
    }

    public void doRssFailed(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (failed builds)", this.getUrl(), this.getBuilds().regressionOnly());
    }

    public void doRssLatest(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        ArrayList lastBuilds = new ArrayList();
        block0: for (Job p : Jenkins.get().allItems(Job.class)) {
            for (Object b = p.getLastBuild(); b != null; b = ((Run)b).getPreviousBuild()) {
                if (!this.relatedTo((Run<?, ?>)b)) continue;
                lastBuilds.add(b);
                continue block0;
            }
        }
        lastBuilds.sort((o1, o2) -> Items.BY_FULL_NAME.compare((Item)o1.getParent(), (Item)o2.getParent()));
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (latest builds)", this.getUrl(), RunList.fromRuns(lastBuilds), Run.FEED_ADAPTER_LATEST);
    }

    @Override
    @NonNull
    public ACL getACL() {
        ACL base = Jenkins.get().getAuthorizationStrategy().getACL(this);
        return ACL.lambda2((a, permission) -> User.idStrategy().equals(a.getName(), this.id) && !(a instanceof AnonymousAuthenticationToken) || base.hasPermission2((org.springframework.security.core.Authentication)a, (Permission)permission));
    }

    public boolean canDelete() {
        IdStrategy strategy = User.idStrategy();
        return this.hasPermission(Jenkins.ADMINISTER) && !strategy.equals(this.id, Jenkins.getAuthentication2().getName()) && UserIdMapper.getInstance().isMapped(this.id);
    }

    @NonNull
    public List<String> getAuthorities() {
        org.springframework.security.core.Authentication authentication;
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>();
        try {
            authentication = this.impersonate2();
        }
        catch (org.springframework.security.core.userdetails.UsernameNotFoundException x) {
            LOGGER.log(Level.FINE, "cannot look up authorities for " + this.id, x);
            return Collections.emptyList();
        }
        for (GrantedAuthority a : authentication.getAuthorities()) {
            String n;
            if (a.equals(SecurityRealm.AUTHENTICATED_AUTHORITY2) || (n = a.getAuthority()) == null || User.idStrategy().equals(n, this.id)) continue;
            r.add(n);
        }
        r.sort(String.CASE_INSENSITIVE_ORDER);
        return r;
    }

    public Object getDynamic(String token) {
        for (Action action : this.getTransientActions()) {
            if (!Objects.equals(action.getUrlName(), token)) continue;
            return action;
        }
        for (Action action : this.getPropertyActions()) {
            if (!Objects.equals(action.getUrlName(), token)) continue;
            return action;
        }
        return null;
    }

    public List<Action> getPropertyActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (UserProperty userProp : this.getProperties().values()) {
            if (!(userProp instanceof Action)) continue;
            actions.add((Action)((Object)userProp));
        }
        return Collections.unmodifiableList(actions);
    }

    public List<Action> getTransientActions() {
        ArrayList<? extends Action> actions = new ArrayList<Action>();
        for (TransientUserActionFactory factory : TransientUserActionFactory.all()) {
            actions.addAll(factory.createFor(this));
        }
        return Collections.unmodifiableList(actions);
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest2 request, StaplerResponse2 response) throws Exception {
        return new ModelObjectWithContextMenu.ContextMenu().from((ModelObjectWithContextMenu)this, request, response);
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK && !Jenkins.get().hasPermission(Jenkins.READ)) {
            return null;
        }
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    static Set<String> getIllegalPersistedUsernames() {
        return new HashSet<String>(Arrays.asList(ILLEGAL_PERSISTED_USERNAMES));
    }

    private Object writeReplace() {
        return XmlFile.replaceIfNotAtTopLevel(this, () -> new Replacer(this));
    }

    static {
        XSTREAM.alias("user", User.class);
    }

    private static class LegitimateButUnknownUserDetails
    extends org.springframework.security.core.userdetails.User {
        private LegitimateButUnknownUserDetails(String username) throws IllegalArgumentException {
            super(username, "", true, true, true, true, Set.of(SecurityRealm.AUTHENTICATED_AUTHORITY2));
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class AllUsers {
        private final ConcurrentMap<String, User> byName = new ConcurrentHashMap<String, User>();

        @Initializer(after=InitMilestone.JOB_CONFIG_ADAPTED)
        public static void scanAll() {
            for (String userId : UserIdMapper.getInstance().getConvertedUserIds()) {
                User user = new User(userId, userId);
                AllUsers.getInstance().byName.putIfAbsent(User.idStrategy().keyFor(userId), user);
            }
        }

        private static AllUsers getInstance() {
            return ExtensionList.lookupSingleton(AllUsers.class);
        }

        private static void reload() {
            AllUsers.getInstance().byName.clear();
            UserDetailsCache.get().invalidateAll();
            AllUsers.scanAll();
        }

        private static void clear() {
            AllUsers.getInstance().byName.clear();
        }

        private static void remove(String id) {
            AllUsers.getInstance().byName.remove(User.idStrategy().keyFor(id));
        }

        private static User get(String id) {
            return (User)AllUsers.getInstance().byName.get(User.idStrategy().keyFor(id));
        }

        private static void put(String id, User user) {
            AllUsers.getInstance().byName.putIfAbsent(User.idStrategy().keyFor(id), user);
        }

        private static Collection<User> values() {
            return AllUsers.getInstance().byName.values();
        }
    }

    public static abstract class CanonicalIdResolver
    extends AbstractDescribableImpl<CanonicalIdResolver>
    implements ExtensionPoint,
    Comparable<CanonicalIdResolver> {
        public static final String REALM = "realm";

        @Override
        public int compareTo(@NonNull CanonicalIdResolver o) {
            return Integer.compare(o.getPriority(), this.getPriority());
        }

        @CheckForNull
        public abstract String resolveCanonicalId(String var1, Map<String, ?> var2);

        public int getPriority() {
            return 1;
        }

        public static List<CanonicalIdResolver> all() {
            ArrayList<CanonicalIdResolver> resolvers = new ArrayList<CanonicalIdResolver>(ExtensionList.lookup(CanonicalIdResolver.class));
            Collections.sort(resolvers);
            return resolvers;
        }

        @CheckForNull
        public static String resolve(@NonNull String idOrFullName, @NonNull Map<String, ?> context) {
            for (CanonicalIdResolver resolver : CanonicalIdResolver.all()) {
                String id = resolver.resolveCanonicalId(idOrFullName, context);
                if (id == null) continue;
                LOGGER.log(Level.FINE, "{0} mapped {1} to {2}", new Object[]{resolver, idOrFullName, id});
                return id;
            }
            return null;
        }
    }

    private static class Replacer {
        private final String id;

        Replacer(User u) {
            this.id = u.getId();
        }

        private Object readResolve() {
            return User.getById(this.id, false);
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class UserIDCanonicalIdResolver
    extends CanonicalIdResolver {
        private static boolean SECURITY_243_FULL_DEFENSE = SystemProperties.getBoolean(User.class.getName() + ".SECURITY_243_FULL_DEFENSE", true);
        private static final ThreadLocal<Boolean> resolving = ThreadLocal.withInitial(() -> false);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String resolveCanonicalId(String idOrFullName, Map<String, ?> context) {
            User existing = User.getById(idOrFullName, false);
            if (existing != null) {
                return existing.getId();
            }
            if (SECURITY_243_FULL_DEFENSE && !resolving.get().booleanValue()) {
                resolving.set(true);
                try {
                    UserDetails userDetails = UserDetailsCache.get().loadUserByUsername(idOrFullName);
                    String string = userDetails.getUsername();
                    return string;
                }
                catch (org.springframework.security.core.userdetails.UsernameNotFoundException x) {
                    LOGGER.log(Level.FINE, "not sure whether " + idOrFullName + " is a valid username or not", x);
                }
                catch (ExecutionException x) {
                    LOGGER.log(Level.FINE, "could not look up " + idOrFullName, x);
                }
                finally {
                    resolving.set(false);
                }
            }
            return null;
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    }

    @Extension
    @Symbol(value={"fullName"})
    public static class FullNameIdResolver
    extends CanonicalIdResolver {
        @Override
        public String resolveCanonicalId(String idOrFullName, Map<String, ?> context) {
            for (User user : User.getAll()) {
                if (!idOrFullName.equals(user.getFullName())) continue;
                return user.getId();
            }
            return null;
        }

        @Override
        public int getPriority() {
            return -1;
        }
    }
}

