/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.search.SearchIndex;
import hudson.search.SearchItem;
import hudson.search.SearchableModelObject;
import hudson.search.UserSearchProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class CollectionSearchIndex<SMT extends SearchableModelObject>
implements SearchIndex {
    protected abstract SearchItem get(String var1);

    protected abstract Collection<SMT> all();

    @NonNull
    protected Iterable<SMT> allAsIterable() {
        Collection<SMT> all = this.all();
        return all == null ? Collections.emptySet() : all;
    }

    @Override
    public void find(String token, List<SearchItem> result) {
        SearchItem p = this.get(token);
        if (p != null) {
            result.add(p);
        }
    }

    @Override
    public void suggest(String token, List<SearchItem> result) {
        boolean isCaseSensitive = UserSearchProperty.isCaseInsensitive();
        if (isCaseSensitive) {
            token = token.toLowerCase();
        }
        for (SearchableModelObject o : this.allAsIterable()) {
            String name = this.getName(o);
            if (isCaseSensitive) {
                name = name.toLowerCase();
            }
            if (o == null || !name.contains(token)) continue;
            result.add(o);
        }
    }

    protected String getName(SMT o) {
        return o.getDisplayName();
    }
}

