/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class TableNestChecker
extends XMLFilterImpl {
    private final Stack<Checker> elements = new Stack();
    private final Stack<String> tagNames = new Stack();
    private static final Checker ALL_ALLOWED = childTag -> true;
    private static final Map<String, Checker> CHECKERS = new HashMap<String, Checker>();

    public static void applyTo(XMLOutput xo) {
        xo.setContentHandler((ContentHandler)new TableNestChecker(xo.getContentHandler()));
    }

    public TableNestChecker() {
        this.elements.push(ALL_ALLOWED);
    }

    public TableNestChecker(ContentHandler target) {
        this();
        this.setContentHandler(target);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String tagName = localName.toUpperCase(Locale.ENGLISH);
        if (!this.elements.peek().isAllowed(tagName)) {
            throw new SAXException(tagName + " is not allowed inside " + this.tagNames.peek());
        }
        Checker next = CHECKERS.get(tagName);
        if (next == null) {
            next = ALL_ALLOWED;
        }
        this.elements.push(next);
        this.tagNames.push(tagName);
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.pop();
        this.tagNames.pop();
        super.endElement(uri, localName, qName);
    }

    static {
        CHECKERS.put("TABLE", new InList("TR", "THEAD", "TBODY"));
        InList rows = new InList("TR");
        CHECKERS.put("THEAD", rows);
        CHECKERS.put("TR", new InList("TD", "TH"));
    }

    private static interface Checker {
        public boolean isAllowed(String var1);
    }

    private static final class InList
    implements Checker {
        private final Set<String> tags;

        private InList(String ... tags) {
            this.tags = new HashSet<String>(Arrays.asList(tags));
        }

        @Override
        public boolean isAllowed(String childTag) {
            return this.tags.contains(childTag);
        }
    }
}

