/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.Messages;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractIdCredentialsListBoxModel<T extends AbstractIdCredentialsListBoxModel<T, C>, C extends IdCredentials>
extends ListBoxModel {
    @NonNull
    protected abstract String describe(@NonNull C var1);

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> with(@CheckForNull C u) {
        if (u != null) {
            this.add(this.describe(u), u.getId());
        }
        return this;
    }

    @Deprecated
    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withEmptySelection() {
        return this.includeEmptyValue();
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> includeEmptyValue() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ListBoxModel.Option a = (ListBoxModel.Option)iterator.next();
            if (!StringUtils.equals((String)"", (String)a.value)) continue;
            return this;
        }
        this.add(0, new ListBoxModel.Option(Messages.AbstractIdCredentialsListBoxModel_EmptySelection(), ""));
        return this;
    }

    @Deprecated
    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withAll(C ... credentials) {
        return this.withMatching(CredentialsMatchers.always(), (Iterable<? extends C>)Arrays.asList(credentials));
    }

    @Deprecated
    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withAll(@NonNull Iterable<? extends C> credentials) {
        return this.withMatching(CredentialsMatchers.always(), credentials.iterator());
    }

    @Deprecated
    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withAll(@NonNull Iterator<? extends C> credentials) {
        return this.withMatching(CredentialsMatchers.always(), credentials);
    }

    @Deprecated
    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withMatching(@NonNull CredentialsMatcher matcher, C ... credentials) {
        return this.withMatching(matcher, (Iterable<? extends C>)Arrays.asList(credentials));
    }

    @Deprecated
    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withMatching(@NonNull CredentialsMatcher matcher, @NonNull Iterable<? extends C> credentials) {
        return this.withMatching(matcher, credentials.iterator());
    }

    @Deprecated
    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withMatching(@NonNull CredentialsMatcher matcher, @NonNull Iterator<? extends C> credentials) {
        while (credentials.hasNext()) {
            IdCredentials c = (IdCredentials)credentials.next();
            if (!matcher.matches(c)) continue;
            this.with(c);
        }
        return this;
    }

    public AbstractIdCredentialsListBoxModel<T, C> include(@Nullable Item context, @NonNull Class<? extends C> type) {
        return this.include(context, type, Collections.emptyList());
    }

    public AbstractIdCredentialsListBoxModel<T, C> include(@NonNull ItemGroup context, @NonNull Class<? extends C> type) {
        return this.include(context, type, Collections.emptyList());
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeAs(@NonNull Authentication authentication, @Nullable Item context, @NonNull Class<? extends C> type) {
        return this.includeAs(authentication, context, type, Collections.emptyList());
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeAs(@NonNull Authentication authentication, @NonNull ItemGroup context, @NonNull Class<? extends C> type) {
        return this.includeAs(authentication, context, type, Collections.emptyList());
    }

    public AbstractIdCredentialsListBoxModel<T, C> include(@Nullable Item context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements) {
        return this.includeMatching(context, type, domainRequirements, CredentialsMatchers.always());
    }

    public AbstractIdCredentialsListBoxModel<T, C> include(@NonNull ItemGroup context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements) {
        return this.includeMatching(context, type, domainRequirements, CredentialsMatchers.always());
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeAs(@NonNull Authentication authentication, @Nullable Item context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements) {
        return this.includeMatchingAs(authentication, context, type, domainRequirements, CredentialsMatchers.always());
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeAs(@NonNull Authentication authentication, @NonNull ItemGroup context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements) {
        return this.includeMatchingAs(authentication, context, type, domainRequirements, CredentialsMatchers.always());
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeMatching(@Nullable Item context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        return this.includeMatchingAs(Jenkins.getAuthentication(), context, type, domainRequirements, matcher);
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeMatching(@NonNull ItemGroup context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        return this.includeMatchingAs(Jenkins.getAuthentication(), context, type, domainRequirements, matcher);
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeMatchingAs(@NonNull Authentication authentication, @Nullable Item context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        this.addMissing((Collection<ListBoxModel.Option>)CredentialsProvider.listCredentials(type, context, authentication, domainRequirements, matcher));
        return this;
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeMatchingAs(@NonNull Authentication authentication, @NonNull ItemGroup context, @NonNull Class<? extends C> type, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        this.addMissing((Collection<ListBoxModel.Option>)CredentialsProvider.listCredentials(type, context, authentication, domainRequirements, matcher));
        return this;
    }

    public AbstractIdCredentialsListBoxModel<T, C> includeCurrentValue(@NonNull String value) {
        if (StringUtils.isEmpty((String)value)) {
            return this.includeEmptyValue();
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ListBoxModel.Option a = (ListBoxModel.Option)iterator.next();
            if (!StringUtils.equals((String)value, (String)a.value)) continue;
            return this;
        }
        int index = this.isEmpty() ? 0 : ("".equals(((ListBoxModel.Option)this.get((int)0)).value) ? 1 : 0);
        this.add(index, new ListBoxModel.Option(Messages.AbstractIdCredentialsListBoxModel_CurrentSelection(), value));
        return this;
    }

    public boolean addMissing(@NonNull Collection<? extends ListBoxModel.Option> c) {
        HashSet<String> existing = new HashSet<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ListBoxModel.Option o = (ListBoxModel.Option)iterator.next();
            existing.add(o.value);
        }
        boolean changed = false;
        for (ListBoxModel.Option option : c) {
            if (existing.contains(option.value)) continue;
            this.add(option);
            changed = existing.add(option.value) || changed;
        }
        return changed;
    }
}

