/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainRestrictedCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.CopyOnWriteMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kohsuke.stapler.DataBoundConstructor;

public class DomainCredentials {
    @NonNull
    private final Domain domain;
    @NonNull
    private final List<Credentials> credentials;

    @DataBoundConstructor
    public DomainCredentials(Domain domain, List<Credentials> credentials) {
        this.domain = domain == null ? Domain.global() : domain.resolve();
        this.credentials = credentials == null ? new ArrayList<Credentials>() : new ArrayList<Credentials>(credentials);
    }

    @NonNull
    public static Map<Domain, List<Credentials>> asMap(@CheckForNull Collection<DomainCredentials> collection) {
        LinkedHashMap<Domain, CopyOnWriteArrayList<Credentials>> map = new LinkedHashMap<Domain, CopyOnWriteArrayList<Credentials>>();
        if (collection != null) {
            for (DomainCredentials item : collection) {
                List existing = (List)map.get(item.getDomain());
                if (existing == null) {
                    map.put(item.getDomain(), new CopyOnWriteArrayList<Credentials>(item.getCredentials()));
                    continue;
                }
                existing.addAll(item.getCredentials());
            }
        }
        return new CopyOnWriteMap.Hash(map);
    }

    @NonNull
    public static List<DomainCredentials> asList(Map<Domain, List<Credentials>> map) {
        ArrayList<DomainCredentials> result = new ArrayList<DomainCredentials>();
        if (map != null) {
            for (Map.Entry<Domain, List<Credentials>> entry : map.entrySet()) {
                result.add(new DomainCredentials(entry.getKey(), entry.getValue()));
            }
        }
        return result;
    }

    @NonNull
    public static Map<Domain, List<Credentials>> toCopyOnWriteMap(@CheckForNull Map<Domain, List<Credentials>> map) {
        if (map instanceof CopyOnWriteMap.Hash) {
            boolean allCopyOnWrite = true;
            for (List<Credentials> list : map.values()) {
                if (list instanceof CopyOnWriteArrayList) continue;
                allCopyOnWrite = false;
                break;
            }
            if (allCopyOnWrite) {
                return map;
            }
        }
        LinkedHashMap tmp = new LinkedHashMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                tmp.put(entry.getKey() == null ? Domain.global() : ((Domain)entry.getKey()).resolve(), new CopyOnWriteArrayList(entry.getValue() == null ? Collections.emptyList() : (Collection)entry.getValue()));
            }
        }
        return new CopyOnWriteMap.Hash(tmp);
    }

    public static Map<Domain, List<Credentials>> migrateListToMap(@CheckForNull Map<Domain, List<Credentials>> map, @CheckForNull List<Credentials> list) {
        if (map == null) {
            map = new CopyOnWriteMap.Hash();
        }
        if (!map.containsKey(Domain.global())) {
            if (list == null) {
                map.put(Domain.global(), new CopyOnWriteArrayList());
            } else {
                map.put(Domain.global(), new CopyOnWriteArrayList<Credentials>(list));
            }
        }
        return map;
    }

    @NonNull
    public static <C extends Credentials> List<C> getCredentials(@NonNull Map<Domain, List<Credentials>> domainCredentialsMap, @NonNull Class<C> type, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher credentialsMatcher) {
        ArrayList<C> result = new ArrayList<C>();
        for (Map.Entry<Domain, List<Credentials>> entry : domainCredentialsMap.entrySet()) {
            if (!entry.getKey().test(domainRequirements)) continue;
            for (Credentials credential : entry.getValue()) {
                if (!type.isInstance(credential) || credential instanceof DomainRestrictedCredentials && !((DomainRestrictedCredentials)credential).matches(domainRequirements) || !credentialsMatcher.matches(credential)) continue;
                result.add(type.cast(credential));
            }
        }
        return result;
    }

    @NonNull
    public static List<DomainCredentials> fixList(@CheckForNull List<DomainCredentials> list) {
        Map<Domain, List<Credentials>> map = DomainCredentials.asMap(list);
        if (!map.containsKey(Domain.global())) {
            map.put(Domain.global(), new CopyOnWriteArrayList());
        }
        return DomainCredentials.asList(map);
    }

    @NonNull
    public Domain getDomain() {
        return this.domain;
    }

    @NonNull
    public List<Credentials> getCredentials() {
        return this.credentials;
    }
}

