/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Date;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.mixin.TagSCMHead;

@Extension
public class BranchNameContributor
extends EnvironmentContributor {
    public void buildEnvironmentFor(Job j, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        BranchProjectFactory projectFactory;
        ItemGroup parent = j.getParent();
        if (parent instanceof MultiBranchProject && (projectFactory = ((MultiBranchProject)parent).getProjectFactory()).isProject((Item)j)) {
            Branch branch = projectFactory.getBranch(j);
            SCMHead head = branch.getHead();
            envs.put("BRANCH_NAME", head.getName());
            if (branch.getAction(PrimaryInstanceMetadataAction.class) != null) {
                envs.put("BRANCH_IS_PRIMARY", "true");
            }
            if (head instanceof ChangeRequestSCMHead) {
                ContributorMetadataAction cma;
                ObjectMetadataAction oma;
                SCMHeadOrigin origin;
                envs.putIfNotNull("CHANGE_ID", ((ChangeRequestSCMHead)head).getId());
                SCMHead target = ((ChangeRequestSCMHead)head).getTarget();
                envs.putIfNotNull("CHANGE_TARGET", target.getName());
                if (head instanceof ChangeRequestSCMHead2) {
                    envs.putIfNotNull("CHANGE_BRANCH", ((ChangeRequestSCMHead2)head).getOriginName());
                }
                if ((origin = head.getOrigin()) instanceof SCMHeadOrigin.Fork) {
                    envs.putIfNotNull("CHANGE_FORK", ((SCMHeadOrigin.Fork)origin).getName());
                }
                if ((oma = branch.getAction(ObjectMetadataAction.class)) != null) {
                    envs.putIfNotNull("CHANGE_URL", oma.getObjectUrl());
                    envs.putIfNotNull("CHANGE_TITLE", oma.getObjectDisplayName());
                }
                if ((cma = branch.getAction(ContributorMetadataAction.class)) != null) {
                    envs.putIfNotNull("CHANGE_AUTHOR", cma.getContributor());
                    envs.putIfNotNull("CHANGE_AUTHOR_DISPLAY_NAME", cma.getContributorDisplayName());
                    envs.putIfNotNull("CHANGE_AUTHOR_EMAIL", cma.getContributorEmail());
                }
            }
            if (head instanceof TagSCMHead) {
                envs.put("TAG_NAME", head.getName());
                envs.putIfNotNull("TAG_TIMESTAMP", Long.toString(((TagSCMHead)head).getTimestamp()));
                envs.putIfNotNull("TAG_UNIXTIME", Long.toString(((TagSCMHead)head).getTimestamp() / 1000L));
                envs.putIfNotNull("TAG_DATE", new Date(((TagSCMHead)head).getTimestamp()).toString());
            }
        }
    }
}

