/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;

public abstract class MultiBranchProjectFactory
extends AbstractDescribableImpl<MultiBranchProjectFactory>
implements ExtensionPoint {
    public boolean recognizes(@NonNull ItemGroup<?> parent, @NonNull String name, @NonNull List<? extends SCMSource> scmSources, @NonNull Map<String, Object> attributes, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.recognizes(parent, name, scmSources, attributes, null, listener);
    }

    public boolean recognizes(@NonNull ItemGroup<?> parent, @NonNull String name, @NonNull List<? extends SCMSource> scmSources, @NonNull Map<String, Object> attributes, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (Util.isOverridden(MultiBranchProjectFactory.class, ((Object)((Object)this)).getClass(), (String)"recognizes", (Class[])new Class[]{ItemGroup.class, String.class, List.class, Map.class, TaskListener.class})) {
            return this.recognizes(parent, name, scmSources, attributes, listener);
        }
        if (Util.isOverridden(MultiBranchProjectFactory.class, ((Object)((Object)this)).getClass(), (String)"createProject", (Class[])new Class[]{ItemGroup.class, String.class, List.class, Map.class, TaskListener.class})) {
            return this.createProject(parent, name, scmSources, attributes, listener) != null;
        }
        throw new AbstractMethodError(((Object)((Object)this)).getClass().getName() + " must override recognizes(ItemGroup,String,Map,SCMHeadEvent,TaskListener)");
    }

    @NonNull
    public MultiBranchProject<?, ?> createNewProject(@NonNull ItemGroup<?> parent, @NonNull String name, @NonNull List<? extends SCMSource> scmSources, @NonNull Map<String, Object> attributes, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (Util.isOverridden(MultiBranchProjectFactory.class, ((Object)((Object)this)).getClass(), (String)"createProject", (Class[])new Class[]{ItemGroup.class, String.class, List.class, Map.class, TaskListener.class})) {
            MultiBranchProject<?, ?> p = this.createProject(parent, name, scmSources, attributes, listener);
            if (p == null) {
                throw new IOException("recognized project " + name + " before, but now");
            }
            return p;
        }
        throw new AbstractMethodError(((Object)((Object)this)).getClass().getName() + " must override createNewProject");
    }

    public void updateExistingProject(@NonNull MultiBranchProject<?, ?> project, @NonNull Map<String, Object> attributes, @NonNull TaskListener listener) throws IOException, InterruptedException {
    }

    @Deprecated
    @CheckForNull
    public MultiBranchProject<?, ?> createProject(@NonNull ItemGroup<?> parent, @NonNull String name, @NonNull List<? extends SCMSource> scmSources, @NonNull Map<String, Object> attributes, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (this.recognizes(parent, name, scmSources, attributes, listener)) {
            return this.createNewProject(parent, name, scmSources, attributes, listener);
        }
        return null;
    }

    public MultiBranchProjectFactoryDescriptor getDescriptor() {
        return (MultiBranchProjectFactoryDescriptor)super.getDescriptor();
    }

    public static abstract class BySCMSourceCriteria
    extends MultiBranchProjectFactory {
        @CheckForNull
        protected abstract SCMSourceCriteria getSCMSourceCriteria(@NonNull SCMSource var1);

        @NonNull
        protected abstract MultiBranchProject<?, ?> doCreateProject(@NonNull ItemGroup<?> var1, @NonNull String var2, @NonNull Map<String, Object> var3) throws IOException, InterruptedException;

        @Override
        @NonNull
        public final MultiBranchProject<?, ?> createNewProject(@NonNull ItemGroup<?> parent, @NonNull String name, @NonNull List<? extends SCMSource> scmSources, @NonNull Map<String, Object> attributes, @NonNull TaskListener listener) throws IOException, InterruptedException {
            return this.doCreateProject(parent, name, attributes);
        }

        @Override
        public boolean recognizes(@NonNull ItemGroup<?> parent, @NonNull String name, @NonNull List<? extends SCMSource> scmSources, @NonNull Map<String, Object> attributes, @NonNull TaskListener listener) throws IOException, InterruptedException {
            return this.recognizes(parent, name, scmSources, attributes, null, listener);
        }

        @Override
        public boolean recognizes(@NonNull ItemGroup<?> parent, @NonNull String name, @NonNull List<? extends SCMSource> scmSources, @NonNull Map<String, Object> attributes, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
            for (SCMSource sCMSource : scmSources) {
                if (((SCMHeadObserver.Any)sCMSource.fetch(this.getSCMSourceCriteria(sCMSource), (SCMHeadObserver)SCMHeadObserver.any(), event, listener)).getRevision() == null) continue;
                return true;
            }
            return false;
        }
    }
}

