/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.jcraft.jzlib.GZIPInputStream;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FeedAdapter;
import hudson.Functions;
import hudson.Util;
import hudson.XmlFile;
import hudson.cli.declarative.CLIMethod;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleLogFilter;
import hudson.console.ConsoleNote;
import hudson.console.ModelHyperlinkNote;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.BallColor;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.CheckPoint;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.EnvironmentContributingAction;
import hudson.model.EnvironmentContributor;
import hudson.model.Executor;
import hudson.model.Fingerprint;
import hudson.model.FreeStyleBuild;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.PersistenceRoot;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.ResultTrend;
import hudson.model.Run;
import hudson.model.RunAction;
import hudson.model.RunnerStack;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TransientBuildActionFactory;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SaveableListener;
import hudson.search.SearchIndexBuilder;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Fingerprinter;
import hudson.util.FormApply;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import hudson.util.XStream2;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.ArtifactManager;
import jenkins.model.ArtifactManagerConfiguration;
import jenkins.model.ArtifactManagerFactory;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.RunAction2;
import jenkins.model.StandardArtifactManager;
import jenkins.model.lazy.BuildReference;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.SystemProperties;
import jenkins.util.VirtualFile;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;

@ExportedBean
public abstract class Run<JobT extends Job<JobT, RunT>, RunT extends Run<JobT, RunT>>
extends Actionable
implements ExtensionPoint,
Comparable<RunT>,
AccessControlled,
PersistenceRoot,
DescriptorByNameOwner,
OnMaster,
StaplerProxy {
    public static final long QUEUE_ID_UNKNOWN = -1L;
    private static int TRUNCATED_DESCRIPTION_LIMIT = SystemProperties.getInteger("historyWidget.descriptionLimit", 100);
    @NonNull
    protected final transient JobT project;
    public transient int number;
    private long queueId = -1L;
    @Restricted(value={NoExternalUse.class})
    protected volatile transient RunT previousBuild;
    @Restricted(value={NoExternalUse.class})
    protected volatile transient RunT nextBuild;
    volatile transient RunT previousBuildInProgress;
    @CheckForNull
    private String id;
    protected long timestamp;
    private long startTime;
    protected volatile Result result;
    @CheckForNull
    protected volatile String description;
    private volatile String displayName;
    private volatile transient State state;
    protected long duration;
    protected String charset;
    private boolean keepLog;
    private volatile transient RunExecution runner;
    @CheckForNull
    private ArtifactManager artifactManager;
    private transient boolean isPendingDelete;
    public static final int LIST_CUTOFF = Integer.parseInt(SystemProperties.getString("hudson.model.Run.ArtifactList.listCutoff", "20"));
    public static final XStream XSTREAM = new XStream2();
    public static final XStream2 XSTREAM2 = (XStream2)XSTREAM;
    private static final Logger LOGGER;
    public static final Comparator<Run> ORDER_BY_DATE;
    public static final FeedAdapter<Run> FEED_ADAPTER;
    public static final FeedAdapter<Run> FEED_ADAPTER_LATEST;
    public static final PermissionGroup PERMISSIONS;
    public static final Permission DELETE;
    public static final Permission UPDATE;
    public static final Permission ARTIFACTS;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK;

    protected Run(@NonNull JobT job) throws IOException {
        this(job, System.currentTimeMillis());
        this.number = ((Job)this.project).assignBuildNumber();
        LOGGER.log(Level.FINER, "new {0} @{1}", new Object[]{this, this.hashCode()});
    }

    protected Run(@NonNull JobT job, @NonNull Calendar timestamp) {
        this(job, timestamp.getTimeInMillis());
    }

    protected Run(@NonNull JobT job, long timestamp) {
        this.project = job;
        this.timestamp = timestamp;
        this.state = State.NOT_STARTED;
    }

    protected Run(@NonNull JobT project, @NonNull File buildDir) throws IOException {
        this.project = project;
        this.previousBuildInProgress = this._this();
        this.number = Integer.parseInt(buildDir.getName());
        this.reload();
    }

    public void reload() throws IOException {
        this.state = State.COMPLETED;
        this.result = Result.FAILURE;
        this.getDataFile().unmarshal(this);
        if (this.state == State.COMPLETED) {
            LOGGER.log(Level.FINER, "reload {0} @{1}", new Object[]{this, this.hashCode()});
        } else {
            LOGGER.log(Level.WARNING, "reload {0} @{1} with anomalous state {2}", new Object[]{this, this.hashCode(), this.state});
        }
    }

    protected void onLoad() {
        for (Action action : this.getAllActions()) {
            if (action instanceof RunAction2) {
                try {
                    ((RunAction2)action).onLoad(this);
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.WARNING, "failed to load " + action + " from " + this.getDataFile(), x);
                    this.removeAction(action);
                }
                continue;
            }
            if (!(action instanceof RunAction)) continue;
            ((RunAction)action).onLoad();
        }
        if (this.artifactManager != null) {
            this.artifactManager.onLoad(this);
        }
    }

    @Deprecated
    public List<Action> getTransientActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (TransientBuildActionFactory factory : TransientBuildActionFactory.all()) {
            for (Action action : factory.createFor(this)) {
                if (action == null) {
                    LOGGER.log(Level.WARNING, "null action added by {0}", factory);
                    continue;
                }
                actions.add(action);
            }
        }
        return Collections.unmodifiableList(actions);
    }

    @Override
    public void addAction(@NonNull Action a) {
        super.addAction(a);
        if (a instanceof RunAction2) {
            ((RunAction2)a).onAttached(this);
        } else if (a instanceof RunAction) {
            ((RunAction)a).onAttached(this);
        }
    }

    @NonNull
    protected RunT _this() {
        return (RunT)this;
    }

    @Override
    public int compareTo(@NonNull RunT that) {
        int res = this.number - ((Run)that).number;
        if (res == 0) {
            return ((AbstractItem)this.getParent()).getFullName().compareTo(((AbstractItem)((Run)that).getParent()).getFullName());
        }
        return res;
    }

    @Exported
    public long getQueueId() {
        return this.queueId;
    }

    @Restricted(value={NoExternalUse.class})
    public void setQueueId(long queueId) {
        this.queueId = queueId;
    }

    @Exported
    @CheckForNull
    public Result getResult() {
        return this.result;
    }

    public void setResult(@NonNull Result r) {
        if (this.state != State.BUILDING) {
            throw new IllegalStateException("cannot change build result while in " + this.state);
        }
        if (this.result == null || r.isWorseThan(this.result)) {
            this.result = r;
            LOGGER.log(Level.FINE, this + " in " + this.getRootDir() + ": result is set to " + r, LOGGER.isLoggable(Level.FINER) ? new Exception() : null);
        }
    }

    @NonNull
    public List<BuildBadgeAction> getBadgeActions() {
        List<BuildBadgeAction> r = this.getActions(BuildBadgeAction.class);
        if (this.isKeepLog()) {
            r = new ArrayList<BuildBadgeAction>(r);
            r.add(new KeepLogBuildBadge());
        }
        return r;
    }

    @Exported
    public boolean isBuilding() {
        return this.state.compareTo(State.POST_PRODUCTION) < 0;
    }

    @Exported
    public boolean isInProgress() {
        return this.state.equals((Object)State.BUILDING) || this.state.equals((Object)State.POST_PRODUCTION);
    }

    public boolean isLogUpdated() {
        return this.state.compareTo(State.COMPLETED) < 0;
    }

    @Exported
    @CheckForNull
    public Executor getExecutor() {
        return this instanceof Queue.Executable ? Executor.of((Queue.Executable)((Object)this)) : null;
    }

    @CheckForNull
    public Executor getOneOffExecutor() {
        for (Computer c : Jenkins.get().getComputers()) {
            for (Executor executor : c.getOneOffExecutors()) {
                if (executor.getCurrentExecutable() != this) continue;
                return executor;
            }
        }
        return null;
    }

    @NonNull
    public final Charset getCharset() {
        if (this.charset == null) {
            return Charset.defaultCharset();
        }
        return Charset.forName(this.charset);
    }

    @NonNull
    public List<Cause> getCauses() {
        CauseAction a = this.getAction(CauseAction.class);
        if (a == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(a.getCauses());
    }

    @CheckForNull
    public <T extends Cause> T getCause(Class<T> type) {
        for (Cause c : this.getCauses()) {
            if (!type.isInstance(c)) continue;
            return (T)((Cause)type.cast(c));
        }
        return null;
    }

    @Exported
    public final boolean isKeepLog() {
        return this.getWhyKeepLog() != null;
    }

    @CheckForNull
    public String getWhyKeepLog() {
        if (this.keepLog) {
            return Messages.Run_MarkedExplicitly();
        }
        return null;
    }

    @NonNull
    public JobT getParent() {
        return this.project;
    }

    @Exported
    @NonNull
    public Calendar getTimestamp() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(this.timestamp);
        return c;
    }

    @NonNull
    public final Date getTime() {
        return new Date(this.timestamp);
    }

    public final long getTimeInMillis() {
        return this.timestamp;
    }

    public final long getStartTimeInMillis() {
        if (this.startTime == 0L) {
            return this.timestamp;
        }
        return this.startTime;
    }

    @Exported
    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @Deprecated
    @CheckForNull
    public String getTruncatedDescription() {
        if (TRUNCATED_DESCRIPTION_LIMIT < 0) {
            return this.description;
        }
        if (TRUNCATED_DESCRIPTION_LIMIT == 0) {
            return "";
        }
        int maxDescrLength = TRUNCATED_DESCRIPTION_LIMIT;
        String localDescription = this.description;
        if (localDescription == null || localDescription.length() < maxDescrLength) {
            return localDescription;
        }
        String ending = "...";
        int sz = localDescription.length();
        int maxTruncLength = maxDescrLength - "...".length();
        boolean inTag = false;
        int displayChars = 0;
        int lastTruncatablePoint = -1;
        for (int i = 0; i < sz; ++i) {
            char ch = localDescription.charAt(i);
            if (ch == '<') {
                inTag = true;
            } else if (ch == '>') {
                inTag = false;
                if (displayChars <= maxTruncLength) {
                    lastTruncatablePoint = i + 1;
                }
            }
            if (inTag || ++displayChars > maxTruncLength || ch != ' ') continue;
            lastTruncatablePoint = i;
        }
        Object truncDesc = localDescription;
        if (lastTruncatablePoint == -1) {
            lastTruncatablePoint = maxTruncLength;
        }
        if (displayChars >= maxDescrLength) {
            truncDesc = ((String)truncDesc).substring(0, lastTruncatablePoint) + "...";
        }
        return truncDesc;
    }

    @NonNull
    public String getTimestampString() {
        long duration = new GregorianCalendar().getTimeInMillis() - this.timestamp;
        return Util.getTimeSpanString(duration);
    }

    @NonNull
    public String getTimestampString2() {
        return Util.XS_DATETIME_FORMATTER.format(new Date(this.timestamp));
    }

    @NonNull
    public String getDurationString() {
        if (this.hasntStartedYet()) {
            return Messages.Run_NotStartedYet();
        }
        if (this.isBuilding()) {
            return Messages.Run_InProgressDuration(Util.getTimeSpanString(System.currentTimeMillis() - this.startTime));
        }
        return Util.getTimeSpanString(this.duration);
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    @NonNull
    public BallColor getIconColor() {
        if (!this.isBuilding()) {
            return this.getResult().color;
        }
        RunT pb = this.getPreviousBuild();
        BallColor baseColor = pb == null ? BallColor.NOTBUILT : ((Run)pb).getIconColor();
        return baseColor.anime();
    }

    public boolean hasntStartedYet() {
        return this.state == State.NOT_STARTED;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="see JENKINS-45892")
    public String toString() {
        if (this.project == null) {
            return "<broken data JENKINS-45892>";
        }
        return ((AbstractItem)this.project).getFullName() + " #" + this.number;
    }

    @Exported
    public String getFullDisplayName() {
        return ((AbstractItem)this.project).getFullDisplayName() + " " + this.getDisplayName();
    }

    @Override
    @Exported
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : "#" + this.number;
    }

    public boolean hasCustomDisplayName() {
        return this.displayName != null;
    }

    public void setDisplayName(String value) throws IOException {
        this.checkPermission(UPDATE);
        this.displayName = value;
        this.save();
    }

    @Exported(visibility=2)
    public int getNumber() {
        return this.number;
    }

    @NonNull
    protected BuildReference<RunT> createReference() {
        return new BuildReference<RunT>(this.getId(), this._this());
    }

    protected void dropLinks() {
        if (this.nextBuild != null) {
            ((Run)this.nextBuild).previousBuild = this.previousBuild;
        }
        if (this.previousBuild != null) {
            ((Run)this.previousBuild).nextBuild = this.nextBuild;
        }
    }

    @CheckForNull
    public RunT getPreviousBuild() {
        return this.previousBuild;
    }

    @CheckForNull
    public final RunT getPreviousCompletedBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).isBuilding(); r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public final RunT getPreviousBuildInProgress() {
        RunT answer;
        if (this.previousBuildInProgress == this) {
            return null;
        }
        ArrayList<RunT> fixUp = new ArrayList<RunT>();
        RunT r = this._this();
        while (true) {
            RunT n;
            if ((n = ((Run)r).previousBuildInProgress) == null) {
                n = ((Run)r).getPreviousBuild();
                fixUp.add(r);
            }
            if (r == n || n == null) {
                answer = null;
                break;
            }
            if (((Run)n).isBuilding()) {
                answer = n;
                break;
            }
            fixUp.add(r);
            r = n;
        }
        for (Run<JobT, RunT> f : fixUp) {
            f.previousBuildInProgress = answer == null ? f : answer;
        }
        return answer;
    }

    @CheckForNull
    public RunT getPreviousBuiltBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && (((Run)r).getResult() == null || ((Run)r).getResult() == Result.NOT_BUILT); r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public RunT getPreviousNotFailedBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).getResult() == Result.FAILURE; r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public RunT getPreviousFailedBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).getResult() != Result.FAILURE; r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public RunT getPreviousSuccessfulBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).getResult() != Result.SUCCESS; r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @NonNull
    public List<RunT> getPreviousBuildsOverThreshold(int numberOfBuilds, @NonNull Result threshold) {
        RunT r = this.getPreviousBuild();
        if (r != null) {
            return ((Run)r).getBuildsOverThreshold(numberOfBuilds, threshold);
        }
        return new ArrayList(numberOfBuilds);
    }

    @NonNull
    protected List<RunT> getBuildsOverThreshold(int numberOfBuilds, @NonNull Result threshold) {
        ArrayList<RunT> builds = new ArrayList<RunT>(numberOfBuilds);
        for (RunT r = this._this(); r != null && builds.size() < numberOfBuilds; r = ((Run)r).getPreviousBuild()) {
            if (((Run)r).isBuilding() || ((Run)r).getResult() == null || !((Run)r).getResult().isBetterOrEqualTo(threshold)) continue;
            builds.add(r);
        }
        return builds;
    }

    @CheckForNull
    public RunT getNextBuild() {
        return this.nextBuild;
    }

    @NonNull
    public String getUrl() {
        String seed;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && (seed = Functions.getNearestAncestorUrl(req, this)) != null) {
            return seed.substring(req.getContextPath().length() + 1) + "/";
        }
        return ((AbstractItem)this.project).getUrl() + this.getNumber() + "/";
    }

    @Exported(visibility=2, name="url")
    @Deprecated
    @NonNull
    public final String getAbsoluteUrl() {
        return ((AbstractItem)this.project).getAbsoluteUrl() + this.getNumber() + "/";
    }

    @Override
    @NonNull
    public final String getSearchUrl() {
        return this.getNumber() + "/";
    }

    @Exported
    @NonNull
    public String getId() {
        return this.id != null ? this.id : Integer.toString(this.number);
    }

    @Override
    @NonNull
    public File getRootDir() {
        return new File(((Job)this.project).getBuildDir(), Integer.toString(this.number));
    }

    @NonNull
    public final ArtifactManager getArtifactManager() {
        return this.artifactManager != null ? this.artifactManager : new StandardArtifactManager(this);
    }

    @NonNull
    public final synchronized ArtifactManager pickArtifactManager() throws IOException {
        if (this.artifactManager != null) {
            return this.artifactManager;
        }
        for (ArtifactManagerFactory f : ArtifactManagerConfiguration.get().getArtifactManagerFactories()) {
            ArtifactManager mgr = f.managerFor(this);
            if (mgr == null) continue;
            this.artifactManager = mgr;
            this.save();
            return mgr;
        }
        return new StandardArtifactManager(this);
    }

    @Deprecated
    public File getArtifactsDir() {
        return new File(this.getRootDir(), "archive");
    }

    @Exported
    @NonNull
    public List<Artifact> getArtifacts() {
        return this.getArtifactsUpTo(Integer.MAX_VALUE);
    }

    @NonNull
    public List<Artifact> getArtifactsUpTo(int artifactsNumber) {
        SerializableArtifactList sal;
        VirtualFile root = this.getArtifactManager().root();
        try {
            sal = root.run(new AddArtifacts(root, artifactsNumber));
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            sal = new SerializableArtifactList();
        }
        ArtifactList r = new ArtifactList();
        r.updateFrom(sal);
        r.computeDisplayName();
        return r;
    }

    public boolean getHasArtifacts() {
        return !this.getArtifactsUpTo(1).isEmpty();
    }

    private static int addArtifacts(@NonNull VirtualFile dir, @NonNull String path, @NonNull String pathHref, @NonNull SerializableArtifactList r, @CheckForNull SerializableArtifact parent, int upTo) throws IOException {
        Object[] kids = dir.list();
        Arrays.sort(kids);
        int n = 0;
        for (Object sub : kids) {
            SerializableArtifact a;
            boolean collapsed;
            String child = ((VirtualFile)sub).getName();
            String childPath = path + child;
            String childHref = pathHref + Util.rawEncode(child);
            String length = ((VirtualFile)sub).isFile() ? String.valueOf(((VirtualFile)sub).length()) : "";
            boolean bl = collapsed = kids.length == 1 && parent != null;
            if (collapsed) {
                a = new SerializableArtifact(parent.name + "/" + child, childPath, ((VirtualFile)sub).isDirectory() ? null : childHref, length, parent.treeNodeId);
                r.tree.put(a, (String)r.tree.remove(parent));
            } else {
                a = new SerializableArtifact(child, childPath, ((VirtualFile)sub).isDirectory() ? null : childHref, length, "n" + ++r.idSeq);
                r.tree.put(a, parent != null ? parent.treeNodeId : null);
            }
            if (((VirtualFile)sub).isDirectory()) {
                if ((n += Run.addArtifacts((VirtualFile)sub, childPath + "/", childHref + "/", r, a, upTo - n)) < upTo) continue;
                break;
            }
            r.add(collapsed ? new SerializableArtifact(child, a.relativePath, a.href, length, a.treeNodeId) : a);
            if (++n >= upTo) break;
        }
        return n;
    }

    @Exported(name="fingerprint", inline=true, visibility=-1)
    @NonNull
    public Collection<Fingerprint> getBuildFingerprints() {
        Fingerprinter.FingerprintAction fingerprintAction = this.getAction(Fingerprinter.FingerprintAction.class);
        if (fingerprintAction != null) {
            return fingerprintAction.getFingerprints().values();
        }
        return Collections.emptyList();
    }

    @Deprecated
    @NonNull
    public File getLogFile() {
        File rawF = new File(this.getRootDir(), "log");
        if (rawF.isFile()) {
            return rawF;
        }
        File gzF = new File(this.getRootDir(), "log.gz");
        if (gzF.isFile()) {
            return gzF;
        }
        return rawF;
    }

    @NonNull
    public InputStream getLogInputStream() throws IOException {
        File logFile = this.getLogFile();
        if (logFile.exists()) {
            try {
                InputStream fis = Files.newInputStream(logFile.toPath(), new OpenOption[0]);
                if (logFile.getName().endsWith(".gz")) {
                    return new GZIPInputStream(fis);
                }
                return fis;
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
        String message = "No such file: " + logFile;
        return new ByteArrayInputStream(this.charset != null ? message.getBytes(this.charset) : message.getBytes(Charset.defaultCharset()));
    }

    @NonNull
    public Reader getLogReader() throws IOException {
        if (this.charset == null) {
            return new InputStreamReader(this.getLogInputStream(), Charset.defaultCharset());
        }
        return new InputStreamReader(this.getLogInputStream(), this.charset);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="method signature does not permit plumbing through the return value")
    public void writeLogTo(long offset, @NonNull XMLOutput out) throws IOException {
        long start = offset;
        if (offset > 0L) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getLogInputStream());){
                if (offset == bufferedInputStream.skip(offset)) {
                    int r;
                    do {
                        long l = start = (r = bufferedInputStream.read()) == -1 ? 0L : start + 1L;
                    } while (r != -1 && r != 10);
                }
            }
        }
        this.getLogText().writeHtmlTo(start, out.asWriter());
    }

    public void writeWholeLogTo(@NonNull OutputStream out) throws IOException, InterruptedException {
        long pos = 0L;
        AnnotatedLargeText logText = this.getLogText();
        pos = logText.writeLogTo(pos, out);
        while (!logText.isComplete()) {
            Thread.sleep(1000L);
            logText = this.getLogText();
            pos = logText.writeLogTo(pos, out);
        }
    }

    @NonNull
    public AnnotatedLargeText getLogText() {
        return new AnnotatedLargeText<Run>(this.getLogFile(), this.getCharset(), !this.isLogUpdated(), this);
    }

    @Override
    @NonNull
    protected SearchIndexBuilder makeSearchIndex() {
        SearchIndexBuilder builder = super.makeSearchIndex().add("console").add("changes");
        for (Action action : this.getAllActions()) {
            if (action.getIconFileName() == null) continue;
            builder.add(action.getUrlName());
        }
        return builder;
    }

    @NonNull
    public Api getApi() {
        return new Api(this);
    }

    @Override
    @NonNull
    public ACL getACL() {
        return ((Job)this.getParent()).getACL();
    }

    public synchronized void deleteArtifacts() throws IOException {
        try {
            this.getArtifactManager().delete();
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        Run run = this;
        synchronized (run) {
            if (this.isPendingDelete) {
                return;
            }
            this.isPendingDelete = true;
        }
        File rootDir = this.getRootDir();
        if (!rootDir.isDirectory()) {
            LOGGER.warning(String.format("%s: %s looks to have already been deleted, assuming build dir was already cleaned up", this, rootDir));
            RunListener.fireDeleted(this);
            Run run2 = this;
            synchronized (run2) {
                this.removeRunFromParent();
            }
            return;
        }
        RunListener.fireDeleted(this);
        if (this.artifactManager != null) {
            this.deleteArtifacts();
        }
        Run run3 = this;
        synchronized (run3) {
            File tmp = new File(rootDir.getParentFile(), "." + rootDir.getName());
            if (tmp.exists()) {
                Util.deleteRecursive(tmp);
            }
            try {
                Files.move(Util.fileToPath(rootDir), Util.fileToPath(tmp), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (SecurityException | UnsupportedOperationException ex) {
                throw new IOException(rootDir + " is in use", ex);
            }
            Util.deleteRecursive(tmp);
            if (tmp.exists()) {
                tmp.deleteOnExit();
            }
            LOGGER.log(Level.FINE, "{0}: {1} successfully deleted", new Object[]{this, rootDir});
            this.removeRunFromParent();
        }
    }

    private void removeRunFromParent() {
        ((Job)this.getParent()).removeRun((Run)this);
    }

    static void reportCheckpoint(@NonNull CheckPoint id) {
        RunExecution exec = RunnerStack.INSTANCE.peek();
        if (exec == null) {
            return;
        }
        exec.checkpoints.report(id);
    }

    static void waitForCheckpoint(@NonNull CheckPoint id, @CheckForNull BuildListener listener, @CheckForNull String waiter) throws InterruptedException {
        while (true) {
            RunExecution exec;
            if ((exec = RunnerStack.INSTANCE.peek()) == null) {
                return;
            }
            Object b = ((Run)exec.getBuild()).getPreviousBuildInProgress();
            if (b == null) {
                return;
            }
            RunExecution runner = ((Run)b).runner;
            if (runner == null) {
                Thread.sleep(0L);
                continue;
            }
            if (runner.checkpoints.waitForCheckPoint(id, listener, waiter)) break;
        }
    }

    @Deprecated
    protected final void run(@NonNull Runner job) {
        this.execute(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute(@NonNull RunExecution job) {
        if (this.result != null) {
            return;
        }
        OutputStream logger = null;
        StreamTaskListener listener = null;
        this.runner = job;
        this.onStartBuilding();
        try {
            long start = System.currentTimeMillis();
            try {
                try {
                    Computer computer = Computer.currentComputer();
                    Charset charset = null;
                    if (computer != null) {
                        charset = computer.getDefaultCharset();
                        this.charset = charset.name();
                    }
                    logger = this.createLogger();
                    listener = this.createBuildListener(job, logger, charset);
                    listener.started(this.getCauses());
                    Authentication auth = Jenkins.getAuthentication2();
                    if (auth.equals(ACL.SYSTEM2)) {
                        listener.getLogger().println(Messages.Run_running_as_SYSTEM());
                    } else {
                        User usr;
                        String id = auth.getName();
                        if (!auth.equals(Jenkins.ANONYMOUS2) && (usr = User.getById(id, false)) != null) {
                            id = ModelHyperlinkNote.encodeTo(usr);
                        }
                        listener.getLogger().println(Messages.Run_running_as_(id));
                    }
                    RunListener.fireStarted(this, listener);
                    this.setResult(job.run((BuildListener)((Object)listener)));
                    LOGGER.log(Level.FINE, "{0} main build action completed: {1}", new Object[]{this, this.result});
                    CheckPoint.MAIN_COMPLETED.report();
                }
                catch (AbortException e) {
                    this.result = Result.FAILURE;
                    listener.error(e.getMessage());
                    LOGGER.log(Level.FINE, "Build " + this + " aborted", e);
                }
                catch (RunnerAbortedException e) {
                    this.result = Result.FAILURE;
                    LOGGER.log(Level.FINE, "Build " + this + " aborted", e);
                }
                catch (InterruptedException e) {
                    this.result = Executor.currentExecutor().abortResult();
                    listener.getLogger().println(Messages.Run_BuildAborted());
                    Executor.currentExecutor().recordCauseOfInterruption(this, listener);
                    LOGGER.log(Level.INFO, this + " aborted", e);
                }
                catch (Throwable e) {
                    this.handleFatalBuildProblem((BuildListener)((Object)listener), e);
                    this.result = Result.FAILURE;
                }
                job.post((BuildListener)((Object)Objects.requireNonNull(listener)));
            }
            catch (Throwable e) {
                this.handleFatalBuildProblem((BuildListener)((Object)listener), e);
                this.result = Result.FAILURE;
            }
            finally {
                long end = System.currentTimeMillis();
                this.duration = Math.max(end - start, 0L);
                LOGGER.log(Level.FINER, "moving into POST_PRODUCTION on {0}", this);
                this.state = State.POST_PRODUCTION;
                if (listener != null) {
                    RunListener.fireCompleted(this, listener);
                    try {
                        job.cleanUp((BuildListener)((Object)listener));
                    }
                    catch (Exception e) {
                        this.handleFatalBuildProblem((BuildListener)((Object)listener), e);
                    }
                    listener.finished(this.result);
                    listener.closeQuietly();
                }
                try {
                    this.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to save build record", e);
                }
            }
            try {
                ((Job)this.getParent()).logRotate();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to rotate log", e);
            }
        }
        finally {
            this.onEndBuilding();
            if (logger != null) {
                try {
                    logger.close();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "failed to close log for " + this, x);
                }
            }
        }
    }

    private OutputStream createLogger() throws IOException {
        try {
            return Files.newOutputStream(this.getLogFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    private StreamBuildListener createBuildListener(@NonNull RunExecution job, OutputStream logger, Charset charset) throws IOException, InterruptedException {
        Object build = job.getBuild();
        for (ConsoleLogFilter filter : ConsoleLogFilter.all()) {
            logger = filter.decorateLogger((Run)build, logger);
        }
        if (this.project instanceof BuildableItemWithBuildWrappers && build instanceof AbstractBuild) {
            BuildableItemWithBuildWrappers biwbw = (BuildableItemWithBuildWrappers)this.project;
            for (BuildWrapper bw : biwbw.getBuildWrappersList()) {
                logger = bw.decorateLogger((AbstractBuild)build, logger);
            }
        }
        return new StreamBuildListener(logger, charset);
    }

    @Deprecated
    public final void updateSymlinks(@NonNull TaskListener listener) throws InterruptedException {
    }

    private void handleFatalBuildProblem(@NonNull BuildListener listener, @NonNull Throwable e) {
        if (listener != null) {
            LOGGER.log(Level.FINE, this.getDisplayName() + " failed to build", e);
            if (e instanceof IOException) {
                Util.displayIOException((IOException)e, listener);
            }
            Functions.printStackTrace(e, listener.fatalError(e.getMessage()));
        } else {
            LOGGER.log(Level.SEVERE, this.getDisplayName() + " failed to build and we don't even have a listener", e);
        }
    }

    protected void onStartBuilding() {
        LOGGER.log(Level.FINER, "moving to BUILDING on {0}", this);
        this.state = State.BUILDING;
        this.startTime = System.currentTimeMillis();
        if (this.runner != null) {
            RunnerStack.INSTANCE.push(this.runner);
        }
        RunListener.fireInitialize(this);
    }

    protected void onEndBuilding() {
        this.state = State.COMPLETED;
        LOGGER.log(Level.FINER, "moving to COMPLETED on {0}", this);
        if (this.runner != null) {
            this.runner.checkpoints.allDone();
            this.runner = null;
            RunnerStack.INSTANCE.pop();
        }
        if (this.result == null) {
            this.result = Result.FAILURE;
            LOGGER.log(Level.WARNING, "{0}: No build result is set, so marking as failure. This should not happen.", this);
        }
        RunListener.fireFinalized(this);
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        this.getDataFile().write(this);
        SaveableListener.fireOnChange(this, this.getDataFile());
    }

    @NonNull
    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getRootDir(), "build.xml"));
    }

    protected Object writeReplace() {
        return XmlFile.replaceIfNotAtTopLevel(this, () -> new Replacer(this));
    }

    @Deprecated
    @NonNull
    public String getLog() throws IOException {
        return Util.loadFile(this.getLogFile(), this.getCharset());
    }

    @NonNull
    public List<String> getLog(int maxLines) throws IOException {
        long filePointer;
        if (maxLines == 0) {
            return Collections.emptyList();
        }
        int lines = 0;
        ArrayList<String> lastLines = new ArrayList<String>(Math.min(maxLines, 128));
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        try (RandomAccessFile fileHandler = new RandomAccessFile(this.getLogFile(), "r");){
            long fileLength;
            for (filePointer = fileLength = fileHandler.length() - 1L; filePointer != -1L && maxLines != lines; --filePointer) {
                fileHandler.seek(filePointer);
                byte readByte = fileHandler.readByte();
                if (readByte == 10) {
                    if (filePointer >= fileLength) continue;
                    ++lines;
                    lastLines.add(this.convertBytesToString(bytes));
                    bytes.clear();
                    continue;
                }
                if (readByte == 13) continue;
                bytes.add(readByte);
            }
        }
        if (lines != maxLines) {
            lastLines.add(this.convertBytesToString(bytes));
        }
        Collections.reverse(lastLines);
        if (lines == maxLines) {
            lastLines.set(0, "[...truncated " + Functions.humanReadableByteSize(filePointer) + "...]");
        }
        return ConsoleNote.removeNotes(lastLines);
    }

    private String convertBytesToString(List<Byte> bytes) {
        Collections.reverse(bytes);
        Byte[] byteArray = bytes.toArray(new Byte[0]);
        return new String(ArrayUtils.toPrimitive((Byte[])byteArray), this.getCharset());
    }

    public void doBuildStatus(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/48x48/" + this.getBuildStatusUrl());
    }

    @NonNull
    public String getBuildStatusUrl() {
        return this.getIconColor().getImage();
    }

    public String getBuildStatusIconClassName() {
        return this.getIconColor().getIconClassName();
    }

    @NonNull
    public Summary getBuildStatusSummary() {
        if (this.isBuilding()) {
            return new Summary(false, Messages.Run_Summary_Unknown());
        }
        ResultTrend trend = ResultTrend.getResultTrend(this);
        for (StatusSummarizer summarizer : ExtensionList.lookup(StatusSummarizer.class)) {
            Summary summary = summarizer.summarize(this, trend);
            if (summary == null) continue;
            return summary;
        }
        switch (trend) {
            case ABORTED: {
                return new Summary(false, Messages.Run_Summary_Aborted());
            }
            case NOT_BUILT: {
                return new Summary(false, Messages.Run_Summary_NotBuilt());
            }
            case FAILURE: {
                return new Summary(true, Messages.Run_Summary_BrokenSinceThisBuild());
            }
            case STILL_FAILING: {
                RunT since = this.getPreviousNotFailedBuild();
                if (since == null) {
                    return new Summary(false, Messages.Run_Summary_BrokenForALongTime());
                }
                RunT failedBuild = ((Run)since).getNextBuild();
                return new Summary(false, Messages.Run_Summary_BrokenSince(((Run)failedBuild).getDisplayName()));
            }
            case NOW_UNSTABLE: 
            case STILL_UNSTABLE: {
                return new Summary(false, Messages.Run_Summary_Unstable());
            }
            case UNSTABLE: {
                return new Summary(true, Messages.Run_Summary_Unstable());
            }
            case SUCCESS: {
                return new Summary(false, Messages.Run_Summary_Stable());
            }
            case FIXED: {
                return new Summary(false, Messages.Run_Summary_BackToNormal());
            }
        }
        return new Summary(false, Messages.Run_Summary_Unknown());
    }

    @NonNull
    public DirectoryBrowserSupport doArtifact() {
        if (Functions.isArtifactsPermissionEnabled()) {
            this.checkPermission(ARTIFACTS);
        }
        return new DirectoryBrowserSupport((ModelObject)this, this.getArtifactManager().root(), Messages.Run_ArtifactsBrowserTitle(((AbstractItem)this.project).getDisplayName(), this.getDisplayName()), "package.png", true);
    }

    public void doBuildNumber(StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain");
        rsp.setCharacterEncoding("US-ASCII");
        rsp.setStatus(200);
        rsp.getWriter().print(this.number);
    }

    public void doBuildTimestamp(StaplerRequest req, StaplerResponse rsp, @QueryParameter String format) throws IOException {
        rsp.setContentType("text/plain");
        rsp.setCharacterEncoding("US-ASCII");
        rsp.setStatus(200);
        DateFormat df = format == null ? DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH) : new SimpleDateFormat(format, req.getLocale());
        rsp.getWriter().print(df.format(this.getTime()));
    }

    public void doConsoleText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain;charset=UTF-8");
        try (InputStream input = this.getLogInputStream();
             OutputStream os = rsp.getCompressedOutputStream((HttpServletRequest)req);
             PlainTextConsoleOutputStream out = new PlainTextConsoleOutputStream(os);){
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
    }

    @Deprecated
    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.getLogText().doProgressText(req, rsp);
    }

    public boolean canToggleLogKeep() {
        return this.keepLog || !this.isKeepLog();
    }

    @RequirePOST
    public void doToggleLogKeep(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.keepLog(!this.keepLog);
        rsp.forwardToPreviousPage(req);
    }

    @CLIMethod(name="keep-build")
    public final void keepLog() throws IOException {
        this.keepLog(true);
    }

    public void keepLog(boolean newValue) throws IOException {
        this.checkPermission(newValue ? UPDATE : DELETE);
        this.keepLog = newValue;
        this.save();
    }

    @RequirePOST
    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(DELETE);
        String why = this.getWhyKeepLog();
        if (why != null) {
            this.sendError(Messages.Run_UnableToDelete(this.getFullDisplayName(), why), req, rsp);
            return;
        }
        try {
            this.delete();
        }
        catch (IOException ex) {
            req.setAttribute("stackTraces", (Object)Functions.printThrowable(ex));
            req.getView((Object)this, "delete-retry.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        rsp.sendRedirect2(req.getContextPath() + "/" + ((AbstractItem)this.getParent()).getUrl());
    }

    public void setDescription(String description) throws IOException {
        this.checkPermission(UPDATE);
        this.description = description;
        this.save();
    }

    @RequirePOST
    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.setDescription(req.getParameter("description"));
        rsp.sendRedirect(".");
    }

    @Deprecated
    public Map<String, String> getEnvVars() {
        LOGGER.log(Level.WARNING, "deprecated call to Run.getEnvVars\n\tat {0}", new Throwable().getStackTrace()[1]);
        try {
            return this.getEnvironment(new LogTaskListener(LOGGER, Level.INFO));
        }
        catch (IOException | InterruptedException e) {
            return new EnvVars();
        }
    }

    @Deprecated
    public EnvVars getEnvironment() throws IOException, InterruptedException {
        LOGGER.log(Level.WARNING, "deprecated call to Run.getEnvironment\n\tat {0}", new Throwable().getStackTrace()[1]);
        return this.getEnvironment(new LogTaskListener(LOGGER, Level.INFO));
    }

    @NonNull
    public EnvVars getEnvironment(@NonNull TaskListener listener) throws IOException, InterruptedException {
        Computer c = Computer.currentComputer();
        Node n = c == null ? null : c.getNode();
        EnvVars env = ((Job)this.getParent()).getEnvironment(n, listener);
        env.putAll(this.getCharacteristicEnvVars());
        for (EnvironmentContributor ec : EnvironmentContributor.all().reverseView()) {
            ec.buildEnvironmentFor(this, env, listener);
        }
        if (!(this instanceof AbstractBuild)) {
            for (EnvironmentContributingAction a : this.getActions(EnvironmentContributingAction.class)) {
                a.buildEnvironment(this, env);
            }
        }
        return env;
    }

    @NonNull
    public final EnvVars getCharacteristicEnvVars() {
        EnvVars env = ((Job)this.getParent()).getCharacteristicEnvVars();
        env.put("BUILD_NUMBER", String.valueOf(this.number));
        env.put("BUILD_ID", this.getId());
        env.put("BUILD_TAG", "jenkins-" + ((AbstractItem)this.getParent()).getFullName().replace('/', '-') + "-" + this.number);
        return env;
    }

    @NonNull
    public String getExternalizableId() {
        return ((AbstractItem)this.project).getFullName() + "#" + this.getNumber();
    }

    @CheckForNull
    public static Run<?, ?> fromExternalizableId(String id) throws IllegalArgumentException, AccessDeniedException {
        int number;
        int hash = id.lastIndexOf(35);
        if (hash <= 0) {
            throw new IllegalArgumentException("Invalid id");
        }
        String jobName = id.substring(0, hash);
        try {
            number = Integer.parseInt(id.substring(hash + 1));
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(x);
        }
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return null;
        }
        Job job = j.getItemByFullName(jobName, Job.class);
        if (job == null) {
            return null;
        }
        return job.getBuildByNumber(number);
    }

    @Exported
    public long getEstimatedDuration() {
        return ((Job)this.project).getEstimatedDuration();
    }

    @POST
    @NonNull
    public HttpResponse doConfigSubmit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(UPDATE);
        try (BulkChange bc = new BulkChange(this);){
            JSONObject json = req.getSubmittedForm();
            this.submit(json);
            bc.commit();
        }
        return FormApply.success(".");
    }

    protected void submit(JSONObject json) throws IOException {
        this.setDisplayName(Util.fixEmptyAndTrim(json.getString("displayName")));
        this.setDescription(json.getString("description"));
    }

    @Override
    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Object returnedResult = super.getDynamic(token, req, rsp);
        if (returnedResult == null) {
            for (Action action : this.getTransientActions()) {
                String urlName = action.getUrlName();
                if (urlName == null || !urlName.equals(token)) continue;
                return action;
            }
            returnedResult = new RedirectUp();
        }
        return returnedResult;
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            if (!this.getParent().hasPermission(Item.DISCOVER)) {
                return null;
            }
            this.getParent().checkPermission(Item.READ);
        }
        return this;
    }

    static {
        XSTREAM.alias("build", FreeStyleBuild.class);
        XSTREAM.registerConverter(Result.conv);
        LOGGER = Logger.getLogger(Run.class.getName());
        ORDER_BY_DATE = new Comparator<Run>(){

            @Override
            public int compare(@NonNull Run lhs, @NonNull Run rhs) {
                long lt = lhs.getTimeInMillis();
                long rt = rhs.getTimeInMillis();
                return Long.compare(rt, lt);
            }
        };
        FEED_ADAPTER = new DefaultFeedAdapter();
        FEED_ADAPTER_LATEST = new DefaultFeedAdapter(){

            @Override
            public String getEntryID(Run e) {
                return "tag:hudson.dev.java.net,2008:" + ((AbstractItem)e.getParent()).getAbsoluteUrl();
            }
        };
        PERMISSIONS = new PermissionGroup(Run.class, Messages._Run_Permissions_Title());
        DELETE = new Permission(PERMISSIONS, "Delete", Messages._Run_DeletePermission_Description(), Permission.DELETE, PermissionScope.RUN);
        UPDATE = new Permission(PERMISSIONS, "Update", Messages._Run_UpdatePermission_Description(), Permission.UPDATE, PermissionScope.RUN);
        ARTIFACTS = new Permission(PERMISSIONS, "Artifacts", Messages._Run_ArtifactsPermission_Description(), null, Functions.isArtifactsPermissionEnabled(), new PermissionScope[]{PermissionScope.RUN});
        SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(Run.class.getName() + ".skipPermissionCheck");
    }

    public static class RedirectUp {
        public void doDynamic(StaplerResponse rsp) throws IOException {
            rsp.setStatus(404);
            rsp.setContentType("text/html;charset=UTF-8");
            PrintWriter out = rsp.getWriter();
            out.println("<html><head><meta http-equiv='refresh' content='1;url=..'/><script>window.location.replace('..');</script></head><body style='background-color:white; color:white;'>Not found</body></html>");
            out.flush();
        }
    }

    private static class DefaultFeedAdapter
    implements FeedAdapter<Run> {
        private DefaultFeedAdapter() {
        }

        @Override
        public String getEntryTitle(Run entry) {
            return entry.getFullDisplayName() + " (" + entry.getBuildStatusSummary().message + ")";
        }

        @Override
        public String getEntryUrl(Run entry) {
            return entry.getUrl();
        }

        @Override
        public String getEntryID(Run entry) {
            return "tag:hudson.dev.java.net," + entry.getTimestamp().get(1) + ":" + ((AbstractItem)entry.getParent()).getFullName() + ":" + entry.getId();
        }

        @Override
        public String getEntryDescription(Run entry) {
            return entry.getDescription();
        }

        @Override
        public Calendar getEntryTimestamp(Run entry) {
            return entry.getTimestamp();
        }

        @Override
        public String getEntryAuthor(Run entry) {
            return JenkinsLocationConfiguration.get().getAdminAddress();
        }
    }

    public final class KeepLogBuildBadge
    implements BuildBadgeAction {
        @Override
        @CheckForNull
        public String getIconFileName() {
            return null;
        }

        @Override
        @CheckForNull
        public String getDisplayName() {
            return null;
        }

        @Override
        @CheckForNull
        public String getUrlName() {
            return null;
        }

        @CheckForNull
        public String getWhyKeepLog() {
            return Run.this.getWhyKeepLog();
        }
    }

    public static abstract class StatusSummarizer
    implements ExtensionPoint {
        @CheckForNull
        public abstract Summary summarize(@NonNull Run<?, ?> var1, @NonNull ResultTrend var2);
    }

    public static class Summary {
        public boolean isWorse;
        public String message;

        public Summary(boolean worse, String message) {
            this.isWorse = worse;
            this.message = message;
        }
    }

    private static class Replacer {
        private final String id;

        Replacer(Run<?, ?> r) {
            this.id = r.getExternalizableId();
        }

        private Object readResolve() {
            return Run.fromExternalizableId(this.id);
        }
    }

    public static final class RunnerAbortedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public abstract class RunExecution {
        private final hudson.model.Run$RunExecution.CheckpointSet checkpoints = new CheckpointSet();
        private final Map<Object, Object> attributes = new HashMap<Object, Object>();

        @NonNull
        public abstract Result run(@NonNull BuildListener var1) throws Exception;

        public abstract void post(@NonNull BuildListener var1) throws Exception;

        public abstract void cleanUp(@NonNull BuildListener var1) throws Exception;

        @NonNull
        public RunT getBuild() {
            return Run.this._this();
        }

        @NonNull
        public JobT getProject() {
            return ((Run)Run.this._this()).getParent();
        }

        @NonNull
        public Map<Object, Object> getAttributes() {
            return this.attributes;
        }

        private final class CheckpointSet {
            private final Set<CheckPoint> checkpoints = new HashSet<CheckPoint>();
            private boolean allDone;

            private CheckpointSet() {
            }

            protected synchronized void report(@NonNull CheckPoint identifier) {
                this.checkpoints.add(identifier);
                this.notifyAll();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected synchronized boolean waitForCheckPoint(@NonNull CheckPoint identifier, @CheckForNull BuildListener listener, @CheckForNull String waiter) throws InterruptedException {
                Thread t = Thread.currentThread();
                String oldName = t.getName();
                t.setName(oldName + " : waiting for " + identifier + " on " + Run.this.getFullDisplayName() + " from " + waiter);
                try {
                    boolean first = true;
                    while (!this.allDone && !this.checkpoints.contains(identifier)) {
                        if (first && listener != null && waiter != null) {
                            listener.getLogger().println(Messages.Run__is_waiting_for_a_checkpoint_on_(waiter, Run.this.getFullDisplayName()));
                        }
                        this.wait();
                        first = false;
                    }
                    boolean bl = this.checkpoints.contains(identifier);
                    return bl;
                }
                finally {
                    t.setName(oldName);
                }
            }

            private synchronized void allDone() {
                this.allDone = true;
                this.notifyAll();
            }
        }
    }

    @Deprecated
    protected abstract class Runner
    extends RunExecution {
        protected Runner() {
        }
    }

    @ExportedBean
    public class Artifact {
        @Exported(visibility=3)
        public final String relativePath;
        String displayPath;
        private String name;
        private String href;
        private String treeNodeId;
        private String length;

        Artifact(SerializableArtifact clone) {
            this(clone.name, clone.relativePath, clone.href, clone.length, clone.treeNodeId);
        }

        Artifact(String name, String relativePath, String href, String len, String treeNodeId) {
            this.name = name;
            this.relativePath = relativePath;
            this.href = href;
            this.treeNodeId = treeNodeId;
            this.length = len;
        }

        @Deprecated
        @NonNull
        public File getFile() {
            return new File(Run.this.getArtifactsDir(), this.relativePath);
        }

        @Exported(visibility=3)
        public String getFileName() {
            return this.name;
        }

        @Exported(visibility=3)
        public String getDisplayPath() {
            return this.displayPath;
        }

        public String getHref() {
            return this.href;
        }

        public String getLength() {
            return this.length;
        }

        public long getFileSize() {
            try {
                return Long.decode(this.length);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, "Cannot determine file size of the artifact {0}. The length {1} is not a valid long value", new Object[]{this, this.length});
                return 0L;
            }
        }

        public String getTreeNodeId() {
            return this.treeNodeId;
        }

        public String toString() {
            return this.relativePath;
        }
    }

    public final class ArtifactList
    extends ArrayList<Artifact> {
        private static final long serialVersionUID = 1L;
        private LinkedHashMap<Artifact, String> tree = new LinkedHashMap();

        void updateFrom(SerializableArtifactList clone) {
            HashMap<String, Artifact> artifacts = new HashMap<String, Artifact>();
            for (SerializableArtifact serializableArtifact : clone) {
                Artifact a = new Artifact(serializableArtifact);
                artifacts.put(a.relativePath, a);
                this.add(a);
            }
            this.tree = new LinkedHashMap();
            for (Map.Entry entry : clone.tree.entrySet()) {
                SerializableArtifact sa = (SerializableArtifact)entry.getKey();
                Artifact a = (Artifact)artifacts.get(sa.relativePath);
                if (a == null) {
                    a = new Artifact(sa);
                }
                this.tree.put(a, (String)entry.getValue());
            }
        }

        public Map<Artifact, String> getTree() {
            return this.tree;
        }

        public void computeDisplayName() {
            boolean collision;
            if (this.size() > LIST_CUTOFF) {
                return;
            }
            int maxDepth = 0;
            int[] len = new int[this.size()];
            String[][] tokens = new String[this.size()][];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = ((Artifact)this.get((int)i)).relativePath.split("[\\\\/]+");
                maxDepth = Math.max(maxDepth, tokens[i].length);
                len[i] = 1;
            }
            int depth = 0;
            do {
                collision = false;
                HashMap<String, Integer> names = new HashMap<String, Integer>();
                for (int i = 0; i < tokens.length; ++i) {
                    String[] token = tokens[i];
                    String displayName = this.combineLast(token, len[i]);
                    Integer j = names.put(displayName, i);
                    if (j == null) continue;
                    collision = true;
                    if (j >= 0) {
                        int n = j;
                        len[n] = len[n] + 1;
                    }
                    int n = i;
                    len[n] = len[n] + 1;
                    names.put(displayName, -1);
                }
            } while (collision && depth++ < maxDepth);
            for (int i = 0; i < tokens.length; ++i) {
                ((Artifact)this.get((int)i)).displayPath = this.combineLast(tokens[i], len[i]);
            }
        }

        private String combineLast(String[] token, int n) {
            StringBuilder buf = new StringBuilder();
            for (int i = Math.max(0, token.length - n); i < token.length; ++i) {
                if (buf.length() > 0) {
                    buf.append('/');
                }
                buf.append(token[i]);
            }
            return buf.toString();
        }
    }

    private static final class SerializableArtifactList
    extends ArrayList<SerializableArtifact> {
        private static final long serialVersionUID = 1L;
        private LinkedHashMap<SerializableArtifact, String> tree = new LinkedHashMap();
        private int idSeq = 0;

        private SerializableArtifactList() {
        }
    }

    private static final class SerializableArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String name;
        final String relativePath;
        final String href;
        final String length;
        final String treeNodeId;

        SerializableArtifact(String name, String relativePath, String href, String length, String treeNodeId) {
            this.name = name;
            this.relativePath = relativePath;
            this.href = href;
            this.length = length;
            this.treeNodeId = treeNodeId;
        }
    }

    private static final class AddArtifacts
    extends MasterToSlaveCallable<SerializableArtifactList, IOException> {
        private static final long serialVersionUID = 1L;
        private final VirtualFile root;
        private final int artifactsNumber;

        AddArtifacts(VirtualFile root, int artifactsNumber) {
            this.root = root;
            this.artifactsNumber = artifactsNumber;
        }

        public SerializableArtifactList call() throws IOException {
            SerializableArtifactList sal = new SerializableArtifactList();
            Run.addArtifacts(this.root, "", "", sal, null, this.artifactsNumber);
            return sal;
        }
    }

    private static enum State {
        NOT_STARTED,
        BUILDING,
        POST_PRODUCTION,
        COMPLETED;

    }
}

