/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.extended.DynamicProxyConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.Fields;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.ReaderWrapper;
import com.thoughtworks.xstream.io.xml.StandardStaxDriver;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.AnyTypePermission;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Label;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.remoting.ClassFilter;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.PrettyPrintWriter;
import hudson.util.ReflectionUtils;
import hudson.util.RobustCollectionConverter;
import hudson.util.RobustMapConverter;
import hudson.util.RobustReflectionConverter;
import hudson.util.xstream.ImmutableListConverter;
import hudson.util.xstream.ImmutableMapConverter;
import hudson.util.xstream.ImmutableSetConverter;
import hudson.util.xstream.ImmutableSortedSetConverter;
import hudson.util.xstream.MapperDelegate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.xstream.SafeURLConverter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class XStream2
extends XStream {
    private static final Logger LOGGER = Logger.getLogger(XStream2.class.getName());
    @Restricted(value={NoExternalUse.class})
    public static final String COLLECTION_UPDATE_LIMIT_PROPERTY_NAME = XStream2.class.getName() + ".collectionUpdateLimit";
    private static final int COLLECTION_UPDATE_LIMIT_DEFAULT_VALUE = 5;
    private RobustReflectionConverter reflectionConverter;
    private final ThreadLocal<Boolean> oldData = new ThreadLocal();
    @CheckForNull
    private final ClassOwnership classOwnership;
    private final Map<String, Class<?>> compatibilityAliases = new ConcurrentHashMap();
    private MapperInjectionPoint mapperInjectionPoint;

    public static HierarchicalStreamDriver getDefaultDriver() {
        return new StaxDriver();
    }

    public XStream2() {
        super(XStream2.getDefaultDriver());
        this.init();
        this.classOwnership = null;
    }

    public XStream2(HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(hierarchicalStreamDriver);
        this.init();
        this.classOwnership = null;
    }

    public XStream2(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        super(reflectionProvider, driver, classLoaderReference, mapper, converterLookup, converterRegistry);
        this.init();
        this.classOwnership = null;
    }

    XStream2(ClassOwnership classOwnership) {
        super(XStream2.getDefaultDriver());
        this.init();
        this.classOwnership = classOwnership;
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        return this.unmarshal(reader, root, dataHolder, false);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder, boolean nullOut) {
        Object o;
        Jenkins h = Jenkins.getInstanceOrNull();
        if (h != null && h.pluginManager != null && h.pluginManager.uberClassLoader != null) {
            this.setClassLoader(h.pluginManager.uberClassLoader);
        }
        if (root == null || !nullOut) {
            o = super.unmarshal(reader, root, dataHolder);
        } else {
            final HashSet topLevelFields = new HashSet();
            o = super.unmarshal((HierarchicalStreamReader)new ReaderWrapper(reader){
                int depth;

                public void moveUp() {
                    if (--this.depth == 0) {
                        topLevelFields.add(this.getNodeName());
                    }
                    super.moveUp();
                }

                public void moveDown() {
                    try {
                        super.moveDown();
                    }
                    finally {
                        ++this.depth;
                    }
                }
            }, root, dataHolder);
            if (o == root && this.getConverterLookup().lookupConverterForType(o.getClass()) instanceof RobustReflectionConverter) {
                this.getReflectionProvider().visitSerializableFields(o, (name, type, definedIn, value) -> {
                    Object v;
                    if (topLevelFields.contains(name)) {
                        return;
                    }
                    Field f = Fields.find((Class)definedIn, (String)name);
                    if (type.isPrimitive()) {
                        v = ReflectionUtils.getVmDefaultValueForPrimitiveType(type);
                        if (v.equals(value)) {
                            return;
                        }
                    } else {
                        if (value == null) {
                            return;
                        }
                        v = null;
                    }
                    LOGGER.log(Level.FINE, "JENKINS-21017: nulling out {0} in {1}", new Object[]{f, o});
                    Fields.write((Field)f, (Object)o, (Object)v);
                });
            }
        }
        if (this.oldData.get() != null) {
            this.oldData.remove();
            if (o instanceof Saveable) {
                OldDataMonitor.report((Saveable)o, "1.106");
            }
        }
        return o;
    }

    protected void setupConverters() {
        super.setupConverters();
        this.reflectionConverter = new RobustReflectionConverter(this.getMapper(), JVM.newReflectionProvider(), new PluginClassOwnership());
        this.registerConverter(this.reflectionConverter, -19);
    }

    public void addCriticalField(Class<?> clazz, String field) {
        this.reflectionConverter.addCriticalField(clazz, field);
    }

    static String trimVersion(String version) {
        return version.replaceFirst(" .+$", "");
    }

    private void init() {
        int updateLimit = SystemProperties.getInteger(COLLECTION_UPDATE_LIMIT_PROPERTY_NAME, 5);
        this.setCollectionUpdateLimit(updateLimit);
        this.addImmutableType(Result.class, false);
        this.denyTypes(new Class[]{Void.TYPE, Void.class});
        this.registerConverter((Converter)new RobustCollectionConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new RobustMapConverter(this.getMapper()), 10);
        this.registerConverter((Converter)new ImmutableMapConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new ImmutableSortedSetConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new ImmutableSetConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new ImmutableListConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new CopyOnWriteMap.Tree.ConverterImpl(this.getMapper()), 10);
        this.registerConverter((Converter)new DescribableList.ConverterImpl(this.getMapper()), 10);
        this.registerConverter(new Label.ConverterImpl(), 10);
        this.registerConverter((SingleValueConverter)new SafeURLConverter(), 10);
        this.registerConverter(new AssociatedConverterImpl(this), -10);
        this.registerConverter(new BlacklistedTypesConverter(), 10000);
        this.addPermission(AnyTypePermission.ANY);
        this.registerConverter((Converter)new DynamicProxyConverter(this.getMapper(), new ClassLoaderReference(this.getClassLoader())){

            public boolean canConvert(Class type) {
                return type != null && super.canConvert(type);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                throw new ConversionException("<dynamic-proxy> not supported");
            }
        }, 10000);
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        CompatibilityMapper m = new CompatibilityMapper((Mapper)new MapperWrapper((Mapper)next){

            public String serializedClass(Class type) {
                if (type != null && ImmutableMap.class.isAssignableFrom(type)) {
                    return super.serializedClass(ImmutableMap.class);
                }
                if (type != null && ImmutableList.class.isAssignableFrom(type)) {
                    return super.serializedClass(ImmutableList.class);
                }
                return super.serializedClass(type);
            }
        });
        this.mapperInjectionPoint = new MapperInjectionPoint((Mapper)m);
        return this.mapperInjectionPoint;
    }

    public Mapper getMapperInjectionPoint() {
        return this.mapperInjectionPoint.getDelegate();
    }

    @Deprecated
    public void toXML(Object obj, OutputStream out) {
        super.toXML(obj, out);
    }

    public void toXMLUTF8(Object obj, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        w.write("<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n");
        this.toXML(obj, w);
    }

    public void setMapper(Mapper m) {
        this.mapperInjectionPoint.setDelegate(m);
    }

    public void addCompatibilityAlias(String oldClassName, Class newClass) {
        this.compatibilityAliases.put(oldClassName, newClass);
    }

    private static class BlacklistedTypesConverter
    implements Converter {
        private BlacklistedTypesConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            throw new UnsupportedOperationException("Refusing to marshal " + source.getClass().getName() + " for security reasons; see https://www.jenkins.io/redirect/class-filter/");
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            throw new ConversionException("Refusing to unmarshal " + reader.getNodeName() + " for security reasons; see https://www.jenkins.io/redirect/class-filter/");
        }

        public boolean canConvert(Class type) {
            if (type == null) {
                return false;
            }
            String name = type.getName();
            return ClassFilter.DEFAULT.isBlacklisted(name) || ClassFilter.DEFAULT.isBlacklisted(type);
        }
    }

    class PluginClassOwnership
    implements ClassOwnership {
        private PluginManager pm;

        PluginClassOwnership() {
        }

        @Override
        public String ownerOf(Class<?> clazz) {
            Jenkins j;
            if (XStream2.this.classOwnership != null) {
                return XStream2.this.classOwnership.ownerOf(clazz);
            }
            if (this.pm == null && (j = Jenkins.getInstanceOrNull()) != null) {
                this.pm = j.getPluginManager();
            }
            if (this.pm == null) {
                return null;
            }
            PluginWrapper p = this.pm.whichPlugin(clazz);
            return p != null ? p.getShortName() + "@" + XStream2.trimVersion(p.getVersion()) : null;
        }
    }

    static interface ClassOwnership {
        @CheckForNull
        public String ownerOf(Class<?> var1);
    }

    public static abstract class PassthruConverter<T>
    implements Converter {
        private Converter converter;

        protected PassthruConverter(XStream2 xstream) {
            this.converter = xstream.reflectionConverter;
        }

        public boolean canConvert(Class type) {
            return false;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            this.converter.marshal(source, writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Object obj = this.converter.unmarshal(reader, context);
            this.callback(obj, context);
            return obj;
        }

        protected abstract void callback(T var1, UnmarshallingContext var2);
    }

    private static final class AssociatedConverterImpl
    implements Converter {
        private final XStream xstream;
        private static final ClassValue<Class<? extends ConverterMatcher>> classCache = new ClassValue<Class<? extends ConverterMatcher>>(){

            @Override
            protected Class<? extends ConverterMatcher> computeValue(Class<?> type) {
                return AssociatedConverterImpl.computeConverterClass(type);
            }
        };
        private final ConcurrentHashMap<Class<?>, Converter> cache = new ConcurrentHashMap();

        private AssociatedConverterImpl(XStream xstream) {
            this.xstream = xstream;
        }

        @CheckForNull
        private Converter findConverter(@CheckForNull Class<?> t) {
            if (t == null) {
                return null;
            }
            Converter result = this.cache.computeIfAbsent(t, unused -> this.computeConverter(t));
            return result == this ? null : result;
        }

        @CheckForNull
        private static Class<? extends ConverterMatcher> computeConverterClass(@NonNull Class<?> t) {
            try {
                ClassLoader classLoader = t.getClassLoader();
                if (classLoader == null) {
                    return null;
                }
                String name = t.getName() + "$ConverterImpl";
                if (classLoader.getResource(name.replace('.', '/') + ".class") == null) {
                    return null;
                }
                return classLoader.loadClass(name).asSubclass(ConverterMatcher.class);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        @CheckForNull
        private Converter computeConverter(@NonNull Class<?> t) {
            Class<? extends ConverterMatcher> cl = classCache.get(t);
            if (cl == null) {
                return this;
            }
            try {
                Constructor<?> c = cl.getConstructors()[0];
                Class<?>[] p = c.getParameterTypes();
                Object[] args = new Object[p.length];
                for (int i = 0; i < p.length; ++i) {
                    if (p[i] == XStream.class || p[i] == XStream2.class) {
                        args[i] = this.xstream;
                        continue;
                    }
                    if (p[i] == Mapper.class) {
                        args[i] = this.xstream.getMapper();
                        continue;
                    }
                    throw new InstantiationError("Unrecognized constructor parameter: " + p[i]);
                }
                ConverterMatcher cm = (ConverterMatcher)c.newInstance(args);
                return cm instanceof SingleValueConverter ? new SingleValueConverterWrapper((SingleValueConverter)cm) : (Converter)cm;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
            catch (InstantiationException | InvocationTargetException e) {
                InstantiationError x = new InstantiationError();
                x.initCause(e);
                throw x;
            }
        }

        public boolean canConvert(Class type) {
            return this.findConverter(type) != null;
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            this.findConverter(source.getClass()).marshal(source, writer, context);
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return this.findConverter(context.getRequiredType()).unmarshal(reader, context);
        }
    }

    private class CompatibilityMapper
    extends MapperWrapper {
        private CompatibilityMapper(Mapper wrapped) {
            super(wrapped);
        }

        public Class realClass(String elementName) {
            Class<?> s = XStream2.this.compatibilityAliases.get(elementName);
            if (s != null) {
                return s;
            }
            try {
                return super.realClass(elementName);
            }
            catch (CannotResolveClassException e) {
                if (elementName.indexOf(45) >= 0) {
                    try {
                        Class c = super.realClass(elementName.replace('-', '$'));
                        XStream2.this.oldData.set(Boolean.TRUE);
                        return c;
                    }
                    catch (CannotResolveClassException cannotResolveClassException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }

    static final class MapperInjectionPoint
    extends MapperDelegate {
        MapperInjectionPoint(Mapper wrapped) {
            super(wrapped);
        }

        public Mapper getDelegate() {
            return this.delegate;
        }

        public void setDelegate(Mapper m) {
            this.delegate = m;
        }
    }

    private static class StaxDriver
    extends StandardStaxDriver {
        private StaxDriver() {
        }

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new PrettyPrintWriter(out, PrettyPrintWriter.XML_1_1, this.getNameCoder());
        }

        public HierarchicalStreamWriter createWriter(OutputStream out) {
            return this.createWriter(new OutputStreamWriter(out, Charset.defaultCharset()));
        }

        protected XMLInputFactory createInputFactory() {
            XMLInputFactory instance = XMLInputFactory.newInstance();
            instance.setProperty("javax.xml.stream.isNamespaceAware", false);
            instance.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            return instance;
        }

        protected XMLOutputFactory createOutputFactory() {
            return XMLOutputFactory.newInstance();
        }
    }
}

