/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.UnprotectedRootAction;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.HMACConfidentialKey;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.util.SystemProperties;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Extension
@Restricted(value={NoExternalUse.class})
public class ResourceDomainRootAction
implements UnprotectedRootAction {
    private static final String RESOURCE_DOMAIN_ROOT_ACTION_ERROR = "jenkins.security.ResourceDomainRootAction.error";
    private static final Logger LOGGER = Logger.getLogger(ResourceDomainRootAction.class.getName());
    public static final String URL = "static-files";
    private static HMACConfidentialKey KEY = new HMACConfidentialKey(ResourceDomainRootAction.class, "key");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static int VALID_FOR_MINUTES = SystemProperties.getInteger(ResourceDomainRootAction.class.getName() + ".validForMinutes", 30);

    @Override
    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @Override
    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @Override
    @CheckForNull
    public String getUrlName() {
        return URL;
    }

    public static ResourceDomainRootAction get() {
        return ExtensionList.lookupSingleton(ResourceDomainRootAction.class);
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ResourceDomainConfiguration.isResourceRequest((HttpServletRequest)req)) {
            rsp.sendError(404, "Jenkins serves only static files on this domain.");
        } else {
            req.setAttribute(RESOURCE_DOMAIN_ROOT_ACTION_ERROR, (Object)true);
            rsp.sendError(404, "Cannot handle requests to this URL unless on Jenkins resource URL.");
        }
    }

    public Object getDynamic(String id, StaplerRequest req, StaplerResponse rsp) throws Exception {
        if (!ResourceDomainConfiguration.isResourceRequest((HttpServletRequest)req)) {
            req.setAttribute(RESOURCE_DOMAIN_ROOT_ACTION_ERROR, (Object)true);
            rsp.sendError(404, "Cannot handle requests to this URL unless on Jenkins resource URL.");
            return null;
        }
        Token token = Token.decode(id);
        if (token == null) {
            rsp.sendError(404, "Jenkins serves only static files on this domain.");
            return null;
        }
        String authenticationName = token.username;
        String browserUrl = token.path;
        if (token.timestamp.plus((long)VALID_FOR_MINUTES, ChronoUnit.MINUTES).isAfter(Instant.now()) && token.timestamp.isBefore(Instant.now())) {
            return new InternalResourceRequest(browserUrl, authenticationName);
        }
        return new Redirection(browserUrl);
    }

    public String getRedirectUrl(@NonNull Token token, @NonNull String restOfPath) {
        String resourceRootUrl = ResourceDomainRootAction.getResourceRootUrl();
        if (!((String)restOfPath).startsWith("/")) {
            restOfPath = "/" + (String)restOfPath;
        }
        return resourceRootUrl + this.getUrlName() + "/" + token.encode() + Arrays.stream(((String)restOfPath).split("[/]")).map(Util::rawEncode).collect(Collectors.joining("/"));
    }

    private static String getResourceRootUrl() {
        return ResourceDomainConfiguration.get().getUrl();
    }

    @CheckForNull
    public Token getToken(@NonNull DirectoryBrowserSupport dbs, @NonNull StaplerRequest req) {
        String dbsFile = req.getOriginalRestOfPath();
        String completeUrl = ((Ancestor)req.getAncestors().get(0)).getRestOfUrl();
        String dbsUrl = completeUrl.substring(0, completeUrl.length() - dbsFile.length());
        LOGGER.fine(() -> "Determined DBS URL: " + dbsUrl + " from restOfUrl: " + completeUrl + " and restOfPath: " + dbsFile);
        Authentication authentication = Jenkins.getAuthentication2();
        String authenticationName = authentication.equals(Jenkins.ANONYMOUS2) ? "" : authentication.getName();
        try {
            return new Token(dbsUrl, authenticationName, Instant.now());
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.WARNING, "Failed to encode token for URL: " + dbsUrl + " user: " + authenticationName, ex);
            return null;
        }
    }

    public static class Token {
        private String path;
        private String username;
        private Instant timestamp;

        @VisibleForTesting
        Token(@NonNull String path, @Nullable String username, @NonNull Instant timestamp) {
            this.path = path;
            this.username = Util.fixNull(username);
            this.timestamp = timestamp;
        }

        private String encode() {
            String value = this.timestamp.toEpochMilli() + ":" + this.username.length() + ":" + this.username + ":" + this.path;
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            byte[] byteValue = ArrayUtils.addAll((byte[])KEY.mac(valueBytes), (byte[])valueBytes);
            return Base64.getUrlEncoder().encodeToString(byteValue);
        }

        private static Token decode(String value) {
            try {
                byte[] byteValue = Base64.getUrlDecoder().decode(value);
                byte[] mac = Arrays.copyOf(byteValue, 32);
                byte[] restBytes = Arrays.copyOfRange(byteValue, 32, byteValue.length);
                String rest = new String(restBytes, StandardCharsets.UTF_8);
                if (!KEY.checkMac(restBytes, mac)) {
                    throw new IllegalArgumentException("Failed mac check for " + rest);
                }
                String[] splits = rest.split("[:]", 3);
                String epoch = splits[0];
                int authenticationNameLength = Integer.parseInt(splits[1]);
                String authenticationNameAndBrowserUrl = splits[2];
                String authenticationName = authenticationNameAndBrowserUrl.substring(0, authenticationNameLength);
                String browserUrl = authenticationNameAndBrowserUrl.substring(authenticationNameLength + 1);
                return new Token(browserUrl, authenticationName, Instant.ofEpochMilli(Long.parseLong(epoch)));
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.FINE, "Failure decoding", ex);
                return null;
            }
        }
    }

    private static class InternalResourceRequest {
        private final String authenticationName;
        private final String browserUrl;

        InternalResourceRequest(@NonNull String browserUrl, @NonNull String authenticationName) {
            this.browserUrl = browserUrl;
            this.authenticationName = authenticationName;
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException {
            User user;
            String restOfPath = req.getRestOfPath();
            String requestUrlSuffix = this.browserUrl;
            LOGGER.fine(() -> "Performing a request as authentication: " + this.authenticationName + " and restOfUrl: " + requestUrlSuffix + " and restOfPath: " + restOfPath);
            Authentication auth = Jenkins.ANONYMOUS2;
            if (Util.fixEmpty(this.authenticationName) != null && (user = User.getById(this.authenticationName, false)) != null) {
                try {
                    auth = user.impersonate2();
                    LOGGER.fine(() -> "Successfully impersonated " + this.authenticationName);
                }
                catch (UsernameNotFoundException ex) {
                    LOGGER.log(Level.FINE, "Failed to impersonate " + this.authenticationName, ex);
                    rsp.sendError(403, "No such user: " + this.authenticationName);
                    return;
                }
            }
            try (ACLContext ignored = ACL.as2(auth);){
                try {
                    String path = requestUrlSuffix + Arrays.stream(restOfPath.split("[/]")).map(Util::rawEncode).collect(Collectors.joining("/"));
                    Stapler.getCurrent().invoke((HttpServletRequest)req, (HttpServletResponse)rsp, (Object)Jenkins.get(), path);
                }
                catch (Exception ex) {
                    for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof AccessDeniedException)) continue;
                        throw (AccessDeniedException)cause;
                    }
                    throw ex;
                }
            }
            catch (AccessDeniedException ade) {
                LOGGER.log(Level.FINE, "Failed permission check for resource URL access", ade);
                rsp.sendError(403, "Failed permission check: " + ade.getMessage());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Something else failed for resource URL access", e);
                rsp.sendError(404);
            }
        }

        public String toString() {
            return "[" + super.toString() + ", authentication=" + this.authenticationName + "; key=" + this.browserUrl + "]";
        }
    }

    private static class Redirection {
        private final String url;

        private Redirection(String url) {
            this.url = url;
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException {
            String restOfPath = req.getRestOfPath();
            String url = Jenkins.get().getRootUrl() + this.url + restOfPath;
            rsp.sendRedirect(302, url);
        }
    }
}

