/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import hudson.util.StreamTaskListener;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.Timer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.durabletask.AgentInfo;
import org.jenkinsci.plugins.durabletask.BourneShellScript;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.durabletask.Handler;
import org.jenkinsci.remoting.util.IOUtils;

public abstract class FileMonitoringTask
extends DurableTask {
    private static final Logger LOGGER = Logger.getLogger(FileMonitoringTask.class.getName());
    protected static final String COOKIE = "JENKINS_SERVER_COOKIE";
    protected static final String BINARY_RESOURCE_PREFIX = "/io/jenkins/plugins/lib-durable-task/durable_task_monitor_";
    private static final String SYSTEM_DEFAULT_CHARSET = "SYSTEM_DEFAULT";
    @CheckForNull
    private String charset;

    private static String cookieFor(FilePath workspace, boolean old) {
        return String.format("durable-%s", old ? Util.getDigestOf((String)workspace.getRemote()) : FileMonitoringTask.digest(workspace.getRemote()));
    }

    private static String cookieFor(FilePath workspace) {
        return FileMonitoringTask.cookieFor(workspace, false);
    }

    private static String digest(String text) {
        try {
            return Util.toHexString((byte[])MessageDigest.getInstance("SHA-256").digest(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    @Override
    public final Controller launch(EnvVars env, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        FileMonitoringController controller = this.launchWithCookie(workspace, launcher, listener, env, COOKIE, FileMonitoringTask.cookieFor(workspace));
        controller.charset = this.charset;
        return controller;
    }

    protected FileMonitoringController launchWithCookie(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        envVars.put(cookieVariable, cookieValue);
        return this.doLaunch(workspace, launcher, listener, envVars);
    }

    @Override
    public final void charset(Charset cs) {
        this.charset = cs.name();
    }

    @Override
    public final void defaultCharset() {
        this.charset = SYSTEM_DEFAULT_CHARSET;
    }

    @CheckForNull
    final String getCharset() {
        return this.charset;
    }

    protected FileMonitoringController doLaunch(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        throw new AbstractMethodError("override either doLaunch or launchWithCookie");
    }

    protected static Map<String, String> escape(EnvVars envVars) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (Map.Entry entry : envVars.entrySet()) {
            m.put((String)entry.getKey(), ((String)entry.getValue()).replace("$", "$$"));
        }
        return m;
    }

    protected static FilePath getNodeRoot(FilePath workspace) throws IOException {
        Computer computer = workspace.toComputer();
        if (computer == null) {
            throw new IOException("Unable to retrieve computer for workspace");
        }
        Node node = computer.getNode();
        if (node == null) {
            throw new IOException("Unable to retrieve node for workspace");
        }
        FilePath nodeRoot = node.getRootPath();
        if (nodeRoot == null) {
            throw new IOException("Unable to retrieve root path of node");
        }
        return nodeRoot;
    }

    protected static AgentInfo getAgentInfo(FilePath nodeRoot) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.get();
        PluginWrapper durablePlugin = jenkins.getPluginManager().getPlugin("durable-task");
        if (durablePlugin == null) {
            throw new IOException("Unable to find durable task plugin");
        }
        String pluginVersion = StringUtils.substringBefore((String)durablePlugin.getVersion(), (String)"-");
        AgentInfo agentInfo = (AgentInfo)nodeRoot.act((FilePath.FileCallable)new AgentInfo.GetAgentInfo(pluginVersion));
        return agentInfo;
    }

    @CheckForNull
    protected static FilePath requestBinary(FilePath ws, FileMonitoringController c) throws IOException, InterruptedException {
        FilePath nodeRoot = FileMonitoringTask.getNodeRoot(ws);
        AgentInfo agentInfo = FileMonitoringTask.getAgentInfo(nodeRoot);
        return FileMonitoringTask.requestBinary(nodeRoot, agentInfo, ws, c);
    }

    @CheckForNull
    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"}, justification="TODO needs triage")
    protected static FilePath requestBinary(FilePath nodeRoot, AgentInfo agentInfo, FilePath ws, FileMonitoringController c) throws IOException, InterruptedException {
        FilePath binary;
        block10: {
            binary = null;
            if (agentInfo.isBinaryCompatible()) {
                FilePath controlDir = c.controlDir(ws);
                binary = agentInfo.isCachingAvailable() ? nodeRoot.child(agentInfo.getBinaryPath()) : controlDir.child(agentInfo.getBinaryPath());
                String resourcePath = BINARY_RESOURCE_PREFIX + agentInfo.getOs().getNameForBinary() + "_" + agentInfo.getArchitecture();
                if (agentInfo.getOs() == AgentInfo.OsType.WINDOWS) {
                    resourcePath = resourcePath + ".exe";
                }
                try (InputStream binaryStream = BourneShellScript.class.getResourceAsStream(resourcePath);){
                    if (binaryStream != null) {
                        if (!agentInfo.isCachingAvailable() || !agentInfo.isBinaryCached()) {
                            binary.copyFrom(binaryStream);
                            binary.chmod(493);
                        }
                        break block10;
                    }
                    FilePath filePath = null;
                    return filePath;
                }
            }
        }
        return binary;
    }

    private static boolean isClosedChannelException(Throwable t) {
        if (t instanceof ClosedChannelException) {
            return true;
        }
        if (t instanceof ChannelClosedException) {
            return true;
        }
        if (t instanceof EOFException) {
            return true;
        }
        if (t == null) {
            return false;
        }
        return FileMonitoringTask.isClosedChannelException(t.getCause()) || Stream.of(t.getSuppressed()).anyMatch(FileMonitoringTask::isClosedChannelException);
    }

    private static class Watcher
    implements Runnable {
        private final FileMonitoringController controller;
        private final FilePath workspace;
        private final Handler handler;
        private final TaskListener listener;
        @CheckForNull
        private final Charset cs;
        private long lastLocation = -1L;

        Watcher(FileMonitoringController controller, FilePath workspace, Handler handler, TaskListener listener) {
            LOGGER.log(Level.FINE, "starting " + this, new Throwable());
            this.controller = controller;
            this.workspace = workspace;
            this.handler = handler;
            this.listener = listener;
            this.cs = FileMonitoringController.transcodingCharset(controller.charset);
            LOGGER.log(Level.FINE, "remote transcoding charset: {0}", this.cs);
        }

        @Override
        public void run() {
            try {
                Integer exitStatus = this.controller.exitStatus(this.workspace, this.listener);
                if (this.lastLocation == -1L) {
                    FilePath lastLocationFile = this.controller.getLastLocationFile(this.workspace);
                    if (lastLocationFile.exists()) {
                        this.lastLocation = Long.parseLong(lastLocationFile.readToString());
                        LOGGER.finest(() -> "Loaded lastLocation=" + this.lastLocation);
                    } else {
                        this.lastLocation = 0L;
                        LOGGER.finest("New watch, lastLocation=0");
                    }
                } else {
                    LOGGER.finest(() -> "Using cached lastLocation=" + this.lastLocation);
                }
                FilePath logFile = this.controller.getLogFile(this.workspace);
                long len = logFile.length();
                if (len > this.lastLocation) {
                    assert (!logFile.isRemote());
                    try (FileChannel ch = FileChannel.open(Paths.get(logFile.getRemote(), new String[0]), StandardOpenOption.READ);){
                        InputStream locallyEncodedStream = Channels.newInputStream(ch.position(this.lastLocation));
                        InputStream utf8EncodedStream = this.cs == null ? locallyEncodedStream : new ReaderInputStream((Reader)new InputStreamReader(locallyEncodedStream, this.cs), StandardCharsets.UTF_8);
                        this.handler.output(utf8EncodedStream);
                        long newLocation = ch.position();
                        this.controller.getLastLocationFile(this.workspace).write(Long.toString(newLocation), null);
                        long delta = newLocation - this.lastLocation;
                        LOGGER.finer(() -> this + " copied " + delta + " bytes from " + logFile);
                        this.lastLocation = newLocation;
                    }
                }
                if (exitStatus != null) {
                    byte[] output = this.controller.getOutputFile(this.workspace).exists() ? this.controller.getOutput(this.workspace) : null;
                    LOGGER.fine(() -> this + " exiting with code " + exitStatus);
                    this.handler.exited(exitStatus, output);
                    this.controller.cleanup(this.workspace);
                } else {
                    if (!this.controller.controlDir(this.workspace).isDirectory()) {
                        LOGGER.log(Level.WARNING, "giving up on watching nonexistent {0}", this.controller.controlDir);
                        this.controller.cleanup(this.workspace);
                        return;
                    }
                    Timer.get().schedule(this, 100L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception x) {
                if (FileMonitoringTask.isClosedChannelException(x)) {
                    LOGGER.warning(() -> this + " giving up on watching " + this.controller.controlDir);
                }
                LOGGER.log(Level.WARNING, this + " giving up on watching " + this.controller.controlDir, x);
            }
        }
    }

    private static class StartWatching
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final FileMonitoringController controller;
        private final Handler handler;
        private final TaskListener listener;

        StartWatching(FileMonitoringController controller, Handler handler, TaskListener listener) {
            this.controller = controller;
            this.handler = handler;
            this.listener = listener;
        }

        public Void invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
            Timer.get().submit(new Watcher(this.controller, new FilePath(workspace), this.handler, this.listener));
            return null;
        }
    }

    protected static class FileMonitoringController
    extends Controller {
        String controlDir;
        private String id;
        private long lastLocation;
        private String cookieValue;
        @CheckForNull
        private String charset;
        private transient List<Closeable> cleanupList;
        private volatile transient Charset writeLogCs;
        static final StatusCheck STATUS_CHECK_INSTANCE = new StatusCheck();
        private static final long serialVersionUID = 1L;

        String getCharset() {
            return this.charset;
        }

        void registerForCleanup(Closeable c) {
            if (this.cleanupList == null) {
                this.cleanupList = new LinkedList<Closeable>();
            }
            this.cleanupList.add(c);
        }

        protected FileMonitoringController(FilePath ws, @NonNull String cookieValue) throws IOException, InterruptedException {
            this.setupControlDir(ws);
            this.cookieValue = cookieValue;
        }

        @Deprecated
        protected FileMonitoringController(FilePath ws) throws IOException, InterruptedException {
            this.setupControlDir(ws);
            this.cookieValue = FileMonitoringTask.cookieFor(ws, true);
        }

        private void setupControlDir(FilePath ws) throws IOException, InterruptedException {
            FilePath tmpDir;
            ws.mkdirs();
            FilePath filePath = tmpDir = ws.getParent() != null ? WorkspaceList.tempDir((FilePath)ws) : null;
            if (tmpDir != null) {
                FilePath cd = tmpDir.child("durable-" + Util.getDigestOf((String)UUID.randomUUID().toString()).substring(0, 8));
                cd.mkdirs();
                this.controlDir = cd.getRemote();
            } else {
                this.controlDir = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean writeLog(FilePath workspace, OutputStream sink) throws IOException, InterruptedException {
            boolean bl;
            OutputStream transcodedSink;
            if (this.writeLogCs == null) {
                String cs;
                this.writeLogCs = FileMonitoringTask.SYSTEM_DEFAULT_CHARSET.equals(this.charset) ? ((cs = (String)workspace.act((Callable)new TranscodingCharsetForSystemDefault())) == null ? null : Charset.forName(cs)) : FileMonitoringController.transcodingCharset(this.charset);
                LOGGER.log(Level.FINER, "remote transcoding charset: {0}", this.writeLogCs);
            }
            FilePath log = this.getLogFile(workspace);
            if (this.writeLogCs == null) {
                transcodedSink = sink;
            } else {
                CharsetDecoder decoder = this.writeLogCs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                transcodedSink = new WriterOutputStream((Writer)new OutputStreamWriter(sink, StandardCharsets.UTF_8), decoder, 1024, true);
            }
            CountingOutputStream cos = new CountingOutputStream(transcodedSink);
            try {
                log.act((FilePath.FileCallable)new WriteLog(this.lastLocation, (OutputStream)new RemoteOutputStream((OutputStream)cos)));
                bl = cos.getByteCount() > 0L;
            }
            catch (Throwable throwable) {
                transcodedSink.flush();
                long written = cos.getByteCount();
                if (written > 0L) {
                    LOGGER.log(Level.FINER, "copied {0} bytes from {1}", new Object[]{written, log});
                    this.lastLocation += written;
                }
                throw throwable;
            }
            transcodedSink.flush();
            long written = cos.getByteCount();
            if (written > 0L) {
                LOGGER.log(Level.FINER, "copied {0} bytes from {1}", new Object[]{written, log});
                this.lastLocation += written;
            }
            return bl;
        }

        @Override
        public Integer exitStatus(FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            return this.exitStatus(workspace, listener);
        }

        @CheckForNull
        protected Integer exitStatus(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
            FilePath status = this.getResultFile(workspace);
            return (Integer)status.act((FilePath.FileCallable)STATUS_CHECK_INSTANCE);
        }

        @Override
        public byte[] getOutput(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            return this.getOutput(workspace);
        }

        protected byte[] getOutput(FilePath workspace) throws IOException, InterruptedException {
            return (byte[])this.getOutputFile(workspace).act((FilePath.FileCallable)new GetOutput(this.charset));
        }

        @CheckForNull
        private static ByteBuffer maybeTranscode(@NonNull byte[] data, @CheckForNull String charset) {
            Charset cs = FileMonitoringController.transcodingCharset(charset);
            if (cs == null) {
                return null;
            }
            return StandardCharsets.UTF_8.encode(cs.decode(ByteBuffer.wrap(data)));
        }

        @CheckForNull
        private static Charset transcodingCharset(@CheckForNull String charset) {
            Charset cs;
            if (charset == null) {
                return null;
            }
            Charset charset2 = cs = charset.equals(FileMonitoringTask.SYSTEM_DEFAULT_CHARSET) ? Charset.defaultCharset() : Charset.forName(charset);
            if (cs.equals(StandardCharsets.UTF_8)) {
                return null;
            }
            return cs;
        }

        @Override
        public final void stop(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            if (this.cookieValue == null) {
                this.cookieValue = FileMonitoringTask.cookieFor(workspace, true);
            }
            launcher.kill(Collections.singletonMap(FileMonitoringTask.COOKIE, this.cookieValue));
        }

        @Override
        public void cleanup(FilePath workspace) throws IOException, InterruptedException {
            this.controlDir(workspace).deleteRecursive();
            if (this.cleanupList != null) {
                this.cleanupList.stream().forEach(IOUtils::closeQuietly);
            }
        }

        public FilePath controlDir(FilePath ws) throws IOException, InterruptedException {
            if (this.controlDir != null) {
                return ws.child(this.controlDir);
            }
            assert (this.id != null);
            FilePath cd = ws.child("." + this.id);
            if (!cd.isDirectory()) {
                cd = ws.child(".jenkins-" + this.id);
            }
            this.controlDir = cd.getRemote();
            this.id = null;
            LOGGER.info("using migrated control directory " + this.controlDir + " for remainder of this task");
            return cd;
        }

        public FilePath getResultFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("jenkins-result.txt");
        }

        public FilePath getLogFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("jenkins-log.txt");
        }

        public FilePath getOutputFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("output.txt");
        }

        @Override
        public String getDiagnostics(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
            FilePath cd = this.controlDir(workspace);
            VirtualChannel channel = cd.getChannel();
            String node = channel instanceof Channel ? ((Channel)channel).getName() : null;
            String location = node != null ? cd.getRemote() + " on " + node : cd.getRemote();
            StringWriter w = new StringWriter();
            Integer code = this.exitStatus(workspace, launcher, (TaskListener)new StreamTaskListener((Writer)w));
            if (code != null) {
                return w + "completed process (code " + code + ") in " + location;
            }
            return w + "awaiting process completion in " + location;
        }

        @Override
        public void watch(FilePath workspace, Handler handler, TaskListener listener) throws IOException, InterruptedException, ClassCastException {
            workspace.actAsync((FilePath.FileCallable)new StartWatching(this, handler, listener));
            LOGGER.log(Level.FINE, "started asynchronous watch in " + this.controlDir, new Throwable());
        }

        public FilePath getLastLocationFile(FilePath workspace) throws IOException, InterruptedException {
            return this.controlDir(workspace).child("last-location.txt");
        }

        private static class GetOutput
        extends MasterToSlaveFileCallable<byte[]> {
            private final String charset;

            GetOutput(String charset) {
                this.charset = charset;
            }

            public byte[] invoke(File file, VirtualChannel vc) throws IOException, InterruptedException {
                byte[] buf = FileUtils.readFileToByteArray((File)file);
                ByteBuffer transcoded = FileMonitoringController.maybeTranscode(buf, this.charset);
                if (transcoded == null) {
                    return buf;
                }
                byte[] buf2 = new byte[transcoded.remaining()];
                transcoded.get(buf2);
                return buf2;
            }
        }

        static class StatusCheck
        extends MasterToSlaveFileCallable<Integer> {
            StatusCheck() {
            }

            @CheckForNull
            public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                if (f.exists() && f.length() > 0L) {
                    String text = Files.readString(f.toPath(), Charset.defaultCharset()).trim();
                    if (text.isEmpty()) {
                        return null;
                    }
                    try {
                        return Integer.valueOf(text);
                    }
                    catch (NumberFormatException x) {
                        throw new IOException("corrupted content in " + f + ": " + x, x);
                    }
                }
                return null;
            }
        }

        private static class TranscodingCharsetForSystemDefault
        extends MasterToSlaveCallable<String, RuntimeException> {
            private TranscodingCharsetForSystemDefault() {
            }

            public String call() throws RuntimeException {
                Charset cs = FileMonitoringController.transcodingCharset(FileMonitoringTask.SYSTEM_DEFAULT_CHARSET);
                return cs != null ? cs.name() : null;
            }
        }

        private static class WriteLog
        extends MasterToSlaveFileCallable<Void> {
            private final long lastLocation;
            private final OutputStream sink;

            WriteLog(long lastLocation, OutputStream sink) {
                this.lastLocation = lastLocation;
                this.sink = sink;
            }

            public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                long len = f.length();
                if (len > this.lastLocation) {
                    try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
                        raf.seek(this.lastLocation);
                        long toRead = len - this.lastLocation;
                        if (toRead > Integer.MAX_VALUE) {
                            throw new IOException("large reads not yet implemented");
                        }
                        byte[] buf = new byte[(int)toRead];
                        raf.readFully(buf);
                        this.sink.write(buf);
                    }
                }
                return null;
            }
        }
    }
}

