within ModelicaByExample.Subsystems.LotkaVolterra.Components;
model Migration "Simple 'diffusion' based model of migration"
  parameter Real rabbit_migration=0.001 "Rabbit migration rate";
  parameter Real fox_migration=0.005 "Fox migration rate";
  ModelicaByExample.Components.LotkaVolterra.Interfaces.Species rabbit_a
    "Rabbit population in Region A"
    annotation (Placement(transformation(extent={{-70,90},{-50,110}})));
  ModelicaByExample.Components.LotkaVolterra.Interfaces.Species rabbit_b
    "Rabbit population in Region B"
    annotation (Placement(transformation(extent={{-70,-110},{-50,-90}})));
  ModelicaByExample.Components.LotkaVolterra.Interfaces.Species fox_a
    "Fox population in Region A"
    annotation (Placement(transformation(extent={{50,90},{70,110}})));
  ModelicaByExample.Components.LotkaVolterra.Interfaces.Species fox_b
    "Fox population in Region B"
    annotation (Placement(transformation(extent={{50,-110},{70,-90}})));
equation
  rabbit_a.rate = (rabbit_a.population-rabbit_b.population)*rabbit_migration;
  rabbit_a.rate + rabbit_b.rate = 0 "Conservation of rabbits";
  fox_a.rate = (fox_a.population-fox_b.population)*fox_migration;
  fox_a.rate + fox_b.rate = 0 "Conservation of rabbits";
  annotation ( Icon(graphics={
        Rectangle(
          extent={{-100,100},{100,-100}},
          lineColor={0,127,0},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid),
        Bitmap(
          extent={{-80,30},{80,-30}},
          imageSource="R0lGODlh3AA7AMQAANnZ2bOzs8zMzIODg8PDw9XV1f39/fHx8fj4+BQUFKOjo/X19YyMjJOTk3R0dCUlJampqWxsbEpKSuTk5Onp6QcHB7u7u1paWkJCQpqamjo6OjIyMuDg4H19fQAAAP///yH5BAAAAAAALAAAAADcADsAAAX/4CeOZGmeaKqubOu+cCzPdG3feK7vfO//wKBwSCwaj8ikcslsOp/QqLRmmAgEhcV0y90aFhMCpOGQbM6XAQTRvVWv2bbcVA0wLppHouLp+/8Zcy5fYWNlZxtpa4JdAAwYCX+Skw8CEwUABRwGjCJ1d3l7k4CdUQcWF5Gjq30JD38VEgGcco6QrJSWmJq0pUcIChp8uMSjEV2nqcWTrrCyvb5BBgQSy9Z+CREBW8DC19bH0UIMqt/FGwocB1LT1ebF2dvigzEB5e+4CXsYUuT4xOjUzVtxYAIHABAcaNggT0WEf9YqWPABzYU9iPn2DUSBsIOGPhX4VCDA4iPGfA1z/xQ8mHBhyhQPT+KSuNGEAneTLihgQGATig0yJVV4IGEAhx0dTYb0MLKFyaDMXm40MOCeJFdDA7A5cSFoBQ0RIABYx+PmKp08ff6E6mdo0aM1SXRdJoFCigAyEyioqIOq1T9YH2hNMffk17Bj45qwcE1CBghkTQwYBjEBBgZ2eRQmVlcF3pN6+Soe4cBcAgAoDBQYgEEPRpI7GFtzDDnFZNCXM48mkeHagwGDV4ApEKDBAAUZGJSRgGGhhgvMJaQJoFtH6W+nU6hm7Roi7N0jKGzGpaFmb2u/gwu/VPx48uXNNzyPPr06eBEUYhKrcCHQPPHWlHdfEwcwIMEDIVEmyf8GDWyU3zL8+TfgEgsQMEAEF1zQGlEOMJABajUVeGCCqzA4oRQLUMCBQOBVeGGGG0rQ4Ycn1jhHiitGZuMQBlSx449cGHCAAI+E9GOPEwDJhAEANOCNHxLUKCSRGBipJBIcKCNUBAo1IMBoTDqpYJRXGnHAX8zYN0+Wf1XApQZelhkEAQqy0oAWW6RIAZ4qnAmPmnLmQME1FbgCYhEIgCGABWN04IAD0GEgnQNGpUDnMnd2oSefciiAXQSA7oAAAAFksFMZeuyRYJ0JfHnCoBEZikSiVjDagKOQ0kcpXG0M4JuOO1RBQAYRmKGqNRsMIIBoH3h6TTahikqqqcodqM//qqy62kYBdeICwXc6LBCAlu9U4AAWHGxVgq/oARtsGMQau9QyyS4rCAGvIMuDAQx4RVSGETBQAC3cXvOtD+KSa4656KrbxgESoAlYODsUIDFGhSbgAAWc4HvNBj3w6690FwQ8cBukFiuBdBo89yGzNjRwcVAXJPkBxDN7kI0PFrPVlj4bwxyF0Dsw0K1XkehFQsors+wyAETTILPPOdkc6AkK5PwPfwQcAHPUOhhNNUhJK3A1CgIANTZTG3QALhNZr82112efUKDWlUnYRNprs+123XYPgKBhOWnrxN1966w34CQUoNDR6HUwwACPCcDpEwcIDjmhhTOuQgENRKC2eWkOENBjj104/iQ+D0hOOQSWe87CAcQppM+1rIT0wAMTMQK66PhobPrpsr9wQIoCtDe5oxhK0HJRARQQDe0B2H775rrzXryoB3R/CQBWD3Q8Bckbt7wDzT8PnPTbt/8CAt0XhEn47tdv//3456///vz37///APxfCAAAOw==",
          fileName="modelica://ModelicaByExample/../../../../../Desktop/rabbit-tracks1.gif",
          origin={-60,0},
          rotation=90),
        Bitmap(
          extent={{-80,20},{80,-20}},
          imageSource="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",
          fileName="modelica://ModelicaByExample/../../../../../Desktop/Red-Fox-tracks-s.jpg",
          origin={60,0},
          rotation=270),
        Text(
          extent={{-100,20},{100,-20}},
          lineColor={0,127,0},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid,
          textString="%name",
          origin={-120,0},
          rotation=90)}));
end Migration;
