/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import java.util.Vector;
import org.jacorb.collection.CollectionImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CosCollection.AnySequenceHolder;
import org.omg.CosCollection.Collection;
import org.omg.CosCollection.ElementInvalid;
import org.omg.CosCollection.EmptyCollection;
import org.omg.CosCollection.Iterator;
import org.omg.CosCollection.IteratorInBetween;
import org.omg.CosCollection.IteratorInvalid;
import org.omg.CosCollection.IteratorInvalidReason;
import org.omg.CosCollection.IteratorOperations;
import org.omg.CosCollection.PositionInvalid;
import org.omg.PortableServer.Servant;

class PositionalIteratorImpl
implements IteratorOperations {
    private Servant srvnt = null;
    protected int pos = -1;
    protected boolean in_between = false;
    protected boolean read_only = true;
    protected CollectionImpl collection;

    PositionalIteratorImpl(CollectionImpl collection) {
        this.collection = collection;
    }

    PositionalIteratorImpl(CollectionImpl collection, boolean read_only) {
        this.collection = collection;
        this.read_only = read_only;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set_to_first_element() {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_servant();
            if (this.collection.is_empty()) {
                this.invalidate();
            } else {
                this.set_pos(0);
            }
        }
        return this.get_pos() == 0;
    }

    @Override
    public boolean set_to_next_element() throws IteratorInvalid {
        return this.set_to_next_nth_element(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set_to_next_nth_element(int n) throws IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_invalid();
            int new_pos = this.get_pos() + n;
            if (this.is_in_between()) {
                new_pos = this.get_pos() + n - 1;
            }
            if (this.collection.number_of_elements() > new_pos && new_pos >= 0) {
                this.set_pos(new_pos);
            } else {
                this.invalidate();
            }
            this.in_between = false;
            return this.exist_next();
        }
    }

    @Override
    public boolean retrieve_element(AnyHolder element) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            try {
                element.value = this.collection.element_retrieve(this.get_pos());
                return true;
            }
            catch (PositionInvalid e) {
                this.set_pos(-1);
                throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retrieve_element_set_to_next(AnyHolder element, BooleanHolder more) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            boolean rc = this.retrieve_element(element);
            this.set_to_next_element();
            more.value = this.exist_next();
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retrieve_next_n_elements(int n, AnySequenceHolder result, BooleanHolder more) throws IteratorInvalid, IteratorInBetween {
        Vector<Any> v = new Vector<Any>(n);
        int i = 0;
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            AnyHolder a = new AnyHolder();
            more.value = true;
            for (i = 0; (i < n || n == 0) && this.get_pos() != -1; ++i) {
                try {
                    this.retrieve_element_set_to_next(a, more);
                    v.addElement(a.value);
                    continue;
                }
                catch (IteratorInvalid e) {
                    more.value = false;
                    break;
                }
            }
        }
        Any[] anies = new Any[v.size()];
        v.copyInto(anies);
        result.value = anies;
        return i > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean not_equal_retrieve_element_set_to_next(Iterator test, AnyHolder element) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            if (this.is_equal(test)) {
                this.retrieve_element(element);
                return false;
            }
            this.retrieve_element(element);
            this.set_to_next_element();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove_element() throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            this.check_read_only();
            try {
                this.collection.element_remove(this.get_pos());
            }
            catch (PositionInvalid e) {
                this.invalidate();
                throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
            }
            catch (EmptyCollection e) {
                this.invalidate();
                throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_element_set_to_next() throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.remove_element();
            return this.set_to_next_element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_next_n_elements(int n, IntHolder actual_number) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            int count = 0;
            int i = 0;
            while ((i < n || n == 0) && this.get_pos() != -1) {
                this.remove_element_set_to_next();
                ++i;
                ++count;
            }
            actual_number.value = count;
            return this.exist_next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean not_equal_remove_element_set_to_next(Iterator test) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            if (this.is_equal(test)) {
                this.remove_element();
                return false;
            }
            this.remove_element_set_to_next();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace_element(Any element) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            this.check_read_only();
            try {
                this.collection.element_replace(this.get_pos(), element);
            }
            catch (PositionInvalid e) {
                this.invalidate();
                throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace_element_set_to_next(Any element) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.replace_element(element);
            return this.set_to_next_element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace_next_n_elements(Any[] elements, IntHolder actual_number) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            actual_number.value = 0;
            int i = 0;
            while (i < elements.length && this.is_valid()) {
                this.replace_element_set_to_next(elements[i]);
                ++i;
                ++actual_number.value;
            }
            return this.exist_next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean not_equal_replace_element_set_to_next(Iterator test, Any element) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            if (this.is_equal(test)) {
                this.replace_element(element);
                return false;
            }
            this.replace_element_set_to_next(element);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add_element_set_iterator(Any element) throws ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.pos = this.collection.element_add(element);
            this.set_pos(this.pos);
            this.in_between = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add_n_elements_set_iterator(Any[] elements, IntHolder actual_number) throws ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            int i;
            actual_number.value = 0;
            for (i = 0; i < elements.length; ++i) {
                this.collection.check_element(elements[i]);
            }
            i = 0;
            while (i < elements.length) {
                this.add_element_set_iterator(elements[i]);
                ++i;
                ++actual_number.value;
            }
            return true;
        }
    }

    @Override
    public synchronized void invalidate() {
        this.pos = -1;
    }

    @Override
    public synchronized boolean is_valid() {
        return this.pos != -1;
    }

    @Override
    public synchronized boolean is_in_between() {
        return this.in_between;
    }

    @Override
    public synchronized boolean is_for(Collection collector) {
        return this.collection.is_this_you(collector);
    }

    @Override
    public synchronized boolean is_const() {
        return this.read_only;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean is_equal(Iterator test) throws IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            PositionalIteratorImpl iter = this.collection.check_iterator(test);
            if (!this.is_valid()) {
                throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
            }
            return this.get_pos() == iter.get_pos();
        }
    }

    @Override
    public Iterator _clone() {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            Iterator iter = this.collection.create_iterator(this.read_only);
            try {
                PositionalIteratorImpl i = this.collection.check_iterator(iter);
                i.set_pos(this.get_pos());
                return iter;
            }
            catch (IteratorInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Iterator from_where) throws IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            PositionalIteratorImpl i = this.collection.check_iterator(from_where);
            i.set_pos(this.get_pos());
            i.set_in_between(this.is_in_between());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_servant();
            this.collection.destroy_me(this);
        }
    }

    public synchronized int get_pos() {
        this.check_servant();
        return this.pos;
    }

    public synchronized void set_pos(int pos) {
        this.check_servant();
        this.pos = pos;
    }

    public synchronized void set_in_between(boolean in_between) {
        this.check_servant();
        this.in_between = in_between;
    }

    public synchronized void set_servant(Servant srvnt) {
        if (srvnt != null) {
            System.out.println("Error: Servant setted before!");
            throw new INTERNAL();
        }
    }

    public synchronized Servant get_servant() {
        if (this.srvnt != null) {
            System.out.println("Error: Servant must be setted before!");
            throw new INTERNAL();
        }
        return this.srvnt;
    }

    protected void check_servant() {
        if (this.srvnt == null) {
            System.out.println("Error: Servant must be setted before!");
            throw new INTERNAL();
        }
    }

    protected void check_invalid() throws IteratorInvalid {
        this.check_servant();
        if (this.pos == -1) {
            throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
        }
    }

    protected void check_in_between() throws IteratorInBetween {
        if (this.in_between) {
            throw new IteratorInBetween();
        }
    }

    protected void check_iterator() throws IteratorInBetween, IteratorInvalid {
        this.check_invalid();
        this.check_in_between();
    }

    protected void check_read_only() throws IteratorInvalid {
        if (this.read_only) {
            throw new IteratorInvalid(IteratorInvalidReason.is_const);
        }
    }

    protected synchronized boolean exist_next() {
        return this.is_valid() && this.collection.number_of_elements() - 1 > this.get_pos();
    }
}

