/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jacorb.config.Configuration;
import org.jacorb.notification.EventTypeWrapper;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxyConsumerMBean;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.IProxyConsumer;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyComm.NotifySubscribeHelper;
import org.omg.CosNotifyComm.NotifySubscribeOperations;
import org.omg.PortableServer.POA;

public abstract class AbstractProxyConsumer
extends AbstractProxy
implements IProxyConsumer,
NotifyPublishOperations,
AbstractProxyConsumerMBean {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private final MessageFactory messageFactory_;
    private final AtomicBoolean isStartTimeSupported_ = new AtomicBoolean(true);
    private final AtomicBoolean isStopTimeSupported_ = new AtomicBoolean(true);
    private List subsequentDestinations_;
    private NotifySubscribeOperations proxySubscriptionListener_;
    private NotifySubscribe subscriptionListener_;
    protected final SupplierAdmin supplierAdmin_;
    private int messageCounter_ = 0;
    private PropertySetAdapter reconfigureQoS_ = new PropertySetAdapter(){

        @Override
        public void actionPropertySetChanged(PropertySet source) {
            AbstractProxyConsumer.this.configureStartTimeSupported();
            AbstractProxyConsumer.this.configureStopTimeSupported();
        }
    };

    protected AbstractProxyConsumer(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, MessageFactory messageFactory, SupplierAdmin supplierAdmin, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(admin, orb, poa, conf, taskProcessor, offerManager, subscriptionManager);
        this.supplierAdmin_ = supplierAdmin;
        this.messageFactory_ = messageFactory;
        this.configureStartTimeSupported();
        this.configureStopTimeSupported();
        this.qosSettings_.addPropertySetListener(new String[]{"Priority", "Timeout", "StartTimeSupported", "StopTimeSupported"}, (PropertySetListener)this.reconfigureQoS_);
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    @Override
    public final List getSubsequentFilterStages() {
        return this.subsequentDestinations_;
    }

    public void setSubsequentDestinations(List list) {
        this.subsequentDestinations_ = list;
    }

    private void configureStartTimeSupported() {
        try {
            this.isStartTimeSupported_.set(this.qosSettings_.get("StartTimeSupported").extract_boolean());
        }
        catch (Exception e) {
            this.isStartTimeSupported_.set("on".equals("on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StartTimeSupported=" + this.isStartTimeSupported_);
        }
    }

    private void configureStopTimeSupported() {
        this.logger_.debug("QoSSettings: " + this.qosSettings_);
        try {
            this.isStopTimeSupported_.set(this.qosSettings_.get("StopTimeSupported").extract_boolean());
        }
        catch (Exception e) {
            this.isStopTimeSupported_.set("on".equals("on"));
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set QoS: StopTimeSupported=" + this.isStopTimeSupported_);
        }
    }

    protected void schedulePullTask(MessageSupplier target) {
        this.getTaskProcessor().scheduleTimedPullTask(target);
    }

    protected void checkMessageProperties(Message m) {
    }

    @Override
    public FilterStage getFirstStage() {
        return this;
    }

    @Override
    public boolean getStopTimeSupported() {
        return this.isStopTimeSupported_.get();
    }

    @Override
    public boolean getStartTimeSupported() {
        return this.isStartTimeSupported_.get();
    }

    public final SupplierAdmin MyAdmin() {
        return this.supplierAdmin_;
    }

    @Override
    public final MessageConsumer getMessageConsumer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasMessageConsumer() {
        return false;
    }

    @Override
    public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        this.offerManager_.offer_change(added, removed);
    }

    public final EventType[] obtain_subscription_types(ObtainInfoMode obtainInfoMode) {
        EventType[] _subscriptionTypes;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                _subscriptionTypes = this.subscriptionManager_.obtain_subscription_types();
                break;
            }
            case 0: {
                _subscriptionTypes = this.subscriptionManager_.obtain_subscription_types();
                this.removeListener();
                break;
            }
            case 3: {
                _subscriptionTypes = EMPTY_EVENT_TYPE_ARRAY;
                this.registerListener();
                break;
            }
            case 2: {
                _subscriptionTypes = EMPTY_EVENT_TYPE_ARRAY;
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode: ObtainInfoMode." + obtainInfoMode.value());
            }
        }
        return _subscriptionTypes;
    }

    private void registerListener() {
        NotifySubscribeOperations _listener;
        if (this.proxySubscriptionListener_ == null && (_listener = this.getSubscriptionListener()) != null) {
            this.proxySubscriptionListener_ = new NotifySubscribeOperations(){

                @Override
                public void subscription_change(EventType[] added, EventType[] removed) {
                    try {
                        _listener.subscription_change(added, removed);
                    }
                    catch (NO_IMPLEMENT e) {
                        AbstractProxyConsumer.this.logger_.info("disable subscription_change for Supplier", (Throwable)e);
                        AbstractProxyConsumer.this.removeListener();
                    }
                    catch (InvalidEventType e) {
                        if (AbstractProxyConsumer.this.logger_.isDebugEnabled()) {
                            AbstractProxyConsumer.this.logger_.debug("subscription_change(" + EventTypeWrapper.toString(added) + ", " + EventTypeWrapper.toString(removed) + ") failed", (Throwable)((java.lang.Object)e));
                        } else {
                            AbstractProxyConsumer.this.logger_.error("invalid event type", (Throwable)((java.lang.Object)e));
                        }
                    }
                    catch (Exception e) {
                        AbstractProxyConsumer.this.logger_.error("subscription change failed", (Throwable)e);
                    }
                }
            };
            this.subscriptionManager_.addListener(this.proxySubscriptionListener_);
        }
    }

    @Override
    protected void removeListener() {
        if (this.proxySubscriptionListener_ != null) {
            this.subscriptionManager_.removeListener(this.proxySubscriptionListener_);
            this.proxySubscriptionListener_ = null;
        }
    }

    @Override
    protected final void clientDisconnected() {
        this.subscriptionListener_ = null;
    }

    @Override
    protected void connectClient(Object client) {
        super.connectClient(client);
        try {
            this.subscriptionListener_ = NotifySubscribeHelper.narrow(client);
            this.logger_.debug("successfully narrowed connecting Supplier to NotifySubscribe");
        }
        catch (Exception e) {
            this.logger_.info("connecting Supplier does not support subscription_change");
        }
    }

    final NotifySubscribeOperations getSubscriptionListener() {
        return this.subscriptionListener_;
    }

    protected void processMessage(Message mesg) {
        this.getTaskProcessor().processMessage(mesg);
        ++this.messageCounter_;
    }

    @Override
    public final int getMessageCount() {
        return this.messageCounter_;
    }

    protected Message[] newMessages(StructuredEvent[] events) {
        ArrayList<Message> _result = new ArrayList<Message>(events.length);
        MessageFactory _messageFactory = this.getMessageFactory();
        for (int i = 0; i < events.length; ++i) {
            Message _newMessage = _messageFactory.newMessage(events[i], (IProxyConsumer)this);
            this.checkMessageProperties(_newMessage);
            _result.add(_newMessage);
        }
        return _result.toArray(new Message[_result.size()]);
    }
}

