/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.Declarator;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class SimpleDeclarator
extends Declarator {
    public SimpleDeclarator(int num) {
        super(num);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void escapeName() {
        if (!this.name.startsWith("_") && lexer.strictJavaEscapeCheck(this.name)) {
            this.name = "_" + this.name;
        }
    }

    @Override
    public void parse() {
        try {
            NameTable.define(this.full_name(), IDLTypes.DECLARATOR);
        }
        catch (NameAlreadyDefined p) {
            parser.error("Declarator name " + this.full_name() + " already declared in this scope.", this.token);
        }
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public IdlSymbol getEnclosingSymbol() {
        return this.enclosing_symbol;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
    }

    @Override
    String full_name() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            return this.pack_name + "." + this.name;
        }
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

